/*	Digital MicroSystems	structure definitions

	FCSTRUCT.H
	Holds structure definitions for filecopy.
*/

/* needs "fcconst.h" for reference.	*/

/*=============================================================================
				HISTORY
    Last change:	13 March 1984		tpl
ver	0
rev	0
mod	a
patch	2


 mod
-----
a	Created from DMSTRUCT.DEF	jjc

*/
/*=============================================================================
			DATA STRUCTURES
*/

/* CPM Disk Parameter Block */

struct	DPB
{
	CHAR	control;
	int	max_checksum;
	int	max_allocation;
	char	drive_name[DRIVENAMESIZE];
	CHAR	hd_volume;
	CHAR	media_type;
	CHAR	unit;
	int	sect_per_track;
	CHAR	block_shift;
	CHAR	block_mask;
	CHAR	extent_mask;
	int	disk_size_mask;
	int	dir_max;
	CHAR	alloc_0_byte;
	CHAR	alloc_1_byte;
	int	dir_check_size;
	int	sys_offset;
};

/*...........................................................................*/

/* CPM Disk Parameter Header */

struct DPH
{
	int	translate_table;
	int	reserved_CPM[3];
	int	dir_buff_address;
	int	dpb_address;
	int	checkSum_address;
	int	alloc_vec_address;
};

/*...........................................................................*/
/* Each hard disk can be described by the following fields of hd_description.*/

struct hd_description
{
	CHAR	diameter;
	int	size_in_Kbytes;
	CHAR	platters;
	CHAR	RW_heads;
	CHAR	tracks;
	CHAR	sect_per_track;
	char	name[HDnameLEN];
};

/*...........................................................................*/

/* MSDOS BIOS Parameter Block */

struct BPB
{
	int	BytesInSect;
	CHAR	SectPerCluster;
	int	reserved_sect;
	CHAR	num_FATs;
	int	num_Root_Dir_Entries;
	int	SectPerDisk;
	CHAR	media_descriptor;
	int	SectPerFAT;
	int	SectPerTrack;
};

/*...........................................................................*/

/* The first 128 byte sector on an MSDOS logical disk is of the following
    format.	*/

struct BPB_sector
{
	CHAR	jump[3];
	CHAR	name[8];
	struct BPB	bpb;
	CHAR	unused[128 - (15 + 11) ];
};

/*...........................................................................*/

struct ms_dir_entry
{
	CHAR	name[MSDIRnameSIZE];
	CHAR	name_extension[MSDIRextNameSIZE];
	CHAR	attribute;
	CHAR	reserved[MSDIRreservedSIZE];
	CHAR	fileTime[2];
	CHAR	fileDate[2];
	int	start_cluster;
	int	size_in_bytes[2];
};

/*---------------------------------------------------------------------------*/

struct ms_fcb
{
	CHAR	drive;
	CHAR	name[LENname];
	CHAR	type[LENtype];
	int	cur_cluster;
	int	rec_size;
	int	file_size[2];
	int	file_date;
	int	curBiosTrack;
	int	curBiosSector;
	int	start_cluster;
	CHAR	attribute;
	CHAR	reserved[3];
	CHAR	cur_record;
	int	rand_rec[2];
};

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

struct ms_ext_fcb
{
	CHAR	ext_flag;
	CHAR	zeros[5];
	CHAR	attribute;
	CHAR	drive;
	CHAR	name[LENname];
	CHAR	type[LENtype];
	int	cur_cluster;
	int	rec_size;
	int	file_size[2];
	int	file_date;
	int	curBiosTrack;
	int	curBiosSector;
	int	start_cluster;
	CHAR	attribute;
	CHAR	reserved[3];
	CHAR	cur_record;
	int	rand_rec[2];
};

/*---------------------------------------------------------------------------*/

/* MSDOS directory info for MSDOS emulation routines.	*/

  struct  ms_dir_info
{
	int	begTrack;
	int	begSector;
	int	curEntry;
	int	curTrack;
	int	curSector;
	int	endEntry;	/* Maximum number of directory entires.	*/
	int	bytesInCluster;
	int	lastCluster;
	int	dataOffset;	/* Offset to beginning of the data space
				   for an msdos type disk. Equals the
				   number of sectors taken by the FATs,
				   the directory and the reserved sector
				   for the BPB.				*/
};

/*---------------------------------------------------------------------------*/
struct recNetAssign
{
	CHAR	size;
	CHAR	unit_number;
	CHAR	control;
	CHAR	volume;
};

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

