/*	Digital MicroSystems		'C' defines / constants

	module	FCCONST.H
*/
/*=============================================================================
			HISTORY
    Last change:	3 January 1984	jjc
ver	0
rev	0
mod	a
patch	1


 mod
-----
  a		Jan 3,	1984	jjc
	.Copy from DMSCONST.DEF

*/

/*
===============================================================================
			CONSTANTS
*/
#define	NEWFEAT	0
/*
#define debug	* global debugging flag *
#define debugP	* procedure name output upon call, debugging flag. *
#define dbg	* local debugging flag *
#define dbg1	* another local debugging flag *
*/
/* Define constants for BDOS calls.	*/

#define		RESET		13
#define		SELDISK		14
#define		GETCURDISK	25


/* Define constants for BIOS calls.	*/

#define		WRMBOOT		1	/* NOTE THAT DOCUMENTATION IS WRONG !*/
#define		SETDISK		9
#define		SETTRACK	10
#define		SETSECTOR	11
#define		SETDMA		12
#define		BIOSREAD	13
#define		BIOSWRITE	14
#define		SECTRAN		16

#define		NETlock		32
#define		CPMMAP		33
#define		NETunlock	34
#define		SENDnet		37
#define		RECnet		38
#define		NACKpoll	39
#define		ACKpoll		40
#define		NEThdSTAT	45

/*...........................................................................*/
/* Masks to bitwise OR the control byte with to set option flags,
 and also to AND the control byte with to see if bit is set.

       Control byte mapping:
	bit		use
       =====	       =====
	0,1   		00 = CPM		01 = MSDOS
			10 = unused		11 = unused

	2,3		unused

	4,5		00 = Read/Write		01 = Read/Only
			10 = First/Write	11 = unused

	6		HiDos Shared	 Separate from bits 4,5 for speed of
					 checking, i.e. only one bit test.
	7		Tape backup
*/
#define		MSDOS		1	/* To mark as MSDOS operating system.*/
#define		CPM		0	/* To mark as CPM operating system.  */
#define		READWRITE	0	/* To mark as Read Write partition.  */
#define		READONLY	0x10	/* To mark as Read Only partition.   */
#define		FIRSTWRITE	0x20	/* To mark as First Write partition. */
#define		SHARED		0x40	/* To mark as HiDos shared disk.     */
#define		TAPEBACKUP	0x80	/* To mark disk for tape backup.     */

#define		NOTAPEBACKUP	0
#define		NOTSHARED	0

#define		OSMASK		0x03	/* TO 'AND' control with to get bits
					 0 and 1, the OS type bits.	     */
#define		PRTCTMASK	0x70	/* To 'AND' control with to get bits
					4, 5 and 6, the protection mode bits.*/
/*...........................................................................*/
/* Other constants, alphabetically listed.	*/

#define		DIRentriesPERsector	4	/* 4 entries per 128 bytes.  */
#define		DRIVENAMESIZE	8	/* Size of dpb drive name in chars.  */
#define		ERASED		0xe5	/* directory entry is erased if this
					  value is in first byte.	     */
#define		FIRST8or14disk	5	/* Sixth entry into hd_types is the
					  first non 5.25 inch entry.	     */
#define		HDnameLEN	35	/* Length of hard disk type descript.*/
#define		LassignSend	15	/* Length of HiNet assign Send buffer*/
#define		LassignRec	4	/* Length of HiNet assign Receive buf*/
#define		LdmsDPBoffset	15	/* Fifteen bytes before normal dpb   */
					/*begins DMS's extension.	     */
#define		LENTABLEinRECORDS   8	/* Alloc table =1k = 8 * 128	     */
#define		LENname		8	/* length of file names.	     */
#define		LENtype		3	/* length of file types.	     */
#define		MAXhdTypes	10	/* 10 types of hard disks allowed.   */
#define		MAXINPUTSTRING	10	/* Size of maximun user input.	     */
#define		MAXvol		4	/* Only 4 volumes allowed.	     */
#define		MAXdrives	8	/* Maximum number of logical drives. */
#define		NAMESIZE	8	/* Size of alloc table name field.   */
#define		NORMwrite	0	/* Reg 'C' = 0 for normal bios write.*/
#define		NUMOS		2   /* Number of types of operating systems. */
#define		NUMPROTCT	4   /* Number of types of protection modes.  */
#define		NUMSIZES	6    /* Number of different partition sizes. */
#define		NUMyn		4	/* Number of yes,no responses.	     */
#define		OSnameLEN	5	/* 5 chars max in OS name (msdos).   */
#define		PASSWDSIZE	6      /* Size of alloc table password field.*/
#define		PRTCTnameLEN	2	/* 2 chars max in user response to
					  protection mode. (RW,RO,FW,S)      */
#define		RETNOTOK	FALSE	/* Parameter to show 'RET' is not
					  allowed as a user response.	     */
#define		RETOK		TRUE	/* Paramter to show a 'RET' IS allowed
					  as a user repsonse.		     */
#define		RETURN		0xff	/* Value returned from Get_Yes_No upon
					  receipt of 'RET' response.	     */
#define		WRbuffSIZE	128	/* 128 byte writes.		     */

/*...........................................................................*/
/*	Constants for UNIT in extended DPB.				     */

#define		SDmedia		0
#define		DDmedia		0x20
#define		HARDmedia	0x40
#define		NETmedia	0x60
#define		MINI1media	0x80
#define		MINI2media	0xa0
#define		fHARDmedia	0xc0

/*...........................................................................*/

#define		FAIL		0xFFFF
#define		ENDdirMS	0xFFFF
#define		CTRLC	3
#define		CTRLD	4
#define		ENQ	5
#define		CTRLF	6
#define		BELL	7
#define		BS	8
#define		TAB	9
#define		LF	10
#define		CR	13
#define		CTRLL	12
#define		CTRLP	0x10
#define		CTRLS	0x13
#define		CTRLX	0x18
#define		CTRLZ	0x1A
#define		SUB	0x1A
#define		CTRLCLBRACK	0x1D
#define		CTRLHAT	0x1E
#define		SPACE	0x20
#define		DEL	0x7F

#define		ESC	0x1B

#define		PERIOD	0x2E


#define		KBUFFSIZE 256	/* circular type ahead size */

#define		DEF256K	262144	/* 256k in decimal.		*/

/*---------------------------------------------------------------------------*/

/* Masks to set attribute byte in MSDOS dir entry.			*/
#define		MSroMASK	0x01
#define		MShiddenMASK	0x02
#define		MSsystemMASK	0x04
#define		MSVOLlabelMASK	0x08
#define		MSsubDirMASK	0x10
#define		MSarchiveMASK	0x20

#define		MSDIRnameSIZE		8
#define		MSDIRextNameSIZE	3
#define		MSDIRreservedSIZE	10

#define		DEF64K			0x10000

#define		MAXfcbs			10
/*...........................................................................*/
/*	HiNet network protocol						     */

#define		ASSIGNnetCode	0x17


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

