	.title	'Hard disk bootstrap loader'
	.sbttl	'HBOOT.ASM'
	.pabs
	.phex
;----------
; Hard disk bootstrap loader
;
; This code is stored on hard disk 0, track 2, sector 1
;
; Use following code to create and store hboot.com:
;
; A>zdti hboot.hex
; -m9000 907f 100
; -^c
; A>save 1 hboot.com
; A>wrun0 hboot.com 2 1
;
; Update history:
;
; 1.426  Initial release
; 1.427  Added serial number
; 1.429  Works with DSC/4
;
; Data and address definitions:
;
cmdHARD	==	3E7h	; PROM routine
resHARD	==	3EAh	; PROM routine
recHARD	==	3F0h	; PROM routine
SETMAP	==	03h
ONMAP	==	00h
OFFPROM	==	02h
BIOSbas	==	0FFF8h
;
; Setup memory map for DSC/4
	.loc	9000h
	lixd	3FEh	; get serial number
	lxi	H,memmap
	lxi	B,0<8+SETMAP
domap:	outi
	mvi	A,11h
	add	B
	mov	B,A
	jrnz	domap
	in	ONMAP
;
; Read BIOS in backwards
readit:	lxi	H,BOOThard
	call	cmdHARD	; send command to controller
	call	resHARD
	lhld	BOOTadr	; compute buffer address
	lxi	B,128
	ora	A
	dsbc	B
	shld	BOOTadr
	mvi	B,128
	call	recHARD	; get buffer from harddisk
	lxi	H,BOOTsec
	dcr	M	; decrement to next sector
	lhld	BOOTadr
	lded	BIOSbas
	ora	A
	dsbc	D	; check if at front of BIOS
	jrnz	readit
;
; Relocate remainder of bootstrap code
	lxi	H,movit
	lxi	D,4000h
	lxi	B,lenmov
	ldir
	jmp	4000h
;
; Map out pages 0 and 9, and map out PROM
movit:	lxi	B,0<8+SETMAP
	mvi	A,0F0h
	outp	A
	mvi	B,90h
	mvi	A,0F9h
	outp	A
	in	OFFPROM

	lhld	BIOSbas	; get BIOS address
	pchl		; jump to the BIOS
lenmov	==	.-movit
;
; Default memory map
memmap:	.byte	0FFh,000h,0F1h,0F2h
	.byte	0F3h,0F4h,0F5h,0F6h
	.byte	0F7h,0F8h,000h,0FAh
	.byte	0FBh,0FCh,0FDh,0FEh
;
; Hard disk command
BOOThard:
	.byte	11h	; read command
BOOTsec:.byte	128	; start at last sector
	.byte	1	; track
	.byte	0
	.byte	0
	.byte	0
	.byte	10	; retries
	.byte	0
BOOTadr:.word	0	; boot buffer address
	.end
