;     SEARCHES MEMORY
;     FROM 0000H THROUGH FFFFH
;     FOR A STRING WHICH MATCHES
;     THE CONSTANT STRING  AT
;     ADDRESS 'STRNG'.
;
;
;                           SAMPLE DIALOGUE:
;
;     A>ZDTI MSEARCH.HEX
;     -IFILENAME.TYP
;     -R
;     -GLOAD,BREAK
;     ADDRESS #1
;     ADDRESS #2
;         .
;         .
;     END OF MEMORY
;     *BREAK
;     -




LOAD   EQU     4000H
STRAD  EQU     LOAD+10H

START  EQU     0000H
STOP   EQU     0FFFFH


SSIZE  EQU     20H
BDOS   EQU     0005H
PRCHR  EQU     02H
PRSTR  EQU     09H
TERM   EQU     '$'
ASC9   EQU     '9'
CR     EQU     0DH
LF     EQU     0AH




       ORG     LOAD

       JMP     ENTRY



STRNG  ORG     STRAD

       DB      02H                          ; CHARACTER COUNT
       DB      18H,50H                      ; SEARCH PATTERN



       ORG     ($ AND 0FFF0H)+10H

ENTRY  LXI     SP,SPNTR
       LXI     H,START



SRCH   LXI     D,STRNG+1
       CALL    EQUAL
       JZ      MATCH

CONT   INX     H
       CALL    FINIS
       JNZ     SRCH

EXIT   LXI     D,MESSG
       MVI     C,PRSTR
       CALL    BDOS



       ORG     ($ AND 0FFF0H)+10H

BREAK  NOP




MATCH  PUSH    H
       LXI     D,STRNG
       XCHG
       MOV     B,M
       INX     H
       XCHG

GOON   MOV     A,B
       CPI     0
       JZ      FOUND
       CALL    EQUAL
       JZ      GOON1
       POP     H
       JMP     CONT

GOON1  INX     H
       INX     D
       DCR     B
       JMP     GOON

FOUND  POP     H

       MOV     A,H                          ; DISCRIMINATE AGAINST
       CPI     ((STRNG+1)/256)              ; THE REFERENCE VALUE
       JNZ     FOUN1                        ; AT 'STRNG'
       MOV     A,L
       CPI     ((STRNG+1) AND 00FFH)

FOUN1  CNZ     PRTHL
       JMP     CONT




;                             SUBROUTINES:


EQUAL  MOV     A,M
       XCHG
       CMP     M
       XCHG
       RET


FINIS  MOV     A,H
       CPI     ((STOP+1)/256)
       RNZ
       MOV     A,L
       CPI     ((STOP+1) AND 00FFH)
       RET


PRTHL  PUSH    A
       PUSH    B
       PUSH    D
       PUSH    H

       MOV     A,H
       CALL    SEND
       MOV     A,L
       CALL    SEND
       CALL    CRLF

       POP     H
       POP     D
       POP     B
       POP     A

       RET


SEND   PUSH    A
       ANI     0F0H
       RRC     
       RRC
       RRC
       RRC
       CALL    BCD
       CALL    OUTCH
       POP     A
       ANI     00FH
       CALL    BCD
       CALL    OUTCH
       RET


CRLF   MVI     A,CR
       CALL    OUTCH
       MVI     A,LF
       CALL    OUTCH
       RET


OUTCH  PUSH    A
       PUSH    B
       PUSH    D
       PUSH    H
  
       MOV     E,A
       MVI     C,PRCHR
       CALL    BDOS

       POP     H
       POP     D
       POP     B
       POP     A

       RET


BCD    ORI     030H
       CPI     ASC9
       RM
       RZ
       ADI     07H
       RET




MESSG  DB      'END OF MEMORY',CR,LF,TERM



       ORG     ($ AND 0FFF0H)+10H

STACK  DS      SSIZE

SPNTR

PREND



       END     LOAD
