

;	 ***   CP/M PATCHES FOR SINGLE-FLOPPY SYSTEM   ***



;	Begin with standard CP/M 2.249.
;
;	Create 1-page files for each of the 5
;	relevant Track 01 Sectors: 26, 28, 45, 46, and 50
;	using SAVE.
;
;	Use DUU to:
;		(a)	read each relevant sector,
;		(b)	save it,
;		(c)	read in corresponding sector
;			file,
;		(d)	restore saved sector, and
;		(e)	write sector into its sector file.
;
;	Use DEBUG to:
;		(a)	load each sector's file,
;		(b)	load UNIDRIVE.HEX just above it,
;		(c)	move appropriate patch down
;			into the sector's area, and
;		(d)	save the modified sector.
;
;	Then use DUU again, to:
;		(a)	read in each modified sector
;			from its file,
;		(b)	save it,
;		(c)	read in corresponding system
;			sector,
;		(d)	restore modified sector, and
;		(e)	write it to system tracks.



;                          ********
;                          ASSEMBLY
;                          CONTROLS:
;                          ********



			.PABS
			.PHEX
			.XSYM

			.RADIX	16
			.LADDR




;                          *********
;                          CONSTANTS:
;                          *********



  USER.INITL  ==   0FD18  ; Cold Boot User Selection
  CONTINUE    ==   0FD1C
  WANG1.PATCH ==   0F3A2  ; BIOS Printer Service
  PATCH1.END  ==   0F3BA  ; 25 Bytes Available
  USER1.PATCH ==   0F48E  ; Used For User #1 Patch
                          ;      ( 9 Bytes )
  WANG2.PATCH ==   0F4DD  ; Parallel Port #0
	XLFTEST  ==   WANG2.PATCH
        XSEND    ==   WANG2.PATCH + 11h
  PATCH2.END  ==   0F4FE  ; 34 Bytes Available

  LFEED       ==   0A
  CRET        ==   0D
  SPACE       ==   20
  SET         ==   0FF




;                         *********
;                         PROCEDURE:
;                         *********



;	     FIX PRINTER SERVICE TO FILTER OUT EXCESS
;                 LINEFEEDS TO THE WANG PRINTER
;
;		     First Part of the Patch:
;
;	Installed at Trk 1 : Sect 26 : Byte 22  =  F3A2
;                       ( 19h  Bytes )


			.LOC	200

	LXI	H, MARGIN.FLAG

	MOV	A, C
	ANI	7F	; STRIP "UNDERSCORE" BIT
	MOV	C, A	;  WHICH PIP TRANSMITS!

CRTEST:
	CPI	CRET
	JNZ	XLFTEST

	MVI	A, SET
	CMP	M
	JRZ	TRANSFER

	MOV	M, A
	INX	H
	MOV	M, A

TRANSFER:
	JMP	XSEND

	NOP		;  Fill Out Patch Area
	NOP



;			DEFAULT USER #1:
;
;	 Installed at Trk 1 : Sect 28 : Byte E  =  F48E
;
;    Also install "JMP   F48E"  at Trk 1 : Sect 45 : Byte 18
;	               ( Address  FD18 )


			.LOC	( . + 0F ) & 0FFF0

	MVI	A, 10
	STA	0004
	XRA	A
	JMP	CONTINUE

	NOP		;  Fill Out Patch Area



;	            Second Part of the Patch:
;
;       Installed at Trk 1 : Sect 28 : Byte 5D  =  F4DD
;			( 1Eh  Bytes )


			.LOC	( . + 0F ) & 0FFF0

LFTEST:
	CPI	LFEED
	JRNZ	VISIBLE

	INX	H
	XRA	A
	CMP	M
	JRZ	SEND

	MOV	M, A

	RET

VISIBLE:
	CPI	SPACE
	JRC	SEND

	XRA	A
	MOV	M, A

SEND:
	IN	08
	ANI	40
	JRNZ	SEND

	MOV	A, C

	OUT	02
	IN	00

	RET



;                         *********
;                         QUASI-RAM:
;                         *********


			RAM.VARIABLES:

		.BYTE	SET
		.BYTE	00

MARGIN.FLAG	==	0F4FA
INHIBIT.FLAG	==	0F4FB

	NOP
	RET		;  Fill Out Patch Area
	RET



;	                   COLD BOOT
;	              JUMP TO USER #1 PATCH
;
;	  Installed at Trk 1 : Sect 45 : Byte 18  =  FD18


			.LOC	( . + 0F ) & 0FFF0

	JMP	USER1.PATCH
	NOP



;			NEW SIGN-ON MESSAGE:
;
;	     Installed at Trk 1 : Sect 46 : Byte 5E


			.LOC	(. + 0F ) & 0FFF0

 	.ASCII	'CP/M 2.400p '



;			DEFAULT IOBYTE 94h:
;
;	 Installed at Trk 1 : Sect 50 : Byte 67  =  FFE7


			.LOC	( . + 0F ) & 0FFF0

	.BYTE	94




			.END


