
	.TITLE	'Z-80 FORTH'
	.PABS
;
;
; fig-FORTH for Z-80
;
; Z-80 code optomization and
; installation by
; Ray Duncan
; Laboratory Microsystems
; 4147 Beethoven Street
; Los Angeles, CA 90066
; (213) 390-9292
;
; Derives from fig-FORTH for 8080
; release 1.1 with compiler security
; and variable length names.
; Implementation by:
;    John Cassady
;    339 15th Street
;    Oakland, CA 94612
; Modified by:
;    Kim Harris
; Acknowledgements:
;    George Flammer
;    Robt. D. Villwock
;
; fig-FORTH is public domain software
; made available by
;    Forth Interest Group
;    P. O. Box 1105
;    San Carlos, CA 94070
;
;
;
	.PAGE
;
FIGREL	==	1	;FIG RELEASE #
FIGREV	==	1	;FIG REVISION #
USRVER	==	1	;USER VERSION #
;
; ASCII CHARACTERS USED
;
ABL	==	20H	;SPACE
ACR	==	0DH	;CARRIAGE RETURN
ADOT	==	02EH	;PERIOD
BELL	==	07H	;CONTROL G
BSIN	==	7FH	;INPUT BACKSPACE CHAR
BSOUT	==	08H	;OUTPUT BACKSPACE
DLE	==	10H	;^P
LF	==	0AH	;LINE FEED
FF	==	0CH	;FORM FEED
;
; MEMORY ALLOCATION
;
EM	==	4000H	;TOP OF MEMORY + 1
NSCR	==	1	;NUMBER OF 1024 BYTE SCREENS
KBBUF	==	128	;BYTES PER DISC BUFFER
US	==	40H	;USER VARIABLES SPACE
RTS	==	0A0H	;RETURN STACK,TERMINAL BUFF
;
CO	==	KBBUF+4	;DISK BUFFER+2HDR+2TAIL
NBUF	==	NSCR*400H/KBBUF	;NUMBER OF BUFFERS
BUF1	==	EM-CO*NBUF	;ADDR FIRST DISK BUFFER
INITR0	==	BUF1-US	;R0
INITS0	==	INITR0-RTS ;S0
;
	.PAGE
;
	.LOC	100H
;
ORIG:	NOP
	JMP	CLD	;VECTOR TO COLD START
	NOP
	JMP	WRM	;VECTOR TO WARM START
	.BYTE	FIGREL	;FIG RELEASE #
	.BYTE	FIGREV	;FIG REVISION #
	.BYTE	USRVER	;USER VERSION #
	.BYTE	0EH	;IMPLEMENTATION ATTRIB
	.WORD	TASK-7	;TOPMOST WORD IN FORTH VOCAB
	.WORD	BSIN	;BACKSPACE CHAR
	.WORD	INITR0	;INIT (UP)
;
; <<< FOLLOWING USED BY COLD, 
;     MUST BE IN SAME ORDENR AS USER VARIABLES >>>
;
	.WORD	INITS0
	.WORD	INITR0
	.WORD	INITS0	;INIT (TIB)
	.WORD	1FH	;INIT (WIDTH)
	.WORD	0	;INIT (WARNING)
	.WORD	INITDP	;INIT (FENCE)
	.WORD	INITDP	;INIT (DP)
	.WORD	FORTH+6	;INIT (VOC - LINK)
;
;
	.WORD	0,0B250H	;CPU NAME
				;32 BIT, BASE 36 INT
;
; IMPLEMENTATION ATTRIBUTES ORIG+0BH
;
; BIT  SIGNIFICANCE
;  0   PROCESSOR ADDR 0=BYTE 1=WORD
;  1   HIGH BYTE AT 0=LOW, 1=HIGH
;  2   ADDR MUST BE EVEN 0=YES  1=NO
;  3   INTERPRETER IS 0=PRE  1=POST
;  4   INCREMENTING 0=ABOVE SUFF  1=OTHER DIFFERENCES
;  5
;  6
;  7
;
;
; FORTH REGISTERS
;
; FORTH   Z-80   FORTH PRESERVATION RULES
;
;  IP     X     PRESERVED ACROSS FORTH WORDS
;
;  RP     IY     PRESERVED ACROSS FORTH WORDS
;  
;  W      DE     SOMETIMES OUTPUT FROM NEXT.
;		 MAY BE ALTERED BEFORE JMP'ING
;		 TO NEXT.  INPUT ONLY WHEN
;		 'DPUSH' CALLED
; 
;  SP	  SP	 SHOULD BE USED ONLY AS DATA
;		 STACK ACROSS FORTH WORDS. MAY
;		 BE USED WITHIN FORTH WORDS IF
;		 RESTORED BEFORE 'NEXT'.
;
;         HL     NEVER OUTPUT FROM 'NEXT'.
;		 INPUT ONLY WHEN 'HPUSH' CALLED.
;
UP:	.WORD	INITR0	;USER AREA POINTER
RPP:	.WORD	INITR0	;RETURN STACK POINTER
;
;
; COMMENT CONVENTIONS
;
;	=	MEANS	'IS EQUAL TO'
;	<-	MEANS	ASSIGNMENT
;
;	NAME	=	ADDRESS OF NAME
;	(NAME)	=	CONTENTS AT NAME
;	((NAME))=	INDIRECT CONTENTS
;
;	CFA	=	ADDRESS OF CODE FIELD
;	LFA	=	ADDRESS OF LINK FIELD
;	NFA	=	ADDR OF START OF NAME FIELD
;	PFA	=	ADDR OF START OF PARAM FIELD
;
;	S1	=	ADDR OF 1ST WD OF PARAM STACK
;	S2	=	ADDR OF 2ND WD OF PARAM STACK
;	R1	=	ADDR OF 1ST WD OF RETURN STACK
;	R2	=	ADDR OF 2ND WD OF RETURN STACK
;	(ABOVE STACK POSITIONS VALID BEFORE AND AFTER
;	 EXECUTION OF ANY WORD, NOT DURING)
;
;	LSB	=	LEAST SIGNIFICANT BIT
;	MSB	=	MOST SIGNIFICANT BIT
;	LB	=	LOW BYTE
;	HB	=	HIGH BYTE
;	LW	=	LOW WORD
;	HW	=	HIGH WORD
;	(MAY BE USED AS SUFFX TO ABOVE NAMES)
;
	.PAGE
;
; DEBUG SUPPORT
;
; TO USE:
; (1)   SET 'BIP' TO IP VALUE TO HALT, CANNOT BE CFA
; (2)   SET MONITOR'S BREAKPOINT PC TO ADDRESS OF
;       'BREAK', PATCH 'HLT' INSTRUCTION THERE,
;       OR INSERT JUMP TO A REGISTER DISPLAY
;       ROUTINE
; (3)	PATCH A 'JP TNEXT' AT 'NEXT'
;
; WHEN (IP)=(BIP) INTERPRETER WILL HALT
;
BIP:	.WORD	0	;BREAKPOINT ON IP VALUE
;
TNEXT:	LHLD	BIP	;GET BREAKPOINT ADDR
	PUSH	X	;COPY (IP) TO (DE)
	POP	D
	ORA	A	;CY <- 0
	DSBC	D	;DOES (IP) = (BIP)?
	JRNZ	TNEXT1  ;NO,JUMP
BREAK:	NOP		;PUT YOUR JUMP
	NOP		;OR HALT
	NOP		;HERE
TNEXT1:	MOV	L,0(X)	;RESUME EXECUTION
	MOV	H,1(X)
	INX	X
	INX	X
	JMPR	NEXT1
;
	.PAGE
;
; NEXT, THE FORTH ADDRESS INTERPRETER
; (POST INCREMENTING VERSION)
;
DPUSH:	PUSH	D
HPUSH:	PUSH	H
NEXT:			;(W) <- ((IP))
			;(IP) <- (IP)+2
	MOV	L,0(X)
	MOV	H,1(X)
	INX	X
	INX	X
NEXT1:	MOV	E,M	;(PC) <- ((W))
	INX	H
	MOV	D,M
	XCHG	
	PCHL		;NOTE (DE) = CFA+1
;
	.PAGE
;
;
; FORTH DICTIONARY
;
;
; DICTIONARY FORMAT:
;
; ADDR	NAME		BYTE CONTENTS
;
; 				(MSB=1
;				(P=PRECEDENCE BIT
;				(S=SMUDGE BIT
; NFA	NAME FIELD	1PS<LEN> <NAME LENGTH
;			0<1CHAR> MSB=0,NAME'S 1ST CHAR
;			0<2CHAR>
;			...
;			1<LCHAR> MSB=1,NAME'S LAST CHAR
; LFA	LINK FIELD	<LINKLB> = PREV WDS NFA
;			<LINKHB>
;LABEL:
; CFA	CODE FIELD	<CODELB> = ADDR CPU CODE
;			<CODEHB>
; PFA	PARAM FIELD	<1PARAM> 1ST PARAMETER BYTE
;			<2PARAM>
;			...
;
;
;
;
DP0:	.BYTE	83H	;LIT
	.ASCIS	'LIT'
	.WORD	0	;(LFA)=0 => END OF DICTIONARY
LIT:	.WORD	.+2	;(S1) <- ((IP))
	MOV	L,0(X)	;(HL) <- ((IP))
	MOV	H,1(X)
	INX	X
	INX	X
	JMPR	HPUSH	;(S1) <- (HL)
;
	.BYTE	87H	;EXECUTE
	.ASCIS	'EXECUTE'
	.WORD	LIT-6
EXEC:	.WORD	.+2
	POP	H	;(HL) <- (S1) = CFA
	JMPR	NEXT1
;
	.BYTE	86H	;BRANCH
	.ASCIS	'BRANCH'
	.WORD	EXEC-0AH
BRAN:	.WORD	.+2
BRAN1:
			;(DE) <- ((IP))
	MOV	E,0(X)	;=BRANCH OFFSET
	MOV	D,1(X)
	DADX	D	;NEW (IP)
	JMPR	NEXT
;
	.BYTE	87H	;0BRANCH
	.ASCIS	'0BRANCH'
	.WORD	BRAN-9
ZBRAN:	.WORD	.+2
	POP	H
	MOV	A,L
	ORA	H
	JRZ	BRAN1	;IF (S1)=0 THEN BRANCH
	INX	X
	INX	X	;ELSE SKIP OFFSET
	JMPR	NEXT
;
	.BYTE	86H	;(LOOP)
	.ASCIS	'(LOOP)'
	.WORD	ZBRAN-0AH
XLOOP:	.WORD	.+2
	LXI	D,1	;(DE) <- INCREMENT
XLOO1:			;((RP))=INDEX
	MOV	A,0(Y)	;INDEX <- INDEX+INCR
	ADD	E
	MOV	0(Y),A
	MOV	E,A
	MOV	A,1(Y)
	ADC	D
	MOV	1(Y),A
	INR	D
	DCR	D
	MOV	D,A	;(DE) <- NEW INDEX
	JM	XLOO2	;IF INCR > 0
	MOV	A,E
	SUB	2(Y)	;THEN (A) <- INDEX-LIMIT
	MOV	A,D
	SBB	3(Y)
	JMPR	XLOO3
XLOO2:	MOV	A,2(Y) 	;ELSE (A) <- LIMIT-X
	SUB	E
	MOV	A,3(Y)
	SBB	D
XLOO3:			;IF (A) < 0
	JM	BRAN1	;THEN LOOP AGAIN
	LXI	B,4	;DISCARD R1 AND R2
	DADY	B
	INX	X	;SKIP BRANCH OFFSET
	INX	X
	JMP	NEXT
;
;
	.BYTE	87H	;(+LOOP)
	.ASCIS	'(+LOOP)'
	.WORD	XLOOP-9
XPLOO:	.WORD	.+2
	POP	D	;(DE) <- INCR
	JMPR	XLOO1
;
	.BYTE	84H	;(DO)
	.ASCIS	'(DO)'
	.WORD	XPLOO-0AH
XDO:	.WORD	.+2
	LXI	D,-4
	DADY	D	;(RP) <- (RP)-4
	POP	D	;(R1) <- (S1)=INIT INDEX
	MOV	0(Y),E
	MOV	1(Y),D
	POP	D	;(R2) <- (S2)=LIMIT
	MOV	2(Y),E
	MOV	3(Y),D
	JMP	NEXT
;
	.BYTE	81H	;I
	.ASCIS	'I'
	.WORD	XDO-7
IDO:	.WORD	.+2	;(S1)<-(R1),(R1)UNCHANGED
	MOV	E,0(Y)
	MOV	D,1(Y)
	PUSH	D	;(S1) <- (DE)
	JMP	NEXT
;
	.BYTE	85H	;DIGIT
	.ASCIS	'DIGIT'
	.WORD	IDO-4
DIGIT:	.WORD	.+2
	POP	H	;(L) <- (S1), LB = ASCII
			;CHAR TO BE CONVERTED
	POP	D	;(DE) <- (S2) = BASE
	MOV	A,E
	SUI	30H	;IF CHR > '0'
	JM	DIGI2
	CPI	0AH	;AND IF CHR > '9'
	JM	DIGI1
	SUI	7
	CPI	0AH	;AND IF CHAR >= 'A'
	JM	DIGI2
DIGI1:	CMP	L	;IF < BASE VALUE
	JP	DIGI2
			;THEN VALID DIGIT CHR
	MOV	E,A	;(S2) <- (DE) = CONV DIGIT
	LXI	H,1	;(S1) <- TRUE
	JMP	DPUSH
			;ELSE INVALID DIGIT
DIGI2:	MOV	L,H	;(HL) <- FALSE
	JMP	HPUSH
;
	.BYTE	86H	;(FIND) (2-1)FAILURE
	.ASCIS	'(FIND)'
	.WORD	DIGIT-8
PFIND:	.WORD	.+2
	POP	D	;(DE) <- NFA
PFIN1:	POP	H	;(HL) <- STRING ADDR
	PUSH	H	;SAVE STRING ADDR FOR
			;NEXT ITERATION
	LDAX	D
	XRA	M	;CHECK LENGTHS,SMUDGE BIT
	ANI	3FH
	JRNZ	PFIN4   ;LENGTHS DIFFERENT
PFIN2:	INX	H	;(HL) <- ADDR NEXT CHAR
			;IN STRING
	INX	D	;(DE) <- ADDR NEXT CHAR
			;IN NF
	LDAX	D
	XRA	M	;IGNORE MSG
	ADD	A
	JRNZ	PFIN3   ;NO MATCH
	JRNC	PFIN2   ;MATCH SO FAR,LOOP AGAIN
	LXI	H,5	;STRING MATCHES
	DAD	D	;((SP)) <- PFA
	XTHL
			;BACK UP TO LENGTH BYTE
			;OF NF = NFA
PFIN6:	DCX	D
	LDAX	D
	ORA	A
	JP	PFIN6	;IF MSB=1 THEN (DE)=NFA
	MOV	E,A	;(DE) <- LENGTH BYTE
	MVI	D,0
	LXI	H,1	;(HL) <- TRUE
	JMP	DPUSH	;RETURN, NF FOUND
			;
			;ABOVE NF NOT A MATCH,
			;TRY ANOTHER
PFIN3:	JRC	PFIN5	;IF NOT END OF NF
PFIN4:	INX	D	;THEN FIND END OF NF
	LDAX	D
	ORA	A
	JP	PFIN4
PFIN5:	INX	D	;(DE) <- LFA
	XCHG	
	MOV	E,M	;(DE) <- LFA
	INX	H
	MOV	D,M
	MOV	A,D
	ORA	E	;IF (LFA) <> 0
	JRNZ	PFIN1   ;THEN TRY PREVIOUS
			;DICTIONARY DEF
			;ELSE END OF DICTIONARY
	POP	H	;DISCARD STRING ADDR
	LXI	H,0	;(HL) <- FALSE
	JMP	HPUSH	;RETURN, NO MATCH FOUND
;
	.BYTE	87H	;ENCLOSE
	.ASCIS	'ENCLOSE'
	.WORD	PFIND-9
ENCL:	.WORD	.+2
	POP	D	;(DE) <- (S1) = DELIMITER
	POP	H	;(HL) <- (S2) = ADDR
			;TEXT TO SCAN
	PUSH	H	;(S4) <- ADDR
	MOV	A,E
	MOV	D,A	;(D) <- DELIMITER CHAR
	MVI	E,-1	;INIT CHAR OFFSET COUNTER
	DCX	H	;(HL) <- ADDR-1
			;SKIP OVER LEADING
			;DELIMITER CHARACTERS
ENCL1:	INX	H
	INR	E
	CMP	M	;IF TEXT CHAR = DELIMITER
	JRZ	ENCL1	;THEN LOOP AGAIN
			;ELSE NON-DELIMITER FOUND
	MVI	D,0	;(S3) <- (E) = OFFSET
			;TO 1ST NON-DELIMITER
	PUSH	D
	MOV	D,A	;(D) <- DELIMITER
	MOV	A,M	;IF 1ST NON-DELIMITER
			; = NULL
	ANA	A
	JRNZ	ENCL2
	MVI	D,0	;THEN (S2) <- OFFSET TO
	INR	E	;BYTE FOLLOWING NULL
	PUSH	D
	DCR	E	;(S1) <- OFFSET TO NULL
	PUSH	D
	JMP	NEXT
			;ELSE TEXT CONTAINS 
			;NON-DELIMITER AND
			;NON-NULL CHARACTER
ENCL2:	MOV	A,D	;(A) <- DELIMITER
	INX	H	;(HL) <- ADDR NEXT CHAR
	INR	E	;(E) <- OFFSET TO NEXT CHAR
	CMP	M	;IF NEXT CHAR <> DELIMITER
	JRZ	ENCL4
	MOV	A,M	;AND IF NEXT CHAR <> NULL
	ANA	A
	JRNZ	ENCL2   ;THEN CONTINUE SCAN
			;ELSE CHAR = NULL
ENCL3:	MVI	D,0	;(S2) <- OFFSET TO NULL
	PUSH	D
	PUSH	D	;(S1) <- OFFSET TO NULL
	JMP	NEXT
			;ELSE CHAR = DELIMITER
ENCL4:	MVI	D,0	;(S2) <- OFFSET TO BYTE
			;FOLLOWING TEXT
	PUSH	D
	INR	E	;(S1) <- OFFSET TO 
			;2 BYTES AFTER END OF WORD
	PUSH	D
	JMP	NEXT
;
	.BYTE	84H	;EMIT
	.ASCIS	'EMIT'
	.WORD	ENCL-0AH
EMIT:	.WORD	DOCOL
	.WORD	PEMIT
	.WORD	ONE
	.WORD	OUTT
	.WORD	PSTOR
	.WORD	SEMIS
;
	.BYTE	83H	;KEY
	.ASCIS	'KEY'
	.WORD	EMIT-7
KEY:	.WORD	.+2
	JMP	PKEY
;
	.BYTE	89H	;?TERMINAL
	.ASCIS	'?TERMINAL'
	.WORD	KEY-6
QTERM:	.WORD	.+2
	LXI	H,0
	JMP	PQTER
;
	.BYTE	82H	;CR
	.ASCIS	'CR'
	.WORD	QTERM-0CH
CR:	.WORD	.+2
	JMP	PCR
;
	.BYTE	85H	;CMOVE
	.ASCIS	'CMOVE'
	.WORD	CR-5
CMOVE:	.WORD	.+2
	POP	B	;(BC) <- (S1)=#CHRS
	POP	D	;(DE) <- (S2)=DEST
	POP	H	;(HL) <- (S3)=SOURCE
	MOV	A,B
	ORA	C
	JZ	NEXT	;EXIT IF COUNT=ZERO
	LDIR		;NOW MOVE STRING
	JMP	NEXT
;
	.BYTE	82H	;U* 16*16 UNSIGNED MPY
	.ASCIS	'U*'
	.WORD	CMOVE-8
USTAR:	.WORD	.+2
	POP	D	;(DE) <- MULTIPLIER
	POP	H	;(HL) <- MULTIPLICAND
	MOV	B,H
	MOV	A,L	;(BA) <- MPCAND
	CALL	MPYX	;(AHL)1 <- MPCAND.LB
			;*MULTIPLIER
			;1ST PARTIAL PRODUCT
	PUSH	H	;SAVE (HL)1
	MOV	H,A
	MOV	A,B
	MOV	B,H	;SAVE (A)1
	CALL	MPYX	;(AHL)2 <- MPCAND.HB
			;* MULTIPLIER
			;2ND PARTIAL PRODUCT
	POP	D	;(DE) <- (HL)1
	MOV	C,D	;(BC) <- (AH)1
			;FORM SUM OF PARTIALS
			;(AHLE) <- (AHL)1+(AHL)2
	DAD	B	;(HL)<- (HL)2 + (AH)1
	ACI	0	;(AHLE)<- (BA)*(DE)
	MOV	D,L
	MOV	L,H
	MOV	H,A	;(HLDE) <- MULTIPLIER*MPCAND
	PUSH	D	;(S2) <- PRODUCT.LW
	JMP	HPUSH	;(S1) <- PRODUCT.HW
;
; MULTIPLY PRIMITIVE
; (AHL) <- (A)*(DE)
;  24       8   16
;
MPYX:	LXI	H,0	;(HL) <- 0 PARTIAL PRODUCT.LW
	MVI	C,8	;LOOP COUNT
MPYX1:	DAD	H	;LEFT SHIFT AHL 24 BITS
	RAL
	JRNC	MPYX2   ;IF NEXT MULTIPLIER BIT=1
	DAD	D	;THEN ADD MPCAND
	ACI	0
MPYX2:	DCR	C	;IF NOT LAST MULTIPLIER BIT
	JRNZ	MPYX1   ;LOOP AGAIN
	RET		;ELSE DONE
;
	.BYTE	82H	;U/
	.ASCIS	'U/'
	.WORD	USTAR-5
USLAS:	.WORD	.+2
	LXI	H,4
	DAD	SP	;((HL)) <- NUMERATOR.LW
	MOV	E,M	;(DE) <- NUMER.LW
	MOV	M,C	;SAVE IP ON STACK
	INX	H
	MOV	D,M
	MOV	M,B
	POP	B	;(BC) <- DENOMINATOR
	POP	H	;(HL) <- NUMER.HW
	MOV	A,L
	SUB	C	;IF NUMER >= DENOM
	MOV	A,H
	SBB	B
	JRC	USLA1
	LXI	H,-1	;THEN OVERFLOW
	LXI	D,-1	;SET REM AND QUOT TO MAX
	JMPR	USLA7
USLA1:	MVI	A,16	;LOOP COUNTER
USLA2:	DAD	H	;LEFT SHIFT CARRY << (HLDE)
	RAL
	XCHG
	DAD	H
	JRNC	USLA3
	INX	D
	ANA	A
USLA3:	XCHG		;SHIFT DONE
	RAR		;RESTORE 1ST CARRY
	PUSH	PSW	;SAVE COUNTER
	JRNC	USLA4   ;IF CARRY=1
	ORA	A	;THEN (HL) <- (HL)-(BC)
	DSBC	B
	JMPR	USLA5
USLA4:	ORA	A	;ELSE TRY (HL) <- (HL)-
	DSBC	B	;(HL) <- PARTIAL REMAINDER
	JRNC	USLA5
	DAD	B	;UNDERFLOW,RESTORE
	DCX	D
USLA5:	INX	D	;INCREMENT QUOTIENT
USLA6:	POP	PSW	;RESTORE COUNTER
	DCR	A
	JRNZ	USLA2   ;LOOP AGAIN
USLA7:	POP	B	;ELSE DONE,RESTORE IP
	PUSH	H	;(S2) <- REMAINDER
	PUSH	D	;(S1) <- QUOTIENT
	JMP	NEXT
;
	.BYTE	83H	;AND
	.ASCIS	'AND'
	.WORD	USLAS-5
ANDD:	.WORD	.+2	;(S1) <- (S1) AND (S2)
	POP	D
	POP	H
	MOV	A,E
	ANA	L
	MOV	L,A
	MOV	A,D
	ANA	H
	MOV	H,A
	JMP	HPUSH
;
	.BYTE	82H	;OR
	.ASCIS	'OR'
	.WORD	ANDD-6
ORR:	.WORD	.+2	;(S1) <- (S1) OR (S2)
	POP	D
	POP	H
	MOV	A,E
	ORA	L
	MOV	L,A
	MOV	A,D
	ORA	H
	MOV	H,A
	JMP	HPUSH
;
	.BYTE	83H	;XOR
	.ASCIS	'XOR'
	.WORD	ORR-5
XORR:	.WORD	.+2	;(S1) <- (S1) XOR (S2)
	POP	D
	POP	H
	MOV	A,E
	XRA	L
	MOV	L,A
	MOV	A,D
	XRA	H
	MOV	H,A
	JMP	HPUSH
;
	.BYTE	83H	;SP@
	.ASCIS	'SP@'
	.WORD	XORR-6
SPAT:	.WORD	.+2
	LXI	H,0	;(S1) <- (SP)
	DAD	SP
	JMP	HPUSH
;
;
	.BYTE	83H
	.ASCIS	'SP!'
	.WORD	SPAT-6
SPST0:	.WORD	.+2	;(SP) <- (S0) (USER VAR)
	LHLD	UP	;(HL) <- USER VAR BASE ADDR
	LXI	D,6
	DAD	D	;(HL) <- S0
	MOV	E,M	;(DE) <- (S0)
	INX	H
	MOV	D,M
	XCHG
	SPHL		;(SP) <- (S0)
	JMP	NEXT
;
	.BYTE	83H	;RP@
	.ASCIS	'RP@'
	.WORD	SPST0-6
RPAT:	.WORD	.+2
	PUSH	Y
	JMP	NEXT
;
	.BYTE	83H	;RETURN STACK PTR STORE
	.ASCIS	'RP!'
	.WORD	RPAT-6
RPST0:	.WORD	.+2	;(RP) <- (R0) (USER VAR)
	LHLD	UP	;(HL) <- USER VAR BASE ADDR
	LXI	D,8
	DAD	D	;(HL) <- R0
	MOV	E,M	;(DE) <- (R0)
	INX	H
	MOV	D,M
	PUSH	D
	POP	Y	;(RP) <- (R0)
	JMP	NEXT
;
	.BYTE	82H	; ;S
	.ASCIS	';S'
	.WORD	RPST0-6
SEMIS:	.WORD	.+2	;(IP) <- (R1)
	MOV	C,0(Y)	;(BC) <- (R1)
	INX	Y
	MOV	B,0(Y)
	INX	Y	;(RP) <- (RP)+2
	PUSH	B	;(IP) <- (BC)
	POP	X
	JMP	NEXT
;
	.BYTE	85H	;LEAVE
	.ASCIS	'LEAVE'
	.WORD	SEMIS-5
LEAVE:	.WORD	.+2	;LIMIT <- INDEX
	MOV	E,0(Y)	;(DE) <- (R1)=INDEX
	MOV	D,1(Y)
	MOV	2(Y),E  ;(R2) <- (DE)=LIMIT
	MOV	3(Y),D
	JMP	NEXT
;
	.BYTE	82H	; >R
	.ASCIS	'>R'
	.WORD	LEAVE-8
TOR:	.WORD	.+2	;(R1) <- (S1)
	POP	D	;(DE) <- (S1)
	DCX	Y
	DCX	Y	;(RP) <- (RP)-2
	MOV	0(Y),E	;((RP) <- (DE)
	MOV	1(Y),D
	JMP	NEXT
;
	.BYTE	82H	; R>
	.ASCIS	'R>'
	.WORD	TOR-5
FROMR:	.WORD	.+2	;(S1) <- (R1)
	MOV	E,0(Y)	;(DE) <- (R1)
	INX	Y
	MOV	D,0(Y)
	INX	Y	;(RP) <- (RP)+2
	PUSH	D	;(S1) <- (DE)
	JMP	NEXT
;
	.BYTE	81H	;R
	.ASCIS	'R'
	.WORD	FROMR-5
RR:	.WORD	IDO+2
;
	.BYTE	82H	; 0=
	.ASCIS	'0='
	.WORD	RR-4
ZEQU:	.WORD	.+2
	POP	H	;(HL) <- (S1)
	MOV	A,L
	ORA	H	;IF (HL)=0
	LXI	H,0	;THEN (HL)=FALSE
	JRNZ	ZEQU1
	INX	H	;ELSE (HL)=TRUE
ZEQU1:	JMP	HPUSH	;(S1) <- (HL)
;
	.BYTE	82H	; 0<
	.ASCIS	'0<'
	.WORD	ZEQU-5
ZLESS:	.WORD	.+2
	POP	H	;(HL) <- (S1)
	DAD	H	;IF (HL) >= 0
	LXI	H,0
	JRNC	ZLES1   ;THEN (HL) <- FALSE
	INX	H
ZLES1:	JMP	HPUSH
;
	.BYTE	81H	;+
	.ASCIS	'+'
	.WORD	ZLESS-5
PLUS:	.WORD	.+2
	POP	D	;(S1) <- (S1)+(S2)
	POP	H
	DAD	D
	JMP	HPUSH
;
	.BYTE	82H	;D+ (4-2)
	.ASCIS	'D+'	;XLW XHW YLW YHW - SLW SHW
	.WORD	PLUS-4	;S4  S3  S2  S1    S2  S1
DPLUS:	.WORD	.+2
	LXI	H,6
	DAD	SP	;((HL)) = XLW
	MOV	E,M	;(DE) =XLW
	MOV	M,C	;SAVE IP ON STACK
	INX	H
	MOV	D,M
	MOV	M,B
	POP	B	;(BC) <- YHW
	POP	H	;(HL) <- YLW
	DAD	D
	XCHG		;(DE) <- YLW +XLW=SUM.LW
	POP	H	;(HL) <- XHW
	DADC	B	;(HL) <- YHR+XHW+CARRY
	POP	B	;RESTORE IP
	PUSH	D	;(S2) <- SUM.LW
	JMP	HPUSH	;(S1) <- SUM.HW
;
	.BYTE	85H	;MINUS
	.ASCIS	'MINUS'
	.WORD	DPLUS-5
MINUS:	.WORD	.+2	;(S1) <- -(S1)
	LXI	H,0
	POP	D
	ORA	A	;OFF CARRY
			;NOW (HL) <- 0 - (S1)
	DSBC	D
	JMP	HPUSH
;
	.BYTE	86H	;DMINUS
	.ASCIS	'DMINUS'
	.WORD	MINUS-8
DMINU:	.WORD	.+2
	POP	D	;(DE) <- HL
	POP	B	;(BC) <- LW
	LXI	H,0
	ORA	A	;CY <- 0
	DSBC	B	;LW <- -LW
	PUSH	H
	LXI	H,0
	DSBC	D	;HW <- -HW
	JMP	HPUSH	;(S2) <- -LW
			;(S1) <- -HL
;
	.BYTE	84H	;OVER
	.ASCIS	'OVER'
	.WORD	DMINU-9
OVER:	.WORD	.+2
	POP	D
	POP	H
	PUSH	H
	JMP	DPUSH
;
	.BYTE	84H	;DROP
	.ASCIS	'DROP'
	.WORD	OVER-7
DROP:	.WORD	.+2
	POP	H
	JMP	NEXT
;
	.BYTE	84H	;SWAP
	.ASCIS	'SWAP'
	.WORD	DROP-7
SWAP:	.WORD	.+2
	POP	H
	XTHL	
	JMP	HPUSH
;
	.BYTE	83H	;DUP
	.ASCIS	'DUP'
	.WORD	SWAP-7
DUP:	.WORD	.+2
	POP	H
	PUSH	H
	JMP	HPUSH
;
	.BYTE	84H	;2DUP
	.ASCIS	'2DUP'
	.WORD	DUP-6
TDUP:	.WORD	.+2
	POP	H
	POP	D
	PUSH	D
	PUSH	H
	JMP	DPUSH
;
	.BYTE	82H	;PLUS STORE
	.ASCIS	'+!'
	.WORD	TDUP-7
PSTOR:	.WORD	.+2	;((S1)) <- ((S1))+(S2)
	POP	H	;(HL) <- (S1)=ADDR
	POP	D	;(DE) <- (S2)=INCR
	MOV	A,M	;((HL))<=((HL))+(DE)
	ADD	E
	MOV	M,A
	INX	H
	MOV	A,M
	ADC	D
	MOV	M,A
	JMP	NEXT
;
	.BYTE	86H	;TOGGLE
	.ASCIS	'TOGGLE'
	.WORD	PSTOR-5
TOGGL:	.WORD	.+2	;((S2))<- ((S2)) XOR (S1)LB
	POP	D	;(E) <- BYTE MASK
	POP	H	;(HL) <- ADDR
	MOV	A,M
	XRA	E
	MOV	M,A	;(ADDR) <- (ADDR) XOR (E)
	JMP	NEXT
;
	.BYTE	81H	;@
	.ASCIS	'@'
	.WORD	TOGGL-9
AT:	.WORD	.+2	;(S1) <- ((S1))
	POP	H	;(HL) <- ADDR
	MOV	E,M	;(DE) <- (ADDR)
	INX	H
	MOV	D,M
	PUSH	D	;(S1) <- (DE)
	JMP	NEXT
;
	.BYTE	82H	;C@
	.ASCIS	'C@'
	.WORD	AT-4
CAT:	.WORD	.+2	;(S1) <- ((S1))LB
	POP	H	;(HL) <- ADDR
	MOV	L,M	;(HL) <- (ADDR) LB
	MVI	H,0
	JMP	HPUSH
;
	.BYTE	82H	;2@
	.ASCIS	'2@'
	.WORD	CAT-5
TAT:	.WORD	.+2
	POP	H	;(HL) <- ADDR HW
	LXI	D,2
	DAD	D	;(HL) <- ADDR LW
	MOV	E,M	;(DE) <- LW
	INX	H
	MOV	D,M
	PUSH	D	;(S2) <- LW
	LXI	D,-3	;(HL) <- ADDR HW
	DAD	D
	MOV	E,M	;(DE) <- HW
	INX	H
	MOV	D,M
	PUSH	D	;(S1) <- HW
	JMP	NEXT
;
	.BYTE	81H	;STORE
	.ASCIS	'!'
	.WORD	TAT-5
STORE:	.WORD	.+2	;((S1)) <- (S2)
	POP	H	;(HL) <- (S1)=ADDR
	POP	D	;(DE) <- (S2)=VALUE
	MOV	M,E	;((HL)) <- (DE)
	INX	H
	MOV	M,D
	JMP	NEXT
;
	.BYTE	82H	;C STORE
	.ASCIS	'C!'
	.WORD	STORE-4
CSTOR:	.WORD	.+2	;((S1))LB <- (S2)LB
	POP	H	;(HL) <- (S1)=ADDR
	POP	D	;(DE) <- (S2)=BYTE
	MOV	M,E	;((HL))LB <- (E)
	JMP	NEXT
;
	.BYTE	82H	;2 STORE
	.ASCIS	'2!'
	.WORD	CSTOR-5
TSTOR:	.WORD	.+2
	POP	H	;(HL) <- ADDR
	POP	D	;(DE) <- HW
	MOV	M,E	;(ADDR) <- HW
	INX	H
	MOV	M,D
	INX	H	;(HL) <- ADDR LW
	POP	D	;(DE) <- LW
	MOV	M,E
	INX	H
	MOV	M,D
	JMP	NEXT
;
	.BYTE	0C1H	; :
	.ASCIS	':'
	.WORD	TSTOR-5
COLON:	.WORD	DOCOL
	.WORD	QEXEC
	.WORD	SCSP
	.WORD	CURR
	.WORD	AT
	.WORD	CONT
	.WORD	STORE
	.WORD	CREAT
	.WORD	RBRAC
	.WORD	PSCOD
DOCOL:
	PUSH	X	;(BC) <- (IP)
	POP	B
	DCX	Y	;(R1) <- (IP)
	MOV	0(Y),B
	DCX	Y	;(RP) <- (RP)-2
	MOV	0(Y),C
	INX	D	;(DE) <- CFA+2=(W)
	PUSH	D	;(IP) <- (DE)=(W)
	POP	X
	JMP	NEXT
;
	.BYTE	0C1H	; SEMICOLON
	.ASCIS	';'
	.WORD	COLON-4
SEMI:	.WORD	DOCOL
	.WORD	QCSP
	.WORD	COMP
	.WORD	SEMIS
	.WORD	SMUDG
	.WORD	LBRAC
	.WORD	SEMIS
;
	.BYTE	84H	;NOOP
	.ASCIS	'NOOP'
	.WORD	SEMI-4
NOOP:	.WORD	DOCOL
	.WORD	SEMIS
;
	.BYTE	88H	;CONSTANT
	.ASCIS	'CONSTANT'
	.WORD	NOOP-7
CON:	.WORD	DOCOL
	.WORD	CREAT
	.WORD	SMUDG
	.WORD	COMMA
	.WORD	PSCOD
DOCON:	INX	D	;(DE) <- PFA
	XCHG
	MOV	E,M	;(DE) <- (PFA)
	INX	H
	MOV	D,M
	PUSH	D
	JMP	NEXT
;
	.BYTE	88H	;VARIABLE
	.ASCIS	'VARIABLE'
	.WORD	CON-11
VAR:	.WORD	DOCOL
	.WORD	CON
	.WORD	PSCOD
DOVAR:	INX	D	;(DE) <- PFA
	PUSH	D	;(S1) <- PFA
	JMP	NEXT
;
	.BYTE	84H	;USER
	.ASCIS	'USER'
	.WORD	VAR-0BH
USER:	.WORD	DOCOL
	.WORD	CON
	.WORD	PSCOD
DOUSE:	INX	D	;(DE) <- PFA
	XCHG
	MOV	E,M	;(DE) <- USER VAR
			;OFFSET
	MVI	D,0
	LHLD	UP      ;(HL) <- USER VAR
			;BASE ADDRESS
	DAD	D	;(HL) <- (HL)+(DE)
	JMP	HPUSH	;(S1) <- BASE+OFFSET
;
	.BYTE	81H	; 0
	.ASCIS	'0'
	.WORD	USER-7
ZERO:	.WORD	DOCON
	.WORD	0
;
	.BYTE	81H	; 1
	.ASCIS	'1'
	.WORD	ZERO-4
ONE:	.WORD	DOCON
	.WORD	1
;
	.BYTE	81H	; 2
	.ASCIS	'2'
	.WORD	ONE-4
TWO:	.WORD	DOCON
	.WORD	2
;
	.BYTE	81H	; 3
	.ASCIS	'3'
	.WORD	TWO-4
THREE:	.WORD	DOCON
	.WORD	3
;
	.BYTE	82H	; BL
	.ASCIS	'BL'
	.WORD	THREE-4
BL:	.WORD	DOCON
	.WORD	20H
;
	.BYTE	83H	; C/L CHAR PER LINE
	.ASCIS	'C/L'
	.WORD	BL-5
CSLL:	.WORD	DOCON
	.WORD	64
;
	.BYTE	85H	;FIRST
	.ASCIS	'FIRST'
	.WORD	CSLL-6
FIRST:	.WORD	DOCON
	.WORD	BUF1
;
	.BYTE	85H	; LIMIT
	.ASCIS	'LIMIT'
	.WORD	FIRST-8
LIMIT:	.WORD	DOCON
	.WORD	EM
;
	.BYTE	85H	; B/BUF
	.ASCIS	'B/BUF' ;BYTES PER BUFFER
	.WORD	LIMIT-8
BBUF:	.WORD	DOCON
	.WORD	KBBUF
;
	.BYTE	85H	;B/SCR
	.ASCIS	'B/SCR'
	.WORD	BBUF-8
BSCR:	.WORD	DOCON
	.WORD	400H/KBBUF
;
	.BYTE	87H	;+ORIGIN
	.ASCIS	'+ORIGIN'
	.WORD	BSCR-8
PORIG:	.WORD	DOCOL
	.WORD	LIT
	.WORD	ORIG
	.WORD	PLUS
	.WORD	SEMIS
;
;
; USER VARIABLES
;
	.BYTE	82H	; S0
	.ASCIS	'S0'
	.WORD	PORIG-0AH
SZERO:	.WORD	DOUSE
	.WORD	6
;
	.BYTE	82H	; R0
	.ASCIS	'R0'
	.WORD	SZERO-5
RZERO:	.WORD	DOUSE
	.WORD	8
;
	.BYTE	83H	; TIB
	.ASCIS	'TIB'
	.WORD	RZERO-5
TIB:	.WORD	DOUSE
	.BYTE	0AH
;
	.BYTE	85H	; WIDTH
	.ASCIS	'WIDTH'
	.WORD	TIB-6
WIDTH:	.WORD	DOUSE
	.BYTE	0CH
;
	.BYTE	87H	;WARNING
	.ASCIS	'WARNING'
	.WORD	WIDTH-8
WARN:	.WORD	DOUSE
	.BYTE	0EH
;
	.BYTE	85H	;FENCE
	.ASCIS	'FENCE'
	.WORD	WARN-0AH
FENCE:	.WORD	DOUSE
	.BYTE	10H
;
	.BYTE	82H	; DP
	.ASCIS	'DP'
	.WORD	FENCE-8
DP:	.WORD	DOUSE
	.BYTE	12H
;
	.BYTE	88H	;VOC-LINK
	.ASCIS	'VOC-LINK'
	.WORD	DP-5
VOCL:	.WORD	DOUSE
	.WORD	14H
;
	.BYTE	83H	; BLK
	.ASCIS	'BLK'
	.WORD	VOCL-0BH
BLK:	.WORD	DOUSE
	.BYTE	16H
;
	.BYTE	82H	; IN
	.ASCIS	'IN'
	.WORD	BLK-6
INN:	.WORD	DOUSE
	.BYTE	18H
;
	.BYTE	83H	; OUT
	.ASCIS	'OUT'
	.WORD	INN-5
OUTT:	.WORD	DOUSE
	.BYTE	1AH
;
	.BYTE	83H	; SCR
	.ASCIS	'SCR'
	.WORD	OUTT-6
SCR:	.WORD	DOUSE
	.BYTE	1CH
;
	.BYTE	86H	;OFFSET
	.ASCIS	'OFFSET'
	.WORD	SCR-6
OFSET:	.WORD	DOUSE
	.BYTE	1EH
;
	.BYTE	87H	;CONTEXT
	.ASCIS	'CONTEXT'
	.WORD	OFSET-9
CONT:	.WORD	DOUSE
	.BYTE	20H
;
	.BYTE	87H	;CURRENT
	.ASCIS	'CURRENT'
	.WORD	CONT-0AH
CURR:	.WORD	DOUSE
	.BYTE	22H
;
	.BYTE	85H	; STATE
	.ASCIS	'STATE'
	.WORD	CURR-0AH
STATE:	.WORD	DOUSE
	.BYTE	24H
;
	.BYTE	84H	; BASE
	.ASCIS	'BASE'
	.WORD	STATE-8
BASE:	.WORD	DOUSE
	.BYTE	26H
;
	.BYTE	83H	; DPL
	.ASCIS	'DPL'
	.WORD	BASE-7
DPL:	.WORD	DOUSE
	.BYTE	28H
;
	.BYTE	83H	; FLD
	.ASCIS	'FLD'
	.WORD	DPL-6
FLD:	.WORD	DOUSE
	.BYTE	2AH
;
	.BYTE	83H	; CSP
	.ASCIS	'CSP'
	.WORD	FLD-6
CSPP:	.WORD	DOUSE
	.BYTE	2CH
;
	.BYTE	82H	; R#
	.ASCIS	'R#'
	.WORD	CSPP-6
RNUM:	.WORD	DOUSE
	.BYTE	2EH
;
	.BYTE	83H	; HLD
	.ASCIS	'HLD'
	.WORD	RNUM-5
HLD:	.WORD	DOUSE
	.WORD	30H
;
; END OF USER VARIABLES
;
	.BYTE	82H	; 1+
	.ASCIS	'1+'
	.WORD	HLD-6
ONEP:	.WORD	DOCOL
	.WORD	ONE
	.WORD	PLUS
	.WORD	SEMIS
;
	.BYTE	82H	; 2+
	.ASCIS	'2+'
	.WORD	ONEP-5
TWOP:	.WORD	DOCOL
	.WORD	TWO
	.WORD	PLUS
	.WORD	SEMIS
;
	.BYTE	84H	;HERE
	.ASCIS	'HERE'
	.WORD	TWOP-5
HERE:	.WORD	DOCOL
	.WORD	DP
	.WORD	AT
	.WORD	SEMIS
;
	.BYTE	85H	;ALLOT
	.ASCIS	'ALLOT'
	.WORD	HERE-7
ALLOT:	.WORD	DOCOL
	.WORD	DP
	.WORD	PSTOR
	.WORD	SEMIS
;
	.BYTE	81H	; ,
	.ASCIS	','
	.WORD	ALLOT-8
COMMA:	.WORD	DOCOL
	.WORD	HERE
	.WORD	STORE
	.WORD	TWO
	.WORD	ALLOT
	.WORD	SEMIS
;
	.BYTE	82H	; C,
	.ASCIS	'C,'
	.WORD	COMMA-4
CCOMM:	.WORD	DOCOL
	.WORD	HERE
	.WORD	CSTOR
	.WORD	ONE
	.WORD	ALLOT
	.WORD	SEMIS
;
	.BYTE	81H	; -
	.ASCIS	'-'
	.WORD	CCOMM-5
SUBB:	.WORD	.+2
	POP	D	;(DE) <- (S1) = Y
	POP	H	;(HL) <- (S2) = X
	ORA	A	;CARRY OFF
	DSBC	D	;NOW SUBTRACT
	JMP	HPUSH	;(S1) <- X-Y
;
	.BYTE	81H	; = 
	.ASCIS	'='
	.WORD	SUBB-4
EQUAL:	.WORD	DOCOL
	.WORD	SUBB
	.WORD	ZEQU
	.WORD	SEMIS
;
	.BYTE	81H	; <
	.ASCIS	'<'
	.WORD	EQUAL-4	;X (S2) < Y (S1)
LESS:	.WORD	.+2
	POP	D	;(DE) <- (S1)=Y
	POP	H	;(HL) <- (S2)=X
	MOV	A,D	;IF X AND Y HAVE
			;SAME SIGNS
	XRA	H	;THIS ALSO CY<- 0
	JM	LES1	;
	DSBC	D
LES1:	INR	H	;IF (HL) >= 0
	DCR	H
	JM	LES2
	LXI	H,0	;THEN X>= Y
	JMP	HPUSH	;(S1) <- FALSE
LES2:	LXI	H,1	;ELSE X<Y
	JMP	HPUSH	;(S1) <- TRUE
;
	.BYTE	82H	; U<  (UNSIGNED <)
	.ASCIS	'U<'
	.WORD	LESS-4
ULESS:	.WORD	DOCOL
	.WORD	TDUP
	.WORD	XORR
	.WORD	ZLESS
	.WORD	ZBRAN
	.WORD	ULES1-.		;IF
	.WORD	DROP
	.WORD	ZLESS
	.WORD	ZEQU
	.WORD	BRAN
	.WORD	ULES2-.
ULES1:	.WORD	SUBB
	.WORD	ZLESS		;ELSE
ULES2:	.WORD	SEMIS		;ENDIF
;
	.BYTE	81H	; >
	.ASCIS	'>'
	.WORD	ULESS-5
GREAT:	.WORD	DOCOL
	.WORD	SWAP
	.WORD	LESS
	.WORD	SEMIS
;
	.BYTE	83H	; ROT
	.ASCIS	'ROT'
	.WORD	GREAT-4
ROT:	.WORD	.+2
	POP	D
	POP	H
	XTHL
	JMP	DPUSH
;
	.BYTE	85H	; SPACE
	.ASCIS	'SPACE'
	.WORD	ROT-6
SPACE:	.WORD	DOCOL
	.WORD	BL
	.WORD	EMIT
	.WORD	SEMIS
;
	.BYTE	84H	; -DUP
	.ASCIS	'-DUP'
	.WORD	SPACE-8
DDUP:	.WORD	DOCOL
	.WORD	DUP
	.WORD	ZBRAN 	;IF
	.WORD	DDUP1-.
	.WORD	DUP	;ENDIF
DDUP1:	.WORD	SEMIS
;
	.BYTE	88H	;TRAVERSE
	.ASCIS	'TRAVERSE'
	.WORD	DDUP-7
TRAV:	.WORD	DOCOL
	.WORD	SWAP
TRAV1:	.WORD	OVER	;BEGIN
	.WORD	PLUS
	.WORD	LIT
	.WORD	7FH
	.WORD	OVER
	.WORD	CAT
	.WORD	LESS
	.WORD	ZBRAN	;UNTIL
	.WORD	TRAV1-.
	.WORD	SWAP
	.WORD	DROP
	.WORD	SEMIS
;
	.BYTE	86H	; LATEST
	.ASCIS	'LATEST'
	.WORD	TRAV-0BH
LATES:	.WORD	DOCOL
	.WORD	CURR
	.WORD	AT
	.WORD	AT
	.WORD	SEMIS
;
	.BYTE	83H	; LFA
	.ASCIS	'LFA'
	.WORD	LATES-9
LFA:	.WORD	DOCOL
	.WORD	LIT
	.WORD	4
	.WORD	SUBB
	.WORD	SEMIS
;
	.BYTE	83H	; CFA
	.ASCIS	'CFA'
	.WORD	LFA-6
CFA:	.WORD	DOCOL
	.WORD	TWO
	.WORD	SUBB
	.WORD	SEMIS
;
	.BYTE	83H	; NFA
	.ASCIS	'NFA'
	.WORD	CFA-6
NFA:	.WORD	DOCOL
	.WORD	LIT
	.WORD	5
	.WORD	SUBB
	.WORD	LIT
	.WORD	-1
	.WORD	TRAV
	.WORD	SEMIS
;
	.BYTE	83H	; PFA
	.ASCIS	'PFA'
	.WORD	NFA-6
PFA:	.WORD	DOCOL
	.WORD	ONE
	.WORD	TRAV
	.WORD	LIT
	.WORD	5
	.WORD	PLUS
	.WORD	SEMIS
;
	.BYTE	84H	; STORE CSP
	.ASCIS	'!CSP'
	.WORD	PFA-6
SCSP:	.WORD	DOCOL
	.WORD	SPAT
	.WORD	CSPP
	.WORD	STORE
	.WORD	SEMIS
;
	.BYTE	86H	; ?ERROR
	.ASCIS	'?ERROR'
	.WORD	SCSP-7
QERR:	.WORD	DOCOL
	.WORD	SWAP
	.WORD	ZBRAN	;IF
	.WORD	QERR1-.
	.WORD	ERROR
	.WORD	BRAN	;ELSE
	.WORD	QERR2-.
QERR1:	.WORD	DROP	;ENDIF
QERR2:	.WORD	SEMIS
;
	.BYTE	85H	; ?COMP
	.ASCIS	'?COMP'
	.WORD	QERR-9
QCOMP:	.WORD	DOCOL
	.WORD	STATE
	.WORD	AT
	.WORD	ZEQU
	.WORD	LIT
	.WORD	11H
	.WORD	QERR
	.WORD	SEMIS
;
	.BYTE	85H	; ?EXEC
	.ASCIS	'?EXEC'
	.WORD	QCOMP-8
QEXEC:	.WORD	DOCOL
	.WORD	STATE
	.WORD	AT
	.WORD	LIT
	.WORD	12H
	.WORD	QERR
	.WORD	SEMIS
;
	.BYTE	86H	; ?PAIRS
	.ASCIS	'?PAIRS'
	.WORD	QEXEC-8
QPAIR:	.WORD	DOCOL
	.WORD	SUBB
	.WORD	LIT
	.WORD	13H
	.WORD	QERR
	.WORD	SEMIS
;
	.BYTE	84H	; ?CSP
	.ASCIS	'?CSP'
	.WORD	QPAIR-9
QCSP:	.WORD	DOCOL
	.WORD	SPAT
	.WORD	CSPP
	.WORD	AT
	.WORD	SUBB
	.WORD	LIT
	.WORD	14H
	.WORD	QERR
	.WORD	SEMIS
;
	.BYTE	88H	; ?LOADING
	.ASCIS	'?LOADING'
	.WORD	QCSP-7
QLOAD:	.WORD	DOCOL
	.WORD	BLK
	.WORD	AT
	.WORD	ZEQU
	.WORD	LIT
	.WORD	16H
	.WORD	QERR
	.WORD	SEMIS
;
	.BYTE	87H	;COMPILE
	.ASCIS	'COMPILE'
	.WORD	QLOAD-0BH
COMP:	.WORD	DOCOL
	.WORD	QCOMP
	.WORD	FROMR
	.WORD	DUP
	.WORD	TWOP
	.WORD	TOR
	.WORD	AT
	.WORD	COMMA
	.WORD	SEMIS
;
	.BYTE	0C1H	; [
	.ASCIS	'['
	.WORD	COMP-0AH
LBRAC:	.WORD	DOCOL
	.WORD	ZERO
	.WORD	STATE
	.WORD	STORE
	.WORD	SEMIS
;
	.BYTE	81H	; ]
	.ASCIS	']'
	.WORD	LBRAC-4
RBRAC:	.WORD	DOCOL
	.WORD	LIT
	.WORD	0C0H
	.WORD	STATE
	.WORD	STORE
	.WORD	SEMIS
;
	.BYTE	86H	; SMUDGE
	.ASCIS	'SMUDGE'
	.WORD	RBRAC-4
SMUDG:	.WORD	DOCOL
	.WORD	LATES
	.WORD	LIT
	.WORD	20H
	.WORD	TOGGL
	.WORD	SEMIS
;
	.BYTE	83H	; HEX
	.ASCIS	'HEX'
	.WORD	SMUDG-9
HEX:	.WORD	DOCOL
	.WORD	LIT
	.WORD	10H
	.WORD	BASE
	.WORD	STORE
	.WORD	SEMIS
;
	.BYTE	87H	;DECIMAL
	.ASCIS	'DECIMAL'
	.WORD	HEX-6
DEC:	.WORD	DOCOL
	.WORD	LIT
	.WORD	10
	.WORD	BASE
	.WORD	STORE
	.WORD	SEMIS
;
	.BYTE	87H	; (;CODE)
	.ASCIS	'(;CODE)'
	.WORD	DEC-10
PSCOD:	.WORD	DOCOL
	.WORD	FROMR
	.WORD	LATES
	.WORD	PFA
	.WORD	CFA
	.WORD	STORE
	.WORD	SEMIS
;
	.BYTE	0C5H	; ;CODE
	.ASCIS	';CODE'
	.WORD	PSCOD-10
SEMIC:	.WORD	DOCOL
	.WORD	QCSP
	.WORD	COMP
	.WORD	PSCOD
	.WORD	LBRAC
SEMI1:	.WORD	NOOP	; (ASSEMBLER)
	.WORD	SEMIS
;
	.BYTE	87H	; <BUILDS
	.ASCIS	'<BUILDS'
	.WORD	SEMIC-8
BUILD:	.WORD	DOCOL
	.WORD	ZERO
	.WORD	CON
	.WORD	SEMIS
;
	.BYTE	85H	; DOES>
	.ASCIS	'DOES>'
	.WORD	BUILD-10
DOES:	.WORD	DOCOL
	.WORD	FROMR
	.WORD	LATES
	.WORD	PFA
	.WORD	STORE
	.WORD	PSCOD
DODOE:
	PUSH	X	;(BC) <- (IP)
	POP	B
	DCX	Y
	MOV	0(Y),B	;(R1) <- (IP)=PFA
			; = SUBSTITUTE CFA
	DCX	Y	;(RP) <- (RP)-2
	MOV	0(Y),C
	INX	D	;(DE) <- PFA
	XCHG
	MOV	C,M	;(IP) <- SUBSTITUTE CFA
	INX	H
	MOV	B,M
	INX	H
	PUSH	B	;(IP) <- (BC)
	POP	X
	JMP	HPUSH	;(S1) <- PFA+2
			; = SUBSTITUTE PFA
;
	.BYTE	85H	;COUNT
	.ASCIS	'COUNT'
	.WORD	DOES-8
COUNT:	.WORD	DOCOL
	.WORD	DUP
	.WORD	ONEP
	.WORD	SWAP
	.WORD	CAT
	.WORD	SEMIS
;
	.BYTE	84H	;TYPE
	.ASCIS	'TYPE'
	.WORD	COUNT-8
TYPE:	.WORD	DOCOL
	.WORD	DDUP
	.WORD	ZBRAN	;IF
	.WORD	TYPE1-.
	.WORD	OVER
	.WORD	PLUS
	.WORD	SWAP
	.WORD	XDO	;DO
TYPE2:	.WORD	IDO
	.WORD	CAT
	.WORD	EMIT
	.WORD	XLOOP	;LOOP
	.WORD	TYPE2-.
	.WORD	BRAN	;ELSE
	.WORD	TYPE3-.
TYPE1:	.WORD	DROP	;ENDIF
TYPE3:	.WORD	SEMIS
;
	.BYTE	89H	; -TRAILING
	.ASCIS	'-TRAILING'
	.WORD	TYPE-7
DTRAI:	.WORD	DOCOL
	.WORD	DUP
	.WORD	ZERO
	.WORD	XDO	;DO
DTRA1:	.WORD	OVER
	.WORD	OVER
	.WORD	PLUS
	.WORD	ONE
	.WORD	SUBB
	.WORD	CAT
	.WORD	BL
	.WORD	SUBB
	.WORD	ZBRAN	;IF
	.WORD	DTRA2-.
	.WORD	LEAVE
	.WORD	BRAN	;ELSE
	.WORD	DTRA3-.
DTRA2:	.WORD	ONE
	.WORD	SUBB ;ENDIF
DTRA3:	.WORD	XLOOP	;LOOP
	.WORD	DTRA1-.
	.WORD	SEMIS
;
	.BYTE	84H	; (.")
	.ASCIS	'(.")'
	.WORD	DTRAI-0CH
PDOTQ:	.WORD	DOCOL
	.WORD	RR
	.WORD	COUNT
	.WORD	DUP
	.WORD	ONEP
	.WORD	FROMR
	.WORD	PLUS
	.WORD	TOR
	.WORD	TYPE
	.WORD	SEMIS
;
	.BYTE	0C2H	; ."
	.ASCIS	'."'
	.WORD	PDOTQ-7
DOTQ:	.WORD	DOCOL
	.WORD	LIT
	.WORD	22H
	.WORD	STATE
	.WORD	AT
	.WORD	ZBRAN	;IF
	.WORD	DOTQ1-.
	.WORD	COMP
	.WORD	PDOTQ
	.WORD	WORD
	.WORD	HERE
	.WORD	CAT
	.WORD	ONEP
	.WORD	ALLOT
	.WORD	BRAN	;ELSE
	.WORD	DOTQ2-.
DOTQ1:	.WORD	WORD
	.WORD	HERE
	.WORD	COUNT
	.WORD	TYPE	;ENDIF
DOTQ2:	.WORD	SEMIS
;
	.BYTE	86H	;EXPECT
	.ASCIS	'EXPECT'
	.WORD	DOTQ-5
EXPEC:	.WORD	DOCOL
	.WORD	OVER
	.WORD	PLUS
	.WORD	OVER
	.WORD	XDO	;DO
EXPE1:	.WORD	KEY
	.WORD	DUP
	.WORD	LIT
	.WORD	0EH
	.WORD	PORIG
	.WORD	AT
	.WORD	EQUAL
	.WORD	ZBRAN
	.WORD	EXPE8-. ;IF
EXPE15:	.WORD	DROP
	.WORD	DUP
	.WORD	IDO
	.WORD	EQUAL
	.WORD	DUP
	.WORD	FROMR
	.WORD	TWO
	.WORD	SUBB
	.WORD	PLUS
	.WORD	TOR
	.WORD	ZBRAN	;IF
	.WORD	EXPE6-.
	.WORD	LIT
	.WORD	BELL
	.WORD	BRAN	;ELSE
	.WORD	EXPE7-.
EXPE6:	.WORD	LIT
	.WORD	BSOUT
	.WORD	EMIT
	.WORD	LIT
	.WORD	ABL
	.WORD	EMIT
	.WORD	LIT
	.WORD	BSOUT
EXPE7:	.WORD	BRAN	;ELSE
	.WORD	EXPE3-.
EXPE2:	.WORD	DUP
	.WORD	LIT
	.WORD	0DH
	.WORD	EQUAL
	.WORD	ZBRAN	;IF
	.WORD	EXPE4-.
	.WORD	LEAVE
	.WORD	DROP
	.WORD	BL
	.WORD	ZERO
	.WORD	BRAN	;ELSE
	.WORD	EXPE5-.
EXPE4:	.WORD	DUP	;ENDIF
EXPE5:	.WORD	IDO
	.WORD	CSTOR
	.WORD	ZERO
	.WORD	IDO
	.WORD	ONEP
	.WORD	STORE	;ENDIF
EXPE3:	.WORD	EMIT
	.WORD	XLOOP	;LOOP
	.WORD	EXPE1-.
	.WORD	DROP
	.WORD	SEMIS
EXPE8:	.WORD	DUP
	.WORD	LIT
	.WORD	05FH
	.WORD	EQUAL
	.WORD	ZBRAN
	.WORD	EXPE2-.
	.WORD	BRAN
	.WORD	EXPE15-.
;
	.BYTE	85H	;QUERY
	.ASCIS	'QUERY'
	.WORD	EXPEC-9
QUERY:	.WORD	DOCOL
	.WORD	TIB
	.WORD	AT
	.WORD	LIT
	.WORD	50H
	.WORD	EXPEC
	.WORD	ZERO
	.WORD	INN
	.WORD	STORE
	.WORD	SEMIS
;
	.BYTE	0C1H	;0 (NULL)
	.BYTE	80H
	.WORD	QUERY-8
NULL:	.WORD	DOCOL
	.WORD	BLK
	.WORD	AT
	.WORD	ZBRAN	;IF
	.WORD	NULL1-.
	.WORD	ONE
	.WORD	BLK
	.WORD	PSTOR
	.WORD	ZERO
	.WORD	INN
	.WORD	STORE
	.WORD	BLK
	.WORD	AT
	.WORD	BSCR
	.WORD	ONE
	.WORD	SUBB
	.WORD	ANDD
	.WORD	ZEQU
	.WORD	ZBRAN	;IF
	.WORD	NULL2-.
	.WORD	QEXEC
	.WORD	FROMR
	.WORD	DROP	;ENDIF
NULL2:	.WORD	BRAN	;ELSE
	.WORD	NULL3-.
NULL1:	.WORD	FROMR
	.WORD	DROP	;ENDIF
NULL3:	.WORD	SEMIS
;
	.BYTE	84H	;FILL
	.ASCIS	'FILL'
	.WORD	NULL-4
FILL:	.WORD	.+2
	POP	D	;DATA
	POP	B	;QUANTITY
	POP	H	;FIRST ADDRESS
FILL1:	MOV	A,B	;CHECK IF COUNT=0
	ORA	C
	JZ	NEXT	;YES,EXIT
	MOV	M,E	;STORE 1 BYTE
	INX	H	;ADVANCE STORE ADDR
	DCX	B	;DECREMENT COUNT
	JMPR	FILL1
;
	.BYTE	85H	;ERASE
	.ASCIS	'ERASE'
	.WORD	FILL-7
ERASEE:	.WORD	DOCOL
	.WORD	ZERO
	.WORD	FILL
	.WORD	SEMIS
;
	.BYTE	86H	;BLANKS
	.ASCIS	'BLANKS'
	.WORD	ERASEE-8
BLANK:	.WORD	DOCOL
	.WORD	BL
	.WORD	FILL
	.WORD	SEMIS
;
	.BYTE	84H	;HOLD
	.ASCIS	'HOLD'
	.WORD	BLANK-9
HOLD:	.WORD	DOCOL
	.WORD	LIT
	.WORD	-1
	.WORD	HLD
	.WORD	PSTOR
	.WORD	HLD
	.WORD	AT
	.WORD	CSTOR
	.WORD	SEMIS
;
	.BYTE	83H	;PAD
	.ASCIS	'PAD'
	.WORD	HOLD-7
PAD:	.WORD	DOCOL
	.WORD	HERE
	.WORD	LIT
	.WORD	44H
	.WORD	PLUS
	.WORD	SEMIS
;
	.BYTE	84H	;WORD
	.ASCIS	'WORD'
	.WORD	PAD-6
WORD:	.WORD	DOCOL
	.WORD	BLK
	.WORD	AT
	.WORD	ZBRAN	;IF
	.WORD	WORD1-.
	.WORD	BLK
	.WORD	AT
	.WORD	BLOCK
	.WORD	BRAN	;ELSE
	.WORD	WORD2-.
WORD1:	.WORD	TIB
	.WORD	AT	;ENDIF
WORD2:	.WORD	INN
	.WORD	AT
	.WORD	PLUS
	.WORD	SWAP
	.WORD	ENCL
	.WORD	HERE
	.WORD	LIT
	.WORD	22H
	.WORD	BLANK
	.WORD	INN
	.WORD	PSTOR
	.WORD	OVER
	.WORD	SUBB
	.WORD	TOR
	.WORD	RR
	.WORD	HERE
	.WORD	CSTOR
	.WORD	PLUS
	.WORD	HERE
	.WORD	ONEP
	.WORD	FROMR
	.WORD	CMOVE
	.WORD	SEMIS
;
	.BYTE	88H	;(NUMBER)
	.ASCIS	'(NUMBER)'
	.WORD	WORD-7
PNUMB:	.WORD	DOCOL
PNUM1:	.WORD	ONEP	;BEGIN
	.WORD	DUP
	.WORD	TOR
	.WORD	CAT
	.WORD	BASE
	.WORD	AT
	.WORD	DIGIT
	.WORD	ZBRAN	;WHILE
	.WORD	PNUM2-.
	.WORD	SWAP
	.WORD	BASE
	.WORD	AT
	.WORD	USTAR
	.WORD	DROP
	.WORD	ROT
	.WORD	BASE
	.WORD	AT
	.WORD	USTAR
	.WORD	DPLUS
	.WORD	DPL
	.WORD	AT
	.WORD	ONEP
	.WORD	ZBRAN	;IF
	.WORD	PNUM3-.
	.WORD	ONE
	.WORD	DPL
	.WORD	PSTOR	;ENDIF
PNUM3:	.WORD	FROMR
	.WORD	BRAN	;REPEAT
	.WORD	PNUM1-.
PNUM2:	.WORD	FROMR
	.WORD	SEMIS
;
	.BYTE	86H	;NUMBER
	.ASCIS	'NUMBER'
	.WORD	PNUMB-0BH
NUMB:	.WORD	DOCOL
	.WORD	ZERO
	.WORD	ZERO
	.WORD	ROT
	.WORD	DUP
	.WORD	ONEP
	.WORD	CAT
	.WORD	LIT
	.WORD	2DH
	.WORD	EQUAL
	.WORD	DUP
	.WORD	TOR
	.WORD	PLUS
	.WORD	LIT
	.WORD	-1
NUMB1:	.WORD	DPL	;BEGIN
	.WORD	STORE
	.WORD	PNUMB
	.WORD	DUP
	.WORD	CAT
	.WORD	BL
	.WORD	SUBB
	.WORD	ZBRAN	;WHILE
	.WORD	NUMB2-.
	.WORD	DUP
	.WORD	CAT
	.WORD	LIT
	.WORD	2EH
	.WORD	SUBB
	.WORD	ZERO
	.WORD	QERR
	.WORD	ZERO
	.WORD	BRAN	;REPEAT
	.WORD	NUMB1-.
NUMB2:	.WORD	DROP
	.WORD	FROMR
	.WORD	ZBRAN	;IF
	.WORD	NUMB3-.
	.WORD	DMINU	;ENDIF
NUMB3:	.WORD	SEMIS
;
	.BYTE	85H	; -FIND (0-3) SUCCESS
	.ASCIS	'-FIND'	; (0-1) FAILURE
	.WORD	NUMB-9
DFIND:	.WORD	DOCOL
	.WORD	BL
	.WORD	WORD
	.WORD	HERE
	.WORD	CONT
	.WORD	AT
	.WORD	AT
	.WORD	PFIND
	.WORD	DUP
	.WORD	ZEQU
	.WORD	ZBRAN	;IF
	.WORD	DFIN1-.
	.WORD	DROP
	.WORD	HERE
	.WORD	LATES
	.WORD	PFIND	;ENDIF
DFIN1:	.WORD	SEMIS
;
	.BYTE	87H	;(ABORT)
	.ASCIS	'(ABORT)'
	.WORD	DFIND-8
PABOR:	.WORD	DOCOL
	.WORD	ABORT
	.WORD	SEMIS
;
	.BYTE	85H	;ERROR
	.ASCIS	'ERROR'
	.WORD	PABOR-0AH
ERROR:	.WORD	DOCOL
	.WORD	WARN
	.WORD	AT
	.WORD	ZLESS
	.WORD	ZBRAN	;IF
	.WORD	ERRO1-.
	.WORD	PABOR	;ENDIF
ERRO1:	.WORD	HERE
	.WORD	COUNT
	.WORD	TYPE
	.WORD	PDOTQ
	.BYTE	2
	.ASCII	'? '
	.WORD	MESS
	.WORD	SPST0
;	CHANGE FROM FIG MODEL
;	.WORD	INN
;	.WORD	AT
;	.WORD	BLK
;	.WORD	AT
	.WORD	BLK
	.WORD	AT
	.WORD	DDUP
	.WORD	ZBRAN
	.WORD	ERRO2-. ;IF
	.WORD	INN
	.WORD	AT
	.WORD	SWAP	;ENDIF
ERRO2:	.WORD	QUIT
;
	.BYTE	83H	;ID.
	.ASCIS	'ID.'
	.WORD	ERROR-8
IDDOT:	.WORD	DOCOL
	.WORD	PAD
	.WORD	LIT
	.WORD	20H
	.WORD	LIT
	.WORD	5FH
	.WORD	FILL
	.WORD	DUP
	.WORD	PFA
	.WORD	LFA
	.WORD	OVER
	.WORD	SUBB
	.WORD	PAD
	.WORD	SWAP
	.WORD	CMOVE
	.WORD	PAD
	.WORD	COUNT
	.WORD	LIT
	.WORD	1FH
	.WORD	ANDD
	.WORD	TYPE
	.WORD	SPACE
	.WORD	SEMIS
;
	.BYTE	86H	;CREATE
	.ASCIS	'CREATE'
	.WORD	IDDOT-6
CREAT:	.WORD	DOCOL
	.WORD	DFIND
	.WORD	ZBRAN	;IF
	.WORD	CREA1-.
	.WORD	DROP
	.WORD	NFA
	.WORD	IDDOT
	.WORD	LIT
	.WORD	4
	.WORD	MESS
	.WORD	SPACE	;ENDIF
CREA1:	.WORD	HERE
	.WORD	DUP
	.WORD	CAT
	.WORD	WIDTH
	.WORD	AT
	.WORD	MIN
	.WORD	ONEP
	.WORD	ALLOT
	.WORD	DUP
	.WORD	LIT
	.WORD	0A0H
	.WORD	TOGGL
	.WORD	HERE
	.WORD	ONE
	.WORD	SUBB
	.WORD	LIT
	.WORD	80H
	.WORD	TOGGL
	.WORD	LATES
	.WORD	COMMA
	.WORD	CURR
	.WORD	AT
	.WORD	STORE
	.WORD	HERE
	.WORD	TWOP
	.WORD	COMMA
	.WORD	SEMIS
;
	.BYTE	0C9H	;[COMPILE]
	.ASCIS	'[COMPILE]'
	.WORD	CREAT-9
BCOMP:	.WORD	DOCOL
	.WORD	DFIND
	.WORD	ZEQU
	.WORD	ZERO
	.WORD	QERR
	.WORD	DROP
	.WORD	CFA
	.WORD	COMMA
	.WORD	SEMIS
;
	.BYTE	0C7H	;LITERAL
	.ASCIS	'LITERAL'
	.WORD	BCOMP-0CH
LITER:	.WORD	DOCOL
	.WORD	STATE
	.WORD	AT
	.WORD	ZBRAN	;IF
	.WORD	LITE1-.
	.WORD	COMP
	.WORD	LIT
	.WORD	COMMA	;ENDIF
LITE1:	.WORD	SEMIS
;
	.BYTE	0C8H	;DLITERAL
	.ASCIS	'DLITERAL'
	.WORD	LITER-0AH
DLITE:	.WORD	DOCOL
	.WORD	STATE
	.WORD	AT
	.WORD	ZBRAN
	.WORD	DLIT1-. 	;IF
	.WORD	SWAP
	.WORD	LITER
	.WORD	LITER	;ENDIF
DLIT1:	.WORD	SEMIS
;
	.BYTE	86H	; ?STACK
	.ASCIS	'?STACK'
	.WORD	DLITE-0BH
QSTAC:	.WORD	DOCOL
	.WORD	SPAT
	.WORD	SZERO
	.WORD	AT
	.WORD	SWAP
	.WORD	ULESS
	.WORD	ONE
	.WORD	QERR
	.WORD	SPAT
	.WORD	HERE
	.WORD	LIT
	.WORD	80H
	.WORD	PLUS
	.WORD	ULESS
	.WORD	LIT
	.WORD	7
	.WORD	QERR
	.WORD	SEMIS
;
	.BYTE	89H	; INTERPRET
	.ASCIS	'INTERPRET'
	.WORD	QSTAC-9
INTER:	.WORD	DOCOL
INTE1:	.WORD	DFIND	;BEGIN
	.WORD	ZBRAN
	.WORD	INTE2-. ;IF
	.WORD	STATE
	.WORD	AT
	.WORD	LESS
	.WORD	ZBRAN
	.WORD	INTE3-. ;IF
	.WORD	CFA
	.WORD	COMMA
	.WORD	BRAN	;ELSE
	.WORD	INTE4-.
INTE3:	.WORD	CFA
	.WORD	EXEC ;ENDIF
INTE4:	.WORD	QSTAC
	.WORD	BRAN
	.WORD	INTE5-. ;ELSE
INTE2:	.WORD	HERE
	.WORD	NUMB
	.WORD	DPL
	.WORD	AT
	.WORD	ONEP
	.WORD	ZBRAN
	.WORD	INTE6-. ;IF
	.WORD	DLITE
	.WORD	BRAN
	.WORD	INTE7-. ;ELSE
INTE6:	.WORD	DROP
	.WORD	LITER	;ENDIF
INTE7:	.WORD	QSTAC	;ENDIF
INTE5:	.WORD	BRAN
	.WORD	INTE1-. ;AGAIN
;
	.BYTE	89H	;IMMEDIATE
	.ASCIS	'IMMEDIATE'
	.WORD	INTER-0CH
IMMED:	.WORD	DOCOL
	.WORD	LATES
	.WORD	LIT
	.WORD	40H
	.WORD	TOGGL
	.WORD	SEMIS
;
	.BYTE	8AH	;VOCABULARY
	.ASCIS	'VOCABULARY'
	.WORD	IMMED-0CH
VOCAB:	.WORD	DOCOL
	.WORD	BUILD
	.WORD	LIT
	.WORD	0A081H
	.WORD	COMMA
	.WORD	CURR
	.WORD	AT
	.WORD	CFA
	.WORD	COMMA
	.WORD	HERE
	.WORD	VOCL
	.WORD	AT
	.WORD	COMMA
	.WORD	VOCL
	.WORD	STORE
	.WORD	DOES
DOVOC:	.WORD	TWOP
	.WORD	CONT
	.WORD	STORE
	.WORD	SEMIS
;
	.BYTE	0C5H	;FORTH
	.ASCIS	'FORTH'
	.WORD	VOCAB-0DH
FORTH:	.WORD	DODOE
	.WORD	DOVOC
	.WORD	0A081H
	.WORD	TASK-7 ;COLD START VALUE
			;ONLY, CHANGED EACH
			;TIME A DEF IS 
			;APPENDED TO VOCABULARY
	.WORD	0	;END OF VOCAB LIST
;
	.BYTE	8BH	;DEFINITIONS
	.ASCIS	'DEFINITIONS'
	.WORD	FORTH-8
DEFIN:	.WORD	DOCOL
	.WORD	CONT
	.WORD	AT
	.WORD	CURR
	.WORD	STORE
	.WORD	SEMIS
;
	.BYTE	0C1H	; (
	.ASCIS	'('
	.WORD	DEFIN-0EH
PAREN:	.WORD	DOCOL
	.WORD	LIT
	.WORD	29H
	.WORD	WORD
	.WORD	SEMIS
;
	.BYTE	84H	;QUIT
	.ASCIS	'QUIT'
	.WORD	PAREN-4
QUIT:	.WORD	DOCOL
	.WORD	ZERO
	.WORD	BLK
	.WORD	STORE
	.WORD	LBRAC
QUIT1:	.WORD	RPST0 	;BEGIN
	.WORD	CR
	.WORD	QUERY
	.WORD	INTER
	.WORD	STATE
	.WORD	AT
	.WORD	ZEQU
	.WORD	ZBRAN
	.WORD	QUIT2-. ;IF
	.WORD	PDOTQ
	.BYTE	2
	.ASCII	'OK'	;ENDIF
QUIT2:	.WORD	BRAN
	.WORD	QUIT1-. ;AGAIN
;
	.BYTE	85H	;ABORT
	.ASCIS	'ABORT'
	.WORD	QUIT-7
ABORT:	.WORD	DOCOL
	.WORD	SPST0
	.WORD	DEC
	.WORD	QSTAC
	.WORD	CR
	.WORD	DOTCPU
	.WORD	PDOTQ
	.BYTE	13
	.ASCII	'fig-FORTH '
	.BYTE	FIGREL+30H,ADOT,FIGREV+30H
	.WORD	CR
	.WORD	PDOTQ
	.BYTE	39
	.ASCII	'installation by '
	.ASCII	'Laboratory Microsystems'
	.WORD	CR
	.WORD	CR
	.WORD	PDOTQ
	.BYTE	3
	.ASCII	' OK'
	.WORD	FORTH
	.WORD	DEFIN
	.WORD	QUIT
;
WRM:	LXI	B,WRM1
	JMP	NEXT
;
WRM1:	.WORD	WARM
;
	.BYTE	84H	;WARM
	.ASCIS	'WARM'
	.WORD	ABORT-8
WARM:	.WORD	DOCOL
	.WORD	MTBUF
	.WORD	ABORT
;
CLD:	LXI	X,CLD1	;SET IP
	LIYD	RPP ;SET RP
	LHLD	ORIG+12H
	SPHL
	JMP	NEXT
CLD1:	.WORD	COLD
;
	.BYTE	84H	;COLD
	.ASCIS	'COLD'
	.WORD	WARM-7
COLD:	.WORD	DOCOL
	.WORD	MTBUF
	.WORD	ZERO
	.WORD	DENSTY
	.WORD	STORE
	.WORD	LIT
	.WORD	BUF1
	.WORD	USE
	.WORD	STORE
	.WORD	LIT
	.WORD	BUF1
	.WORD	PREV
	.WORD	STORE
	.WORD	DRZER
	.WORD	LIT
	.WORD	0
	.WORD	LIT
	.WORD	EPRINT
	.WORD	STORE
	.WORD	LIT
	.WORD	ORIG+12H
	.WORD	LIT
	.WORD	UP
	.WORD	AT
	.WORD	LIT
	.WORD	6
	.WORD	PLUS
	.WORD	LIT
	.WORD	10H
	.WORD	CMOVE
	.WORD	LIT
	.WORD	ORIG+12
	.WORD	AT
	.WORD	LIT
	.WORD	FORTH+6
	.WORD	STORE
	.WORD	ABORT
;
	.BYTE	84H	; S->D
	.ASCIS	'S->D'
	.WORD	COLD-7
STOD:	.WORD	.+2
	POP	D
	LXI	H,0
	MOV	A,D
	ANI	80H
	JZ	STOD1
	DCX	H
STOD1:	JMP	DPUSH
;
	.BYTE	82H	; +-
	.ASCIS	'+-'
	.WORD	STOD-7
PM:	.WORD	DOCOL
	.WORD	ZLESS
	.WORD	ZBRAN
	.WORD	PM1-. ;IF
	.WORD	MINUS	;ENDIF
PM1:	.WORD	SEMIS
;
	.BYTE	83H	; D+-
	.ASCIS	'D+-'
	.WORD	PM-5
DPM:	.WORD	DOCOL
	.WORD	ZLESS
	.WORD	ZBRAN
	.WORD	DPM1-. ;IF
	.WORD	DMINU	;ENDIF
DPM1:	.WORD	SEMIS
;
	.BYTE	83H	; ABS
	.ASCIS	'ABS'
	.WORD	DPM-6
ABS:	.WORD	DOCOL
	.WORD	DUP
	.WORD	PM
	.WORD	SEMIS
;
	.BYTE	84H	; DABS
	.ASCIS	'DABS'
	.WORD	ABS-6
DABS:	.WORD	DOCOL
	.WORD	DUP
	.WORD	DPM
	.WORD	SEMIS
;
	.BYTE	83H	; MIN
	.ASCIS	'MIN'
	.WORD	DABS-7
MIN:	.WORD	DOCOL
	.WORD	TDUP
	.WORD	GREAT
	.WORD	ZBRAN
	.WORD	MIN1-. ;IF
	.WORD	SWAP 	;ENDIF
MIN1:	.WORD	DROP
	.WORD	SEMIS
;
	.BYTE	83H	;MAX
	.ASCIS	'MAX'
	.WORD	MIN-6
MAX:	.WORD	DOCOL
	.WORD	TDUP
	.WORD	LESS
	.WORD	ZBRAN
	.WORD	MAX1-. ;IF
	.WORD	SWAP	;ENDIF
MAX1:	.WORD	DROP
	.WORD	SEMIS
;
	.BYTE	82H	; M*
	.ASCIS	'M*'
	.WORD	MAX-6
MSTAR:	.WORD	DOCOL
	.WORD	TDUP
	.WORD	XORR
	.WORD	TOR
	.WORD	ABS
	.WORD	SWAP
	.WORD	ABS
	.WORD	USTAR
	.WORD	FROMR
	.WORD	DPM
	.WORD	SEMIS
;
	.BYTE	82H	; M/
	.ASCIS	'M/'
	.WORD	MSTAR-5
MSLAS:	.WORD	DOCOL
	.WORD	OVER
	.WORD	TOR
	.WORD	TOR
	.WORD	DABS
	.WORD	RR
	.WORD	ABS
	.WORD	USLAS
	.WORD	FROMR
	.WORD	RR
	.WORD	XORR
	.WORD	PM
	.WORD	SWAP
	.WORD	FROMR
	.WORD	PM
	.WORD	SWAP
	.WORD	SEMIS
;
	.BYTE	81H	; *
	.ASCIS	'*'
	.WORD	MSLAS-5
STAR:	.WORD	DOCOL
	.WORD	MSTAR
	.WORD	DROP
	.WORD	SEMIS
;
	.BYTE	84H	; /MOD
	.ASCIS	'/MOD'
	.WORD	STAR-4
SLMOD:	.WORD	DOCOL
	.WORD	TOR
	.WORD	STOD
	.WORD	FROMR
	.WORD	MSLAS
	.WORD	SEMIS
;
	.BYTE	81H	; /
	.ASCIS	'/'
	.WORD	SLMOD-7
SLASH:	.WORD	DOCOL
	.WORD	SLMOD
	.WORD	SWAP
	.WORD	DROP
	.WORD	SEMIS
;
	.BYTE	83H	; MOD
	.ASCIS	'MOD'
	.WORD	SLASH-4
MODD:	.WORD	DOCOL
	.WORD	SLMOD
	.WORD	DROP
	.WORD	SEMIS
;
	.BYTE	85H	; */MOD
	.ASCIS	'*/MOD'
	.WORD	MODD-6
SSMOD:	.WORD	DOCOL
	.WORD	TOR
	.WORD	MSTAR
	.WORD	FROMR
	.WORD	MSLAS
	.WORD	SEMIS
;
	.BYTE	82H	; */
	.ASCIS	'*/'
	.WORD	SSMOD-8
SSLA:	.WORD	DOCOL
	.WORD	SSMOD
	.WORD	SWAP
	.WORD	DROP
	.WORD	SEMIS
;
	.BYTE	85H	; M/MOD
	.ASCIS	'M/MOD'
	.WORD	SSLA-5
MSMOD:	.WORD	DOCOL
	.WORD	TOR
	.WORD	ZERO
	.WORD	RR
	.WORD	USLAS
	.WORD	FROMR
	.WORD	SWAP
	.WORD	TOR
	.WORD	USLAS
	.WORD	FROMR
	.WORD	SEMIS
;
;
; BLOCK MOVED DOWN 2 PAGES
;
	.BYTE	86H	; (LINE)
	.ASCIS	'(LINE)'
	.WORD	MSMOD-8
PLINE:	.WORD	DOCOL
	.WORD	TOR
	.WORD	LIT
	.WORD	40H
	.WORD	BBUF
	.WORD	SSMOD
	.WORD	FROMR
	.WORD	BSCR
	.WORD	STAR
	.WORD	PLUS
	.WORD	BLOCK
	.WORD	PLUS
	.WORD	LIT
	.WORD	40H
	.WORD	SEMIS
;
	.BYTE	85H	; .LINE
	.ASCIS	'.LINE'
	.WORD	PLINE-9
DLINE:	.WORD	DOCOL
	.WORD	PLINE
	.WORD	DTRAI
	.WORD	TYPE
	.WORD	SEMIS
;
	.BYTE	87H	; MESSAGE
	.ASCIS	'MESSAGE'
	.WORD	DLINE-8
MESS:	.WORD	DOCOL
	.WORD	WARN
	.WORD	AT
	.WORD	ZBRAN
	.WORD	MESS1-. ;IF
	.WORD	DDUP
	.WORD	ZBRAN
	.WORD	MESS2-. ;IF
	.WORD	LIT
	.WORD	4
	.WORD	OFSET
	.WORD	AT
	.WORD	BSCR
	.WORD	SLASH
	.WORD	SUBB
	.WORD	DLINE
	.WORD	SPACE 	;ENDIF
MESS2:	.WORD	BRAN	;ELSE
	.WORD	MESS3-.
MESS1:	.WORD	PDOTQ
	.BYTE	6
	.ASCII	'MSG # '
	.WORD	DOT	;ENDIF
MESS3:	.WORD	SEMIS
;
	.PAGE
;
; 8080 PORT FETCH AND STORE
;
	.BYTE	82H	; P@ "PORT @"
	.ASCIS	'P@'
	.WORD	MESS-10
PTAT:	.WORD	.+2
	POP	B	;(C)=PORT NUMBER
	INP	L	;(L) <- (PORT)
	MVI	H,0
	JMP	HPUSH
;
; 
	.BYTE	82H	; "PORT STORE" P!
	.ASCIS	'P!'
	.WORD	PTAT-5
PTST0:	.WORD	.+2
	POP	B	;(C) <- PORT #
	POP	H	;(L) <- CDATA
	OUTP	L	;SEND DATA
	JMP	NEXT
;
	.PAGE
;
; CP/M COMPATIBLE DISK INTERFACE
;
; CP/M BIOS CALLS USED
; (NOTE EQUATES ARE 3 LOWER THAN DOCUMENTED
;  OFFSETS BECAUSE BASE ADDRESS IS BIOS+3)
;
RITSEC	==	39
RDSEC	==	36
SETDMA	==	33
SETSEC	==	30
SETTRK	==	27
SETDSK	==	24
;
; DOUBLE DENSITY 8 INCH FLOPPY CAPACITIES
SPT2	==	52	;SECTORS PER TRACK
TRKS2	==	77	;NUMBER OF TRACKS
SPDRV2	==	SPT2*TRKS2 ;SECTORS/DRIVE
;
; SINGLE DENSITY 8 INCH FLOPPY CAPACITIES
SPT1	==	26	;SECTORS/TRACK
TRKS1	==	77	;TRACKS/DISK
SPDRV1	==	SPT1*TRKS1 ;SECTORS/DRIVE
;
BPS	==	128	;BYTES/SECTOR
MXDRV	==	2	;MAX # OF DRIVES
;
;
; FORTH VARIABLES AND CONSTANTS USED
; IN DISK INTERFACE
;
	.BYTE	85H	; (CURRENT DRIVE #)
	.ASCIS	'DRIVE'
	.WORD	PTST0-5
DRIVE:	.WORD	DOVAR
	.WORD	0
;
	.BYTE	83H	; (SECTOR #)
	.ASCIS	'SEC'
	.WORD	DRIVE-8
SEC:	.WORD	DOVAR
	.WORD	0
;
	.BYTE	85H	; (CURRENT TRACK #)
	.ASCIS	'TRACK'
	.WORD	SEC-6
TRACK:	.WORD	DOVAR
	.WORD	0
;
	.BYTE	83H	; USE
	.ASCIS	'USE'	;(ADDR NEXT BUFFER TO USE)
	.WORD	TRACK-8
USE:	.WORD	DOVAR
	.WORD	BUF1
;
	.BYTE	84H	; PREV
	.ASCIS	'PREV'	;(ADDR OF PREV USED BUFFER)
	.WORD	USE-6
PREV:	.WORD	DOVAR
	.WORD	BUF1
;
	.BYTE	87H	; SEC/BLK
	.ASCIS	'SEC/BLK' ;(#SECTORS PER BLOCK)
	.WORD	PREV-7
SPBLK:	.WORD	DOCON
	.WORD	KBBUF/BPS
;
	.BYTE	85H	; #BUFF
	.ASCIS	'#BUFF'	;(NUMBER OF BUFFERS)
	.WORD	SPBLK-10
NOBUF:	.WORD	DOCON
	.WORD	NBUF
;
	.BYTE	87H	; DENSITY
	.ASCIS	'DENSITY' ;0=SINGLE,1=DOUBLE
	.WORD	NOBUF-8
DENSTY:	.WORD	DOVAR
	.WORD	0
;
	.BYTE	8AH	;DISK-ERROR
	.ASCIS	'DISK-ERROR' ;(DISK STATUS)
	.WORD	DENSTY-10
DSKERR:	.WORD	DOVAR
	.WORD	0
;
;
; DISK INTERFACE HIGH LEVEL ROUTINES
;
	.BYTE	84H	; +BUF (ADVANCE BUFFER)
	.ASCIS	'+BUF'
	.WORD	DSKERR-13
PBUF:	.WORD	DOCOL
	.WORD	LIT
	.WORD	CO
	.WORD	PLUS
	.WORD	DUP
	.WORD	LIMIT
	.WORD	EQUAL
	.WORD	ZBRAN
	.WORD	PBUF1-.
	.WORD	DROP
	.WORD	FIRST
PBUF1:	.WORD	DUP
	.WORD	PREV
	.WORD	AT
	.WORD	SUBB
	.WORD	SEMIS
;
	.BYTE	86H	; UPDATE
	.ASCIS	'UPDATE'
	.WORD	PBUF-7
UPDAT:	.WORD	DOCOL
	.WORD	PREV
	.WORD	AT
	.WORD	AT
	.WORD	LIT
	.WORD	8000H
	.WORD	ORR
	.WORD	PREV
	.WORD	AT
	.WORD	STORE
	.WORD	SEMIS
;
	.BYTE	8DH	;EMPTY-BUFFERS
	.ASCIS	'EMPTY-BUFFERS'
	.WORD	UPDAT-9
MTBUF:	.WORD	DOCOL
	.WORD	FIRST
	.WORD	LIMIT
	.WORD	OVER
	.WORD	SUBB
	.WORD	ERASEE
	.WORD	SEMIS
;
	.BYTE	83H	; DR0
	.ASCIS	'DR0'
	.WORD	MTBUF-16
DRZER:	.WORD	DOCOL
	.WORD	ZERO
	.WORD	OFSET
	.WORD	STORE
	.WORD	SEMIS
;
	.BYTE	83H	; DR1
	.ASCIS	'DR1'
	.WORD	DRZER-6
DRONE:	.WORD	DOCOL
	.WORD	DENSTY
	.WORD	AT
	.WORD	ZBRAN
	.WORD	DRON1-.
	.WORD	LIT
	.WORD	SPDRV2
	.WORD	BRAN
	.WORD	DRON2-.
DRON1:	.WORD	LIT
	.WORD	SPDRV1
DRON2:	.WORD	OFSET
	.WORD	STORE
	.WORD	SEMIS
;
	.BYTE	86H	; BUFFER
	.ASCIS	'BUFFER'
	.WORD	DRONE-6
BUFFE:	.WORD	DOCOL
	.WORD	USE
	.WORD	AT
	.WORD	DUP
	.WORD	TOR
BUFF1:	.WORD	PBUF	;WON'T WORK IF
	.WORD	ZBRAN
	.WORD	BUFF1-. ;SINGLE BUFFER
	.WORD	USE
	.WORD	STORE
	.WORD	RR
	.WORD	AT
	.WORD	ZLESS
	.WORD	ZBRAN
	.WORD	BUFF2-.
	.WORD	RR
	.WORD	TWOP
	.WORD	RR
	.WORD	AT
	.WORD	LIT
	.WORD	7FFFH
	.WORD	ANDD
	.WORD	ZERO
	.WORD	RSLW
BUFF2:	.WORD	RR
	.WORD	STORE
	.WORD	RR
	.WORD	PREV
	.WORD	STORE
	.WORD	FROMR
	.WORD	TWOP
	.WORD	SEMIS
;
	.BYTE	85H	; BLOCK
	.ASCIS	'BLOCK'
	.WORD	BUFFE-9
BLOCK:	.WORD	DOCOL
	.WORD	OFSET
	.WORD	AT
	.WORD	PLUS
	.WORD	TOR
	.WORD	PREV
	.WORD	AT
	.WORD	DUP
	.WORD	AT
	.WORD	RR
	.WORD	SUBB
	.WORD	DUP
	.WORD	PLUS
	.WORD	ZBRAN
	.WORD	BLOC1-.
BLOC2:	.WORD	PBUF
	.WORD	ZEQU
	.WORD	ZBRAN
	.WORD	BLOC3-.
	.WORD	DROP
	.WORD	RR
	.WORD	BUFFE
	.WORD	DUP
	.WORD	RR
	.WORD	ONE
	.WORD	RSLW
	.WORD	TWO
	.WORD	SUBB
BLOC3:	.WORD	DUP
	.WORD	AT
	.WORD	RR
	.WORD	SUBB
	.WORD	DUP
	.WORD	PLUS
	.WORD	ZEQU
	.WORD	ZBRAN
	.WORD	BLOC2-.
	.WORD	DUP
	.WORD	PREV
	.WORD	STORE
BLOC1:	.WORD	FROMR
	.WORD	DROP
	.WORD	TWOP
	.WORD	SEMIS
;
;
; CP/M INTERFACE ROUTINES
;
; SERVICE REQUEST
;
IOS:	LHLD	1	; (HL) <- BIOS TABLE
			;ADDRESS +3
	DAD	D	; + SERVICE REQ OFFSET
	PCHL		;EXECUTE REQUEST
			;RETURN FUNCTION
			;PROVIDED BY CP/M
;
	.BYTE	86H	; SET-IO
			;(ASSIGN SECTOR, TRACK
			; FOR BDOS)
	.ASCIS	'SET-IO'
	.WORD	BLOCK-8
SETIO:	.WORD	.+2
	LBCD	USE+2    ;(BC) <- ADDR BUFF
	LXI	D,SETDMA ;SEND BUFFER ADDRESS
			;TO CP/M
	CALL	IOS 
	LBCD	SEC+2    ; (BC) <- (SECTOR)
	LXI	D,SETSEC ;SEND SECTOR # TO CP/M
	CALL	IOS
	LBCD	TRACK+2 ; (BC) <- (TRACK)
	LXI	D,SETTRK
	CALL	IOS
	JMP	NEXT
;
	.BYTE	89H	; SET-DRIVE
	.ASCIS	'SET-DRIVE'
	.WORD	SETIO-9
SETDRV:	.WORD	.+2
	LDA	DRIVE+2  ; (C) <- DRIVE #
	MOV	C,A
	LXI	D,SETDSK ;SEND DRIVE # TO CP/M
	CALL	IOS
	JMP	NEXT
;
;
; T&SCALC  (CALCULATES DRIVE #
;		       TRACK #
;		       SECTOR #)
; 
; STACK INPUT: SECTOR DISPLACEMENT (BLK# * SEC/BLK)
; STACK OUTPUT: VARIABLES DRIVE,TRACK,SEC
;
	.BYTE	87H	;T&SCALC
	.ASCIS	'T&SCALC'
	.WORD	SETDRV-12
TSCALC:	.WORD	DOCOL
	.WORD	DENSTY
	.WORD	AT
	.WORD	ZBRAN
	.WORD	TSCALS-.
	.WORD	LIT
	.WORD	SPDRV2
	.WORD	SLMOD
	.WORD	LIT
	.WORD	MXDRV
	.WORD	MIN
	.WORD	DUP
	.WORD	DRIVE
	.WORD	AT
	.WORD	EQUAL
	.WORD	ZBRAN
	.WORD	TSCAL1-.
	.WORD	DROP
	.WORD	BRAN
	.WORD	TSCAL2-.
TSCAL1:	.WORD	DRIVE
	.WORD	STORE
	.WORD	SETDRV
TSCAL2:	.WORD	LIT
	.WORD	SPT2
	.WORD	SLMOD
	.WORD	TRACK
	.WORD	STORE
	.WORD	ONEP
	.WORD	SEC
	.WORD	STORE
	.WORD	SEMIS
; SINGLE DENSITY
TSCALS:	.WORD	LIT
	.WORD	SPDRV1
	.WORD	SLMOD
	.WORD	LIT
	.WORD	MXDRV
	.WORD	MIN
	.WORD	DUP
	.WORD	DRIVE
	.WORD	AT
	.WORD	EQUAL
	.WORD	ZBRAN
	.WORD	TSCAL3-.
	.WORD	DROP
	.WORD	BRAN
	.WORD	TSCAL4-.
TSCAL3:	.WORD	DRIVE
	.WORD	STORE
	.WORD	SETDRV
TSCAL4:	.WORD	LIT
	.WORD	SPT1
	.WORD	SLMOD
	.WORD	TRACK
	.WORD	STORE
	.WORD	ONEP
	.WORD	SEC
	.WORD	STORE
	.WORD	SEMIS
;
; SEC-READ
; (READ A SECTOR SET-UP BY 'SET-DRIVE'
;  AND 'SET-IO')
;
	.BYTE	88H	; SEC-READ
	.ASCIS	'SEC-READ'
	.WORD	TSCALC-10
SECRD:	.WORD	.+2
	LXI	D,RDSEC ; REQUEST TRANSFER
			; BY CP/M
	CALL	IOS
	STA	DSKERR+2 ;SAVE STATUS
	JMP	NEXT
;
; SEC-WRITE
; (WRITE A SECTOR SET UP BY
;  'SET-DRIVE' AND 'SET-IO')
;
	.BYTE	89H	; SEC-WRITE
	.ASCIS	'SEC-WRITE'
	.WORD	SECRD-11
SECWT:	.WORD	.+2
	LXI	D,RITSEC ;REQUEST TRANSFER
	CALL	IOS	;BY CP/M
	STA	DSKERR+2 ;(DSKERR) <- STATUS
	JMP	NEXT
;
	.BYTE	83H	; R/W 
			; (FORTH DISK PRIMITIVE)
	.ASCIS	'R/W'
	.WORD	SECWT-12
RSLW:	.WORD	DOCOL
	.WORD	USE
	.WORD	AT
	.WORD	TOR
	.WORD	SWAP
	.WORD	SPBLK
	.WORD	STAR
	.WORD	ROT
	.WORD	USE
	.WORD	STORE
	.WORD	SPBLK
	.WORD	ZERO
	.WORD	XDO
RSLW1:	.WORD	OVER
	.WORD	OVER
	.WORD	TSCALC
	.WORD	SETIO
	.WORD	ZBRAN
	.WORD	RSLW2-.
	.WORD	SECRD
	.WORD	BRAN
	.WORD	RSLW3-.
RSLW2:	.WORD	SECWT
RSLW3:	.WORD	ONEP
	.WORD	LIT
	.WORD	80H
	.WORD	USE
	.WORD	PSTOR
	.WORD	XLOOP
	.WORD	RSLW1-.
	.WORD	DROP
	.WORD	DROP
	.WORD	FROMR
	.WORD	USE
	.WORD	STORE
	.WORD	SEMIS
;
;
; *******************************************
; ALTERNATIVE R/W FOR NO DISK INTERFACE
; RSLW DW DOCOL,DROP,DROP,DROP,SEMIS
; *******************************************
;
;
	.BYTE	85H	; FLUSH
	.ASCIS	'FLUSH'
	.WORD	RSLW-6
FLUSH:	.WORD	DOCOL
	.WORD	NOBUF
	.WORD	ONEP
	.WORD	ZERO
	.WORD	XDO
FLUS1:	.WORD	ZERO
	.WORD	BUFFE
	.WORD	DROP
	.WORD	XLOOP
	.WORD	FLUS1-.
	.WORD	SEMIS
;
	.BYTE	84H	; LOAD
	.ASCIS	'LOAD'
	.WORD	FLUSH-8
LOAD:	.WORD	DOCOL
	.WORD	BLK
	.WORD	AT
	.WORD	TOR
	.WORD	INN
	.WORD	AT
	.WORD	TOR
	.WORD	ZERO
	.WORD	INN
	.WORD	STORE
	.WORD	BSCR
	.WORD	STAR
	.WORD	BLK
	.WORD	STORE ;BLK <- SCR * B/SCR
	.WORD	INTER
	.WORD	FROMR
	.WORD	INN
	.WORD	STORE
	.WORD	FROMR
	.WORD	BLK
	.WORD	STORE
	.WORD	SEMIS
;
	.BYTE	0C3H	; -->
	.ASCIS	'-->'
	.WORD	LOAD-7
ARROW:	.WORD	DOCOL
	.WORD	QLOAD
	.WORD	ZERO
	.WORD	INN
	.WORD	STORE
	.WORD	BSCR
	.WORD	BLK
	.WORD	AT
	.WORD	OVER
	.WORD	MODD
	.WORD	SUBB
	.WORD	BLK
	.WORD	PSTOR
	.WORD	SEMIS
	.PAGE
;
;
; CP/M CONSOLE AND PRINTER INTERFACE
;
; CP/M BIOS CALLS USED
; (NOTE: BELOW OFFSETS ARE 3 LOWER THAN
;  CP/M DOCUMENTATION SINCE BASE ADDR = BIOS+3)
;
KCSTAT	==	3	; CONSOLE STATUS
KCIN	==	6	; CONSOLE INPUT
KCOUT	==	9	; CONSOLE OUTPUT
KPOUT	==	12	; PRINTER OUTPUT
EPRINT:	.WORD	0	; ENABLE PRINTER VARIABLE
			; 0=DSB , 1=ENB
;
; BELOW BIOS CALLS USE 'IOS' IN DISK INTERFACE
;
CSTAT:	PUSH	B	; CONSOLE STATUS
	LXI	D,KCSTAT ;CHECK IF ANY CHAR
			;HAS BEEN TYPED
	CALL	IOS
	POP	B	;IF CHAR TYPED THEN
			;A <- 0FFH
	RET		;ELSE A <- 0
			;CHR IGNORED
;
CIN:	PUSH	B	;CONSOLE INPUT
	LXI	D,KCIN	;WAIT UNTIL READY
	CALL	IOS	;(A) <- CHR, (MSB) <-0
	POP	B	
	RET
;
COUT:	PUSH	H	;CONSOLE OUTPUT
	LXI	D,KCOUT ;WAIT UNTIL READY
	CALL	IOS	;THEN OUTPUT (C)
	POP	H
	RET
;
POUT:	LXI	D,KPOUT ;PRINTER OUTPUT
	CALL	IOS	;WAIT UNTIL READY,
	RET		;THEN OUTPUT (C)
;
CPOUT:	CALL	COUT	;OUTPUT (C) TO CONSOLE
	XCHG
	LDA	EPRINT ; IF (EPRINT)<>0
	ORA	A
	JRZ	CPOU1
	MOV	C,E	;THEN OUTPUT (C) TO 
	CALL	POUT	;PRINTER
CPOU1:	RET
;
; FORTH TO CP/M SERIAL TO INTERFACE
;
PQTER:	CALL	CSTAT	;IF CHR TYPED
	LXI	H,0
	ORA	A
	JZ	PQTE1
	INR	L	;THEN (S1) <- TRUE
PQTE1:	JMP	HPUSH	;ELSE (S1) <- FALSE
;
PKEY:	CALL	CIN	;READ CHR FROM CONSOLE
	CPI	DLE	;IF CHR = (^P)
	MOV	E,A
	JNZ	PKEY1
	LXI	H,EPRINT ;THEN TOGGLE (EPRINT)LSB
	MVI	E,ABL	;CHR <- BLANK
	MOV	A,M
	XRI	1
	MOV	M,A
PKEY1:	MOV	L,E
	MVI	H,0
	JMP	HPUSH	;(S1)LB <- CHR
;
PEMIT:	.WORD	.+2	;(EMIT) ORPHAN
	POP	H	;(L) <- (S1)LB = CHR
	MOV	C,L
	CALL	CPOUT	;OUTPUT CHR TO CONSOLE
			;AND MAYBE PRINTER
	JMP	NEXT
;
PCR:			;
	MVI	C,ACR	;OUTPUT (CR) TO CONSOLE
	MOV	L,C
	CALL	CPOUT	;AND MAYBE TO PRINTER
	MVI	C,LF	;OUTPUT (LF) TO CONSOLE
	MOV	L,C
	CALL	CPOUT	;AND MAYBE TO PRINTER
	JMP	NEXT
;
	.PAGE
;
	.BYTE	0C1H	; (TICK)
	.BYTE	0A7H
	.WORD	ARROW-6
TICK:	.WORD	DOCOL
	.WORD	DFIND
	.WORD	ZEQU
	.WORD	ZERO
	.WORD	QERR
	.WORD	DROP
	.WORD	LITER
	.WORD	SEMIS
;
	.BYTE	86H	; FORGET
	.ASCIS	'FORGET'
	.WORD	TICK-4
FORG:	.WORD	DOCOL
	.WORD	CURR
	.WORD	AT
	.WORD	CONT
	.WORD	AT
	.WORD	SUBB
	.WORD	LIT
	.WORD	18H
	.WORD	QERR
	.WORD	TICK
	.WORD	DUP
	.WORD	FENCE
	.WORD	AT
	.WORD	LESS
	.WORD	LIT
	.WORD	15H
	.WORD	QERR
	.WORD	DUP
	.WORD	NFA
	.WORD	DP
	.WORD	STORE
	.WORD	LFA
	.WORD	AT
	.WORD	CONT
	.WORD	AT
	.WORD	STORE
	.WORD	SEMIS
;
	.BYTE	84H	; BACK
	.ASCIS	'BACK'
	.WORD	FORG-9
BACK:	.WORD	DOCOL
	.WORD	HERE
	.WORD	SUBB
	.WORD	COMMA
	.WORD	SEMIS
;
	.BYTE	0C5H	; BEGIN
	.ASCIS	'BEGIN'
	.WORD	BACK-7
BEGIN:	.WORD	DOCOL
	.WORD	QCOMP
	.WORD	HERE
	.WORD	ONE
	.WORD	SEMIS
;
	.BYTE	0C5H	; ENDIF
	.ASCIS	'ENDIF'
	.WORD	BEGIN-8
ENDIFF:	.WORD	DOCOL
	.WORD	QCOMP
	.WORD	TWO
	.WORD	QPAIR
	.WORD	HERE
	.WORD	OVER
	.WORD	SUBB
	.WORD	SWAP
	.WORD	STORE
	.WORD	SEMIS
;
	.BYTE	0C4H	; THEN
	.ASCIS	'THEN'
	.WORD	ENDIFF-8
THEN:	.WORD	DOCOL
	.WORD	ENDIFF
	.WORD	SEMIS
;
	.BYTE	0C2H	; DO
	.ASCIS	'DO'
	.WORD	THEN-7
DO:	.WORD	DOCOL
	.WORD	COMP
	.WORD	XDO
	.WORD	HERE
	.WORD	THREE
	.WORD	SEMIS
;
	.BYTE	0C4H	; LOOP
	.ASCIS	'LOOP'
	.WORD	DO-5
LOOP:	.WORD	DOCOL
	.WORD	THREE
	.WORD	QPAIR
	.WORD	COMP
	.WORD	XLOOP
	.WORD	BACK
	.WORD	SEMIS
;
	.BYTE	0C5H	; +LOOP
	.ASCIS	'+LOOP'
	.WORD	LOOP-7
PLOOP:	.WORD	DOCOL
	.WORD	THREE
	.WORD	QPAIR
	.WORD	COMP
	.WORD	XPLOO
	.WORD	BACK
	.WORD	SEMIS
;
	.BYTE	0C5H	; UNTIL
	.ASCIS	'UNTIL'
	.WORD	PLOOP-8
UNTIL:	.WORD	DOCOL
	.WORD	ONE
	.WORD	QPAIR
	.WORD	COMP
	.WORD	ZBRAN
	.WORD	BACK
	.WORD	SEMIS
;
	.BYTE	0C3H	; END
	.ASCIS	'END'
	.WORD	UNTIL-8
ENDD:	.WORD	DOCOL
	.WORD	UNTIL
	.WORD	SEMIS
;
	.BYTE	0C5H	; AGAIN
	.ASCIS	'AGAIN'
	.WORD	ENDD-6
AGAIN:	.WORD	DOCOL
	.WORD	ONE
	.WORD	QPAIR
	.WORD	COMP
	.WORD	BRAN
	.WORD	BACK
	.WORD	SEMIS
;
	.BYTE	0C6H	; REPEAT
	.ASCIS	'REPEAT'
	.WORD	AGAIN-8
REPEA:	.WORD	DOCOL
	.WORD	TOR
	.WORD	TOR
	.WORD	AGAIN
	.WORD	FROMR
	.WORD	FROMR
	.WORD	TWO
	.WORD	SUBB
	.WORD	ENDIFF
	.WORD	SEMIS
;
	.BYTE	0C2H	; IF
	.ASCIS	'IF'
	.WORD	REPEA-9
IFF:	.WORD	DOCOL
	.WORD	COMP
	.WORD	ZBRAN
	.WORD	HERE
	.WORD	ZERO
	.WORD	COMMA
	.WORD	TWO
	.WORD	SEMIS
;
	.BYTE	0C4H	; ELSE
	.ASCIS	'ELSE'
	.WORD	IFF-5
ELSEE:	.WORD	DOCOL
	.WORD	TWO
	.WORD	QPAIR
	.WORD	COMP
	.WORD	BRAN
	.WORD	HERE
	.WORD	ZERO
	.WORD	COMMA
	.WORD	SWAP
	.WORD	TWO
	.WORD	ENDIFF
	.WORD	TWO
	.WORD	SEMIS
;
	.BYTE	0C5H	; WHILE
	.ASCIS	'WHILE'
	.WORD	ELSEE-7
WHILE:	.WORD	DOCOL
	.WORD	IFF
	.WORD	TWOP
	.WORD	SEMIS
;
	.BYTE	86H	; SPACES
	.ASCIS	'SPACES'
	.WORD	WHILE-8
SPACS:	.WORD	DOCOL
	.WORD	ZERO
	.WORD	MAX
	.WORD	DDUP
	.WORD	ZBRAN
	.WORD	SPAX1-. ;IF
	.WORD	ZERO
	.WORD	XDO ;DO
SPAX2:	.WORD	SPACE
	.WORD	XLOOP
	.WORD	SPAX2-. ;ENDIF
SPAX1:	.WORD	SEMIS
;
	.BYTE	82H	; <#
	.ASCIS	'<#'
	.WORD	SPACS-9
BDIGS:	.WORD	DOCOL
	.WORD	PAD
	.WORD	HLD
	.WORD	STORE
	.WORD	SEMIS
;
	.BYTE	82H	; #>
	.ASCIS	'#>'
	.WORD	BDIGS-5
EDIGS:	.WORD	DOCOL
	.WORD	DROP
	.WORD	DROP
	.WORD	HLD
	.WORD	AT
	.WORD	PAD
	.WORD	OVER
	.WORD	SUBB
	.WORD	SEMIS
;
	.BYTE	84H	; SIGN
	.ASCIS	'SIGN'
	.WORD	EDIGS-5
SIGN:	.WORD	DOCOL
	.WORD	ROT
	.WORD	ZLESS
	.WORD	ZBRAN
	.WORD	SIGN1-.	;IF
	.WORD	LIT
	.WORD	2DH
	.WORD	HOLD 	;ENDIF
SIGN1:	.WORD	SEMIS
;
	.BYTE	81H	; #
	.ASCIS	'#'
	.WORD	SIGN-7
DIG:	.WORD	DOCOL
	.WORD	BASE
	.WORD	AT
	.WORD	MSMOD
	.WORD	ROT
	.WORD	LIT
	.WORD	9
	.WORD	OVER
	.WORD	LESS
	.WORD	ZBRAN
	.WORD	DIG1-. ;IF
	.WORD	LIT
	.WORD	7
	.WORD	PLUS ;ENDIF
DIG1:	.WORD	LIT
	.WORD	30H
	.WORD	PLUS
	.WORD	HOLD
	.WORD	SEMIS
;
	.BYTE	82H	; #S
	.ASCIS	'#S'
	.WORD	DIG-4
DIGS:	.WORD	DOCOL
DIGS1:	.WORD	DIG 	;BEGIN
	.WORD	OVER
	.WORD	OVER
	.WORD	ORR
	.WORD	ZEQU
	.WORD	ZBRAN
	.WORD	DIGS1-. ;UNTIL
	.WORD	SEMIS
;
	.BYTE	83H	; D.R
	.ASCIS	'D.R'
	.WORD	DIGS-5
DDOTR:	.WORD	DOCOL
	.WORD	TOR
	.WORD	SWAP
	.WORD	OVER
	.WORD	DABS
	.WORD	BDIGS
	.WORD	DIGS
	.WORD	SIGN
	.WORD	EDIGS
	.WORD	FROMR
	.WORD	OVER
	.WORD	SUBB
	.WORD	SPACS
	.WORD	TYPE
	.WORD	SEMIS
;
	.BYTE	82H	; .R
	.ASCIS	'.R'
	.WORD	DDOTR-6
DOTR:	.WORD	DOCOL
	.WORD	TOR
	.WORD	STOD
	.WORD	FROMR
	.WORD	DDOTR
	.WORD	SEMIS
;
	.BYTE	82H	; D.
	.ASCIS	'D.'
	.WORD	DOTR-5
DDOT:	.WORD	DOCOL
	.WORD	ZERO
	.WORD	DDOTR
	.WORD	SPACE
	.WORD	SEMIS
;
	.BYTE	81H	; .
	.ASCIS	'.'
	.WORD	DDOT-5
DOT:	.WORD	DOCOL
	.WORD	STOD
	.WORD	DDOT
	.WORD	SEMIS
;
	.BYTE	81H	; ?
	.ASCIS	'?'
	.WORD	DOT-4
QUES:	.WORD	DOCOL
	.WORD	AT
	.WORD	DOT
	.WORD	SEMIS
;
	.BYTE	82H	; U.
	.ASCIS	'U.'
	.WORD	QUES-4
UDOT:	.WORD	DOCOL
	.WORD	ZERO
	.WORD	DDOT
	.WORD	SEMIS
;
	.BYTE	85H	; VLIST
	.ASCIS	'VLIST'
	.WORD	UDOT-5
VLIST:	.WORD	DOCOL
	.WORD	LIT
	.WORD	80H
	.WORD	OUTT
	.WORD	STORE
	.WORD	CONT
	.WORD	AT
	.WORD	AT
VLIS1:	.WORD	OUTT 	;BEGIN
	.WORD	AT
	.WORD	CSLL
	.WORD	GREAT
	.WORD	ZBRAN
	.WORD	VLIS2-. ;IF
	.WORD	CR
	.WORD	ZERO
	.WORD	OUTT
	.WORD	STORE	;ENDIF
VLIS2:	.WORD	DUP
	.WORD	IDDOT
	.WORD	SPACE
	.WORD	SPACE
	.WORD	PFA
	.WORD	LFA
	.WORD	AT
	.WORD	DUP
	.WORD	ZEQU
	.WORD	QTERM
	.WORD	ORR
	.WORD	ZBRAN
	.WORD	VLIS1-. ;UNTIL
	.WORD	DROP
	.WORD	SEMIS
;
; EXIT CP/M
;
	.BYTE	83H	; BYE
	.ASCIS	'BYE'
	.WORD	VLIST-8
BYE:	.WORD	.+2
	JMP	0
;
;
	.BYTE	84H	; LIST
	.ASCIS	'LIST'
	.WORD	BYE-6
LIST:	.WORD	DOCOL
	.WORD	DEC
	.WORD	CR
	.WORD	DUP
	.WORD	SCR
	.WORD	STORE
	.WORD	PDOTQ
	.BYTE	6
	.ASCII	'SCR # '
	.WORD	DOT
	.WORD	LIT
	.WORD	10H
	.WORD	ZERO
	.WORD	XDO
LIST1:	.WORD	CR
	.WORD	IDO
	.WORD	LIT
	.WORD	3
	.WORD	DOTR
	.WORD	SPACE
	.WORD	IDO
	.WORD	SCR
	.WORD	AT
	.WORD	DLINE
	.WORD	QTERM	; ?TERMINAL
	.WORD	ZBRAN
	.WORD	LIST2-. ;IF
	.WORD	LEAVE	;LEAVE
LIST2:	.WORD	XLOOP
	.WORD	LIST1-. ;ENDIF
	.WORD	CR
	.WORD	SEMIS
;
	.BYTE	85H	; INDEX
	.ASCIS	'INDEX'
	.WORD	LIST-7
INDEX:	.WORD	DOCOL
	.WORD	LIT
	.WORD	FF
	.WORD	EMIT
	.WORD	CR
	.WORD	ONEP
	.WORD	SWAP
	.WORD	XDO
INDE1:	.WORD	CR
	.WORD	IDO
	.WORD	LIT
	.WORD	3
	.WORD	DOTR
	.WORD	SPACE
	.WORD	ZERO
	.WORD	IDO
	.WORD	DLINE
	.WORD	QTERM
	.WORD	ZBRAN
	.WORD	INDE2-.
	.WORD	LEAVE
INDE2:	.WORD	XLOOP
	.WORD	INDE1-.
	.WORD	SEMIS
;
	.BYTE	85H	; TRIAD
	.ASCIS	'TRIAD'
	.WORD	INDEX-8
TRIAD:	.WORD	DOCOL
	.WORD	LIT
	.WORD	FF
	.WORD	EMIT
	.WORD	LIT
	.WORD	3
	.WORD	SLASH
	.WORD	LIT
	.WORD	3
	.WORD	STAR
	.WORD	LIT
	.WORD	3
	.WORD	OVER
	.WORD	PLUS
	.WORD	SWAP
	.WORD	XDO
TRIA1:	.WORD	CR
	.WORD	IDO
	.WORD	LIST
	.WORD	QTERM	; ?TERMINAL
	.WORD	ZBRAN
	.WORD	TRIA2-. ;IF
	.WORD	LEAVE	; LEAVE
TRIA2:	.WORD	XLOOP
	.WORD	TRIA1-. ;ENDIF
	.WORD	CR
	.WORD	LIT
	.WORD	15
	.WORD	MESS
	.WORD	CR
	.WORD	SEMIS
;
	.BYTE	84H	; .CPU
	.ASCIS	'.CPU'
	.WORD	TRIAD-8
DOTCPU:	.WORD	DOCOL
	.WORD	BASE
	.WORD	AT
	.WORD	LIT
	.WORD	36
	.WORD	BASE
	.WORD	STORE
	.WORD	LIT
	.WORD	22H
	.WORD	PORIG
	.WORD	TAT
	.WORD	DDOT
	.WORD	BASE
	.WORD	STORE
	.WORD	SEMIS
;
	.BYTE	85H	; STRING MATCH FOR EDITOR
	.ASCIS	'MATCH'
	.WORD	DOTCPU-7
MATCH:	.WORD	.+2	; (CURSOR ADDR -4)
			; (BYTES LEFT  -3)
			; (STRING ADDR -2)
			; (COUNT       -1)
			; LEAVES ON STACK:
			; (BOOLEAN     -2)
			; (CURSOR ADV  -1)
	SIXD	MATCHA  ;SAVE IP
	SIYD	MATCHB  ;SAVE RP
	POP	B	;GET COUNT
	POP	X	;STRING ADDR
	POP	D	;BYTES LEFT
	POP	Y	;CURSOR ADDR
	LXI	H,0	;INIT CURSOR ADV
MATCH1:	PUSH	X	;SAVE STRING ADDR
	PUSH	Y	;     CURSOR
	PUSH	B	;     AND LENGTH
	MOV	A,0(X)	;TRY THE FIRST CHAR
	CMP	0(Y)
	JRZ	MATCH4  ;POSSIBLE MATCH
MATCH2:	POP	B	;RESTORE COUNT
	POP	Y	;        CURSOR
	POP	X	;    AND STRING ADDR
	INX	Y	;ADVANCE CURSOR
	INX	H	;COUNT ADVANCES
	DCX	D	;BYTES LEFT
	MOV	A,D
	ORA	E	;OUT OF BYTES?
	JRNZ	MATCH1  ;NOT YET
	PUSH	H	;PUSH CURSOR ADV
	LXI	H,0	;PUSH FALSE FLAG
	XTHL
	PUSH	H
MATCH3:	LIXD	MATCHA ;RESTORE IP
	LIYD	MATCHB ;RESTORE RP
	JMP	NEXT	; GO ON
MATCH4:	DCX	B	;COUNT STRING LENGTH
	MOV	A,B	;ALL STRING MATCHED?
	ORA	C
	JRZ	MATCH5  ;YES,SUCCESS!
	INX	X	;STILL MATCHING
	INX	Y	;ADVANCE CURSOR AND 
			;STRING ADDRESSES
	MOV	A,0(X)	;TRY NEXT CHAR
	CMP	0(Y)
	JRNZ	MATCH2  ;NO GOOD
	JMPR	MATCH4	;STILL MATCHES OK
MATCH5:			;SUCCESSFUL MATCH
	POP	B	;SET CURSOR AT END
	DAD	B	;OF MATCHED TEXT
			;DISCARD OTHER JUNK
	POP	B	;ON STACK
	POP	B
	LXI	B,1	;PUSH TRUE FLAG
	PUSH	B
	PUSH	H	;PUSH CURSOR ADVANCE
	JMP	MATCH3	;GO RESTORE REGISTERS
MATCHA:	.WORD	0	;SAVE (IP)
MATCHB:	.WORD	0	;SAVE (RP)
;
	.BYTE	84H	; TASK
	.ASCIS	'TASK'
	.WORD	MATCH-8
TASK:	.WORD	DOCOL
	.WORD	SEMIS
;
INITDP:	.BLKB	EM-.	;CONSUME MEMORY
			;TO LIMIT
;
	.PAGE
;
; MEMORY MAP
; (THE FOLLOWING EQUATES ARE
;  NOT REFERENCED ELSEWHERE)
;
MCOLD	==	ORIG	;JUMP TO COLD START
MWARM	==	ORIG+4	;JUMP TO WARM START
MA2	==	ORIG+8	;COLD START PARAMETERS
MUP	==	UP	;USER VARIABLES'
			;BASE 'REG'
MRP	==	RPP	;RETURN STACK 'REG'
;
MBIP	==	BIP	;DEBUG SUPPORT
MDPUSH	==	DPUSH	;ADDRESS INTERPRETER
MHPUSH	==	HPUSH	;
MNEXT	==	NEXT
;
MDP0	==	DP0	;START FORTH DICTIONARY
MDIO	==	DRIVE	;CP/M DISK INTERFACE
MCIO	==	EPRINT	;CONSOLE AND PRINTER
			;INTERFACE
MIDP	==	INITDP	;END INITIAL FORTH
			;DICTIONARY
			;= COLD (DP) VALUE
			;= COLD (FENCE) VALUE
			; I  NEW
			; I  DEFINITIONS
			; V
			; ^
			; I  DATA
			; I  STACK
MIS0	==	INITS0	;= COLD (SP) VALUE = (S0)
			;= (TIB)
			; I  TERMINAL INPUT
			; I  BUFFER
			; V
			; ^
			; I  RETURN
			; I  STACK
MIR0	==	INITR0	;START USER VARIABLES
			;= COLD (RP) VALUE = (R0)
			;= (UP)
			;END USER VARIABLES
MFIRST	==	BUF1	;START DISK BUFFERS
			; = FIRST
MEND	==	EM-1	;END DISK BUFFERS
MLIMIT	==	EM	;LAST MEMORY LOC USED+1
			; = LIMIT
	.END	ORIG
