.title "Send flags on HiNet until reset."
	.sbttl "SENDFLG"
version	==	1
revision==	0
patch	==	' '
	.phex
	.pabs
	.loc	100h
	lxi	SP,stack
	lxi	D,logmsg
	mvi	C,9
	call	5
;
; Send flags forever
        lxi	H,SENDprog
	lxi	B,SEND$<8+SIO1BC
	outir
	sub	A
	out	SIO1BD	; send userno of zero
	mvi	A,11010000b; reset underrun/EOM status
	out	SIO1BC	; reset underrun status
        jmp	.
;---------------
; SIO commands
SENDprog:
	.byte	    00011000b ; channel reset
	.byte	  3,00100000b ; auto enables
	.byte	14h,00100000b ; SDLC mode
	.byte	11h,11000100b ; no interrupts
	.byte	  5,11101011b ; transmitter enable
	.byte	    10000000b ; reset CRC generator
        SEND$	==	.-SENDprog
	SIO1BC	== 	2Bh
	SIO1BD	==	29h
	cr	==	0Dh	;carriage return
	lf	==	0Ah	;line feed
;
logmsg: .ascii	[cr][lf]'SENDFLG Version'
  	.byte	version+'0','.'
	.byte	revision/10+'0',revision@10+'0'
	.byte	patch 
        .ascii  [cr][lf][lf]'Sending flags (until you '
	.asciz		    'hit RESET)$'
;
	.blkw	30
stack:
        .end
	.end