//---------------------------------------------------------------------------
//
//    DIGITAL hereby grants any authorized developer using the PATHWORKS SDK 
//    ("Developer"), a royalty-free, non-exclusive license to use any of 
//    DIGITAL's source code supplied with the PATHWORKS SDK to create binaries 
//    which the developer may then copy and merge with the developers software 
//    for distribution to its customers.  DIGITAL is not liable for any 
//    damages caused by any errors in the source code provided with the SDK.
//
//---------------------------------------------------------------------------

#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#define WIN32_LEAN_AND_MEAN TRUE
    /* kick out conflicts between winsock.h & iocb.h */
    /* Could use #define _WINSOCKAPI_ instead.  */
#include <windows.h>
#include <winerror.h>  // WIN32 defined errors

#define IOCB_INCL_DN         /* include DECnet structures */
#include "socket.h"
#include "iocb_32.h"

// globals 
    DWORD rc;
    OVERLAPPED ols = {0,0,0,0,0};
    NIOCB iocb;
    HANDLE thread2 = 0;
    DWORD threadid;
    WORD listen_socket = 0;
    
DWORD WINAPI thread2_proc(LPVOID threadparam);
VOID WINAPI IOCBCompletionRoutine(NIOCB *);
VOID check_sync_err(char *,BOOL,NIOCB *);
BOOL check_async_err(char *);
VOID process_event(char *);

/*************************************************************************/

HANDLE spawn_thread(VOID)
{
    if (!(ols.hEvent = CreateEvent(NULL,TRUE,FALSE,"DEC_Event_Test")))
    {
        printf("Unable to create event, error: %u\n",GetLastError());
        return(0);
    }
    thread2 = CreateThread(NULL,0,thread2_proc,0,0,&threadid);
    if (!thread2)
        printf("Unable to create second thread, error: %u\n",GetLastError());
    return(thread2);
}

/*************************************************************************/

DWORD WINAPI thread2_proc(LPVOID threadparam)
{ // main procedure for second thread in order to test event processing
  // and the Win32 form of callbacks
    WORD holder;
    
    iocb.io_seal = IOCB_SEAL;
    iocb.io_flags = MSG_NIOCB | MSG_USRWAIT;
    iocb.io_callback = NULL;
    iocb.io_status = iocb.io_errno = iocb.io_socket = 0;
    
// ATTACH: example of function call that executes immediately    
    iocb.patt.att_socket = iocb.patt.att_srp = iocb.patt.att_supreq = 0;
    iocb.patt.att_domain = AF_DECnet;
    iocb.patt.att_type = SOCK_STREAM;
    iocb.patt.att_protocol = DNPROTO_NSP;
    iocb.io_psize = sizeof(ATTACH_DN);
    iocb.io_fcode = PRU_ATTACH;
    rc = IocbSubmit(DECnet_API,&iocb,0); // this is a sync call
    check_sync_err("ATTACH",TRUE,&iocb);
    listen_socket = iocb.io_socket;
    
// BIND: example of trying to use an event with a function call that
//       executes immediately
    memset(&iocb.psdn,0,sizeof(struct sockaddr_dn));
    iocb.psdn.sdn_family = AF_DECnet;
    iocb.psdn.sdn_objnum = DNOBJECT_DTR; // pretend we are DTR 
    iocb.io_fcode = PRU_BIND;
    iocb.io_psize = sizeof(struct sockaddr_dn);
    rc = IocbSubmit(DECnet_API,&iocb,&ols);  // pretend async call
    check_sync_err("BIND",TRUE,&iocb);
    switch(rc = WaitForSingleObject(ols.hEvent,100))
    {  // this logic validates the event is not signalled for sync calls
    case WAIT_TIMEOUT:  // this is what should happen
        break;
    case WAIT_OBJECT_0:
        printf("Error: Event signalled for Synchronous IOCB Call.\n");
        return(0);
        break;
    default:
        printf("Bind Event Wait Failed with %u, error: %u\n",rc,GetLastError());
        return(0);
        break;
    }

// LISTEN: another example of function call that executes immediately
    iocb.plsn.lsn_backlog = 2;
    iocb.io_fcode = PRU_LISTEN;
    iocb.io_psize = sizeof(struct listen_dn);
    rc = IocbSubmit(DECnet_API,&iocb,0);  // this is a sync call
    check_sync_err("LISTEN",TRUE,&iocb);

// ACCEPT: example of using an event with an async call that will wait
//         for incoming network I/O
    printf("\n");
    iocb.patt.att_socket = listen_socket;
    iocb.patt.att_srp = iocb.patt.att_supreq = 0;
    iocb.patt.att_domain = AF_DECnet;
    iocb.patt.att_type = SOCK_STREAM;
    iocb.patt.att_protocol = DNPROTO_NSP;
    iocb.io_fcode = PRU_ACCEPT;
    iocb.io_psize = sizeof(struct sockaddr_dn);
    iocb.io_socket = 0;  // have DECnet assign next socket number
    rc = IocbSubmit(DECnet_API,&iocb,&ols);  // this is an async call
    if (check_async_err("ACCEPT"))
        process_event("ACCEPT");
    holder = iocb.psdn.sdn_add.a_addr[0]; // incoming connect request arrived
    holder += iocb.psdn.sdn_add.a_addr[1] << 8;
    printf("        Incoming Socket: %u\n",iocb.io_socket);
    printf("        Calling DECnet Node address: %u.%u\n\n",
           holder / 1024, holder % 1024);

// DISCONNECT: example of using a Win32 callback routine with an async call
    iocb.io_fcode = PRU_DISCONNECT;
    iocb.io_psize = 0;
    iocb.io_callback = (byte *) IOCBCompletionRoutine;
    iocb.io_flags |= MSG_CALLBACK;  // Now try for a callback
    rc = IocbSubmit(DECnet_API,&iocb,&ols);  // this is an async call
    if (check_async_err("DISCONNECT"))
    {
        printf("Waiting forever for DISCONNECT\n");
        rc = SleepEx(INFINITE,TRUE);
        if (rc == WAIT_IO_COMPLETION)
        {
            printf("    DISCONNECT Wait satisfied by IO Completion.\n");
            rc = 0;
            check_sync_err("DISCONNECT",TRUE,&iocb);
        }
        else printf("    DISCONNECT Callback Wait Failed with %u, error: %u\n",
                    rc,GetLastError());
    }
    else printf("DISCONNECT completed too quickly, can't wait.\n");
    iocb.io_callback = NULL;
    iocb.io_flags ^= MSG_CALLBACK;
    
// DETACH: example of async call that does not have to wait usually
    iocb.io_fcode = PRU_DETACH;  // this may be an async call
    iocb.io_psize = 0;
    rc = IocbSubmit(DECnet_API,&iocb,&ols);
    if (check_async_err("DETACH2"))
        process_event("DETACH2");

    thread2 = 0;
    ExitThread(0);
    return(0);  // prevent compiler warning
}

/*************************************************************************/

VOID WINAPI IOCBCompletionRoutine(NIOCB *iocb3)
{
    printf("    IOCB Completion Subroutine called.\n");
    if (iocb3 != &iocb)
    	printf("Error: passed NIOCB %p does not match expected %p.\n",
    		iocb3,&iocb);
   else
   {
   	rc = 0;
   	check_sync_err("IOCompRtn",FALSE,iocb3);
   }
}

/*************************************************************************/

VOID process_event(char *cmdnm)
{ // wait for async function to complete & check for errors
    printf("Waiting forever for %s...\n",cmdnm);
    rc = WaitForSingleObject(ols.hEvent,INFINITE);
    if (rc == WAIT_OBJECT_0)  // 0
    {
        printf("    Event signalled for %s call.\n",cmdnm);
        rc = 0;
        check_sync_err(cmdnm,TRUE,&iocb);
    }
    else 
    {
        printf("    %s Event Wait Failed with %u, error: %u\n",
                cmdnm,rc,GetLastError());
        ExitThread(1);
    }
    if (!ResetEvent(ols.hEvent))  // must be done after every wait
        printf("    Error: Reset Event Failed.\n");
}

/*************************************************************************/

BOOL check_async_err(char *cmdnam)
{  // determine if async function had errors & how completed
    if (rc == 0 && iocb.io_status == 0)
        return(FALSE); // call worked immediately
    if (rc != ERROR_IO_PENDING)
    {
        printf("    %s call returned %u at Win32 level.\n",rc);
        ExitThread(1);
    }
    if (iocb.io_status == IOCB_PENDING)
        return(TRUE);  // typical pending case
    if (iocb.io_status == IOCB_ERROR)
    {
        printf("    %s call returned %u at the DECnet level.\n",
               iocb.io_errno);
        ExitThread(1);
    }
    return(FALSE); // call must have completed ok, right?
}

/*************************************************************************/

VOID check_sync_err(char *cmdname,BOOL exitsw,NIOCB *iocbp)
{  // called from either thread for IOCB functions that execute immediately
    BOOL errsw = FALSE;
    
    if (rc)
    {
      printf("DECnet %s call failed at WIN32 level, error: %u\n",cmdname,rc);
      errsw = TRUE;
    }
    if (iocbp->io_status)
    {
      printf("    DECnet %s call failed at DECnet level.   ",cmdname);
      if (iocbp->io_status == IOCB_ERROR)
        printf("Errno: %u\n",iocbp->io_errno);
      else if (iocbp->io_status == IOCB_PENDING)
        printf("    Synchronous Call is Pending. - Error!\n");
      errsw = TRUE;
    }
    if (errsw && exitsw)
      ExitThread(1);  // terminate thread; do not return
}

/*************************************************************************/

VOID cleanup (VOID)  // cleanup the mess left by the second thread
{  // called by main thread
    NIOCB iocb2;  // note that we MUST use a different iocb
    
    if (listen_socket)
    {
        iocb2.io_seal = IOCB_SEAL;
        iocb2.io_flags = MSG_NIOCB | MSG_USRWAIT;
        iocb2.io_callback = NULL;
        iocb2.io_fcode = PRU_DETACH;
        iocb2.io_status = iocb2.io_errno = iocb2.io_psize = 0;
        iocb2.io_socket = listen_socket;
        rc = IocbSubmit(DECnet_API,&iocb2,0);  // assume this is a sync call
        check_sync_err("DETACH",FALSE,&iocb2);
    }
    if (thread2)
    {
        Sleep(2*1000); // sleep for 2 seconds to allow 2nd thread to finish
        if (thread2)
            TerminateThread(thread2,0);
    }
    if (ols.hEvent)
        CloseHandle(ols.hEvent);
}
