/*  *********************************************************************
    *  PATHWORKS Socket Library						*
    *  									*
    *  function prototypes			File: SKPROTO.H		*
    *									*
    *********************************************************************
    *  Copyright (c) 1985-1995, All Rights Reserved			*
    *  Digital Equipment Corporation, Littleton, MA.			*
    *  									*
    *  This software is furnished under a license and may be used and	*
    *  copied only in accordance with the terms of such license and	*
    *  with the inclusion of the above copyright notice.  This 		*
    *  software or any other copies thereof may not be provided or 	*
    *  otherwise made available to any other person.  No title to	*
    *  or ownership of the software is hereby transferred.		*
    *  									*
    *  The information in this software is subject to change without	*
    *  notice and should not be constured as a commitment by 		*
    *  Digital Equipment Corporation.					*
    *  									*
    *  Digital assumes no responsiblity for the use or reliability	*
    *  of its software on equipment which is not supplied by Digital.	*
    ********************************************************************* */


#ifndef SKPROTO_H
    #define SKPROTO_H

#include <sktypes.h>
#include <skdefs.h>
#include <iocb.h>

#ifdef __cplusplus
extern "C"
{
#endif

/* Core Socket library functions */
short PW_APIENTRY SktInstallCheck(short);
PW_APIENTRY SktSubmitIOCB(short,NIOCB FAR *);
short PW_APIENTRY SktGetTransport(unsigned short,short FAR *);
PW_APIENTRY SktAccept(short,void FAR *, int FAR *,short FAR *);
PW_APIENTRY SktBind(short, CONST void FAR *, int, short FAR *);
PW_APIENTRY SktConnect(short, void FAR *, unsigned int, short FAR *);
PW_APIENTRY SktGetPeerName(short,void FAR *, int FAR *,short FAR *);
PW_APIENTRY SktGetSockName(short,void FAR *, int FAR *,short FAR *);
PW_APIENTRY SktListen(short,unsigned short,short FAR *);
PW_APIENTRY SktRecv(short,unsigned char FAR *,unsigned int,unsigned short,short FAR *);
PW_APIENTRY SktSRead(short,unsigned char FAR *,unsigned int,short FAR *);
PW_APIENTRY SktSClose(short,short FAR *);
PW_APIENTRY SktSelect(short, unsigned char FAR *, unsigned char FAR *,
                    unsigned char FAR *, struct timeval FAR *, short FAR *);
PW_APIENTRY SktSend(short,unsigned char FAR *,unsigned int,unsigned short,short FAR *);
PW_APIENTRY SktSWrite(short,unsigned char FAR *,unsigned int,short FAR *);
PW_APIENTRY SktSetSockOpt(short,unsigned short,unsigned short, CONST void FAR *,
    unsigned int, short FAR *);
PW_APIENTRY SktGetSockOpt(short, unsigned short, unsigned short, void FAR *, 
    int FAR *, short FAR *);
PW_APIENTRY SktShutdown(short,unsigned short,short FAR *);
PW_APIENTRY SktSIOCtl(short,unsigned short,void FAR *,short FAR *);
PW_APIENTRY SktSocket(short,unsigned short,unsigned short,short FAR *); 

PW_APIENTRY Sktpwfunc(void FAR *, char FAR *, int FAR *);

#if defined(__HIGHC__) || defined(PROT386)
	short PW_APIENTRY SktSetPollFunc(short, unsigned long);
#else
	short PW_APIENTRY SktSetPollFunc(short, int (FAR PASCAL *)(NIOCB FAR *));
#endif

/* DECnet library */
#ifdef IOCB_INCL_DN
    PW_APIENTRY SktDnetErrConvert(unsigned int);
    PW_APIENTRY SktGetNodeName(char FAR *, int);
    PW_APIENTRY SktDnetGetAcc(struct dnet_accent FAR *, struct dnet_accent FAR FAR *);
    PW_APIENTRY SktDnetAddr(char FAR *, struct dn_naddr FAR *);
    PW_APIENTRY SktDnetGetAlias(char FAR *, char FAR *, int);
    PW_APIENTRY SktDnetConn(char FAR *, char FAR *, int, unsigned char FAR *, 
        int, unsigned char FAR *, int FAR *, unsigned short,
    #ifdef	__HIGHC__
    	unsigned long,
    #else
    	int (FAR PASCAL *)(NIOCB FAR *),
    #endif
    	int (FAR PASCAL *)(void FAR *, char FAR *, int FAR *), short FAR *);
    PW_APIENTRY SktDnetEOF(short);
    PW_APIENTRY SktDnetHtoA(struct dn_naddr FAR *, char FAR *, int);
    PW_APIENTRY SktDnetNtoA(struct dn_naddr FAR *, char FAR *, int);
    PW_APIENTRY SktDnetOtoA(struct sockaddr_dn FAR *, char FAR *, int);
    PW_APIENTRY SktDnetPath(char FAR *,char FAR *, int);

    PW_APIENTRY SktGetNodeByAddr(unsigned long FAR *, unsigned char FAR *, 
            short, short, struct nodeent_f FAR *);
    PW_APIENTRY SktGetNodeByName(unsigned long FAR *, char FAR *, 
            struct nodeent_f FAR *);
    PW_APIENTRY SktGetNodeEnt(unsigned long FAR *, struct nodeent_f FAR *);
    PW_APIENTRY SktSetNodeEnt(unsigned long FAR *, short);
    PW_APIENTRY SktEndNodeEnt(unsigned long FAR *);
    PW_APIENTRY SktGetNodeAdd(struct dn_naddr FAR *);

    PW_APIENTRY SktDnetNError(int);
    PW_APIENTRY SktNError(short,char FAR *,char FAR *, int);
#endif

/* TCP/IP support library */
#ifdef IOCB_INCL_IN
    PW_APIENTRY SktSendto(short, unsigned char FAR *, unsigned int, unsigned int,
    		unsigned char FAR *, unsigned int, short FAR *);
    PW_APIENTRY SktRecvfrom(short, unsigned char FAR *, unsigned int,
    		unsigned int, unsigned char FAR *, int FAR*, short FAR *);
    PW_APIENTRY SktHtons(short ,unsigned short FAR *,short FAR *);
    PW_APIENTRY SktHtonl(unsigned long ,unsigned long FAR *,short FAR *);
    PW_APIENTRY SktNtohs(short ,unsigned short FAR *,short FAR *);
    PW_APIENTRY SktNtohl(unsigned long ,unsigned long FAR *,short FAR *);

    PW_APIENTRY SktInetMakeAddr(unsigned long FAR *, unsigned long FAR *,
    			struct in_addr FAR *, short FAR *);
    PW_APIENTRY SktInetNtoA(struct in_addr FAR *, char FAR *, short FAR *);
    PW_APIENTRY SktInetAddr(CONST char FAR *, unsigned long FAR *, short FAR *);
    PW_APIENTRY SktInetNetwork(CONST char FAR *,unsigned long FAR *,short FAR *);
    PW_APIENTRY SktInetLnaof(struct in_addr FAR *,unsigned long FAR *,short FAR *);
    PW_APIENTRY SktInetNetof(struct in_addr FAR *,unsigned long FAR *,short FAR *);

    PW_APIENTRY SktSetNetEnt(short ,short FAR *);
    PW_APIENTRY SktEndNetEnt(short FAR *);
    PW_APIENTRY SktGetNetEnt(struct netent FAR *,short FAR *);

    PW_APIENTRY SktSetProtoEnt(short,short FAR *);
    PW_APIENTRY SktEndProtoEnt(short FAR *);
    PW_APIENTRY SktGetProtoEnt(struct protoent FAR *,short FAR *);

    PW_APIENTRY SktSetServEnt(short ,short FAR *);
    PW_APIENTRY SktEndServEnt(short FAR *);
    PW_APIENTRY SktGetServEnt(struct servent FAR *,short FAR *);

    PW_APIENTRY SktSetHostEnt(short ,short FAR *);
    PW_APIENTRY SktEndHostEnt(short FAR *);
    PW_APIENTRY SktGetHostEnt(struct hostent FAR *,short FAR *);

    PW_APIENTRY SktGetHostByName(CONST char FAR *, struct hostent FAR *, short FAR *);
    PW_APIENTRY SktGetHostByAddr(CONST char FAR *, short , short , struct hostent FAR *, short FAR *);
    PW_APIENTRY SktGetServByName(CONST char FAR *, CONST char FAR *,struct servent FAR *, short FAR *);
    PW_APIENTRY SktGetServByPort(short , CONST char FAR *,struct servent FAR *, short FAR *);

    PW_APIENTRY SktGetHostName(char FAR *, short, short FAR *);
    PW_APIENTRY SktGetNetByName(char FAR *,struct netent FAR *,short FAR *);
    PW_APIENTRY SktGetNetByAddr(unsigned long,short,struct netent FAR *,short FAR *);
    PW_APIENTRY SktGetProtoByName(CONST char FAR *,struct protoent FAR *,short FAR *);
    PW_APIENTRY SktGetProtoByNumber(short,struct protoent FAR *,short FAR *);
    PW_APIENTRY SktGetLocalIPAddress(struct in_addr FAR *, short FAR *);
    PW_APIENTRY SktGetNetFiles(char FAR *, short, short FAR *);
    PW_APIENTRY SktGetUsername(char FAR *, short, short FAR *);
#endif

/* Internal routines.  Use at your own risk.
 *
 * *** NOTE TO APPLICATION DEVELOPERS: ***
 *
 * DO NOT EVER CALL ANY ROUTINE WHOSE NAME STARTS WITH "ISkt".
 * It is GUARANTEED that the "ISkt" interface will change over time.
 * It is NOT SUPPORTED.  Also, they are not tested as well as the
 * documented, supported routines.
 */
PW_APIENTRY ISktStrlen(CONST char FAR *);
PW_APIENTRY ISktStrcat(char FAR *, CONST char FAR *);
PW_APIENTRY ISktStrcpy(char FAR *, CONST char FAR *);
PW_APIENTRY ISktStrncpy(char FAR *, CONST char FAR *, int);
PW_APIENTRY ISktStricmp(CONST char FAR *, CONST char FAR *);
PW_APIENTRY ISktStrnicmp(CONST char FAR *, CONST char FAR *, int);
PW_APIENTRY ISktStrcmp(CONST char FAR *, CONST char FAR *);
char  FAR * PW_APIENTRY ISktStrpbrk(CONST char FAR *, char FAR *);
PW_APIENTRY ISktItoA(unsigned short, char FAR *);
PW_APIENTRY ISktAtoI(CONST char FAR *);
void  PW_APIENTRY ISktmemset(void FAR *, unsigned char, unsigned int);
void  PW_APIENTRY ISktmemcpy(void FAR *, CONST void FAR *, unsigned int);
PW_APIENTRY ISktmemcmp(CONST void FAR *, CONST void FAR *, unsigned int);

#ifndef WIN32
    short PW_APIENTRY ISktHOpen(char FAR *, short);
    PW_APIENTRY ISktHClose(short);
    PW_APIENTRY ISktHRead(short, void FAR *, int);
    PW_APIENTRY ISktHGets(char FAR *,short, int);
    PW_APIENTRY ISktHWrite(short, void FAR *, int);
    PW_APIENTRY ISktHSeek(short, long, short);
    short PW_APIENTRY ISktDosGetenv(char FAR *, char FAR *);
    void  FAR *       ISktDosGetMasterEnvironment(void);
    #if	!defined(PROT386)
        short FAR * PW_APIENTRY ISktDosGetVect(unsigned char);
    #else
        char _far * ISktDosGetVect(unsigned char);
    #endif
#endif

#ifdef IOCB_INCL_DN
    PW_APIENTRY ISktDnetCrypt(unsigned char FAR *, int);
#endif

#ifdef IOCB_INCL_IN
    short PW_APIENTRY GetTcpipOpt(char FAR *,char FAR *,char FAR *);
#endif

/*
 * Note: These routines are even less supported than the others.
 */
short PW_APIENTRY ISkttrans_famtable(short );
short PW_APIENTRY ISkttrans_typtable(short );
short PW_APIENTRY ISkttrans_protable(short );
short PW_APIENTRY ISkttrans_mpxtable(short );
short PW_APIENTRY ISktGetTransMap(short );
void  PW_APIENTRY ISktSetTransMap(short, short );
void  PW_APIENTRY ISktInitTransMap(void );
short PW_APIENTRY ISktFirstSockNum(void );
short PW_APIENTRY ISktGetRealModeVector(unsigned char, unsigned short FAR *, unsigned short FAR *);
short PW_APIENTRY srmi(unsigned char, unsigned short, unsigned short, unsigned short );
short PW_APIENTRY ISktGetNewNum(unsigned short , unsigned short, unsigned short, unsigned short, short FAR *);
unsigned short PW_APIENTRY ISktConvertToSelector(unsigned short, unsigned short);

#ifdef __cplusplus
}
#endif
 
#endif  
