/*  *********************************************************************
    *  PATHWORKS Socket Library						*
    *  									*
    *  DECnet-specific IOCB definitions		File: IOCB_DN.H		*
    *									*
    *********************************************************************
    *  Copyright (c) 1985-1992, All Rights Reserved			*
    *  Digital Equipment Corporation, Littleton, MA.			*
    *  									*
    *  This software is furnished under a license and may be used and	*
    *  copied only in accordance with the terms of such license and	*
    *  with the inclusion of the above copyright notice.  This 		*
    *  software or any other copies thereof may not be provided or 	*
    *  otherwise made available to any other person.  No title to	*
    *  or ownership of the software is hereby transferred.		*
    *  									*
    *  The information in this software is subject to change without	*
    *  notice and should not be constured as a commitment by 		*
    *  Digital Equipment Corporation.					*
    *  									*
    *  Digital assumes no responsiblity for the use or reliability	*
    *  of its software on equipment which is not supplied by Digital.	*
    ********************************************************************* */

#ifndef IOCB_DN_H
#define IOCB_DN_H

/*
 * DECnet local node information data structure
 */
typedef struct	localinfo_dn
{
	unsigned char	lcl_version[3]; 	/* Version number of DNP */
	unsigned char	lcl_nodename[7];	/* Node name */
	unsigned short	lcl_nodeaddr;		/* Node address */
	unsigned short  lcl_segsize;		/* Segment size */
	unsigned char	lcl_sockets;		/* Available sockets */
	unsigned char	lcl_decnet_device; 	/* DECnet database device  */
    exptr          lcl_decnet_path;        /* DECnet data base path */
} LOCALINFO_DN;

/*
 * DECnet select() data structure for socket mask I/O examination
 */
typedef struct  select_dn
{
	unsigned short sel_nfds;	    /* Number of handles to select  */
	unsigned long  sel_read;	    /* Read handles mask */
	unsigned long  sel_write;	    /* Write handles mask */
	unsigned long  sel_except;	    /* Exception handles mask */
	unsigned short sel_seconds;	    /* Timeout value */
} SELECT_DN;

typedef struct  select2_dn          /* extended select for 63 sockets */
{
	unsigned short sel2_nfds;	    /* Number of handles to select  */
	unsigned char  sel2_read[8];	    /* Read handles mask */
	unsigned char  sel2_write[8];	    /* Write handles mask */
	unsigned char  sel2_except[8];	    /* Exception handles mask */
	unsigned short sel2_seconds;	    /* Timeout value */
} SELECT2_DN;

typedef struct  select64_dn          /* extended select for 63 sockets */
{
	unsigned short sel64_nfds;	    /* Number of handles to select  */
	unsigned char  sel64_read[8];	    /* Read handles mask */
	unsigned char  sel64_write[8];	    /* Write handles mask */
	unsigned char  sel64_except[8];	    /* Exception handles mask */
	unsigned short sel64_seconds;	    /* Timeout value */
} SELECT64_DN;

typedef struct  select256_dn          /* extended select for 255 sockets */
{
	unsigned short sel256_nfds;	    /* Number of handles to select  */
	unsigned char  sel256_read[32];	    /* Read handles mask */
	unsigned char  sel256_write[32];	    /* Write handles mask */
	unsigned char  sel256_except[32];	    /* Exception handles mask */
	unsigned short sel256_seconds;	    /* Timeout value */
} SELECT256_DN;


/*
 * DECnet - shutdown function parameter list
 */
typedef struct	shutdown_dn
{
	unsigned short shd_how;	/* Type of shutdown */
} SHUTDOWN_DN;

/*
 * DECnet - Attach function parameter list data structure
 */			 
typedef struct	attach_dn
{		
        short   att_socket;             /* If non-zero, rest of members
                                         *  ignored and 'att_socket' socket's
                                         *  attributes are used for this attach,
                                         *  ie: accept function request
					 */
	unsigned short att_domain;	/* Domain */
	unsigned short att_type;	/* Communications type */
	unsigned short att_protocol;	/* Protocol */
        unsigned short att_srp;         /* Socket recovery period */
	unsigned short att_supreq;	/* Support requirements */
} ATTACH_DN;   

/*
 * DECnet - Listen function parameter list data structure
 */
typedef struct	listen_dn
{
	short	lsn_backlog;	/* Maximum backlog on incoming connects */
} LISTEN_DN;

/*
 * DECnet - Socket I/O control function parameter list data structure
 */									    
typedef struct	sioctl_dn
{
	short	sio_s;		    /* Socket */
	short	sio_request;	    /* Type of socket I/O request */
       /*
	* Long pointer to argument list
	*	long => (lo word)offset:(hi word)segment
        */
	exptr 	sio_argp;	   /* Points to argument list */
} SIOCTL_DN;

/*
 * DECnet - Set/Getsockopt function parameter list data structure
 */				       
typedef struct  sockopt_dn
{		       
	short	sop_level;	/* Socket option level */
	short	sop_optname;	/* Socket option name */	     
       /* 
	* If sop_level = SOL_SOCKET, then rest of structure is null
	* Else if sop_level = DNPROTO_NSP, then 
	*	depending upon value of sop_optname,
	*	sop_optval may be a long pointer to either an accessdata_dn or
	*	optdata_dn structure, or a 1 byte array containing access mode
	*
        */
	exptr 	sop_optval;	/* Socket option value */
       /*
	* For getsockopt(), sop_optlen is an address of int type to place
	* a returned option value length
	*
        */
	long sop_optlen;	/* Socket option length */
} SOCKOPT_DN;


/*
 * Send/Recv Buffer Descriptor structure
 *
 *  Note: first element must overlap old io_buffer pointer 
 */ 
typedef struct  buffer_dn
{
    exptr           io_buffer;      /* pointer to user buffer */
    unsigned short   io_buflen;      /* length of user buffer */
} BUFFER_DN;

#endif	/* IOCB_DN_H */

