/*
***********************************************************************
*  NEWDNP - DECnet network process                                    *
*                                                                     *
*  DEC NETBIOS extension definitions          File: DSCB.ASH          *
*                                                                     *
*  Authors:               					      *
*           				                              *
*                                                                     *
*  This file contains definitions for DEC NETBIOS extensions          *
***********************************************************************
*  Copyright (c) 1990 by Digital Equipment Corporation                *
*  All Rights Reserved.                                               *
*                                                                     *
*  This software is furnished under a license and may be used and     *
*  copied only in accordance with the terms of such license and with  *
*  the inclusion of the above copyright notice.  This software or     *
*  any other copies thereof may not be provided or otherwise made     *
*  available to any other person.  No title to and ownership of the   *
*  software is hereby transferred.                                    *
*                                                                     *
*  The information in this software is subject to change without      *
*  notice and should not be construed as a commitment by DIGITAL      *
*  Equipment Corporation.                                             *
*  DIGITAL assumes no responsibility for the use or reliability       *
*  of its software on equipment which is not supplied by DIGITAL.     *
***********************************************************************
*                                                                     *
*  Revision History:                                                  *
*                                                                     *
***********************************************************************
*/

/*
***********************************************************************
*  MS-net table structures                                            *
***********************************************************************
*/

#define MS_INUSE	0x0001	  // marks this entry as inuse
#define MS_PERMANENT	0x0002	  // permanent entry, do not reuse
#define MS_TTLMIN       (24*60)   // Lifetime of cached wanq response in mins

typedef struct _msnode_struc
{
   word ms_flags;		  // node name flags
   word ms_timer;		  // timer cell
   byte ms_name[16];              // ASCIZ node name
   byte ms_addr[2];		  // DECnet Phase IV node address
} MSNODE;


//
//  DECnet access info structure  -- it is no accident that this looks just
//  like accessdata_dn!
//

typedef struct _ainfo_struc
{
   word ai_acclen;		// length of account name
   byte ai_account[40];		// asciz account name
   word ai_passlen;		// password length
   byte ai_password[40];	// asciz password
   word ai_userlen;		// username length
   byte ai_username[40];	// asciz username
} AINFO;


typedef struct _ra_struc 
{
   byte ra_name[16];            // remote adapter name
   word ra_objtype;             // object number
   byte ra_addr[2];             // node address
   AINFO ra_access;             // NOTE: size of accessdata_dn
} RA;


//
//  DEC Session Control Block (DSCB)
//

//
//  This part of the DSCB structure is repeated after the DSCB itself
//  when the "read all remote" command is used.
//

typedef struct _dscb_remname {
   byte dscb_name[16];    	// adapter name
   byte dscb_num[2];          	// DECnet node address
   byte dscb_objtype;     	// object type
   word dscb_acc_len;      	// account length
   byte dscb_acc[40];     	// account name
   word dscb_pass_len;    	// password length
   byte dscb_pass[40];    	// password
   word dscb_user_len;		// user name length
   byte dscb_user[40];    	// user name
} DSCB_REMOTE_NAME;

//
// The union in the structure below allows us to access the structure
// using normal fields for most of the commands.  the "Read All Remote"
// command duplicates the DSCB_REMOTE_NAME record over and over
// after the dscb itself, hence the extra structure.
//

typedef struct _dscb_struc
{
   byte dscb_cmd;     			// command code
   byte dscb_err;           		// return code
   byte dscb_index;     	   	// index into table
   union {
       DSCB_REMOTE_NAME dscb_rname; 	// Remote name as a structure
       struct {				// Same remote name as individual fields
	   byte dscb_name[16];    	// adapter name
	   byte dscb_num[2];          	// DECnet node address
	   byte dscb_objtype;     	// object type
	   word dscb_acc_len;      	// account length
	   byte dscb_acc[40];     	// account name
	   word dscb_pass_len;    	// password length
	   byte dscb_pass[40];    	// password
	   word dscb_user_len;		// user name length
	   byte dscb_user[40];    	// user name
	   };
       };
} DSCB;

// ***********************************************************************
// *  Constants                                                          *
// ***********************************************************************


//
//  DSCB command constants
//

#define DSCB_INSTCHK	0x00	// install check
#define DSCB_ADDENTRY	0x01    // add ms-net node
#define DSCB_DELBYNUM	0x02    // delete ms-net node by number
#define DSCB_DELBYNAME	0x03    // delete ms-net node by name
#define DSCB_READBYNUM	0x04    // read ms-net node by number
#define DSCB_READBYNAME	0x05    // read ms-net node by name
#define DSCB_READBYIDX	0x06    // read ms-net node by index
#define DSCB_DELALL	0x07    // delete all ms-net nodes
#define DSCB_ADDREMADAP	0x21    // add remote adapter
#define DSCB_DELREMADAP	0x22    // delete remote adapter
#define DSCB_READREMNAM	0x23    // read remote adapter by name
#define DSCB_READREMSIZ	0x24    // read remote adapter tbl size
#define DSCB_READALLREM	0x25    // read all remote adapters
#define DSCB_DELALLREM	0x26    // delete all remote adapters

#define DSCBERR_REMFULL	1       // remote adapter table full
#define DSCBERR_DUPLNAM	2       // duplicate name in table
#define DSCBERR_DUPLNUM	3       // duplicate number
#define DSCBERR_NONAME	4       // name not found
#define DSCBERR_NONUM	5       // number not found
#define DSCBERR_BADIDX	6       // bad index value
#define DSCBERR_IDXOVER	7       // index out of range
#define DSCBERR_INVCMD	8       // invalid command
#define DSCBERR_NORESRC	9       // no resources
#define DSCBERR_NOOWN	10      // can't delete own node
#define DSCBERR_INVBLEN	11      // buffer len too small
#define DSCBERR_NOREM	12      // no remote adapter table



