/*  *********************************************************************
    *  PATHWORKS WinSock Library					*
    *  									*
    *  WinSock DECnet/PATHWORKS specific stuff	File: DWINSOCK.H	*
    *									*
    *********************************************************************
    *  Copyright (c) 1985-1994, All Rights Reserved			*
    *  Digital Equipment Corporation, Littleton, MA.			*
    *  									*
    *  This software is furnished under a license and may be used and	*
    *  copied only in accordance with the terms of such license and	*
    *  with the inclusion of the above copyright notice.  This 		*
    *  software or any other copies thereof may not be provided or 	*
    *  otherwise made available to any other person.  No title to	*
    *  or ownership of the software is hereby transferred.		*
    *  									*
    *  The information in this software is subject to change without	*
    *  notice and should not be constured as a commitment by 		*
    *  Digital Equipment Corporation.					*
    *  									*
    *  Digital assumes no responsiblity for the use or reliability	*
    *  of its software on equipment which is not supplied by Digital.	*
    ********************************************************************* */

/*
 *	Edit History:
 *
 *		When		Who	What
 *		-------------------------------------------------------------
 *		10/6/93		sar	V5.0.015: Added init_aliases calls
 *					to database routines.
 *		10/11/93	sar	V5.0.016: Added support for FD_CLOSE
 *					notification.
 *		10/12/93	sar	V5.0.017: Added checks for blocking
 *					calls in progress, changed the order
 *					of the blocking loops.
 *		10/19/93	sar	V5.0.018: Added SKT_EMSGSIZE.
 *					Also several QAR fixes from
 *					Mike Cheng.
 *		10/22/93	sar	V5.0.019: change free_task_id to call
 *					SktSClose directly, instead of
 *					calling closesocket().
 *		10/22/93	sar	V5.0.020: Modified debug code in
 *					WSDEBUG.C.  Made code that
 *					returns HOST_NOT_FOUND return the
 *					correct WINSOCK value (11001).
 *		10/26/93	sar	V5.0.021: link against a new socket
 *					lib; make more fixes to debug code;
 *					init ALL pointers in static structures
 *					that are returned by the database
 *					routines.
 *		10/26/93	sar	V5.0.022: WSAAsyncSelect now makes
 *					sockets non-blocking.
 *					Added SKT_NO_DATA.  Fixed the Async
 *					getXbyY routines.
 *		11/03/93	sar	V5.0.023: Lots of misc fixes.
 *		11/04/93	sar	V5.0.024: accept() parameter
 *					validation, socket renumbering.
 *					V5.0.025: if SktGetTransport can't
 *					find a transport for a socket,
 *					the error returned should be
 *					WSAENOTSOCK, not WSAENOTINITIALISED.
 *					Made changes to accept, recv,
 *					recvfrom, send, sendto.
 *		11/09/93	sar	V5.0.026: WSACleanup() must check
 *					for blocking calls in progress.
 *		11/10/93	sar	V5.0.027: select() is cancellable;
 *					asyncgetXbyY return correct error #;
 *					select checks for valid sockets
 *					passed in; lots of misc fixes.
 *		11/15/93	sar	V5.0.028: select and WSAAsyncSelect
 *					now support 64 sockets.
 *		11/17/93	sar	V5.0.029: added SKT_EPIPE.  SEND
 *					now maps SKT_EPIPE to WSAECONNABORTED
 *					because winsock send will never return
 *					EPIPE.
 *		11/19/93	sar	V5.0.030: Change in connect.
 *		11/19/93	sar	V5.0.031: accept() calls new routine
 *					in socket lib to renumber socket.
 *		11/19/93	sar	V5.0.032: FD_CONNECT processing in
 *					WSAAsyncSelect got more complicated.
 *		11/23/93	sar	V5.0.033: Fix minor bug in async
 *					getXbyY routines.
 *		12/01/93	sar	V5.0.034: BL10 version.
 *		01/26/94	sar	V5.0.035: Forte fix (create a window
 *					to use in call to SetTimer in
 *					WSAStartup)
 *		02/23/94	fcl     V5.0.036: Fix alleged "not release 
 *					memory" bug for PC_SNMP's eventd. 
 *					The real bug is eventd did not get
 *					WM_QUIT to get out the message loop.
 *					The bug is fixed in select()
 *					by checking if operation cancelled 
 *					everytime before peek and dispatch 
 *					a message in BlockingHook(). 
 *		03/15/94	fcl	warned user about they may not have
 *					pwwsock.exe
 *		03/15/94	fcl	check if operation completed every
 *					time before we call BlockingHook().
 *		03/18/94	fcl	Add warning if winexec pwwsock.exe 
 *					failed.
 *		03/23/94	fcl	reset WinSockTimerID when timer is
 *					killed.
 *		03/24/94	fcl	039: add third param to canceliocb().
 *
 *		04/11/93	fcl	040: add sweepcount concept to increase
 *					the async performance.
 *      05/24/94    DEK 041: changed AF_DECnet to SKT_AF_DECnet in wsbind().
 *      06/24/94    DEK 042: more parameter checks in recv and send.
 *      07/21/94    DEK 043: added IsInQ() check in wsioctls() to determine if
 *                  socket is Async queue before setting blocking with FIONBIO.
 *      08/09/94    clb 044:   clear tv.tv_usec before SktSelect() in wstimer.c
 *      08/10/94    fcl 045:   check for EPIPE one more time in wsrecv.c
 *      08-15-94    clb 046:   zero out inputbuf for gethostbyaddr DNR
 *  24-oct-1994     clb 047: add SIOCtl to recv() to catch partial reads
 *      22-nov-1994 clb 048: cleanup sockets in WEP()
 *      29-nov-94   lwp 048: check SKT_EPIPE after SktSubmitIOCB in recvfrom();
 *                           also avoid add WSABASEERR to LastError when it's zero
 *                           in WSAGetLastError().
 *      20-dec-1994 clb 049: increase MAX_HOOKS from 16 to 64
 *      21-dec-1994 clb 050: Pass V1.50 to trigger DECnet support (for 32-bit)
 *      01-mar-1995 clb 051: Clear MSG_USRWAIT on non-blocking IO
 *      14-mar-1995 clb 052: fix typo  &argp -> *argp
 *      30-mar-1995 lwp 053: CLD cfs.23985, don't send FD_CLOSE on listening socket.
 *      10-may-1995 clb 054: Clear high-order bytes of *argp for ioctlsocket()
 *      26-may-1995 clb 055: Add Yield() to DefaultBlockingHook()
 *      28-jun-1995 clb 056: Fix return from WSAIsBlocking(), FIONBIO
 *      05-sep-1995 clb 057: No DECnet OOB
 *      14-sep-1995 clb 058: Truncate overlong sockaddr length for bind
 *      20-sep-1995 lwp 059: put in 3 fixes for 3 clds, volvo, devetir and southwest,
 *									  cld 26975, 29326, 32777.
 */
#ifndef	DEC_WINSOCK_H
#define	DEC_WINSOCK_H

#define	DECWSAVersion		0x0101
#define	DECWSADescription	"DEC PATHWORKS WinSock DLL Version 6.0.059:"

/* Some constants from our include files that have the same names as
 *	winsock-defined constants, but with different values.
 *	So, we give them different names.  This will cause a problem if
 *	the values in the regular socket library change.  Most of these
 *	are unlikely to change though.
 */

#define	SKT_ERROR		-1	// Error returned from SktSubmitIOCB
#define	SKT_EBADF		9
#define	SKT_EBUSY		16
#define	SKT_EPIPE		32
#define	SKT_EWOULDBLOCK		35
#define	SKT_EINPROGRESS		36
#define	SKT_EDESTADDRREQ	39
#define	SKT_EMSGSIZE		40

#define	SKT_FIONREAD	1	// Get number of bytes to read
#define SKT_FIONBIO	2	// Toggle socket blocking/nonblocking i/o
#define SKT_FIONASYNC	3	// Set socket to asynch - not implemented
#define SKT_FIORENUM	4	// change a socket's assigned number

#define	SKT_AF_DECnet	1

#define	SKT_HOST_NOT_FOUND	1
#define SKT_NO_DATA             4

#define	_SKDEFS_
#define	IOCB_H
#include <sktypes.h>
#undef	_SKDEFS_
#include <ws_iocb.h>
#include <skproto.h>

#include <memory.h>

#define	WSANOTINITIALIZED	WSANOTINITIALISED

/*
 * Some stuff from OUR socket.h not included in the WINSOCK.H file.
 *+
 */

/*
 *  Transport selectors
 */

#define TSEL_DECNET	0
#define TSEL_TCPIP	1
#define TSEL_OSI	2

/*
 * Protocol types.
 */

#define PF_RAW		1		/* DLX data */
#define PF_MOP		2		/* DLX MOP data */

#define MSG_ASYNC	0x0008		/* perform function asynchronously   */
#define MSG_CALLBACK	0x0010		/* perform callback		     */
#define MSG_NEOM	0x0020		/* don't do to End of Message	     */
#define MSG_NBOM	0x0040		/* don't set Beginning of Message    */
#define MSG_NIOCB       0x0080          /* new IOCB format                   */
#define MSG_USRBUF      0x0100          /* use user buffer for data          */
#define MSG_USRWAIT     0x0200          /* don't spin in DNP                 */
#define MSG_TASKSWITCH  0x2000          /* allow task switch                 */

#define	MSG_MAXIOVLEN	16
/*
 * End of stuff from our socket.h
 *-
 */
#ifdef	BLD_WS	/* means "BuiLDing WinSock" */
	#define	DECPW_WS	DECWSADescription
#endif
#ifdef	BLD_WS	/* means "BuiLDing WinSock" */

#define	AFtoTSEL(af)	(af - 1)	/* Converts address family to tsel */
#define	TSELtoAF(tsel)	(tsel+1)	/* Converts tsel to address family */

extern	int PASCAL FAR winsock_is_init(void );
extern	BOOL	operation_cancelled(void );
extern	BOOL	operation_complete(NIOCB *);
extern	BOOL	blocking_call_in_progress(void);
extern	int far pascal BlockingHook(void);
extern	void	set_opcan(void);
extern	void	reset_opcan(void);
extern	void	canceliocb(NIOCB FAR *, short, short);
extern	void	set_bcip(void);
extern	void	clear_bcip(void);
extern	BOOL	pending_select(SOCKET, long);
extern	void	re_enable_select(SOCKET, long);
extern	int	find_task(void);
extern	int	alloc_task_id(void);
extern	int	free_task_id(HTASK );
extern  void set_nonblk_skt(SOCKET);
extern  void clear_nonblk_skt(SOCKET);
extern  BOOL test_nonblk_skt(SOCKET);
#endif

#include <dn.h>
#include <dnetdb.h>

#ifdef	BLD_WS	/* means "BuiLDing WinSock" */

#if	defined(WSDBG_ERR) || defined(WSDBG_ALL)
extern void far pascal	WSD_ERROR(char *, char *);
#else
#define	WSD_ERROR(s1, s2)
#endif

#if	defined(WSDBG_ENTRY) || defined(WSDBG_ALL)
extern void far pascal	WSD_ENTRY(char *);
#else
#define	WSD_ENTRY(s)
#endif

#if	defined(WSDBG_SUCCESS) || defined(WSDBG_ALL)
extern void far pascal	WSD_SUCCESS(char *);
#else
#define	WSD_SUCCESS(s)
#endif

#if	defined(WSDBG_NYI) || defined(WSDBG_ALL)
extern void far pascal	WSD_NYI(char *);
#else
#define	WSD_NYI(s)
#endif

#endif



#endif	/* DEC_WINSOCK_H */

