;	LOADER FOR CP/M ON CORVUS DISC
;	   VERSION 1.4S/TT (S100/TRS80 II VERSION)
;
; THIS PROGRAM LOADS THE 1 SECTOR CP/M BOOT LOADER FROM DISC
; AND RUNS IT TO BOOT IN CP/M.  IN THIS WAY, THIS LOADER IS
; INDEPENDENT OF THE SIZE OF CP/M.
;
; THIS PROGRAM MAY BE PUT IN ROM OR LOADED FROM FLOPPY OR CASSETTE
; (EVEN PAPER TAPE).  THE EQUATES ARE NOW SET UP SO THAT IT
; MAY BE LOADED UNDER CP/M.
;
;$I CRVSYS.S		; SYSTEM EQUATES
;	----	S100/TRS80 II9 PORT ADDRESSES & MASKS	----
;
STAT	EQU	0DFH	; STATUS I/O PORT
DATA	EQU	0DEH	; DATA I/O PORT
DRDY	EQU	1	; MASK FOR DRIVE READY BIT
DRDYST	EQU	0	; IF BIT 0 = 0 THEN DRIVE READY
DIFAC	EQU	2	; MASK FOR DRIVE ACTIVE BIT
HTD	EQU	2	; IF BIT 1 SET THEN HOST-TO-DRIVE STATUS
DTH	EQU	0	; IF BIT 1 = 0 THEN DRIVE-TO-HOST
;
;
;
;$I CLOADR.BDY		; MAIN BODY OF CLOADR
;
RDCOM	EQU	12H	; READ COMMAND (VERS. 1 CCODE)
SSIZE	EQU	128	; SECTOR SIZE (IN BYTES)
;
BDRIVE	EQU	1	; DRIVE # TO BOOT FROM
BSEC	EQU	12	; DISC ADDRESS TO BOOT FROM (RESERVE A FEW SEC.)
;
CBOOT	EQU	0	; ORIGIN OF BOOT PROGRAM (THAT WHICH IS LOADED)
;
	ORG	100H	; SET SO IT CAN BE LOADED FROM FLOPPY CP/M
;
READ:	LXI	H,CBOOT	; GET BOOT ADDRESS
	LXI	D,BSEC	; GET BOOT SECTOR ADDRESS
	MVI	A,RDCOM	; GET READ COMMAND
	CALL	WAITO	; SEND IT TO CONTROLLER
	MVI	A,BDRIVE	; GET DRIVE #
	CALL	WAITO
	MOV	A,E	; GET LOW BYTE OF DISC ADDRESS
	CALL	WAITO
	MOV	A,D	; GET UPPER BYTE OF DISC ADDRESS
	CALL	WAITO
	CALL	TURN	; WAIT FOR BUSS TO TURN AROUND
	CALL	WAITI	; READ ERROR CODE
	ANI	80H	; LOOK AT FATAL BIT
	JNZ	START	; IF ERROR, TRY AGAIN
	MVI	B,SSIZE	; GET SECTOR SIZE
	PUSH	H	; SAVE LOAD ADDRESS ON STACK
RLP:	CALL	WAITI	; READ DATA BYTE FROM DISC
	MOV	M,A	; SAVE IT IN MEMORY
	INX	H
	DCR	B
	JNZ	RLP	; LOOP UNTIL DONE
	RET		; JUMP INTO CODE
;
;
;$I CRV.IO		; CORVUS BASIC IO ROUTINES
;FILEID: CRV.IO
;

TURN:				; WAIT FOR DRIVE-TO-HOST STATUS AND
	IN	STAT		; DELAY TILL DATA STABLE
	ANI	DRDY OR DIFAC	; TEST STATUS
	CPI	DRDYST OR DTH	; IS DRIVE READY & DRIVE-TO-HOST
	JNZ	TURN		; IF NOT THEN LOOP
	MVI	B,6		; SET DELAY COUNT
	CALL	DELAY		; GOOD AT 4MHZ ALSO
	RET			;
;
DELAY:	DCR	B
	JNZ	DELAY
	RET
;
WAITI:	IN	STAT	; READ STATUS PORT
	ANI	DRDY OR DIFAC	; LOOK AT STATUS
	CPI	DRDYST OR DTH	; IS DRIVE READY & DRIVE-TO-HOST
	JNZ	WAITI	; LOOP UNTIL READY
	IN	DATA	; READ BYTE FROM DISC
	RET
;
WAITO:	PUSH	PSW	; SAVE COMMAND
	IN	STAT	; READ STATUS PORT
	ANI	DRDY OR DIFAC	; LOOK AT STATUS
	CPI	DRDYST OR HTD	; IS DRIVE READY & HOST-TO-DRIVE
	JNZ	WAITO+1	; LOOP UNTIL READY
	POP	PSW
	OUT	DATA	; WRITE BYTE TO DISC
	RET

;
;$I CRVINIT.IO		; RESYNC CONTROLLER ROUTINE
;FILEID: CRVINIT.IO
;
;
; --- INITIALIZE CONTROLLER ----
;
INIT:	MVI	A,0FFH	; GET AN INVALID COMMAND
	OUT	DATA	; SEND IT TO CONTROLLER
	MVI	B,150	; SET FOR LONG DELAY
	CALL	DELAY
	IN	STAT
	ANI	DRDY OR DIFAC	; LOOK AT DRIVE ACTIVE BIT
	CPI	DRDYST OR DTH	; IS STATUS = READY & DRIVE-TO-HOST
	JNZ	INIT	; LOOP UNTIL DRIVE-TO-HOST
	CALL	WAITI	; GET ERROR CODE
	CPI	8FH	; CHECK RETURN CODE
	JNZ	INIT	; IF NOT RIGHT, TRY AGAIN
	RET

	END
