; CORVUS DISC DRIVERS FOR CP/M 2.0    (BIOS)
;
; 	VERSION 1.22
;	 BY BRK
;
;
;
;$I CRVSYS.S			; SYSTEM EQUATES
;	----	S100/TRS80 II9 PORT ADDRESSES & MASKS	----
;
STAT	EQU	0DFH	; STATUS I/O PORT
DATA	EQU	0DEH	; DATA I/O PORT
DRDY	EQU	1	; MASK FOR DRIVE READY BIT
DRDYST	EQU	0	; IF BIT 0 = 0 THEN DRIVE READY
DIFAC	EQU	2	; MASK FOR DRIVE ACTIVE BIT
HTD	EQU	2	; IF BIT 1 SET THEN HOST-TO-DRIVE STATUS
DTH	EQU	0	; IF BIT 1 = 0 THEN DRIVE-TO-HOST
;
;
;
; ----  CORVUS DISK EQUATES TO BE SET BY USER ----
FIVEMB	EQU	0		; ONLY 1 OF THESE DRIVE DESIGNATOR
TENMB	EQU	1		; MAY BE SET TO 1.
TWNTYMB	EQU	0		;

NPSUDO	EQU	2		; DEFAULT # OF DRIVES TO DIVIDE 
				; DISK INTO
PIPES	EQU	0		; SET TO 1 IF A PIPES AREA IS RESERVED

BLKSZ	EQU	8		; ALLOCATION BLOCK SIZE (DEFAULT ?K)

MSIZE	EQU	20		; CP/M VERSION MEMORY SIZE IN KB
;
DELTA	EQU	0H		; OFFSET FROM STD CP/M SIZE
BIAS	EQU	(MSIZE-20)*1024-DELTA	; OFFSET FROM 20K CP/M
;
;$I BIOSC.BDY		; MAIN BODY OF CORVUS DISK DRIVERS
;FILEID: BIOSC.BDY
;
;
CCP	EQU	3400H+BIAS	; BASE OF CP/M
OFFSET	EQU	980H-CCP	; OFFSET USED WITH  DDT IN
				; SYSTEM CONFIGURATION
BDOS	EQU	CCP+806H	; BASE OF BDOS
BIOS	EQU	CCP+1600H	; BASE OF BIOS
NSEC	EQU	(BIOS-CCP)/128	; # SECTORS TO BOOT
CDISC	EQU	04		; BUFFER LOCATION FOR CURRENT DISC #
IOBYTE	EQU	03		; LOCATION OF INTEL IOBYTE
;
; ----- CORVUS EQUATES ----
;
RDCOM	EQU	12H	; READ COMMAND (VERS. 1 CCODE)
WRCOM	EQU	13H	; WRITE COMMAND (VERS. 1 CCODE)
SSIZE	EQU	128	; SECTOR SIZE (IN BYTES)
BDRIVE	EQU	1	; CORVUS DRIVE # TO BOOT FROM
CSEC	EQU	13	; STARTING DISC ADDRESS FOR CP/M BOOT
;

FMAX	EQU	2		; ALLOW 2 FLOPPY DRIVES
DMAX	EQU	FMAX+NPSUDO	; DETERMINE TOTAL # OF DRIVES


;
	ORG	BIOS
;
;
;  CP/M INTERFACE JUMP TABLE
;
	JMP	BOOT
WBOOTE:	JMP	WBOOT
	JMP	CONST
	JMP	CONIN
	JMP	CONOUT
	JMP	LIST
	JMP	PUNCH
	JMP	READER
	JMP	DHOME
	JMP	SELDSK
	JMP	SETTRK
	JMP	SETSEC
	JMP	SETDMA
	JMP	DREAD
	JMP	DWRIT
	JMP	LISTST	; LIST DEVICE STATUS REQUEST
	JMP	SECTRAN	; SECTOR TRANSLATION ROUTINE
;
; ---- AUXILIARY JUMP TABLE FOR DRIVE SWITCHING ----
;
DHOME:	JMP	HOMEC	; SET TO HOME CORVUS DISC DRIVE
DREAD:	JMP	READC	; SET TO READ FROM CORVUS DRIVE
DWRIT:	JMP	WRITEC	; SET TO WRITE TO CORVUS DRIVE
;
; ---- SECTOR TRANSLATION ROUTINE ----
;
SECTRAN: MOV	A,D	; TEST IF TABLE TRANSLATION IS REQUESTED
	ORA	E
	JNZ	STR1	; YES, SO DO IT
	MOV	L,C	; NO, SO JUST TRANSFER TO (H,L)
	MOV	H,B
	RET
STR1:	XCHG		; GET TABLE ADDRESS IN (H,L)
	DAD	B	; INDEX INTO TABLE
	MOV	L,M	; GET BYTE IN (H,L)
	MVI	H,0
	RET
;
; ---- COLD BOOT STARTUP ----
;
BOOT:	LXI	SP,80H	; SETUP TEMP. STACK
	LXI	H,BMSG	; POINT TO BOOT UP MESSAGE
	CALL	PTMSG	; PRINT IT OUT
	MVI	A,0	; GET CURRENT DISC #
	STA	CDISC	; SAVE IN BUFFER
	MOV	C,A
	CALL	SELDSK	; SELECT IT ALSO ( INITIALIZE BUFFERS)
GOCPM:	MVI	A,0C3H	; GET JUMP INSTRUCTION
	STA	0	; SETUP FOR WARM BOOT
	LXI	H,WBOOTE ; WARM BOOT ENTRY
	SHLD	1	; SET ADDRESS
	STA	5	; SETUP BDOS ENTRY JUMP
	LXI	H,BDOS
	SHLD	6
	LXI	B,80H	; DEFAULT DMA ADDRESS
	CALL	SETDMA
	LDA	CDISC	; GET CURRENT DRIVE #
	MOV	C,A	; SAVE FOR CCP FUNCTION
GOC1:	JMP	CCP	; ENTER CP/M
;
; ---- WARM BOOT STARTUP ROUTINE ----
;
WBOOT:	LXI	SP,80H	; SET STACK
	LXI	H,CCP+3
	SHLD	GOC1+1	; DISABLE AUTO-START
	CALL	INIT	; RESYNC CONTROLLER
;
	MVI	C,NSEC	; GET # SECTORS TO BOOT
	LXI	H,CCP	; GET RAM START ADDRESS OF LOAD
	LXI	D,CSEC	; GET DISC ADDRESS FOR COPY OF CP/M
BT1:	MVI	A,RDCOM	; GET READ COMMAND
	CALL	WAITO	; SEND IT TO CONTROLLER
	MVI	A,BDRIVE ; GET BOOTUP DRIVE # (CORVUS PHYSICAL DRIVE)
	CALL	SET1	; SEND REMAINING COMMANDS
	CALL	RDC1	; READ IN ONE SECTOR
	ORA	A	; TEST FOR ERROR
	JNZ	BERR	; IF ERROR, ISSUE MESSAGE
	INX	D	; INCREMENT DISC ADDRESS
	DCR	C	; COUNT DOWN SECTORS
	JNZ	BT1	; LOOP UNTIL DONE
	JMP	GOCPM	; SETUP AND RE-ENTER CP/M
;
BERR:	CALL	BTERR	; ISSUE ERROR MESSAGE
	HLT		; HALT SYSTEM
;
BTERR:	LXI	H,BEMSG	; POINT TO ERROR MESSAGE
;  --- MESSAGE PRINTOUT ROUTINE ----
;
PTMSG:	MOV	A,M	; GET MESSAGE BYTE
	CPI	'$'	; IS IT THE TERMINAL CHARACTER
	RZ		; YES, SO RETURN
	MOV	C,A	; SAVE FOR CONSOLE OUTPUT
	PUSH	H
	CALL	CONOUT
	POP	H
	INX	H
	JMP	PTMSG
;
; ---- CORVUS DISC READ ROUTINE ----
;
READC:	MVI	A,RDCOM	; GET READ COMMAND
	CALL	SETUP	; COMPUTE DISC ADDRESS AND ISSUE COMMANDS
	LHLD	DMAAD	; GET DMA ADDRESS
RDC1:	CALL	RTURN	; WAIT FOR ACCEPTANCE OF COMMAND
	JNZ	ERRCD	; IF ERROR
	MVI	B,SSIZE	; GET SECTOR SIZE
	CALL	RDBLK	; 1.23 - USE RDBLK TO GET BYTES
RTN:	XRA	A	; CLEAR ERROR INDICATOR
	RET
;
; ---- CORVUS DISC WRITE ROUTINE ----
;
WRITEC: MVI	A,WRCOM	; GET WRITE COMMAND
	CALL	SETUP	; COMPUTE ADDRESS AND ISSUE COMMANDS
	MVI	B,SSIZE	; GET SECTOR SIZE
	LHLD	DMAAD	; GET DMA ADDRESS
	CALL	WTBLK	; 1.23 - USE WTBLK TO PUT BYTES
	CALL	RTURN	; WAIT FOR BUSS TURN AROUND AND READ ERROR #
	JZ	RTN	; RETURN IF OK
ERRCD:	PUSH	B	; IF ERROR, ISSUE ERROR MESSAGE
	LXI	H,ERMSG
	CALL	PTMSG
	POP	PSW	; GET ERROR # BACK IN ACC
	CALL	HEXOT	; PRINT IT OUT IN HEX
	LXI	H,ERMSG1
	CALL	PTMSG	; PRINT REMAINDER OF MESSAGE
	MVI	A,1	; SET ERROR INDICATOR
	RET
;
RTURN:	CALL	TURN	; WAIT FOR "DRIVE-TO-HOST" STATUS
	CALL	WAITI	; READ ERROR BYTE
	MOV	B,A	; SAVE IT
	ANI	80H	; LOOK AT FATAL ERROR BIT
	RET
;
;
; --- OUTPUT ACC IN HEX ---
;
HEXOT:	PUSH	PSW	; SAVE BYTE
	RRC		; SHIFT UPPER NIBBLE DOWN 4 BITS
	RRC
	RRC
	RRC
	CALL	HEXB	; OUTPUT UPPER NIBBLE IN HEX
	POP	PSW	; RESTORE BYTE
HEXB:	ANI	0FH	; MASK OUT UPPER NIBBLE
	ADI	'0'	; ADD ASCII BIAS
	CPI	'9'+1	; IS IT NUMERIC?
	JC	PRT	; YES, SO SEND IT OUT
	ADI	7	; NO, SO ADJUST FOR A-F
PRT:	MOV	C,A	; SAVE FOR OUTPUT
	JMP	CONOUT	; OUTPUT TO CONSOLE
;
; --- COMPUTE CORVUS DISC ADDRESS AND SEND TO CONTROLLER ---
;
SETUP:	CALL	WAITO	; ISSUE DISC R/W  COMMAND
	LHLD	TRACK	; GET TRACK # FROM BUFFER
	XCHG		; PUT IN (D,E)
	LXI	H,0	; CLEAR CONVERSION BUFFER
	LDA	NSPTRK	; GET # SECTORS/TRACK  (ASSUMED <255)
	MVI	B,8	; SET TO MULTIPLY 8 BITS
;           MULTIPLY :(H,L)=TRACK*(# SECTORS/TRACK)
MULT:	DAD	H	; SHIFT BUFFER OVER 1 POSITION
	RAL		; TEST NEXT BIT OF (#SECTORS/TRACK)
	JNC	ML1	; IF NOT A 1, DON'T ADD IN
	DAD	D	; IF A 1, ADD IN  TRACK #
ML1:	DCR	B	; COUNT DOWN # BITS
	JNZ	MULT	; LOOP UNTIL DONE
	XCHG		; PUT RESULT IN (D,E)
	LHLD	SECTOR	; GET SECTOR #
	DAD	D	; (H,L)=SECTOR+TRACK*(#SECTORS/TRACK)
;
	XCHG		; PUT RESULT IN (D,E)
	LHLD	ADDOF	; GET POINTER TO DISC ADDRESS OFFSET
;	    ADD IN DISC ADDRESS OFFSET
	MOV	A,E	; GET LOWER BYTE OF RELATIVE DISC ADDRESS
	ADD	M	; ADD IN LOWER BYTE OF ABSOLUTE DISC OFFSET
	MOV	E,A	; SAVE RESULT
	INX	H	; POINT TO NEXT BYTE OF OFFSET
	MOV	A,D	; DO ADDITION AGAIN
	ADC	M
	MOV	D,A	; SAVE IT
	INX	H	; POINT TO LAST BYTE OF OFFSET
	MVI	A,0	; CLEAR ACC WITHOUT CLEARING CARRY BIT
	ADC	M	; GET UPPER BYTE OF DISC ADDRESS
	RLC		; SHIFT OVER 4 PLACES
	RLC
	RLC
	RLC
	MOV	C,A	; SAVE IT
	LDA	CDRIVE	; GET CORVUS DRIVE # (1-4)
	ADD	C	; MERGE IN EXTENDED DISC ADDRESS BITS
;
;	   WE NOW HAVE  (D,E)=LOWER TWO BYTES OF DISC ADDRESS
;	                ACC  =EXTENDED DISC ADDRESS+DRIVE #
;
SET1:	CALL	WAITO	; SEND DRIVE # TO CONTROLLER
	MOV	A,E
	CALL	WAITO	; SEND LOWER DISC ADDRESS TO CONTROLLER
	MOV	A,D
	JMP	WAITO
;
; --- HOME CORVUS DRIVE ----
;
HOMEC:	LXI	B,0	; GET TRACK 0
	JMP	SETTRK
;
; ---- SELECT DISC ROUTINE ----
;  NOTE, THIS ROUTINE DOES A LOT OF EXTRA WORK SO
;  THAT SOME OF IT NEED NOT BE DONE FOR EACH DISC
;  READ/WRITE OPERATION.  THE METHOD USED TO SWITCH
;  BETWEEN CORVUS AND FLOPPY DRIVES (PATCHING A JUMP
;  TABLE) IS MAINLY USED BECAUSE IT CONCENTRATES THE
;  SELECT FUNCTIONS ALL WITHIN THE SELDSK ROUTINE.
;
SELDSK:	MOV	A,C	; GET CP/M DRIVE #
	LXI	H,DSKNO	; POINT TO BUFFER WITH LAST DRIVE #
	CMP	M	; ARE THEY THE SAME?
	JZ	SLD3	; YES, SO JUST GET POINTER AND RETURN
	CPI	DMAX	; NO, SO SEE IF # IS TOO BIG
	JNC	SLDERR	; ERROR, SO GIVE NOTICE
	MOV	M,C	; UPDATE DRIVE #
	CPI	NPSUDO	; IS IT A FLOPPY?
	JNC	SLD1	; YES, SO PROCESS SELECT
;	    COPY CORVUS ROUTINE ADDRESSES INTO JUMP TABLE
	LXI	H,READC
	SHLD	DREAD+1
	LXI	H,WRITEC
	SHLD	DWRIT+1
	LXI	H,HOMEC
	SHLD	DHOME+1
;
	MOV	L,C	; GET CP/M DRIVE # IN (H,L)
	MVI	H,0
	DAD	H	; MULTIPLY BY 4
	DAD	H
	LXI	D,OFSBAS ; POINT TO BASE OF OFFSET TABLE
	DAD	D	; SELECT THE RIGHT ONE
	SHLD	ADDOF	; SAVE POINTER FOR LATER USE
	INX	H
	INX	H
	INX	H
	MOV	A,M	; GET ACTUAL CORVUS DRIVE #
	STA	CDRIVE	; SAVE IT
	JMP	SLD2	; COMPUTE ADDRESS OF PARAM. BLOCK
;	    COPY FLOPPY ROUTINE ADDRESSES INTO JUMP TABLE
SLD1:	LXI	H,READF
	SHLD	DREAD+1
	LXI	H,WRITEF
	SHLD	DWRIT+1
	LXI	H,HOMEF
	SHLD	DHOME+1
;
	PUSH	B
	CALL	SELDF	; CALL FLOPPY SELECT ROUTINE
	POP	B
;
SLD2:	MOV	L,C	; GET CP/M DRIVE # IN (H,L)
	MVI	H,0
	DAD	H	; MULTIPLY BY 16
	DAD	H
	DAD	H
	DAD	H
	LXI	D,DPBASE ; GET START OF PARAM. BLOCK
	DAD	D	; SELECT THE RIGHT BLOCK
	SHLD	PPOINT	; SAVE POINTER
	LXI	D,10
	DAD	D	; POINT TO ADDRESS OF DISC BLOCK
	MOV	E,M	; GET ADDRESS IN FROM TABLE INTO (D,E)
	INX	H
	MOV	D,M
	XCHG		; PUT IN (H,L)
	MOV	E,M	; GET # SECTORS/TRACK INTO (D,E)
	INX	H
	MOV	D,M
	XCHG
	SHLD	NSPTRK	; SAVE IT IN BUFFER
SLD3:	LHLD	PPOINT	; GET PARAM. POINTER
	RET
SLDERR:	LXI	H,0	; IF SELECT ERROR, GET 0 IN (H,L)
	LDA	CDISC
	ANI	0F0H
	STA	CDISC	; SET TO REBOOT ON DRIVE  A
	RET
;
SETTRK:	MOV	L,C	; SAVE TRACK #
	MOV	H,B
	SHLD	TRACK
	RET
;
SETSEC:	MOV	L,C	; SAVE CP/M SECTOR #
	MOV	H,B
	SHLD	SECTOR
	RET
;
SETDMA:	MOV	L,C	; SAVE DMA ADDRESS
	MOV	H,B
	SHLD	DMAAD
	RET
;
;
;$I CRV.IO		; BASIC CORVUS IO ROUTINES
;FILEID: CRV.IO
;

TURN:				; WAIT FOR DRIVE-TO-HOST STATUS AND
	IN	STAT		; DELAY TILL DATA STABLE
	ANI	DRDY OR DIFAC	; TEST STATUS
	CPI	DRDYST OR DTH	; IS DRIVE READY & DRIVE-TO-HOST
	JNZ	TURN		; IF NOT THEN LOOP
	MVI	B,6		; SET DELAY COUNT
	CALL	DELAY		; GOOD AT 4MHZ ALSO
	RET			;
;
DELAY:	DCR	B
	JNZ	DELAY
	RET
;
WAITI:	IN	STAT	; READ STATUS PORT
	ANI	DRDY OR DIFAC	; LOOK AT STATUS
	CPI	DRDYST OR DTH	; IS DRIVE READY & DRIVE-TO-HOST
	JNZ	WAITI	; LOOP UNTIL READY
	IN	DATA	; READ BYTE FROM DISC
	RET
;
WAITO:	PUSH	PSW	; SAVE COMMAND
	IN	STAT	; READ STATUS PORT
	ANI	DRDY OR DIFAC	; LOOK AT STATUS
	CPI	DRDYST OR HTD	; IS DRIVE READY & HOST-TO-DRIVE
	JNZ	WAITO+1	; LOOP UNTIL READY
	POP	PSW
	OUT	DATA	; WRITE BYTE TO DISC
	RET

;
;$I RWBLK.IO		; READ & WRITE BLOCK ROUTINES
;FILEID: RWBLK.IO
;
RDBLK:	IN	STAT	; READ STATUS PORT
	ANI	DRDY	; LOOK AT STATUS
	JNZ	RDBLK	; LOOP UNTIL READY
	IN	DATA	; READ BYTE FROM DISC
	MOV	M,A	; PUT DATA IN BUFFER
	INX	H	; INCREMENT DATA BUF POINTER
	DCR	B	; DECREMENT BYTE COUNTER
	JNZ	RDBLK	; LOOP IF NOT 0
	RET
;
WTBLK:	IN	STAT	; READ STATUS PORT
	ANI	DRDY	; LOOK AT STATUS
	JNZ	WTBLK	; LOOP UNTIL READY
	MOV	A,M	; GET DATA BYTE INTO ACC
	OUT	DATA	; WRITE BYTE TO DISC
	INX	H	; INCREMENT DATA BUFFER POINTER
	DCR	B	; DECREMENT BYTE COUNTER
	JNZ	WTBLK	; IF NOT 0 THEN LOOP
	RET

;
;$I CRVINIT.IO		; RESYNC CONTROLLER ROUTINE
;FILEID: CRVINIT.IO
;
;
; --- INITIALIZE CONTROLLER ----
;
INIT:	MVI	A,0FFH	; GET AN INVALID COMMAND
	OUT	DATA	; SEND IT TO CONTROLLER
	MVI	B,150	; SET FOR LONG DELAY
	CALL	DELAY
	IN	STAT
	ANI	DRDY OR DIFAC	; LOOK AT DRIVE ACTIVE BIT
	CPI	DRDYST OR DTH	; IS STATUS = READY & DRIVE-TO-HOST
	JNZ	INIT	; LOOP UNTIL DRIVE-TO-HOST
	CALL	WAITI	; GET ERROR CODE
	CPI	8FH	; CHECK RETURN CODE
	JNZ	INIT	; IF NOT RIGHT, TRY AGAIN
	RET
;
;$I BIOSC.DPB		; DISK PARAMETER BLOCK STRUCTURE
;FILE ID: BIOSC.DPB

;$I DPB.SET			; SET UP CORVUS DISK PARAMETER BLOCK
;FILE ID: DPB.SET
;
				; SPT MUST BE A MULTIPLE OF 4
	IF FIVEMB
DRVSZ	EQU	11220		; 5.61MB USER AREA
SPT	EQU	64		; 64 SECTORS/TRACK ON 5MB
      ENDIF
      IF TENMB
DRVSZ	EQU	21220		; 10.61MB USER AREA
SPT	EQU	60		; 60 SECTORS/TRACK ON 10
      ENDIF
      IF TWNTYMB
DRVSZ	EQU	38460		; 19.23MB USER AREA
SPT	EQU	64		; 64 SECTORS/TRACK ON 20
      ENDIF

      IF PIPES			; 500 BLOCKS FOR PIPES AREA
RESERVE	EQU	564		; # OF 512 BYTE BLOCKS RESERVED 
      ENDIF			; IF A PIPES AREA TO EXIST
      IF NOT PIPES		; 64 BLOCKS FOR CORVUS USE
RESERVE	EQU	64		; # OF 512 BYTE BLOCKS IF NO PIPES
      ENDIF

				; DRM+1 MUST BE A MULTIPLE OF BLKSZ*32 
				; FOR ALOCMSK TO BE SET UP RIGHT
DRM	EQU	255		; # DIRECTORY ENTRIES - 1

				; NUMBER OF DIRECTORY BLOCKS TO ALLOCATE
				; (((DRM+1)*32)/(BLKSZ*1024))
NDB	EQU	((DRM+1)/(BLKSZ*32))
;

SHFTCNT	EQU	16-NDB		; SHIFT LEFT COUNT
				; BIT MAP FOR RESERVED DIRECTORY BLOCKS
ALOCMSK	EQU	(0FFFFH SHL SHFTCNT)
				; UPPER BYTE OF DIRECTORY BIT MAP
AL0	EQU	(ALOCMSK SHR 8) AND 00FFH
				; LOWER BYTER OF DIRECTORY BIT MAP
AL1	EQU	ALOCMSK AND 00FFH
;
OFF	EQU	1		; RESERVED TRACKS/PSEUDO DRIVE
BLM	EQU	(BLKSZ*8)-1	; BLOCK MASK (USED INTERNALLY BY CP/M)

      IF BLKSZ SHR 1		 ;IF ALLOCATION BLOCK SIZE = 2K
BSH	EQU	4		;
      ENDIF
      IF BLKSZ SHR 2		; if allocation size = 4k
BSH	EQU	5		;
      ENDIF
      IF BLKSZ SHR 3		; if allocation size = 8k
BSH	EQU	6		;
      ENDIF
      IF BLKSZ SHR 4		; if allocation size = 16k
BSH	EQU	7		;
      ENDIF


PDRVSZ	EQU	(DRVSZ - RESERVE)/NPSUDO	;
RTOFF	EQU	(SPT * OFF)/4	; # OF 512 BYTE SECTORS RESERVED FOR
				; BOOT TRACK OF EACH PSEUDO DISK

BLKS	EQU	BLKSZ*2		; # OF 512 BYTE BLOCKS IN 1 
				; ALLOCATION BLOCK.
;
DSM	EQU	((PDRVSZ-RTOFF)/BLKS)-1	;
;
;	THE FOLLOWING SET OF EQUATES THAT SET GRTR ARE USED TO 
;	DETERMINE IF THE DSM IS >= 256.  THE EXTENT MASK IS SET 
;	DEPENDING ON GRTR EQUATE.
;
GRTR	SET	0	;
      IF (DSM SHR 8)OR(DSM SHR 9)OR(DSM SHR 10)
GRTR	SET	1	; IF ANY OF THESE BITS SET THEN DSM >= 256
      ENDIF
      IF (DSM SHR 11)OR(DSM SHR 12)OR(DSM SHR 13)
GRTR	SET	1	; IF ANY OF THESE BITS SET, DSM >= 256
      ENDIF
      IF (DSM SHR 14)OR(DSM SHR 15)
GRTR	SET	1	; 
      ENDIF
      IF GRTR
EXM	EQU	(BLKSZ/2)-1	;
      ENDIF
      IF NOT GRTR
EXM	EQU	BLKSZ-1		;
      ENDIF

; --- DISC PARAMETER BLOCK ---
;
DPBC:		
	DW	SPT	; SECTORS/TRACK ON CORVUS PSEUDO DRIVE
	DB	BSH	; BLOCK SHIFT
	DB	BLM	; BLOCK MASK
	DB	EXM	; EXTENT MASK
	DW	DSM	; DISK SIZE-1
	DW	DRM	; DIRECTORY MAX-1
	DB	AL0	; ALLOC0
	DB	AL1	; ALLOC1
	DW	0	; CHECK SIZE
	DW	OFF	; TRACK OFFSET


;
; ---- CORVUS DISC OFFSET TABLE ----
;
;  THIS TABLE SPECIFIES WHERE THE PSEUDO DRIVES ARE
;  ON THE CORVUS DRIVE (BY ADDRESS AND DRIVE #).
;
MAX16	EQU	16384		; MAX # OF 128 BYTE SECTORS ADDRESSIBLE
				; BY 16 BITS (IN UNITS OF 512 BYTE
				; BLOCKS. 16384*4=65536)

CUROFF	SET	0			;

CUROFF	SET	CUROFF + RESERVE	;

OFSBAS:		
      IF NPSUDO			;
PDRV0OFF EQU	CUROFF		;
CUROFF	SET	PDRV0OFF + PDRVSZ	;

PDRV0:		
	DW	(PDRV0OFF MOD MAX16)*4	;
	DB	PDRV0OFF/MAX16		;
	DB	1			;
;
      ENDIF
      IF NPSUDO SHR 1		;
PDRV1OFF EQU	CUROFF			;
PDRV2OFF EQU	PDRV1OFF + PDRVSZ	;
CUROFF	 SET	PDRV2OFF + PDRVSZ	;

PDRV1:		
	DW	(PDRV1OFF MOD MAX16)*4	;
	DB	PDRV1OFF/MAX16		;
	DB	1			;
;
PDRV2:		
	DW	(PDRV2OFF MOD MAX16)*4	;
	DB	PDRV2OFF/MAX16		;
	DB	1			;
;
      ENDIF
      IF NPSUDO SHR 2		;
PDRV3OFF EQU	CUROFF			;
PDRV4OFF EQU	PDRV3OFF + PDRVSZ	;
PDRV5OFF EQU	PDRV4OFF + PDRVSZ	;
PDRV6OFF EQU	PDRV5OFF + PDRVSZ	;
CUROFF	 SET	PDRV6OFF + PDRVSZ	;

PDRV3:		
	DW	(PDRV3OFF MOD MAX16)*4	;
	DB	PDRV3OFF/MAX16		;
	DB	1			;
;
PDRV4:		
	DW	(PDRV4OFF MOD MAX16)*4	;
	DB	PDRV4OFF/MAX16		;
	DB	1			;
;
PDRV5:		
	DW	(PDRV5OFF MOD MAX16)*4	;
	DB	PDRV5OFF/MAX16		;
	DB	1			;
;
PDRV6:		
	DW	(PDRV6OFF MOD MAX16)*4	;
	DB	PDRV0OFF/MAX16		;
	DB	1			;
;
      ENDIF


ALVSZ	EQU	((DSM+1)/8)+1	;
      IF NPSUDO			;
ALV0:				;
	DS	ALVSZ		;
CSV0:				;
	DS	0		; DRIVE 0 CHECK BUF (NOT USED)
      ENDIF
      IF NPSUDO SHR 1		;
ALV1:				;
	DS	ALVSZ		;
CSV1:				;
	DS	0		; DRIVE 1 CHECK BUF (NOT USED)
ALV2:				;
	DS	ALVSZ		;
CSV2:				;
	DS	0		; DRIVE 2 CHECK BUF (NOT USED)
      ENDIF
      IF NPSUDO SHR 2		;
ALV3:				;
	DS	ALVSZ		;
CSV3:				;
	DS	0		; DRIVE 3 CHECK BUF (NOT USED)
ALV4:				;
	DS	ALVSZ		;
CSV4:				;
	DS	0		; DRIVE 4 CHECK BUF (NOT USED)
ALV5:				;
	DS	ALVSZ		;
CSV5:				;
	DS	0		; DRIVE 5 CHECK BUF (NOT USED)
ALV6:				;
	DS	ALVSZ		;
CSV6:				;
	DS	0		; DRIVE 6 CHECK BUF (NOT USED)
      ENDIF


;
DPBASE:		
      IF NPSUDO			;
DPE0:		
	DW	0,0	; CORVUS PSEUDO DRIVE 1
	DW	0,0
	DW	DIRBUF,DPBC	; DIRECTORY BUFFER, PARAM. BLOCK
	DW	CSV0,ALV0	; CHECK, ALLOC MAP
      ENDIF
;
      IF NPSUDO SHR 1		;
DPE1:				; CORVUS PSEUDO DRIVE 2
	DW	0,0		;
	DW	0,0
	DW	DIRBUF,DPBC	; DIRECTORY BUFFER, PARAM. BLOCK
	DW	CSV1,ALV1	; CHECK, ALLOC MAP
;
DPE2:				; CORVUS PSEUDO DRIVE 3
	DW	0,0		;
	DW	0,0
	DW	DIRBUF,DPBC	; DIRECTORY BUFFER, PARAM. BLOCK
	DW	CSV2,ALV2	; CHECK, ALLOC MAP
;
      ENDIF
      IF NPSUDO SHR 2		;
DPE3:				; CORVUS PSEUDO DRIVE 4
	DW	0,0		;
	DW	0,0
	DW	DIRBUF,DPBC	; DIRECTORY BUFFER, PARAM. BLOCK
	DW	CSV3,ALV3	; CHECK, ALLOC MAP
;
DPE4:				; CORVUS PSEUDO DRIVE 5
	DW	0,0		;
	DW	0,0
	DW	DIRBUF,DPBC	; DIRECTORY BUFFER, PARAM. BLOCK
	DW	CSV4,ALV4	; CHECK, ALLOC MAP
;
DPE5:				; CORVUS PSEUDO DRIVE 6
	DW	0,0		;
	DW	0,0
	DW	DIRBUF,DPBC	; DIRECTORY BUFFER, PARAM. BLOCK
	DW	CSV5,ALV5	; CHECK, ALLOC MAP
;
DPE6:				; CORVUS PSEUDO DRIVE 7
	DW	0,0		;
	DW	0,0
	DW	DIRBUF,DPBC	; DIRECTORY BUFFER, PARAM. BLOCK
	DW	CSV6,ALV6	; CHECK, ALLOC MAP
;
      ENDIF
;
;
;$I BIOSC.FLP		; FLOPPY DRIVER
DPEF1:	DW	FTAB,0		; FLOPPY TRANSLATION TABLE
	DW	0,0
	DW	DIRBUF,DPBF	; DIRECTORY BUFFER, PARAM. BLOCK
	DW	CSVF1,ALVF1	; CHECK, ALLOC MAP
;
DPEF2:	DW	FTAB,0		; FLOPPY TRANSLATION TABLE
	DW	0,0
	DW	DIRBUF,DPBF	; DIRECTORY BUFFER, PARAM. BLOCK
	DW	CSVF2,ALVF2	; CHECK, ALLOC MAP
;
;
DPBF:	DW	26	; SECTORS/TRACK ON STD 8 INCH FLOPPY
	DB	3	; BLOCK SHIFT FACTOR
	DB	7	; BLOCK MASK
	DB	0	; NULL MASK
	DW	242	; DISC SIZE-1
	DW	63	; DIRECTORY MAX
	DB	192	; ALLOC 0
	DB	0	; ALLOC 1
	DW	16	; CHECK SIZE
	DW	2	; TRACK OFFSET
;
ALVF1:	DS	31	; DRIVE 1 ALLOC. MAP (FLOPPY)
CSVF1:	DS	16	; CHECKSUM ARRAY
ALVF2:	DS	31	; DRIVE 2 ALLOC. MAP
CSVF2:	DS	16	; CHECKSUM ARRAY
;
;
;
; ---- STANDARD 8 INCH FLOPPY INTERLACE TABLE ----
;
FTAB:	DB	1,7,13,19
	DB	25,5,11,17
	DB	23,3,9,15
	DB	21,2,8,14
	DB	20,26,6,12
	DB	18,24,4,10
	DB	16,22
;
;
; ---- CONSOLE INPUT ROUTINE ----
;    (EXAMPLE, SIMPLE I/O PORT ORIENTED)
;
CONIN:	CALL	CONST	; CHECK CONSOLE STATUS
	ORA	A
	JZ	CONIN	; LOOP UNTIL READY
	IN	1	; GET CHAR.
	ANI	7FH	; MASK OFF PARITY
	RET
;
; ---- CONSOLE STATUS TEST ----
;
CONST:	IN	0	; GET STATUS
	ANI	20H	; MASK IT
	MVI	A,0	; GET NOT READY INDICATOR
	RZ
	CMA		; RETURN WITH 0FFH IF READY
	RET
;
; ---- CONSOLE OUTPUT ----
;
CONOUT:	IN	0	; GET STATUS BYTE
	ANI	2	; MASK IT
	JZ	CONOUT	; LOOP UNTIL READY
	MOV	A,C
	OUT	1	; OUTPUT TO CONSOLE
	RET
;
; ---- LIST DEVICE DRIVERS ----
;
LIST:	NOP	; PUT IN CODE FOR LIST DEVICE
	RET
;
; ---- LIST STATUS TEST ----
;
LISTST:	XRA	A	; CLEAR STATUS
	RET
;
; ---- PUNCH DEVICE ----
;
PUNCH:	NOP	; PUT IN CODE FOR PUNCH
	RET
;
; ---- READER DEVICE ----
;
READER:	MVI	A,'Z'-40H	; RETURN CONTROL-Z
	RET
;
; -------------- FLOPPY DISC ROUTINES ----------------
;	(USED TRACK, SECTOR, AND DMA ADDRESS IN BUFFERS)
;
; ---- READ SECTOR FROM FLOPPY ----
;
READF:	NOP	; PUT IN CODE FOR READ ROUTINE
	XRA	A	; CLEAR FLAGS
	RET
;
; ---- WRITE SECTOR TO FLOPPY ----
;
WRITEF:	NOP		; PUT IN CODE FOR WRITE ROUTINE
	XRA	A
	RET
;
; ---- HOME THE FLOPPY ----
;
HOMEF:	NOP		; PUT IN CODE FOR HOME ROUTINE
	RET
;
; ---- SELECT FLOPPY ----
;
SELDF:	NOP		; PUT IN CODE TO SELECT BETWEEN FLOPPYS
	RET
;
;
; -------- MESSAGES -----------
;
BMSG:	DB 0DH,0AH,' ----- CORVUS  '
	DB MSIZE/10+'0',MSIZE MOD 10 + '0'
	DB 'K CP/M  V2.0 OF 12-1-81 -----',0DH,0AH,'$'
;$I BIOSC.DAT		 BIOSC DATA FILE
;FILEID: BIOSC.DAT

;
BEMSG:	DB 0DH,0AH,07,' ** BOOT ERROR **',0DH,0AH,'$'
;
ERMSG:	DB 0DH,0AH,07,' -- DISC R/W ERROR # $'
;
ERMSG1:	DB 'H --',0DH,0AH,'$'
;
; --------- BUFFERS --------------
;
DMAAD:	DS	2	; DMA ADDRESS
TRACK:	DS	2	; TRACK #
SECTOR:	DS	2	; SECTOR #
DSKNO:	DB	0FFH	; CURRENT DISC # (UNDEFINED AT START)
ADDOF:	DS	2	; BUFFER FOR POINTER TO ADDRESS OFFSET
NSPTRK:	DS	2	; BUFFER WITH # SECTORS/TRACK
PPOINT:	DS	2	; POINTER TO CURRENT PARAM. BLOCK
CDRIVE:	DS	1	; BUFFER FOR CORVUS DISC #
;
DIRBUF:	DS	128	; DIRECTORY ACCESS BUFFER
;
;
;
	END
   	D:BIOSC.S             