	TITLE	186 IO DISPATCHING SYSTEM
	PAGE	60,132
	.SALL

RETF	MACRO
	DB	0CBH
	ENDM

TESTM	MACRO	XX
	LOCAL	LAB
	CMP	SI,OFFSET DGROUP:&XX&+TASKMAX
	JB	LAB
	SUB	SI,TASKMAX
LAB:
	ENDM

;	CONFIGURATION
;
;
;	CONDITIONS
;
DUALPRIO EQU	0			;DUAL PRIORITY
;
TASKMAX EQU	16		;MAXIMUM NO OF TASKS
	INCLUDE \186\XINSTR.MAC
	.LIST

DGROUP	GROUP	DATA
PGROUP	GROUP	PROG

DATA	SEGMENT WORD PUBLIC 'DATA'
;
	ASSUME DS:DGROUP
	PUBLIC EXITTSK,RUNTSKL,RUNTSKH,DISPAT
;
SPTAB	DW	TASKMAX DUP (?)		;TASK STACK POINTER TABLE
	IF	DUALPRIO
LPRIOF	DB	TASKMAX DUP (?)		;LOW PRIORITY TASK FIFO
	ENDIF
HPRIOF	DB	TASKMAX DUP (?)		;HIGH PRIORITY TASK FIFO
	IF	DUALPRIO
LOPRIIP	DW	?			;LOW PRIORITY FIFO IN POINTER
LOPRIOP	DW	?			;LOW PRIORITY FIFO OUT POINTER
	ENDIF
HIPRIIP	DW	?			;HIGH PRIORITY FIFO IN POINTER
HIPRIOP DW	?			;HIGH PRIORITY FIFO OUT POINTER
CURTSP	DW	?			;ADDRESS OF CURRENT SPTABLE ENTRY 
EXITTSK	DD	?			;EXIT TASK ROUTINE ADDRESS
RUNTSKL DD	?			;RUN LOW PRIO ROUTINE ADDRESS
RUNTSKH DD	?			;RUN HIGH PRIO ROUTINE ADDRESS
CURTSK	DB	?			;NUMBER OF CURRENT TASK
DATA	ENDS

PROG	SEGMENT BYTE PUBLIC 'PROG'
	ASSUME CS:PGROUP
	PUBLIC	INITDSP,DISPAT
	PUBLIC	INITDSP

;	ROUTINE ADDRESS TABLE
;
DSPADDT	DW	OFFSET PGROUP:EXITTASK
	IF	DUALPRIO
	DW	OFFSET PGROUP:RUNLO
	ELSE
	DW	OFFSET PGROUP:RUNHI
	ENDIF
	DW	OFFSET PGROUP:RUNHI
NROUTS	EQU	($-DSPADDT)/2

;INITDSP	INIT	DISPATCHER
;ENTRY:
;	CX	NUMBER OF TASKS
;	BX	TASK STACK SIZE
;	SS	STACK SEGMENT
;	ES:DI	POINTING TO TASK ADDRESS TABLE IN FOLLOWING FORMAT:
;	DWORD	0 TO CX-1	DWORD POINTERS TO TASKS
;EXIT:
;	NONE
;DESTROYS:
;	NONE

INITDSP	PROC	NEAR			;ENTRY POINT FOR INITIALIZATION
	PUSHA
	PUSH	CX
	MOV	SI,OFFSET DS:SPTAB	;INIT STACK POINTER TABLE
	XOR	AX,AX
INITDSP1:
	ADD	AX,BX			;CALCULATE STACK POINTER
	MOV	[SI],AX			;STORE
	ADD	SI,2			;POINT TO NEXT ENTRY
	LOOP	INITDSP1		;LOOP UNTIL ALL INIT
;
;	INIT TASK STACKS
;
	POP	CX			;RE-INIT LOOP COUNTER
	MOV	BP,BX			;POINT TO STACK OF FIRST TASK
INITDSP2:
	MOV	AX,ES:[DI]		;XFER ADDRESS OF TASK
	ADD	DI,2
	MOV	[BP-2],AX
	MOV	AX,ES:[DI]
	MOV	[BP],AX
	ADD	BP,BX			;POINT TO STACK OF NEXT TASK
	LOOP	INITDSP2		;LOOP UNTIL DONE
	IF	DUALPRIO
	MOV	AX,OFFSET DS:LPRIOF	;INIT FIFO POINTERS
	MOV	LOPRIIP,AX
	MOV	LOPRIOP,AX
	ENDIF
	MOV	AX,OFFSET DS:HPRIOF
	MOV	HIPRIIP,AX
	MOV	HIPRIOP,AX
	MOV	CX,NROUTS		;INIT ROUTINE ADDRESS TABLE
	MOV	DI,OFFSET DS:EXITTSK
	MOV	SI,OFFSET PGROUP:DSPADDT
INITDSP3:
	MOV	BX,CS:[SI]		;GET ROUTINE ADDRESS
	ADD	SI,2
	MOV	[DI],BX			;STORE
	MOV	[DI+2],CS		;STORE CS
	ADD	SI,4
	LOOP	INITDSP3
	POPA
	RET
INITDSP	ENDP

EXITTASK PROC FAR			;ENTRY POINT FOR TASK EXIT
	MOV	CURTSK,0		;FLAG NO TASK RUNNING
	MOV	SI,CURTSP		;SAVE STACK POINTER
	MOV	[SI],SP

;	RUN NEXT TASK

DISPAT:
	XOR	BH,BH
DISPAT1:
	MOV	SI,HIPRIOP		;GET HIGH PRIORITY FIFO PNTR
	MOV	BL,[SI]			;GET TASK NUMBER IF ANY
	AND	BL,BL			;IF TASK
	IF	DUALPRIO
	JZ	DISPAT3
	ELSE
	JZ	DISPAT1
	ENDIF
	MOV	[SI],BH			;CLEAR ENTRY
	INC	SI			;POINT TO NEXT ENTRY
	TESTM	HPRIOF			;CORRECT WRAPAROUND
	MOV	HIPRIOP,SI		;STORE NEW POINTER
DISPAT2:
	MOV	SI,OFFSET DS:SPTAB	;POINT TO STACK POINTER
	ADD	SI,BX			;OF TASK
	MOV	CURTSK,BL		;FLAG TASK RUNNING
	MOV	CURTSP,SI		;STORE ADDR SP SAVE FOR EXIT
	MOV	SP,[SI]			;LOAD STACK POINTER
	RETF				;RUN TASK
	IF	DUALPRIO
DISPAT3:
	MOV	SI,LOPRIOP		;GET LOW PRIORITY FIFO PNTR
	MOV	BL,[SI]			;GET TASK NUMBER IF ANY
	AND	BL,BL			;IF NO TASK
	JZ	DISPAT1			;TRY HIGH PRIORITY AGAIN
	MOV	[SI],BH			;CLEAR ENTRY 
	INC	SI			;POINT TO NEXT ENTRY
	TESTM	LPRIOF			;CORRECT WRAPAROUND
	MOV	LOPRIOP,SI		;STORE NEW POINTER
	JMP	DISPAT2			;EXECUTE TASK
	ENDIF
EXITTASK ENDP


;RUNHI,RUNLO	PUTS TASK IN AL IN HIGH OR LOW PRIORITY QUEUE
;ENTRY:
;	AL	NUMBER OF TASK*2
;EXIT:
;	NONE
;DESTROYS:
;	NONE

RUNHI	PROC FAR			;RUN TASK COMMAND HIGH PRIORITY
	PUSH	SI
	CLI
	MOV	SI,HIPRIIP		;GET HIGH PRIORITY FIFO PNTR
	MOV	[SI],AL			;STORE TASK NUMBER
	INC	SI			;POINT TO NEXT ENTRY
	TESTM	HPRIOF			;CORRECT WRAPAROUND
	MOV	HIPRIIP,SI		;STORE NEW POINTER
	POP	SI
	STI
	RETF
RUNHI	ENDP


	IF	DUALPRIO
RUNLO	PROC FAR			;RUN TASK COMMAND LOW PRIORITY
	PUSH 	SI
	CLI
	MOV	SI,LOPRIIP		;GET LOW PRIORITY FIFO PNTR
	MOV	[SI],AL			;STORE TASK NUMBER
	INC	SI			;POINT TO NEXT ENTRY
	TESTM	LPRIOF			;CORRECT WRAPAROUND
	MOV	LOPRIIP,SI		;STORE NEW POINTER
	POP	SI
	STI
	RETF
RUNLO	ENDP
	ENDIF
PROG	ENDS
	END
