	TITLE	INIT SEP SYNC NONINTERLACED VIDEO
	PAGE	60,132
;
;	DEFINITIONS
;
VFROP	EQU	6			;VERTIVAL FRONT PORCH
VSYNCW	EQU	20
VBAP	EQU	6			;VERTICAL BACK PORCH
HFROP	EQU	4			;HOR FRONT PORCH
HSYNCW	EQU	4			;HOR PULSE WIDTH
HBAP	EQU	4			;HOR BACK PORCH
LINES_CHAR EQU	10


NX	EQU	80			;CHARACTERS PER LINE
NY	EQU	24			;LINES MAIN FIELD
NYR	EQU	2			;LINES RESERVED FIELD
NYD	EQU	3			;DUMMY LINES

BASE	EQU	40H

;
;	INTERNAL DEFINITIONS
;
VFIELDL	EQU	LINES_CHAR*(NY+NYR)	;LINES/FIELD
VFIELDD	EQU	LINES_CHAR*(NYD)	;DUMMY LINES
HFIELD	EQU	NX/2			;DISPLAYED WORDS
LINES	EQU	VFROP+VFIELDL+VBAP+VSYNCW
WORDS	EQU	HFROP+HFIELD+HBAP+HSYNCW
OAWRDS	EQU	WORDS*LINES
OABYTS	EQU	OAWRDS*2
BBASE	EQU	(BASE AND 0FFFH) SHL 4
VBAL	EQU	VBAP*WORDS*2
VSL	EQU	VSYNCW*WORDS*2
VFRL	EQU	VFROP*WORDS*2
FLDL	EQU	VFIELDL*WORDS*2
CHKL1	EQU	VBAL
CHKL2	EQU	CHKL1+VSL
CHKL3	EQU	CHKL2
CHKL4	EQU	CHKL3+VFRL
CHKL5	EQU	CHKL4+FLDL

RTJPADR	EQU	OABYTS+2
RTJP	EQU	(BASE SHL 3)+2
;
	INCLUDE	\SYSCON\SYSCON.EQU
	INCLUDE	SRC\VIDMAC.MAC
;
PGROUP	GROUP	PROG
	ASSUME	CS:PGROUP
;
PROG	SEGMENT	BYTE PUBLIC 'PROG'
	PUBLIC	VDIS260,DATSEG
;
	EXTRN	INIATTR:NEAR,CHRGEN:NEAR
DATSEG	DW	LINES*WORDS/8+BASE+1	;DATA SEGMENT
VDIS260:
	DW	VDI286TE
	DB	2			;FLAG NON INTERLACED VIDEO
	DB	LINES_CHAR		;LINES PER CHARACTER
	DW	LINES			;TOTAL LINES
	DW	WORDS			;TOTAL WORDS
	DW	VFIELDL			;ACTIVE VERTICAL LINES
	DW	HFIELD			;ACTIVE WORDS
	DW	BASE			;VIDEO SEGMENT
	DW	2			;VERTICAL SYNCFIELD 1
	DW	0
	DW	CHKL4+2			;EXIT ADR SYNC FIELD 1
	DW	0
	DW	CHKL4			;ADDRESS FIRST ACTIVE LINE
	DW	WORDS*2+2		;OFFSET TO EXIT ADR OF LINE
	DW	HFROP*2			;OFFSET TO ACTIVE PART OF LINE
	DW	OAWRDS+WORDS*LINES_CHAR*3;TOTAL WORDS
	DW	LINES_CHAR*3		;DUMMY LINES
	DW	OFFSET PGROUP:CHRGEN	;CHARGEN ADDR
	DD	IATTR			;$ INIT ROUT ATTRIBUTES
	DD	SLNKLST			;$ INIT ROUT LINK LIST
	DW	WORDS*2			;BYTES PER LINE
	DW	(HFROP+HSYNCW+HBAP)*2
	DW	LINES_CHAR*2*WORDS	;LENGTH CHARACTER LINE
	DW	LINES*WORDS*2-(HBAP+HSYNCW)*2
	DW	VFIELDL*WORDS*2		;LENGTH ACTIVE FIELD
	DW	NX			;ACTIVE BYTES PER LINE
	DW	NX-1			;MAX XCURSOR
	DW	NY-1			;MAX YCURSOR
	DW	NYR			;RESERVED CHARACTER LINES
	DW	NYD			;DUMMY CHARACTER LINES
VDI286TE EQU	($-VDIS260)/2
;
SLNKLST	PROC	FAR
	MOV	AX,BASE
	MOV	ES,AX
	MOV	BX,CHKL4+2
	MOV	AX,(BASE SHL 3)+(CHKL4 SHR 1)+2
	MOV	CX,VFIELDL+VFIELDD
LDCLP:
	MOV	ES:[BX],AX
	ADD	BX,WORDS*2
	ADD	AX,WORDS
	LOOP	LDCLP
	MOV	BX,RTJPADR
	MOV	WORD PTR ES:[BX],RTJP
	RET
SLNKLST	ENDP
;
;
IATTR	PROC	FAR
	PUSH	DS
	MOV	BX,OFFSET PGROUP:INIATTRIBU
	JMP	INIATTR
INIEND:
	MOV	DX,ATTRPT
	MOV	AH,30H
	OUT	DX,AX
	POP	DS
	RET
IATTR	ENDP
;
;
INIATTRIBU:
	ADDRS	0,BASE
	COUNT	VBAP
;
;	HOR SYNC DURING VERT BACK PORCH FIELD 1
;
VBAPL:
	ADDA	(HFROP+HFIELD+HBAP)*2
	COPY	HSYNCW,<HSYNCW DUP (HSYNC)>
	RP	VBAPL
;
;	VERT SYNC FIELD 1
;
	SUBA	HSYNCW*2
	COPY	HSYNCW,<HSYNCW DUP (VSYNC)>
	COUNT	VSYNCW
VSYNCL:
	COUNT	HFROP+HFIELD+HBAP
VSYNCL1:
	COPY	1,VERT
	RP	VSYNCL1
	COPY	HSYNCW,<HSYNCW DUP (VSYNC)>
	RP	VSYNCL
;
	COUNT	VFROP
VFROPL:
	ADDA	(HFROP+HFIELD+HBAP)*2
	COPY	HSYNCW,<HSYNCW DUP (HSYNC)>
	RP	VFROPL
;
;	FIELD1
;
	COUNT	VFIELDL
FIELD:
	COPY	1,LDCNTR
	ADDA	HFROP*2-2
	COUNT	HFIELD
FIELD1:
	COPY	1,NORM
	RP	FIELD1
	ADDA	HBAP*2
	COPY	HSYNCW,<HSYNCW DUP (HSYNC)>
	RP	FIELD
	COPY	1,LDCNTR
	ENDTB	INIEND
;
;
PROG	ENDS
	END
	

