	TITLE	INIT FOR INTERLACED COMPOSITE VIDEO 520 LINES
	PAGE	60,132
	.LALL
;	DEFINITIONS
;
VFROP	EQU	8			;VERTICAL FRONT PORCH
VSYNCW	EQU	8			;VERTICAL SYNC WIDTH
VBAP	EQU	04			;VERTICAL BACK PORCH
HFROP	EQU	4			;HOR FRONT PORCH
HSYNCW	EQU	2			;HOR PULSE WIDTH
HBAP	EQU	2			;HOR BACK PORCH
VFROPC	EQU	4			;VERT FRONTPULSE COUNT
VBAPC	EQU	4			;VERT BACKPULSE COUNT
LINES_CHAR EQU	10			;LINES PER CHARACTER LINE


NX	EQU	80			;CHARACTERS PER LINE
NY	EQU	46			;LINES MAIN FIELD
NYR	EQU	4			;LINES RESERVED FIELD

BASE	EQU	40H			;VIDEO BASE SEGMENT

;
;	INTERNAL DEFINITIONS
;
VFIELDL	EQU	LINES_CHAR*(NY+NYR)	;LINES/FIELD
VFIELDD	EQU	LINES_CHAR*NYR		;DUMMY LINES
HFIELD	EQU	NX/2			;DISPLAYED WORDS
LINES	EQU	VFROP+VFIELDL+VBAP+VFROPC+VSYNCW+VBAPC
WORDS	EQU	HFROP+HFIELD+HBAP+HSYNCW
OAWRDS	EQU	WORDS*LINES+WORDS*VFIELDD+1
OABYTS	EQU	OAWRDS*2
BBASE	EQU	(BASE AND 0FFFH) SHL 4
VBAL	EQU	VBAP*WORDS*2
VFPL	EQU	VFROPC*WORDS*2
VSL	EQU	VSYNCW*WORDS*2
VBPL	EQU	VBAPC*WORDS*2
VFRL	EQU	VFROP*WORDS*2
FLDL	EQU	VFIELDL*WORDS*2
CHKL1	EQU	VBAL+VFPL
CHKL2	EQU	CHKL1+VSL
CHKL3	EQU	CHKL2+VBPL
CHKL4	EQU	CHKL3+VFRL
CHKL5	EQU	CHKL4+FLDL+2

RTJPADR	EQU	OABYTS+2-2*WORDS-VFIELDD*WORDS*2
RTJPADR1 EQU	OABYTS+2-VFIELDD*WORDS*2
RTJP	EQU	(BASE SHL 3)+1
RTJP1	EQU	RTJP+CHKL4/4+1
;
	INCLUDE	\SYSCON\SYSCON.EQU
	INCLUDE	SRC\VIDMAC.MAC
	.LIST
;
PGROUP	GROUP	PROG
	ASSUME	CS:PGROUP
;
PROG	SEGMENT	BYTE PUBLIC 'PROG'
	PUBLIC	VDIC520,DATSEG
;
	EXTRN	INIATTR:NEAR,CHRGEN:NEAR
;
;
DATSEG	DW	OAWRDS/8+BASE+1		;DATA SEGMENT
VDIC520:
	DW	VDIC520TE
	DB	3			;FLAG INTERLACED VIDEO
	DB	LINES_CHAR		;LINES PER CHARACTER
	DW	LINES			;TOTAL LINES
	DW	WORDS			;TOTAL WORDS
	DW	VFIELDL			;ACTIVE VERTICAL LINES
	DW	HFIELD			;ACTIVE WORDS
	DW	BASE			;VIDEO SEGMENT
	DW	2			;VERTICAL SYNCFIELD 1
	DW	CHKL4/2+4		;VERTICAL SYNC FIELD 2
	DW	CHKL4/2+2		;EXIT ADR SYNC FIELD 1
	DW	CHKL4+4			;EXIT ADR SYNC FIELD 2
	DW	CHKL4+2			;ADDR OF FIRST LINE
	DW	WORDS*2+2		;OFFSET TO EXIT ADR OF LINE
	DW	HFROP*2			;OFFSET TO ACTIVE PART OF LINE
	DW	OAWRDS			;TOTAL WORDS
	DW	VFIELDD			;DUMMY LINES
	DW	OFFSET PGROUP:CHRGEN	;CHARGEN ADDR
	DD	IATTR			;$ INIT ROUT ATTRIBUTES
	DD	SLNKLST			;$ INIT ROUT LINK LIST
	DW	WORDS*2			;BYTES PER LINE
	DW	(HFROP+HSYNCW+HBAP)*2
	DW	LINES_CHAR*2*WORDS	;LENGTH CHARACTER LINE
	DW	LINES*WORDS*2-(HBAP+HSYNCW)*2
	DW	VFIELDL*WORDS*2		;LENGTH ACTIVE FIELD
	DW	NX			;ACTIVE BYTES PER LINE
	DW	NX-1			;MAX XCURSOR
	DW	NY-1			;MAX YCURSOR
	DW	NYR			;RESERVED CHARACTER LINES
VDIC520TE EQU	($-VDIC520)/2
;
SLNKLST	PROC	FAR
	MOV	AX,BASE
	MOV	ES,AX
	MOV	BX,CHKL4/2+2
	MOV	AX,(BASE SHL 3)+(CHKL4 SHR 1)+2
	MOV	ES:[BX],AX
	MOV	BX,CHKL4+4
	MOV	AX,(BASE SHL 3)+(CHKL4 SHR 1)+2+WORDS
	MOV	CX,VFIELDL+VFIELDD
LDCLP:
	MOV	ES:[BX],AX
	ADD	AX,WORDS
	ADD	BX,WORDS*2
	LOOP	LDCLP
	MOV	BX,RTJPADR
	MOV	WORD PTR ES:[BX],RTJP1
	MOV	BX,RTJPADR1
	MOV	WORD PTR ES:[BX],RTJP
	RET
SLNKLST	ENDP
;
;
IATTR	PROC	FAR
	PUSH	DS
	MOV	BX,OFFSET PGROUP:INIATTRIBU
	JMP	INIATTR
INIEND:
	MOV	DX,ATTRPT
	MOV	AH,30H
	OUT	DX,AX
	POP	DS
	RET
IATTR	ENDP
;
;
INIATTRIBU:
	ADDRS	0,BASE
;
;	VERT BACK PORCH
;
	COUNT	VBAP/2
VBAPL:
	COUNT	(HFROP+HFIELD+HBAP)
VBAPL1:
	COPY	1,VERT
	RP	VBAPL1
	COPY	HSYNCW,<HSYNCW DUP (VSYNC)> ;HOR SYNC DURING VERT BACK PORCH
	RP	VBAPL
;
;	VERT FRONT PULSES
;
	COUNT	VFROPC-1
VFRPUL:
	COUNT	(HFROP+HFIELD+HBAP-HSYNCW)/2
VFRPUL1:
	COPY	1,VERT
	RP	VFRPUL1
	COPY	HSYNCW,<HSYNCW DUP (VSYNC)>
	RP	VFRPUL
	SUBA	HSYNCW*2
	COPY	HSYNCW,<HSYNCW DUP (VSYNC)>
;
;	VERT SYNC
;
	COUNT	VSYNCW
VSYNCL:
	COUNT	(HFROP+HFIELD+HBAP-HSYNCW)/2
VSYNCL1:
	COPY	1,VSYNC
	RP	VSYNCL1
	COPY	HSYNCW,<HSYNCW DUP (VERT)>
	RP	VSYNCL
	SUBA	HSYNCW*4
	COPY	HSYNCW,<HSYNCW DUP (VERT)>
	COPY	HSYNCW,<HSYNCW DUP (VSYNC)>
;
;	VERTICAL BACK PULSES
;
	COUNT	VBAPC+1
VBAPUL:
	COUNT	(HFROP+HFIELD+HBAP-HSYNCW)/2 ;VERT BACK PULSES
VBAPUL1:
	COPY	1,VERT
	RP	VBAPUL1
	COPY	HSYNCW,<HSYNCW DUP (VSYNC)> ;HOR SYNC AFTER .5H
	RP	VBAPUL
;
;	VERT FRONT PORCH
;
	COUNT	VFROP/2
VFROPL:
	ADDA	(HFROP+HFIELD+HBAP)*2
	COPY	HSYNCW,<HSYNCW DUP (HSYNC)>
	RP	VFROPL
	COPY	1,LDCNTR
;
;	VERT BACK PORCH FIELD 2
;
	COUNT	VBAP/2
AVBAPL:
	COUNT	(HFROP+HFIELD+HBAP)
AVBAPL1:
	COPY	1,VERT
	RP	AVBAPL1
	COPY	HSYNCW,<HSYNCW DUP (VSYNC)> ;HOR SYNC DURING VERT BACK PORCH
	RP	AVBAPL
;
;	VERT FRONT PULSES
;
	COUNT	VFROPC
AVFRPUL:
	COUNT	(HFROP+HFIELD+HBAP-HSYNCW)/2
AVFRPUL1:
	COPY	1,VERT
	RP	AVFRPUL1
	COPY	HSYNCW,<HSYNCW DUP (VSYNC)>
	RP	AVFRPUL
	SUBA	HSYNCW*2
	COPY	HSYNCW,<HSYNCW DUP (VSYNC)>
;
;	VERT SYNC
;
	COUNT	VSYNCW
AVSYNCL:
	COUNT	(HFROP+HFIELD+HBAP-HSYNCW)/2
AVSYNCL1:
	COPY	1,VSYNC
	RP	AVSYNCL1
	COPY	HSYNCW,<HSYNCW DUP (VERT)>
	RP	AVSYNCL
	SUBA	HSYNCW*4
	COPY	HSYNCW,<HSYNCW DUP (VERT)>
	COPY	HSYNCW,<HSYNCW DUP (VSYNC)>
;
;	VERTICAL BACK PULSES
;
	COUNT	VBAPC
AVBAPUL:
	COUNT	(HFROP+HFIELD+HBAP-HSYNCW)/2 ;VERT BACK PULSES
AVBAPUL1:
	COPY	1,VERT
	RP	AVBAPUL1
	COPY	HSYNCW,<HSYNCW DUP (VSYNC)> ;HOR SYNC AFTER .5H
	RP	AVBAPUL
;
;	VERT FRONT PORCH
;
	COUNT	VFROP/2
AVFROPL:
	ADDA	(HFROP+HFIELD+HBAP)*2
	COPY	HSYNCW,<HSYNCW DUP (HSYNC)>
	RP	AVFROPL
	COPY	1,LDCNTR
;
;	FIELD1+2
;
	COUNT	VFIELDL
FIELD:
	ADDA	HFROP*2-2
	COUNT	HFIELD
FIELD1:
	COPY	1,NORM
	RP	FIELD1
	ADDA	HBAP*2
	COPY	HSYNCW,<HSYNCW DUP (HSYNC)>
	COPY	1,LDCNTR
	RP	FIELD
	ENDTB	INIEND
;
;
PROG	ENDS
	END
,

N

