	.XLIST
	TITLE	RTC DRIVER GIFDIC COMPATIBLE
	PAGE	60,132

;
PGROUP	GROUP	PROG
DGROUP	GROUP	DATA
	ASSUME	CS:PGROUP,DS:DGROUP

;
;
	PUBLIC	RTCINIT,RTCREAD,RTCWRITE
;
	EXTRN	DATSEG:NEAR
;
;
	INCLUDE	\GIFI\SRC\GIFMAC.MAC
	INCLUDE	\SYSCON\SYSCON.EQU
	INCLUDE	\186\XINSTR.MAC
	PUBLIC	RTCTAB
	.LIST
;EQUATES M3000

RTCCMD	EQU	00000001		;WATCH RUNNING,PULSE OUTPUT 256 HZ

;
;
PROG	SEGMENT	BYTE PUBLIC 'PROG'
;
;	READ FROM,WRITE TO REAL TIME CLOCK CHIP
;
;ENTRY
;	ES:DI	USER BUFFER
;	CX	BYTE COUNT 0-15
;	DL	START ADDRESS 0-14
;
;	DESCRIPTION:
;	THIS ROUTINE TRANSFER #CX BYTES BETWEEN RTC RAM LOC #DL
;	AND A USER BUFFER ADDRESSED VIA ES:DI
;

RTCREAD	PROC	FAR
	MOV	DH,44H			;READ MODE,2 TRYS
	JMP	SHORT RTCRW0
RTCWRITE PROC	FAR
	MOV	DH,4			;WRITE MODE,2 TRYS
RTCRW0:
	XOR	CH,CH
	MOV	BYTE PTR RTCERR,CH	;RES ERROR STATUS
	JCXZ	RTCTEST0		;EXIT IF NO DATA REQUESTED
	MOV	AH,DL			;CHECK FOR COUNT+START<15
	ADD	AH,CL
	CMP	AH,16			;IF <16
	JB	RTCRW1			;CONTINUE
	MOV	AH,DEVOVR		;ELSE FLAG ERROR
	STC
RTCTEST0:
	RET
RTCRW1:
	PUSH	AX
RTCRW11:
	PUSH	DI			;SAVE BUFFER POINTER POINTER
	PUSH	CX
	MOV	AH,DL			;GET START ADDRESS
	XOR	BH,BH			;CLEAR CHECKSUM
RTCRW2:
	TEST	DH,60H			;IF READ OR CMP MODE
	JNZ	RTCRW21			;READ
	MOV	BL,ES:[DI]		;ELSE 	OUTPUT DATA
	ADD	BH,BL			;ADD UP CHECKSUM
	CALL	RTCWR
	XOR	AL,AL
	JMP	SHORT RTCRW31
RTCRW21:
	CALL	RTCRD			;READ
	ADD	BH,AL			;ADD UP CHECKSUM
	TEST	DH,20H			;IF COMPARE
	JNZ	RTCRW3			;COMPARE
	MOV	ES:[DI],AL		;STORE DATA
RTCRW3:
	CMP	AL,ES:[DI]		;COMPARE
RTCRW31:
	PUSHF
	INC	DI
	inc	ah			; increment address
	POPF
	LOOPZ	RTCRW2			;AND LOOP IF MATCH
	POP	CX
	POP	DI
	JNZ	RTCRW4			;IF NO MATCH - TRY AGAIN
	TEST	DH,20H			;ELSE IF DATA NOT COMPARED
	JNZ	RTCRW5
	OR	DH,20H			;FLAG COMPARE MODE
	JMP	RTCRW11			;AND COMPARE
RTCRW4:
	AND	DH,4FH			;DISABLE COMPARE MODE
	DEC	DH			;IF NOT RETRYED
	TEST	DH,2
	JNZ	RTCRW11			;LOOP
	STC
	POP	AX
	MOV	AH,DEAD			;ELSE FLAG RTC FAILURE
	RET				;AND EXIT
RTCRW5:
	TEST	DL,8			;IF CLOCK ACCESSED
	JZ	RTCRW6			;DONT PERFORM CHECKSUM TEST
	MOV	AL,BH			;GET 8 BIT CHECKSUM
	MOV	BL,BH			;CALCULATE CHECKSUM (2 BITS)
	SHRAX	2
	ADD	BX,AX
	SHRAX	2
	ADD	BX,AX
	SHRAX	2
	ADD	BX,AX
	SHLBL	5
	MOV	BH,BL			;COMPLEMENT ONE BIT TO
	AND	BH,40H			;DETECT ALL ZEROS AND ALL ONES ERRORS
	NOT	BL
	AND	BL,20H
	OR	BL,BH
	ADD	BL,RTCCMD
	MOV	AH,15			;CHECKSUM IS STORED IN COMMAND WORD
	TEST	DH,40H			;IF READ MODE
	JNZ	RTCRW51			;CHECK CHECKSUM
	CALL	RTCWR			;ELSE STORE CHECKSUM
	JMP	SHORT RTCRW6
RTCRW51:
	CALL	RTCRD
	AND	AL,0F3H			;IGNORE FLAG BITS
	CMP	AL,BL			;IF EQUAL
	JZ	RTCRW6			;EXIT
	POP	AX
	MOV	AH,PARERR		;ELSE FLAG DATA ERROR
	STC
	RET
RTCRW6:
	POP	AX
	TEST	BYTE PTR RTCERR,0FFH	;IF HW ERROR 
	JZ	RTCRW7
	MOV	AH,BYTE PTR RTCERR	;GET CODE
	STC				;FLAG
RTCRW7:
	RET
RTCWRITE ENDP
RTCREAD	ENDP
;
;
RTCSTAT	PROC
	MOV	DX,RTCIO		;RTC IO ADDRESS
	CLI
	IN	AL,DX
	AND	AL,0FH			;IF BUSY
	JNZ	RTCBSY			;EXIT
	MOV	AL,12 			;WAIT 32 USEC
RTCWLP:
	DEC	AL
	JNZ	RTCWLP
	IN	AL,DX			;TEST SECOND TIME FOR NOT BUSY
	AND	AL,0FH
	JNZ	RTCBSY
	RET
RTCBSY:
	STI				;SERVICE INTERUPTS
	JMP	RTCSTAT			;AND CHECK STATUS AGAIN
RTCSTAT	ENDP
;
;
;
RTCWR	PROC
	push	cx
	mov	cx,2
rtcwt:
	PUSH	DX
	CALL	RTCSTAT
	MOV	AL,AH			;OUTPUT ADDRESS
	OUT	DX,AL
	MOV	AL,BL
	SHR	AL,1
	SHR	AL,1
	SHR	AL,1
	SHR	AL,1
	OUT	DX,AL
	MOV	AL,BL			;LSD
	NOP
	NOP
	NOP
	OUT	DX,AL
	POP	DX
	STI
	PUSH	BX
	call	rtcrd
	POP	BX
	cmp	byte ptr es:[di],bl
	jz	rtcwex
	cmp	ah,15
	jz	rtcwex
	loop	rtcwt
rtcwex:
	pop	cx
	RET
RTCWR	ENDP
;
;
RTCRD	PROC
	push	bx
	push	cx
	mov	cx,2
rdloop:
	call	rdrtc
	push	ax
	call	rdrtc
	pop	bx
	cmp	al,bl
	jz 	readok
	loop	rdloop
readok:
	pop	cx
	pop	bx
	ret

rdrtc:
	PUSH	DX
	PUSH	BX
	CALL	RTCSTAT
	MOV	AL,AH			;OUTPUT ADDRESS
;	INC	AH
	OUT	DX,AL
	NOP
	NOP
	NOP
	IN	AL,DX			;INPUT MSD
	SHL	AL,1
	SHL	AL,1
	SHL	AL,1
	SHL	AL,1
	AND	AL,0F0H
	MOV	BL,AL
	IN	AL,DX			;INPUT LSD
	AND	AL,0FH
	OR	AL,BL
	POP	BX
	POP	DX
	STI
	RET
RTCRD	ENDP
;
;
;
RTCWRV	PROC	NEAR			;RTC WRITE WITH VERIFY
	PUSH	CX
	MOV	CX,3			;THREE TRYS
RTCWRV1:
	CALL	RTCWR			;WRITE
	CALL	RTCRD			;READ BACK
	CMP	BL,AL			;IF EQUAL
	JZ	RTCWRV2			;EXIT
	DEC	AH			;ELSE RETRY
	LOOP	RTCWRV1
	MOV	RTCERR,DEAD		;FLAG ERROR RTC CHIP DOES NOT RESPOND
	STC
RTCWRV2:
	POP	CX
	RET
RTCWRV	ENDP
;
;
;
RTCINIT	PROC	FAR
	XOR	DX,DX			;NO DYNAMIC MEMORY
	XOR	AH,AH
	STC
	RET
RTCINIT	ENDP
;
;
;
;
;
READTIM	PROC
	MOV	SI,OFFSET DGROUP: RTCTBUFF;TEMP BUFFER RTC DATA
	MOV	AH,0			;ADDRESS COUNTER FOR RTC FILE
	MOV	CX,8			;READ IN ONLY TIME
RTCTLP:
	CALL	RTCRD			;READ ONE BYTE FROM RTC
	JNC	RTCBSY1
	MOV	[SI],AL
	INC	SI
	LOOP	RTCTLP			;LOOP UNTIL ALL BYTES READ
	SUB	SI,8
	MOV	AH,0
	CALL	RTCRD			;READ SECONDS AGAIN
	CMP	AL,[SI]			;VERIFY WITH VALUE IN BUFFER
	JNZ	RTCBSY1			;IF NOT EQUAL THEN IGNORE ALL DATA
	MOV	AX,DS
	MOV	ES,AX

	MOV	DI,OFFSET DGROUP: RTCMBUFF;ELSE UPDATE MAIN BUFFER
	CLD
	MOV	CL,4
RDT1:
	CLD
	LODSW
	STOSW
	LOOP	RDT1
	STC				;FLAG TIME UPDATED
RTCBSY1:
	RET
READTIM	ENDP
;
RTCTAB:
	DW	9*64+6
	DW	OFFSET PGROUP:RTCINIT
	DW	0FFFFH
	DW	0FFFFH
	DW	0FFFFH
	DW	OFFSET PGROUP:RTCREAD
	DW	OFFSET PGROUP:RTCWRITE
	DW	0FFFFH
;
PROG	ENDS
DATA	SEGMENT	WORD PUBLIC 'DATA'
RTCTBUFF DW	4 DUP (?)
RTCMBUFF DW	4 DUP (?)
RTCERR	DB	?
DATA	ENDS
	END



