TITLE	KB Driver Tables

if1
%out Pass 1...
endif
if2
%out Pass 2...
endif

pgroup group prog

public ignore, ctsize
ctsize		equ chreot-chrtab
ignore		equ 0ffh
dummy		equ ignore
ctrl_c		equ 03h
bs		equ 08h
tab		equ 09h
lf		equ 0ah
cr		equ 0dh
esc		equ 1bh
del		equ 7fh


etab	macro	chr
	db	0c0h-'A'+chr
endm


ftab	macro	fun
	db	80h+(fun-funtab)/2
endm

prog segment byte public 'prog'
	extrn shift_lock:near, shift_release:near, warmboot:near
	extrn	setups:near,disscrl:near,shome:near,fbreak:near
	public chrtab, funtab
	assume cs:pgroup

chrtab:

%out (0,0)
; (Control,Shift)=(0,0)
	etab	'E'		; 01	F5
	etab	'B'		; 02	Down cursor
	db	'\'		; 03
	db	cr		; 04
	db	':'		; 05
	db	'/'		; 06
	etab	'A'		; 07
	etab	'A'		; 08	Up cursor
	db	'9'		; 09
	db	'p'		; 0A
	db	'j'		; 0B
	db	'n'		; 0C
	etab	'G'		; 0D	F7
	ftab	fbreakk		; 0E	Break
	db	tab		; 0F
	db	'8'		; 10
	db	'4'		; 11
	db	lf		; 12
	etab	'C'		; 13	F3
	ftab	sup		; 14	Set up
	db	'-'		; 15
	db	']'		; 16
	db	'l'		; 17
	db	','		; 18
	etab	'F'		; 19
	etab	'C'		; 1A	Cursor right
	db	bs		; 1B
	db	'7'		; 1C
	db	'@'		; 1D
	db	dummy		; 1E
	etab	'B'		; 1F	F2
	db	dummy		; 20
	db	'0'		; 21
	db	'['		; 22
	db	'k'		; 23
	db	'm'		; 24
	etab	'H'		; 25	F8
	db	esc		; 26
	db	'q'		; 27
	db	'9'		; 28
	db	'5'		; 29
	db	'1'		; 2A
	etab	'D'		; 2B	F4
	etab	'D'		; 2C	Left cursor
	db	'^'		; 2D
	db	del		; 2E
	db	';'		; 2F
	db	'.'		; 30
	etab	'M'		; 31	F13
	db	'5'		; 32
	db	'y'		; 33
	db	'd'		; 34
	db	'x'		; 35
	db	' '		; 36
	etab	'I'		; 37	F9
	db	'1'		; 38
	db	'w'		; 39
	db	'+'		; 3A
	db	'6'		; 3B
	db	'2'		; 3C
	etab	'O'		; 3D	F15
	db	'7'		; 3E
	db	'i'		; 3F
	db	'g'		; 40
	db	'v'		; 41
	db	'.'		; 42
	etab	'K'		; 43	F11
	db	'3'		; 44
	db	'r'		; 45
	db	'a'		; 46
	db	dummy		; 47
	db	cr		; 48
	etab	'N'		; 49	F14
	db	'6'		; 4A
	db	'u'		; 4B
	db	'f'		; 4C
	db	'c'		; 4D
	db	'0'		; 4E
	etab	'J'		; 4F	F10
	db	'2'		; 50
	db	'e'		; 51
	db	dummy		; 52
	db	'-'		; 53
	db	'3'		; 54
	ftab	home		; 55
	db	'8'		; 56
	db	'o'		; 57
	db	'h'		; 58
	db	'b'		; 59
	db	dummy		; 5A
	etab	'L'		; 5B	F12
	db	'4'		; 5C
	db	't'		; 5D
	db	's'		; 5E
	db	'z'		; 5F
	ftab	shft_rls	; 60	Shift Release

%out (0,1)
; (Control,Shift)=(0,1)
	etab	'E'		; 01    F5
	db	ignore		; 02	Down cursor
	db	'|'		; 03
	db	cr		; 04
	db	'*'		; 05
	db	'?'		; 06
	etab	'A'		; 07
	db	ignore		; 08	Up cursor
	db	')'		; 09
	db	'P'		; 0A
	db	'J'		; 0B
	db	'N'		; 0C
	etab	'G'		; 0D	F7
	ftab	fbreakk		; 0E	Break
	db	tab		; 0F
	db	'8'		; 10
	db	'4'		; 11
	db	lf		; 12
	etab	'C'		; 13	F3
	db	ignore		; 14	Set up
	db	'='		; 15
	db	'}'		; 16
	db	'L'		; 17
	db	'<'		; 18
	etab	'F'		; 19
	etab	'P'		; 1A	Cursor right
	db	bs		; 1B
	db	'7'		; 1C
	db	'@'+20H		; 1D
	db	dummy		; 1E
	etab	'B'		; 1F	F2
	db	dummy		; 20
	db	'_'		; 21
	db	'{'		; 22
	db	'K'		; 23
	db	'M'		; 24
	etab	'H'		; 25	F8
	db	esc		; 26
	db	'Q'		; 27
	db	'9'		; 28
	db	'5'		; 29
	db	'1'		; 2A
	etab	'D'		; 2B	F4
	etab	'M'		; 2C	Left cursor
	db	'~'		; 2D
	db	del		; 2E
	db	'+'		; 2F
	db	'>'		; 30
	etab	'M'		; 31	F13
	db	'%'		; 32
	db	'Y'		; 33
	db	'D'		; 34
	db	'X'		; 35
	db	' '		; 36
	etab	'I'		; 37	F9
	db	'!'		; 38
	db	'W'		; 39
	db	'+'		; 3A
	db	'6'		; 3B
	db	'2'		; 3C
	etab	'O'		; 3D	F15
	db	"'"		; 3E
	db	'I'		; 3F
	db	'G'		; 40
	db	'V'		; 41
	db	'.'		; 42
	etab	'K'		; 43	F11
	db	'#'		; 44
	db	'R'		; 45
	db	'A'		; 46
	db	dummy		; 47
	db	cr		; 48
	etab	'N'		; 49	F14
	db	'&'		; 4A
	db	'U'		; 4B
	db	'F'		; 4C
	db	'C'		; 4D
	db	'0'		; 4E
	etab	'J'		; 4F	F10
	db	'"'		; 50
	db	'E'		; 51
	db	dummy		; 52
	db	'-'		; 53
	db	'3'		; 54
	ftab	home		; 55
	db	'('		; 56
	db	'O'		; 57
	db	'H'		; 58
	db	'B'		; 59
	db	dummy		; 5A
	etab	'L'		; 5B	F12
	db	'$'		; 5C
	db	'T'		; 5D
	db	'S'		; 5E
	db	'Z'		; 5F
	ftab	shft_lck	; 60	Shift Lock

%out (1,0)
; (Control,Shift)=(1,0)
	etab	'E'		; 01    F5
	db	ignore		; 02	Down cursor
	db	'`'-40h		; 03
	db	cr		; 04
	db	ignore		; 05
	db	ignore		; 06
	etab	'A'		; 07
	db	ignore		; 08	Up cursor
	db	ignore		; 09
	db	'P'-40h		; 0A
	db	'J'-40h		; 0B
	db	'N'-40h		; 0C
	etab	'G'		; 0D	F7
	db	ctrl_c		; 0E
	db	ignore		; 0F
	db	'8'-40h		; 10
	db	'4'-40h		; 11
	db	ignore		; 12
	etab	'C'		; 13	F3
	ftab	wmbt		; 14	Set up#
	db	ignore		; 15
	db	']'-40h		; 16
	db	'L'-40h		; 17
	db	ignore		; 18
	etab	'F'		; 19
	etab	'P'		; 1A	Cursor right
	db	ignore		; 1B
	db	ignore		; 1C
	db	'@'-40h		; 1D
	db	dummy		; 1E
	etab	'B'		; 1F	F2
	db	dummy		; 20
	db	ignore		; 21
	db	'['-40h		; 22
	db	'K'-40h		; 23
	db	'M'-40h		; 24
	etab	'H'		; 25	F8
	db	esc		; 26
	db	'Q'-40h		; 27
	db	ignore		; 28
	db	ignore		; 29
	db	ignore		; 2A
	etab	'D'		; 2B	F4
	etab	'M'		; 2C	Left cursor
	db	'^'-40h		; 2D
	db	del-40h		; 2E
	db	ignore		; 2F
	db	ignore		; 30
	etab	'M'		; 31	F13
	db	ignore		; 32
	db	'Y'-40h		; 33
	db	'D'-40h		; 34
	db	'X'-40h		; 35
	ftab	nscrl		; 36
	etab	'I'		; 37	F9
	db	ignore		; 38
	db	'W'-40h		; 39
	db	ignore		; 3A
	db	ignore		; 3B
	db	ignore		; 3C
	etab	'O'		; 3D	F15
	db	ignore		; 3E
	db	'I'-40h		; 3F
	db	'G'-40h		; 40
	db	'V'-40h		; 41
	db	ignore		; 42
	etab	'K'		; 43	F11
	db	ignore		; 44
	db	'R'-40h		; 45
	db	'A'-40h		; 46
	db	dummy		; 47
	db	cr		; 48
	etab	'N'		; 49	F14
	db	ignore		; 4A
	db	'U'-40h		; 4B
	db	'F'-40h		; 4C
	db	'C'-40h		; 4D
	db	ignore		; 4E
	etab	'J'		; 4F	F10
	db	ignore		; 50
	db	'E'-40h		; 51
	db	dummy		; 52
	db	ignore		; 53
	db	ignore		; 54
	db	ignore		; 55
	db	ignore		; 56
	db	'O'-40h		; 57
	db	'H'-40h		; 58
	db	'B'-40h		; 59
	db	dummy		; 5A
	etab	'L'		; 5B	F12
	db	ignore		; 5C
	db	'T'-40h		; 5D
	db	'S'-40h		; 5E
	db	'Z'-40h		; 5F
	db	dummy		; 60

%out (1,1)
; (Control,Shift)=(1,1)
	etab	'E'		; 01    F5
	db	ignore		; 02	Down cursor
	db	'|'-40h		; 03
	db	cr		; 04
	db	ignore		; 05
	db	ignore		; 06
	etab	'A'		; 07
	db	ignore		; 08	Up cursor
	db	ignore		; 09
	db	'P'-40h		; 0A
	db	'J'-40h		; 0B
	db	'N'-40h		; 0C
	etab	'G'		; 0D	F7
	db	ctrl_c		; 0E
	db	ignore		; 0F
	db	ignore		; 10
	db	ignore		; 11
	db	ignore		; 12
	etab	'C'		; 13	F3
	ftab	wmbt		; 14	Set up
	db	ignore		; 15
	db	'}'-40h		; 16
	db	'L'-40h		; 17
	db	ignore		; 18
	etab	'F'		; 19
	etab	'P'		; 1A	Cursor right
	db	ignore		; 1B
	db	ignore		; 1C
	db	'@'-40h		; 1D
	db	dummy		; 1E
	etab	'B'		; 1F	F2
	db	dummy		; 20
	db	ignore		; 21
	db	'{'-40h		; 22
	db	'K'-40h		; 23
	db	'M'-40h		; 24
	etab	'H'		; 25	F8
	db	esc		; 26
	db	'Q'-40h		; 27
	db	ignore		; 28
	db	ignore		; 29
	db	ignore		; 2A
	etab	'D'		; 2B	F4
	etab	'M'		; 2C	Left cursor
	db	'~'-40h		; 2D
	db	del-40h		; 2E
	db	ignore		; 2F
	db	ignore		; 30
	etab	'M'		; 31	F13
	db	ignore		; 32
	db	'Y'-40h		; 33
	db	'D'-40h		; 34
	db	'X'-40h		; 35
	ftab	nscrl		; 36
	etab	'I'		; 37	F9
	db	ignore		; 38
	db	'W'-40h		; 39
	db	ignore		; 3A
	db	ignore		; 3B
	db	ignore		; 3C
	etab	'O'		; 3D	F15
	db	ignore		; 3E
	db	'I'-40h		; 3F
	db	'G'-40h		; 40
	db	'V'-40h		; 41
	db	ignore		; 42
	etab	'K'		; 43	F11
	db	ignore		; 44
	db	'R'-40h		; 45
	db	'A'-40h		; 46
	db	dummy		; 47
	db	cr		; 48
	etab	'N'		; 49	F14
	db	ignore		; 4A
	db	'U'-40h		; 4B
	db	'F'-40h		; 4C
	db	'C'-40h		; 4D
	db	ignore		; 4E
	etab	'J'		; 4F	F10
	db	ignore		; 50
	db	'E'-40h		; 51
	db	dummy		; 52
	db	ignore		; 53
	db	ignore		; 54
	db	ignore		; 55
	db	ignore		; 56
	db	'O'-40h		; 57
	db	'H'-40h		; 58
	db	'B'-40h		; 59
	db	dummy		; 5A
	etab	'L'		; 5B	F12
	db	ignore		; 5C
	db	'T'-40h		; 5D
	db	'S'-40h		; 5E
	db	'Z'-40h		; 5F
	db	dummy		; 60
chreot:

funtab:
shft_lck	dw	offset pgroup:shift_lock
shft_rls	dw	offset pgroup:shift_release
wmbt		dw	offset pgroup:warmboot
sup		dw	offset pgroup:setups
nscrl		dw	offset pgroup:disscrl
home		dw	offset pgroup:shome
fbreakk		dw	offset pgroup:fbreak
prog ends

end
