	PAGE	60,132
TEST	EQU	0
CNTRLCNST EQU	192
SHIFTCNST EQU	96

KBBRK	EQU	4		;NUMBER OF TICKS PER BIT OF THE KB
KBCBITS	EQU	10	;DATA BITS KEY BOARD
ETX	EQU	3
	EXTRN	PKNMX:ABS
	INCLUDE	\GIFI\SRC\GIFMAC.MAC
;
;
;
PGROUP	GROUP	PROG
DGROUP	GROUP	DATA
	ASSUME	CS:PGROUP,DS:DGROUP
;
DATA	SEGMENT WORD PUBLIC 'DATA'
	PUBLIC	KBMODE
KBMODE	DW	?		;COLEXKB ENABLE SWITCH
PKMODE	DW	?		;PEKOR MODE SWITCH
PKDATA	DW	?		;PEKOR DATA
KBPROC	DW	?		;PROC ADDRES KB
KBDATA	DW	?
KBBITS	DB	?		;BIT COUNTER KB
KBELAY DB	?		;DELAY COUNTER KB
PKCOUNT	DB	?		;PEKOR BIT COUNTER
DATA	ENDS
;
;
;
	INCLUDE	\SYSCON\SYSCON.EQU
	INCLUDE	\186\186.EQU
	INCLUDE	\186\XINSTR.MAC
	INCLUDE	\186\MPROC.MAC
PROG	SEGMENT BYTE PUBLIC 'PROG'
;

	PUBLIC	KBINIT
;
	EXTRN	PUT_BUFF:NEAR,DATSEG:WORD,PKREC:NEAR
;
;
;
KBSERVICE	PROC
KBTEST:
	MOV	DX,SYSSTAT	;STATUS PORT SYSCON
	IN	AX,DX		;CHECK FOR START BIT
	AND	AX,1 SHL DINKB ;IF NO START BIT
	RET
;
KBDELAY:
	DEC	KBELAY
	JNZ	KBDELAY1
	MOV	BYTE PTR KBELAY,KBBRK
KBDELAY1:
	RET
;
KBROUT:
	JMP	WORD PTR KBPROC	;EXECUTE KEYBOARD ROUTINE
KBINIT:
	INITVC	INT1VC,PKINPUT
	MOV	WORD PTR KBMODE,OFFSET PGROUP: KBROUT ;INIT FOR COLEX K KB
	MOV	WORD PTR PKMODE,OFFSET PGROUP:PKINIT
KBINIT1:
	MOV	BYTE PTR KBELAY,KBBRK
	MOV	BYTE PTR KBBITS,KBCBITS
	MOV	WORD PTR KBPROC,OFFSET PGROUP: KBWAIT ;INIT FOR STARTBIT
	RET
;
KBWAIT:
	CALL	KBTEST
	JNZ	NO_START_BIT	;WAIT FOR START BIT
	MOV	KBDATA,0
	MOV	WORD PTR KBPROC,OFFSET PGROUP: STBCHECK ;ELSE CHECK STARTBIT
NO_START_BIT:
	RET
;
STBCHECK:			;CHECK FOR VALID STARTBIT
	CALL	KBTEST		;IF STARTBIT NOT VILID
	JNZ	KBINIT1	;IGNORE AND REINIT FOR STARTBIT
	MOV	WORD PTR KBPROC,OFFSET PGROUP: INPUT_DATA ;THEN INPUT DATA
TSTSTRTBIT:
	RET			
;
INPUT_DATA:
	CALL	KBDELAY	;WAIT FOR TIME TO SAMPLE DATA
	JNZ	INPUT_DATA1
	CALL	KBTEST
	OR	WORD PTR KBDATA,AX ;STORE
	SHR	WORD PTR KBDATA,1 
	DEC	BYTE PTR KBBITS ;IF NOT ALL BITS SHIFTED IN
	JNZ	INPUT_DATA1	;THEN LOOP
	MOV	WORD PTR KBPROC,OFFSET PGROUP: STOP_BIT ;ELSE CHECK STOP BIT
INPUT_DATA1:
	RET
;
STOP_BIT:
	CALL	KBTEST
	JZ	KBINIT1	;IF NO STOP BIT THEN IGNORE DATA
	MOV	WORD PTR KBPROC,OFFSET PGROUP:INPUT_DATA1
	MOV	AX,WORD PTR KBDATA
	MOV	CX,DINKB-KBCBITS
	SHR	AX,CL
	AND	AX,1FFH
	JZ	KBINIT1
	CMP	AX,4*96H
	JG	KBINIT1
	CALL	KBINIT1
	CALL	PUT_BUFF
	RET
KBSERVICE ENDP

PKINPUT	PROC	NEAR		;DATA INPUT FOR PEKOR KEYBOARD
	PUSHA
	PUSH	DS
	PUSH	ES
	MOV	DS,CS:DATSEG
	JMP	WORD PTR PKMODE ;BRANCH 

PKINIT:					;INIT FOR PEKOR KEYBOARD
	MOV	KBMODE,OFFSET PGROUP:COLEXDIS ;DISABLE COLEX KEYBOARD
	MOV	PKMODE,OFFSET PGROUP:PKREAD ;SWITCH TO READ MODE
	MOV	PKCOUNT,8	;INIT COUNTER
PKREAD:					;READ AND STORE ONE BIT FROM KEYBOARD
	CALL	KBTEST
	OR	AX,PKDATA
	SHR	AX,1
	MOV	PKDATA,AX
	DEC	PKCOUNT		;BIT COUNTER -1
	JNZ	PKREAD1		;EXIT IF NOT ALL DATA BITS
	MOV	PKMODE,OFFSET PGROUP:PKSTOP ;ELSE GET STOP BIT
PKREAD1:
	EOI	INT1VC		;REENABLE INTERUPT
	POP	ES
	POP	DS
	POPA
	IRET
COLEXDIS:
	RET

PKSTOP:					;GET STOP BIT AND TRANSLATE DATA
	CALL	KBTEST
	JZ	PKREAD1		;IGNORE DATA IF NO STOP BIT
	MOV	PKCOUNT,8	;SET COUNT AGAIN
	MOV	PKMODE,OFFSET PGROUP:PKREAD ;READ MODE AGAIN
	EOI 	INT1VC
	XOR	AX,AX
	XCHG	AX,PKDATA	;ELSE GET DATA
	STI
	SHRAX	4
	DEC	AX
	MOV	AH,AL
	AND	AL,7FH
	CMP	AL,PKNMX
	JNB	PKREAD1
	MOV	AL,AH
	AND	AX,0FFH
	CALL	PKREC
	JMP	PKREAD1
PKINPUT	ENDP

PROG	ENDS
	END	
E