	.XLIST
	TITLE	BOOT GIFTIC PROM
	INCLUDE	\GIFI\SRC\RCD0.S86
	INCLUDE \GIFI\SRC\GIFMAC.MAC
;
;
DGROUP	GROUP	DATA
DATA	SEGMENT	WORD PUBLIC 'DATA'
	ASSUME	DS:DGROUP
	EXTRN	DELTAB:WORD,MEMEND:WORD
	PUBLIC	OSNR
OSNR	DB	?
DATA	ENDS
;
;
PGROUP	GROUP	PROG
PROG	SEGMENT	BYTE PUBLIC 'PROG'
	ASSUME CS:PGROUP
;
;
	PUBLIC	IBOOT
;
;
;
;
WAITT	EQU	3000	;30 SECONDS

	.LIST
	EXTRN	SEL:NEAR,RSASI:NEAR,GIFDIC:FAR,MRSASI:NEAR
;
;
;	FNDCON LOOKS FOR CONTROLLERS CONNECTED TO THE SASI BUS
;
;	CONTROLLER MAP:
;	0	XEBEC
;	1	XEBEC
;	2	LFLP/XFLP
;
;	EXIT:
;		BL BITS 0-2 ARE REPRESENTING CONTROLLERS 0-2
;		BH CONTAINS # DRIVES ASSUMED
;
;	DRIVE 	MAP:
;
;	IF FLOPPY CONTROLLER FOUND THEN 2 FLOPPYS ARE ASSUMED
;	IF ONE XEBEC HAS BEEN FOUND THEN IT IS ASSUMED THAT
;	TWO HARD DISK DRIVES ARE CONNECTED TO IT
;	IF TO XEBEC HAVE BEEN FOUND THEN EACH XEBEC IS SUPPOSED
;	TO HAVE ONE DISK DRIVE CONNECTED TO IT 
;	THESE DRIVES HAVE TO BE UNIT 0
;
;
FNDCON	PROC	NEAR
	XOR	SI,SI	;NO DRIVES,CONTROLLERS
	MOV	CL,0	;SEL CONNTROLLER
	CALL	SEL
	JB	FNDCON1	;SKIP IT IF NOT THERE
	CALL	RSASI
	OR	SI,211H	;ELSE FLAG 2 UNITS,1ST XEBEC
FNDCON1:
	MOV	CL,1
	CALL	SEL
	JB	FNDCON2
	CALL	RSASI
	OR	SI,222H	;2CND XEBEC
FNDCON2:
	MOV	CL,2	;FLOPPY
	CALL	SEL
	JB	FNDCON3
	CALL	RSASI
	ADD	SI,204H
FNDCON3:
	RET
FNDCON	ENDP
;
;RDRCD0	READS RECORD 0 OF DRIVE #AL INTO TEMP BUFFER DS:[MEMEND]
;
;ENTRY:
;	AL DRIVE NUMBER
;EXIT:
;	ES:DI ARE POINTING TO BUFFER
;
;REMARK:	THIS ROUTINE LOADS WITHOUT CARE BEHIND GIFDIC DATA AREA
;
;
;
RDRCD0	PROC	NEAR
	PUSH	DS
	POP	ES
	MOV	DI,MEMEND	;POINT TO FREE MEMORY
	XOR	DX,DX		;RCD 0
;!!!!!!!!!!!
;	MOV	DX,24H
;	MOV	DI,0F000H
	MOV	CX,1
	PUSH	AX
	GIFCALL	DSKDEV,READ,0
	POP	AX
	RET
RDRCD0	ENDP
;
;
SOSM:
	MOV	CX,1000H
SOSM1:
	PUSH	DX
	PUSH	AX
	PUSH	DI
	MOV	DX,6
	XOR	DI,DI
	XOR	BP,BP
	MOV	ES,BP
	GIFCALL	DSKDEV,SSTATUS,0
	POP	DI
	POP	AX
	POP	DX
	RET
;
;
;INICON	SELECTS CONTROLLER TYPE FROM HARD DISK AND EXECUTES
;INITIALISATION AND DIAGNOSTICS
;
;
INICON	PROC	NEAR
	CMP	WORD PTR[DI.IFLAG],055FFH ;CHECK FOR VALID INIT FLAG
	JNZ	INICON31
	CMP	WORD PTR[DI.IFLAGH],0AAH
INICON31:
	JNZ	INICON3
	PUSH	DI
	MOV	BX,[DI.HPN]
	MOV	AH,BYTE PTR[BX+DI.HPN]
	MOV	BX,[DI.CPN]	;POINT TO CONTROLLER PARAMETER TABLE
	ADD	BX,CPN
	ADD	DI,BX
	XOR	CX,CX
INICON1:
	ADD	DI,2
	MOV	CL,[DI-1]
	CMP	AH,[DI-2]	;IF NOT RIGHT TABLE
	JNZ	INICON2		;LOOKUP NEXT TABLE
;!!!!!!!!!
	MOV	CX,DX
	MOV	DL,8		;INIT XEBEC 
	PUSH	DS
	POP	ES
	PUSH	DX
	GIFCALL	DSKDEV,SSTATUS,0
	POP	DX
	MOV	DL,0AH
	GIFCALL	DSKDEV,SSTATUS,0
	POP	DI
	ADD	DI,NOSM+1		;INIT OSMAP
	MOV	CL,OSNR
	CMP	CL,BYTE PTR[DI-1]	;CHECK FOR VALID OS
	JNBE	INICON3		;MAP DISK OUT IF ILLEGAL MAP
INICON4:
	PUSH	AX
	MOV	AL,OSM1-OSM0	;LENGTH ENTRY
	MUL	CL
	ADD	DI,AX		;POINT TO IT
	POP	AX
	CMP	WORD PTR [DI],0FFFFH	;IF NOT VALID
	JZ	INICON3		;DONT MAP UNIT
	MOV	ES,[DI]		;BOOT SETOR OFFSET
	MOV	DH,[DI+6]	;UPPER OS START ADDRESS
	MOV	AH,[DI+10]	;UPPER IMAGE SIZE
	MOV	CX,[DI+8]	;LOWER IMAGE SIZE
	MOV	DI,[DI+4]	;LOWER OS START ADDRESS
	MOV	DL,6		;SET OSMAP
	GIFCALL	DSKDEV,SSTATUS,AH
	RET
INICON2:
	ADD	DI,CX		;LOOK FOR NEXT TABLE
	CMP	BYTE PTR[DI],0FFH ;IF EOT
	JNZ	INICON1
INICON3:
	CLC
	RET			;CONTROLLER CAN NOT BE INIT
INICON	ENDP
;
;
;
;
;
;IDSK	INITS THE DISK HANDLER FOR:
;	EXISTING CONTROLLERS
;	ASSUMED DISK UNITS
;	ASUMMED NUMBER OF UNITS
;	ALL DRIVES ARE RESET
;
;ENTRY:
;	SI 	UPPER BYTE NUMBER OF UNITS
;		LOWER BYTE CONTROLLER BIT MAP
;		SI HAS BEEN SET BY FNDCON
;
;
SDSK:
	PUSH	CX
	PUSH	DX
	MOV	AL,DL
	MOV	DL,2
	GIFCALL	DSKDEV,SSTATUS,0	;SET DRIVE MAP
	JNB	SDSK1
	JMP	$
SDSK1:
	CALL	SOSM
	POP	DX
	INC	DX
	POP	CX
	INC	CX
	RET
;
;
IDSK	PROC	NEAR
	MOV	AL,4		;PRESET N UNITS
	CALL	IDSK5
	MOV	DX,4000H	;HD MEDIA
	TEST	SI,1		;TEST FOR FIRST XEBEC
	JZ	IDSK1		;IGNORE IT IF NOT THERE
	XOR	CX,CX		;ELSE INIT XEBEC ONE (U0)
	CALL	SDSK
IDSK1:
	TEST	SI,2		;LOOK FOR SCND XEBEC
	JZ	IDSK2
	MOV	CX,100H		;XEBEC  HAS ONE DRIVE (U0)
	CALL	SDSK
	TEST	SI,1		;IF XEBEC ONE DOES NOT EXIST
	JNZ	IDSK3
;	INC	DX
	JMP	IDSK21
;	JMP	SHORT IDSK3
IDSK2:
	TEST	SI,1		;IF XEBEC ONE EXIST
	JZ	IDSK3
IDSK21:
	CALL	SDSK		;IT HAS TWO DRIVES
IDSK3:
	TEST	SI,4		;IF FLOPPY
	JZ	IDSK4
	MOV	DH,50H		;INIT FOR 2 UNITS
	MOV	CX,200H
	CALL	SDSK
	CALL	SDSK
IDSK4:
	MOV	AX,SI
	MOV	AL,AH
IDSK5:
	MOV	DL,4		;INIT N UNITS
	GIFCALL	DSKDEV,SSTATUS,0
	RET
IDSK	ENDP
;
;
;
;IBOOT FINDS AND MAPS EXISTING CONTROLLERS ACCORDING TO THE
;FOLLOWING MAP
;
;	CONTROLLER NR 		TYPE ASSUMED
;
;	0			XEBEC
;	1			XEBEC
;	2			XFLP/LFLP
;
;IBOOT	READS BLOCK 0 OF READY HARD DISK DRIVES AND INITS
;XEBEC CONTROLLERS
;IF THERE ARE 2 XEBEC CONROLLERS THEN IBOOT WAITS FOR
;UP TO 30 SECONDS TO READ BLOCK 0 OF EACH DRIVE
;IF ANY DRIVE IS NOT READY WITHIN 30 SECONDS THE CORRESPONDING
;XEBEC WILL BE MAPPED OUT
;IF ONE XEBEC IS CONNECTED THEN IBOOT WAITS FOR UP TO 30 SECONDS
;TO READ BLOCK 0 OF DRIVE 0
;IT WILL MAP OUT THIS XEBEC IF DRIVE IS NOT READY WITHIN 30 SECONDS
;
IBOOT	PROC	NEAR
	MOV	AL,0FFH
	GIFCALL	DSKDEV,RESET,0	;RESET DRIVER
	CALL	FNDCON
	MOV	[DELTAB],WAITT
IBOOTLR:
	CALL	IDSK		;INIT CONTROLLERS,DISKHANDLER
IBOOTL:
	CMP	[DELTAB],0 	;IF TIMEOUT
	JZ	IBOOTOK		;EXIT
	XOR	AL,AL
	TEST	SI,1		;ELSE TEST FOR CONTROLLER THERE
	JZ	IBOOT2
	MOV	AH,0
	CALL	ICON
	JB	IBOOT2		;IF INIT FINISHED
	TEST	SI,20H		;IF NO SECOND CONTROLLER
	JNZ	IBOOT1
	CALL	ICON
	JB	IBOOT4
IBOOT1:
	AND	SI,32H
IBOOT2:
	TEST	SI,10H
	MOV	AL,1
	JNZ	IBOOT21
	DEC	AX
IBOOT21:
	TEST	SI,2
	JZ	IBOOT4
	MOV	AH,1
	CALL	ICON
	JB	IBOOT4
IBOOT3:
	AND	SI,31H
IBOOT4:
	TEST	SI,3
	JNZ	IBOOTL
IBOOTOK:
;	CALL	MRSASI		;INIT XEBEC CONTROLLERS
	RET
ICON:
	PUSH	AX
	CALL	SOSM
	PUSH	AX
	GIFCALL	DSKDEV,RESET,0	;RESET DRIVE
	MOV	DL,0		;CHECK MEDIA
	POP	AX
	PUSH	AX
	GIFCALL	DSKDEV,GSTATUS,0
	POP	AX
	JB	IBOOT6
	CALL	RDRCD0		;READ RECORD 0
	PUSHF
	XOR	CX,CX
	CALL	SOSM1
	POPF
	JNB	IBOOT5
	CMP	AH,NOTRDY	;WAIT ONLY IF NOT READY ERROR
	STC
	JNZ	IBOOT6
	XOR	AH,AH
	JMP	SHORT IBOOT6
IBOOT5:
	MOV	DX,AX
	CALL	INICON		;INIT CONROLLER
IBOOT6:
	POP	AX
	INC	AX
	RET
IBOOT	ENDP
;
PROG	ENDS
	END
