/**
*
* This module defines and initializes various decimal constants and work
* items.  The header file DEC.H contains external declarations for these
* items.  If you change any of the #defines here, you must also change 
* them in DEC.H and recompile the decimal arithmetic package.
*
**/

#define D_DIG 8			/* Maximum number of digit bytes */
#define D_MAX (D_DIG+2)		/* Maximum number of bytes */

char I0[3] = {1,0,0};		/* 0 constant */
char I1[3] = {1,1,0x10};	/* 1 constant */
char I2[3] = {1,1,0x20};	/* 2 constant */
char D5[3] = {1,0,0x50};	/* 0.5 constant */
char D05[3] = {1,-1,0x50};	/* 0.05 constant */
char D005[3] = {1,-2,0x50};	/* 0.005 constant */
char PI[10] = {			/* PI constant */
	8,1,0x31,0x41,0x59,0x26,0x53,0x60,0,0};
char E[10] = {			/* E constant (base of natural log) */
	8,1,0x27,0x18,0x28,0x18,0x28,0x45,0x90,0x45};
char PID2[10] = {		/* PI/2 constant */
	8,1,0x15,0x70,0x79,0x63,0x26,0x80,0,0};
char PIM2[10] = {		/* PI*2 constant */
	8,1,0x62,0x83,0x18,0x53,0x07,0x20,0,0};
char M[10] = {			/* 1/E constant */
	8,0,0x43,0x42,0x94,0x48,0x19,0x03,0x25,0x10};
char DPR[10] = {		/* degrees per radian */
	8,2,0x57,0x29,0x57,0x79,0x50,0,0,0};
char RPD[10] = {		/* radians per degree */
	8,-1,0x17,0x45,0x33,0,0,0,0,0};
char SR10[10] = {		/* square root of 10 */
	8,1,0x31,0x62,0x27,0x80,0,0,0,0};


char X[D_MAX] = {D_DIG,0};	/* Work areas */
char Y[D_MAX] = {D_DIG,0};
char Z[D_MAX] = {D_DIG,0};
char X1[D_MAX] = {D_DIG,0};
char Y1[D_MAX] = {D_DIG,0};
char Z1[D_MAX] = {D_DIG,0};

char FDEDIT = 0;		/* Non-zero to include dollar sign */
char FDTYPE = 0;		/* Non-zero if last cvfd input was E format */
