	page	60,132
	.xlist
	include gifdic.mac
	include 80186.mac
	.list
lf	equ	0ah
cr	equ	0dh
etx	equ	04h
esc	equ	01bh
pgroup	group	prog

prog	segment byte public 'prog'
	assume	cs:pgroup
;
;	Link this program to GIFDIC
;
begin:				; set up stack
	xor	cx,cx
	int	99h		; link up to GIFDIC
	mov	ax,es:[di.ghndlr]
	mov	cs:gifl,ax
	mov	ax,es:[di.spgroup]
	mov	cs:gifh,ax
start:	push	cs
	pop	ss
	mov	sp,offset pgroup:stacke
;
;	the main part of the program
;
main:
	mov	di,offset cs:signon	;sign on message
	call	ptext			; print it
retry:
	mov	si, 80h			; point to input buffer
	call	g_selct			; quit?
	cmp	al,03h			; quit?
	jnz	nxt1
	jmp	the_end
nxt1:	cmp	al,031h			; '1'?
	jnz	nxt2
	jmp	do_asgn
nxt2:	cmp	al,032h			; '2'?
	jnz	nxt3
	jmp	do_kvd
nxt3:	cmp	al,033h			; '3'?
	jnz	nxt4
	jmp	dte_do
nxt4:	cmp	al,034h			; '4'?
	jnz	nxt5
	jmp	do_dce
nxt5:	cmp	al,035h			; '5'?
	jz	do_ptr
	call	error_in
	jmp	main
;
error_in:
	mov	di, offset cs:got_error	; error message
	call	ptext
	ret
;
cr_chk:
	cmp	al,cr			; <CR>?
	jz	start			; y: start again
	ret				; n: return
g_selct:
	gifcall	scondev,read,waitrdy	; get a character
	and	al,7fh
	cmp	al,10h			; ^Q?
	jz	g_selct			; yes, ignore
	cmp	al,12h			; ^S?
	jz	g_selct			; yes, ignore
	cmp	al,7fh			; delete?
	jnz	g_echo			; n:
	mov	al,08h			; y: substitute b-space
g_echo:
	and	al,07fh			; seven bits
	push	ax
	gifcall	scondev,write,waitrdy	; echo it
	pop	ax
	cmp	al,cr			; <CR>?
	jnz	g_dolf			; n:
	push	ax			; save on stack again
	mov	al,lf			; y: echo lf as well
	gifcall scondev,write,waitrdy	; echo it
	pop	ax			; restore <CR>
	ret				; done
g_dolf:	cmp	al,lf			; <lf>?
	jnz	g_ne_ctr		; n: done
	mov	al,cr			; y: echo cr as well
	gifcall	scondev,write,waitrdy	; echo it
g_ne_ctr:
	ret
;
trmntr:
	call	g_selct			; get another character
	cmp	al,0dh			; <cr>?
	jz	trm_ok			; y:
	cmp	al,0ah			; <lf>?
trm_ok:
	ret
;'
do_ptr:
	mov	di,offset cs:prt_mes	; printer message
	call	ptext			; print it
retry_ptr:
	call	g_selct			; get selection
	call	cr_chk
	push	ax			; save selection
	call	trmntr			; valid terminator?
	jz	ptr_selok
	cmp	al,08h			; b-space?
	pop	ax
	jnz	ptr_err
	jmp	retry_ptr
ptr_selok:
	pop	ax
	cmp	al,031h			; '1' selected?
	jnz	try_ptr2
	mov	al,1
	jmp	set_ptr
try_ptr2:
	cmp	al,032h			; '2' selected?
	jz	ptr_sel2
ptr_err:
	call	error_in
	jmp	do_ptr
ptr_sel2:
	mov	al,0
set_ptr:
	mov	dl,slowds		; set strobe command
	gifcall	prtdev,sstatus,waitrdy
	jmp	main
;
do_dce:
	mov	di,offset cs:dce_mes	; DCE message
	call	ptext	
	mov	bx,dcedev
	call	g_baud
	jz	do_dce1
dce_err:
	call	error_in
	jmp	do_dce
;
do_dce1:
	mov	di,offset cs:bit_chr	; next message
	call	ptext			; print it
	call	g_selct			; get selection
	call	cr_chk
	cmp	al,020h
	jz	do_dce2
	nop

do_dce2:
	mov	di,offset cs:parity	; parity message
	call	ptext			; print it
	call	g_selct			; get selection
	call	cr_chk
	cmp	al,020h
	jz	do_dce3
	nop

do_dce3:
	mov	di,offset cs:xon_off	; xon/xoff message
	call	ptext
	call	g_selct			; get selection
	call	cr_chk
	cmp	al,020h
	jz	do_dce
;
;	Common DCE and DTE subroutines
;
g_baud:
	push	bx
	call	g_selct			; get selection
	call	cr_chk
	pop	bx
	cmp	al,020h
	jz	baud_done
	push	bx
	push	ax
	call	trmntr
	jz	baud_selok
	pop	ax
	pop	bx
	cmp	al,08h
	jnz	baud_done
	jmp	g_baud
baud_selok:
	pop	ax
	pop	bx
	cmp	al,030h
	jle	baud_done
	cmp	al,039h
	jge	baud_done

	and	al,0fh
	sub	al,1
	mov	dl,sbaudr
	gifcall	,sstatus,waitrdy
	xor	ax,ax
	cmp	ax,0
baud_done:
	ret
;
dte_do:
	mov	di,offset cs:dte_mes	; DTE message
	call	ptext			; print it
	mov	di,offset cs:ser_mes	; common serial message
	call	ptext			; print it
	mov	bx,dtedev
	call	g_baud
	jz	do_dte1
dte_err:
	call	error_in
	jmp	do_dte
do_dte1:
	mov	di,offset cs:bit_chr	; next message
	call	ptext
	call	g_selct			; get selection
	call	cr_chk
	cmp	al,020h
	jz	do_dte2
	nop

do_dte2:
	mov	di,offset cs:parity	; parity message
	call	ptext			; print it
	call	g_selct			; get selection
	call	cr_chk
	cmp	al,020h
	jz	do_dte3
	nop

do_dte3:
	mov	di,offset cs:xon_off	; xon/xoff message
	call	ptext			; print it
	call	g_selct			; get selection
	call	cr_chk
	cmp	al,020h
	jz	dte_do
	jmp	retry

;
do_kvd:
	mov	di,offset cs:kvd_mes	; KVD message
	call	ptext			; print it
	call	g_selct			; get selection
	call	cr_chk
	cmp	al,020h
	jz	do_kvd1
	nop

do_kvd1:
	mov	di,offset cs:kvd_opt	; kvd options message
	call	ptext			; print it
	call	g_selct			; get selection
	call	cr_chk

	jmp	retry
;
retr_asgn:
	call	error_in
do_asgn:
	mov di,offset cs:asgn_mes	; assign device message
	call	ptext
	mov	si,080h
	call	get_line
	mov	di,offset cs:pointer
	mov	word ptr cs:[di],81h
	call	get_logical
	push	ax
	call	get_byte
	call	get_physical
	pop	bx
	cmp	bx,SPRTDEV
	jz	is_prt
	cmp	al,3
	jc	set_it
	jmp	main
is_prt:
	cmp	al,0
	jnz	isprt
	jmp	retr_asgn
isprt:
	cmp	al,3
	jnz	not_lst
	mov	al,0
not_lst:
	cmp	al,3
	jc	set_it
	jmp	retr_asgn
set_it:
	mov	dl,SCON
	gifcall	,SSTATUS,NOOPT
	jmp	main
;
;	Return to MSDOS
;
the_end:
	mov	ax,4c00h	; exit command
	int	21h		; quit to MSDOS
;
;	PTEXT:
;		In:	DS:SI -> character string
;
ptext:
	mov	al,cs:[di]
	cmp	al,etx
	jz	pexit
	call	pbyte
	inc	di
	jmp	ptext
pexit:
	ret
pbyte:
	push	di
	gifcall	scondev,write,waitrdy
	pop	di
	ret
;
;	GETLINE:
;		In:	DS:SI -> input buffer
;
get_line:
	mov	byte ptr ds:[si],0
	mov	di,si
	inc	di
get_next:
	push	ds
	push	di
	gifcall	scondev,read,waitrdy
	cmp	al,0dh
	jnz	delete
	jmp	start
delete:
	cmp	al,7fh
	jnz	echo
	mov	al,08h
echo:
	and	al,07fh
	push	ax
	gifcall	scondev,write,waitrdy
	pop	ax
	pop	di
	pop	ds
	cmp	al,cr
	jnz	dolf
	mov	al,lf
	gifcall	scondev,write,waitrdy
	ret
dolf:
	cmp	al,lf
	jnz	doctr
	mov	al,cr
	gifcall	scondev,write,waitrdy
	ret
doctr:
	cmp	al,08h
	jnz	any_ctr
	dec	di
	cmp	di,si
	jz	get_line
	dec	byte	ptr ds:[si]
	jmp	get_next
any_ctr:
	cmp	al,20h
	jc	get_next
	mov	ds:[di],al
	inc	byte ptr ds:[si]
	inc	di
	cmp	byte ptr ds:[si],80h
	jnz	get_next
	ret

get_logical:
	call	get_byte
	cmp	al,' '
	jz	get_logical
	cmp	al,'C'
	jz	do_con
	cmp	al,'L'
	jz	do_lst
	cmp	al,'D'
	jz	do_deb
	cmp	al,'A'
	jz	do_aux
escape:
	jmp	retr_asgn
do_con:
	call	get_byte
	cmp	al,'O'
	jnz	escape
	call	get_byte
	cmp	al,'N'
	jnz	escape
	call	get_byte
	cmp	al,':'
	jnz	escape
	mov	ax,SCONDEV
	ret
do_lst:
	call	get_byte
	cmp	al,'S'
	jnz	escape
	call	get_byte
	cmp	al,'T'
	jnz	escape
	call	get_byte
	cmp	al,':'
	jnz	escape
	mov	ax,SPRTDEV
	ret
do_deb:
	call	get_byte
	cmp	al,'E'
	jnz	escape
	call	get_byte
	cmp	al,'B'
	jnz	escape
	call	get_byte
	cmp	al,':'
	jnz	escape
	mov	ax,SAUXDEV
	ret

do_aux:
	call	get_byte
	cmp	al,'U'
	jnz	escape
	call	get_byte
	cmp	al,'X'
	jnz	escape
	call	get_byte
	cmp	al,':'
	jnz	escape
	mov	ax,SAUXDEV
	ret

get_physical:
	call	get_byte
	cmp	al,' '
	jz	get_physical
	cmp	al,'K'
	jz	do_key
	cmp	al,'D'
	jz	do_ser
	cmp	al,'P'
	jz	do_prt
way_out:
	jmp	retr_asgn
do_key:
	call	get_byte
	cmp	al,'V'
	jnz	way_out
	call	get_byte
	cmp	al,'D'
	jnz	way_out
	call	get_byte
	cmp	al,':'
	jnz	way_out
	mov	ax,0
	ret
do_prt:
	call	get_byte
	cmp	al,'R'
	jnz	way_out
	call	get_byte
	cmp	al,'T'
	jnz	way_out
	call	get_byte
	cmp	al,':'
	jnz	way_out
	mov	ax,3
	ret
do_ser:
	call	get_byte
	cmp	al,'C'
	jnz	do_dte
	call	get_byte
	cmp	al,'E'
	jnz	way_out
	call	get_byte
	cmp	al,':'
	jnz	way_out
	mov	ax,1
	ret
do_dte:
	cmp	al,'T'
	jnz	way_out
	call	get_byte
	cmp	al,'E'
	jnz	way_out
	call	get_byte
	cmp	al,':'
	jnz	way_out
	mov	ax,2
	ret

get_byte:
	mov	di,offset cs:pointer
	mov	di,cs:[di]
	mov	al,ds:[di]
	inc	word ptr cs:[pointer]
	dec	byte ptr ds:[80h]
	cmp	byte ptr ds:[80h],0ffh
	jz	run_out
	cmp	al,20h
	jc	get_byte
	cmp	al,10h		; ignore ^Q
	jz	get_byte	; ignore ^S
	cmp	al,13h
	jz	get_byte	; ignore ^S
	cmp	al,60h
	jc	got_byte
	and	al,05fh
got_byte:
	ret
run_out:
	jmp	retr_asgn

pointer:
	dw	?
got_error:
	db	cr,lf,lf,'ENTRY ERROR ... please retry.',lf,etx
signon:
	db	esc,'H',esc,'J'
	db	cr,lf,'COLEX VME/186 SETUP UTILITY'
	db	cr,lf,lf,'Utility functions:'
	db	cr,lf,lf,'       1. Change device assignment'
	db	cr,lf,'       2. Change KVD: dev configuration'
	db	cr,lf,'       3. Change DTE: dev configuration'
	db	cr,lf,'       4. Change DCE: dev configuration'
	db	cr,lf,'       5. Change PRT: dev configuration'
	db	cr,lf,lf
	db	'KVD: is the built in keyboard and video port.'
	db	cr,lf,'DCE: is the DCE serial port.'
	db	cr,lf,'DTE: is the DTE serial port.'
	db	cr,lf,'PRT: is the Centronics parallel printer port.'
	db	cr,lf,lf
	db	'Select (1-5) or ^C to quit: ',etx
asgn_mes:
	db	esc,'H',esc,'J'
	db	cr,lf,'COLEX VME/186 Logical to physical device assignment.'
	db	cr,lf,lf,'To change the device assignments, enter the '
	db	'logical device,',lf,cr,'then the physical device.'
	db	cr,lf,'For example:'
	db	cr,lf,'            "CON:=DCE:" or "LST:=PRT:" etc.',cr,lf,lf
	db	'Valid assignments are:',cr,lf
	db	'                      CON:= KVD: DCE: DTE:',cr,lf
	db	'                      DEB:= KVD: DCE: DTE:',cr,lf
	db	'                      AUX:= KVD: DCE: DTE:',cr,lf
	db	'                      LST:= PRT: DCE: DTE:',cr,lf,lf
	db	'CON: is the system console device.',cr,lf
	db	'DEB: is the debug console device.',cr,lf
	db	'AUX: is the system auxillary devie.',cr,lf
	db	'LST: is the system printer devie.',cr,lf
	db	lf
	db	'KVD: is the build in keyboard and video port.',cr,lf
	db	'DCE: is the DCE serial port.',cr,lf
	db	'DTE: is the DTE serial port.',cr,lf
	db	'PRT: is the Centronics parallel printer port.',cr,lf
	db	'Enter assignment or <CR> for main menu: ',etx
kvd_mes:
	db	esc,'H',esc,'J'
	db	cr,lf,lf,'Video options are:'
	db	cr,lf,'         1. Composite Video, 50Hz, 240 lines.'
	db	cr,lf,'         2. Composite Video, 50Hz, 260 lines.'
	db	cr,lf,'         3. Composite Video, 60Hz, 240 lines.'
	db	cr,lf,'         4. Composite Video, 60Hz, 260 lines.'
	db	cr,lf,'         5. Separate Video, 50Hz.'
	db	cr,lf,'         6. Separate Video, 60Hz.'
	db	cr,lf,'         7. User defined #1.'
	db	cr,lf,'         8. User defined #2.'
	db	cr,lf,'         (Space) proceeds to next menu'
	db	cr,lf,lf,'Select (1-8) or (CR) to ret to main menu:',etx
kvd_opt:
	db	esc,'H',esc,'J'
	db	cr,lf,'VME/186 Keyboard and Video options.',lf
	db	cr,lf,'       Wraparound     Auto CR    New Line',lf
	db      cr,lf,'  1.       On            On         On'
	db	cr,lf,'  2.       On            On         Off'
	db	cr,lf,'  3.       On            Off        On'
	db 	cr,lf,'  4.       On            Off        Off'
	db	cr,lf,'  5.       Off           On         On'
	db	cr,lf,'  6.       Off           On         Off'
	db	cr,lf,'  7.       Off           Off        On'
	db	cr,lf,'  8.       Off           Off        Off'
	db	cr,lf,lf,'Select (1-8) or (CR) to ret to main menu:',etx
dte_mes:
	db	esc,'H',esc,'J'
	db	cr,lf,'VME/186 DTE Serial device configuration.'
	db	etx
dce_mes:
	db	esc,'H',esc,'J'
	db	cr,lf,'VME/186 DCE Serial device configuration.'
ser_mes:
	db	cr,lf,lf,'Baud Rate:'
	db	cr,lf,'  1. 110'
	db	cr,lf,'  2. 300'
	db	cr,lf,'  3. 600'
	db	cr,lf,'  4. 1200'
	db	cr,lf,'  5. 2400'
	db	cr,lf,'  6. 4800'
	db	cr,lf,'  7. 9600'
	db	cr,lf,'  8. 19200'
	db	cr,lf,'  (Space) to next menu'
	db	cr,lf,lf,'Select (1-8) or (CR) to ret to main menu:',etx
bit_chr:
	db	esc,'H',esc,'J'
	db	cr,lf,lf,'Bits/Char, Stop Bits'
	db	cr,lf,lf,' 1. 7,1'
	db	cr,lf,'  2. 7,2'
	db	cr,lf,'  3. 8,1'
	db	cr,lf,'  4. 8,2'
	db	cr,lf,lf,'Select (1-4) or (CR) to ret to main menu:',etx
parity:
	db	esc,'H',esc,'J'
	db	cr,lf,lf,'Parity Options'
	db	cr,lf,lf,'         1. Off'
	db	cr,lf,'         2. Odd'
	db	cr,lf,'         3. Even'
	db	cr,lf,lf,'Select (1-3) or (CR) to ret to main menu:',etx
xon_off:
	db	esc,'H',esc,'J'
	db	cr,lf,lf,'Xon Xoff Protocol.',lf
	db	cr,lf,'              Xon/Xoff      Xany'
	db	cr,lf,'        1.       On          On'
	db	cr,lf,'        2.       On          Off'
	db	cr,lf,'        3.       Off         On'
	db	cr,lf,'        4.       Off         Off'
	db	cr,lf,lf,'Select (1-4) or (CR) to ret to main menu:',etx
prt_mes:
	db	esc,'H',esc,'J'
	db	cr,lf,lf,'VME/186 Parallel Printer configuration',lf
	db	cr,lf,'        1.  Slow printer strobe'
	db	cr,lf,'        2.  Fast printer strobe'
	db	cr,lf,lf,'Select (1,2) or (CR) to ret to main menu:',etx

GIFDIC	label	dword
gifl	dw	?
gifh	dw	?
	dw	128 dup (?)
stacke	dw	?

prog	ends
	end	begin
