TITLE --- DSKMOV :  to move all the sectors, from 1 to 5146h , up 1 sector

reallife equ 1
include xinstr.mac
include dskmov.equ
include gifmac.mac
include rcd0.s86

pgroup group prog
dgroup group data


prog segment byte public 'prog'


	assume cs:pgroup
	assume ds:dgroup

	extrn ggifhdlr:near, gifdic:dword, ledtor:near, bootstart:near

; function : to move all the sectors of drive 0, 
;	     from 1 to 5146h, up 1 sector
; input : nil
; output : CY if error
; destroyed : ax, bx, cx, dx, di, ds, es

nprocedure dskmov
	
	mov al, itson		; set control break to on
	mov dl, al
	mov ah, 33h	
	int 21h
	mov ax, seg dgroup	; set ds and es pointing to data segment
	mov ds, ax
	mov es, ax
	call ggifhdlr		; get gifdic handler address
	call pparm		; parse the parameters
	push es			; save es
	mov al, drnum		; set OS MAP to drive # = drive num
	xor dx, dx		; 		os start address = 0
	xor di, di		; 		boot sector offset = ignore
	xor ah, ah		; 		image size = 5148
	mov cx, (highests+2)
	mov dl, sosmap
	gifcall dskdev,sstatus,(block)or(waitnr)
	pop es			; resume es
	jnc dskmovcont8
	jmp dskmoverr
dskmovcont8:
	mov al, drnum
	gifcall dskdev,reset,(block)or(waitnr)	; reset the drive
	jnc dskmovcont9
	jmp dskmoverr
dskmovcont9:
	mov ctlnum, ch		; save controller number
	mov dl, 8		; pass xebec initialization character set
	xor ax, ax
	mov al, drtyp
	mov di, ax
	shldi 3
	add di, offset dgroup:xbc
	mov ch, ctlnum
	gifcall dskdev,sstatus,(block)or(waitnr)
	jnc dskmovcont10
	jmp dskmoverr
dskmovcont10:
	mov dl, 0ah		; xebec initialization
	mov ch, ctlnum
	gifcall dskdev,sstatus,(block)or(waitnr)
	jnc dskmovcont11
	jmp dskmoverr
dskmovcont11:
	mov cx, 1		; read and check record 0
	mov dx, 0
	mov di, offset dgroup:transbuf
	mov al, drnum
	gifcall dskdev,read,(block)or(waitnr) ; read sector 0
	jnc dskmovcont1
	jmp dskmoverr
dskmovcont1:
	mov di, offset dgroup:record0.iflag
	mov si, offset dgroup:transbuf.iflag
	mov cx, 2
repe	cmpsw
	jne dskmovcont2
	mov di, offset dgroup:initstg  ; display already initialized string
	call dispstrg
	jmp dskmovret
dskmovcont2:
	mov di, offset dgroup:headstg ; display the header
	call dispstrg
	jnc dskmovcont7
	jmp dskmoverr
dskmovcont7:
	mov cx, remainh		; copy the remaining highest 6 sectors first
	mov dx, (highests-remainh+1) ; set dx to 5141h
	call disprng
	jnc dskmovcont3
	jmp dskmoverr
dskmovcont3:
	mov di, offset dgroup:transbuf; di points to destination buffer
	mov al, drnum
	gifcall dskdev,read,(block)or(waitnr); read the six sectors
	jnc dskmovcont4		; if error exit
	jmp dskmoverr
dskmovcont4:
if reallife
	mov cx, remainh		; write back the sectors, each up 1 sector
	mov dx, (highests-remainh+2)
	mov di, offset dgroup:transbuf
	mov al, drnum
	gifcall dskdev,write,(block)or(waitnr)
	jnc dskmovcont5		; if error exit
	jmp dskmoverr
endif
dskmovcont5:
	mov cx, copycnt		; number of copies
	mov dx, startsect		; set dx to the start sector
cpydsk:
	mov ah, 0bh		; check whether a control break is input
	int 21h
	push cx				; save dx and cx value
	push dx
	mov al, drnum			; set al to physical unit got from user
	mov cx, transnum		; cx contains number of segments to
					; transfer
	call disprng
	jnc dskmovcont6
	jmp dskmoverr
dskmovcont6:
	mov di, offset dgroup:transbuf  ; set di to point to transbuf
	gifcall dskdev, read, (block)or(waitnr) ; do read operation
	jnc cpycont1			; if error exit
	pop dx
	pop cx
	jmp dskmoverr
cpycont1:
	pop dx				; resume original start sector value
	inc dx				; up one sector
	push dx				; save dx value
if reallife
	mov al, drnum			; set al to physical unit got from user
	mov cx, transnum		; cx contains number of segments to
					; transfer
	mov di, offset dgroup:transbuf  ; set di to point to transbuf
	gifcall dskdev, write, (block)or(waitnr) ; do write operation
endif
	pop dx
	pop cx
	jc dskmoverr			; if error exit
	sub dx, (transnum+1)
	loop cpydsk
	mov di, offset dgroup:rcd0stg
	call dispstrg
	jc dskmoverr
if reallife
	mov al, drnum			; transfer rcd0
	mov cx, 1
	mov di, offset dgroup:record0
	mov dx, 0
	gifcall dskdev, write, (block)or(waitnr) 
	jc dskmoverr
endif
	mov di, offset dgroup:bootrstg
	call dispstrg
	jc dskmoverr
if reallife
	push cs
	pop es
	mov al, drnum			; transfer boot record
	mov cx, 1
	mov di, offset cs:bootstart
	mov dx, 1
	gifcall dskdev, write, (block)or(waitnr)
	jc dskmoverr
endif
	xor ax, ax		; set os map to drive # = 0
	mov es, ax		;		os start address = 1
	xor dx, dx		;		boot sector offset = 0
	mov di, 1		;		image size = 5147
	mov cx, (highests+1)
	mov dl, sosmap
	gifcall dskdev,sstatus,(block)or(waitnr)
	jc dskmoverr
dskmovret:
	mov ah, 4ch
	int 21h
dskmoverr:
	call disperr
	jmp dskmovret
dskmov endp


; function : to display a string of characters terminated by "$"
; input : es:di pointing the start of the string
; output : nil, CY if error and ah contains the error code
; destroyed : nil

nprocedure dispstrg

	pusha
lpnxtchr:
	cmp byte ptr es:[di], term_c
	je dispsret
	mov al, es:[di]
	gifcall kvddev, write, noopt
	jc dispsret
	inc di
	jmp lpnxtchr
dispsret:
	popa
	ret
dispstrg endp


; function : to display the range of sectors which is undergoing move
; input : dx : start sector number
;	  cx : block size
; output : nil, CY if error, ah contains error code
; destroyed : nil

nprocedure disprng

	pusha
	mov al, cr_c		; move cursor to beginning of line
	gifcall kvddev, write, noopt
	jc disprret
	push cx
	mov hexbuf, dx		; prepare parameters for calling hexin
	mov bx, (kvddev shl 6)
	mov cx, 4
	mov dx, hexcmd
	mov di, offset dgroup:hexbuf
	mov si, offset dgroup:ascbuf
	call ledtor
	jnc disprcont1
	pop cx
	jmp disprret
disprcont1:
	mov al, col_c		; display ":"
	gifcall kvddev, write, noopt
	pop cx
	jc disprret
	add hexbuf, cx		; display the highest sector number in the
	dec hexbuf		; block
	mov cx, 4
	mov dx, hexcmd
	mov bx, (kvddev shl 6)
	mov di, offset dgroup:hexbuf
	mov si, offset dgroup:ascbuf
	call ledtor
disprret:
	popa
	ret
disprng endp	

; function : to display the error code
; in : ah -- the error code
; out: nil
; destroyed: nil

nprocedure disperr

	pusha
	mov byte ptr hexbuf, ah		; save error code
	mov di, offset dgroup:errstg	; display error exist message
	call dispstrg
	jc disperet
	mov cx, 2
	mov dx, hexcmd
	mov bx, (kvddev shl 6)
	mov di, offset dgroup:hexbuf
	mov si, offset dgroup:ascbuf
	call ledtor
disperet:
	popa
	ret
disperr endp



; function : to parse the parameters on the command line and find
;	     the drive # ( 0 to 8 ) and/or drive type ( T/t) is
;	     entered, if it is, store its value into the
;	     corresponding buffer
; input :  nil
; output : nil
; destroyed: bx, ax, cx, di, si

nprocedure pparm

	push es
	mov ax, cs		; set cs, di pointing to parameter buffer
	sub ax, 10h
	mov es, ax
	mov di, 80h
	xor cx, cx
	mov cl, es:[di]
	inc di
	mov al, parmterm
	jmp stage0
pparmret:
	pop es
	ret
pparm 	endp

stage0:				; search for the parameter terminator
	jcxz pparmret
repne  scas es:byte ptr [di]
	je  stage1
	jmp pparmret


stage1:				; in this stage, parameter terminator is found
	jcxz pparmret
	mov al, es:[di]		; get char after "/"
	dec cx			
	inc di
	cmp al, sp_c		; ignore space
	je stage1
	push cx
	push di
	push es
	mov cx, 0ah
	mov di, offset dgroup:legalparm
	mov bx, ds
	mov es, bx
repne   scas byte ptr es:[di]
	pop es
	pop di
	pop cx
	je stage1cont
	mov al, parmterm
	jmp stage0
stage1cont:
	mov parmval, al		; save the parameter value
	jmp stage2


stage2:				; in this stage, a legal character is got
	jcxz stage3
	mov al, es:[di]
	dec cx
	inc di
	cmp al, sp_c		; ignore space
	je stage2
	cmp al, parmterm	; check whether it is a terminator
	je stage3		; a terminator is found
	jmp stage0	

dtype:
	mov drtyp, teacflag
	jmp stage1

stage3:
	cmp parmval, "T"
	je dtype
	cmp parmval, "t"
	je dtype
	mov al, parmval
	sub al, "0"
	mov drnum, al
	jmp stage1

prog ends


data segment word public 'data'


transbuf db (transnum * secsiz) dup (0)

record0 rcd0 <,,,hpnt,cpnt>
     	db (secsiz - (size rcd0) ) dup (0)

headstg  db "Copying ......", cr_c, lf_c, term_c
rcd0stg  db cr_c, lf_c, "Saving new record zero", cr_c, lf_c, term_c
bootrstg  db "Saving new boot record", cr_c, lf_c, term_c
errstg  db  cr_c, lf_c, "Error encountered, error code : ", cr_c, lf_c, term_c
initstg db "disk already initialized",cr_c,lf_c,term_c
hexbuf dw 0000h
ascbuf db 4 dup (?)
legalparm db "Tt01234567"
drnum db 00
drtyp db 00
parmval db 00
xbc db 01h, 32h, 04h, 00h, 00h, 00h, 00h, 0bh	; shugart
    db 01h, 32h, 04h, 00h, 80h, 00h, 40h, 0bh	; teac
ctlnum db 01h
data ends

stkseg  segment stack

	dw  200h dup (0)
stkseg ends

end  dskmov

	
	


