TITLE Monitor Memory Fill
;
name monfll
;
pgroup group prog
dgroup group data
;
      extrn cmd_tmn:abs
;
; data segment (dummy)
data segment word public 'data'
      extrn ssss:dword, cccc:word, dddd:word
data ends
;
      public M_fill
      assume cs:pgroup, ds:dgroup, es:dgroup
;
;
; Memfill
;
prog segment byte public 'prog'
;
; M_fill :
;   Fill memory locations start from ssss to dddd for cccc bytes with
;   the string list in the command buffer.
;
      extrn hex_test:near, strhex_byte:near
      extrn skip_blank:near, ill_char:near
;
M_fill proc near
; Interprete the string list
      mov      bx, si  ; String list base
      mov      di, bx
int_str_loop:
      call     skip_blank
      mov      al, [si]
      cmp      al, 0
      jne      is_1
; Quoted
      inc      si
str_cp_lp:
      lodsb
      cmp      al, 0
      je       short int_str_lpend
      stosb
      jmp      short str_cp_lp
; Non-quote
is_1:
      cmp      al, cmd_tmn
      je       is_tmn
      call     hex_test
      jc       is_2
      lodsb
      jmp      M_fill_err
is_2:
      call     strhex_byte
      mov      al, dl
      stosb
int_str_lpend:
      jmp      short int_str_loop
is_tmn:
      mov      dx, di  ; Terminating position
      mov      si, bx
      mov      cx, cccc
      cmp      dddd, 0
      jne      fl_3
; String fill (Count is string length)
      mov      cx, dx
      sub      cx, bx
      ja       fl_2
      jmp      short M_fill_end ; Null string
fl_3:
      cmp      dx, bx
      ja       fl_2
      mov      byte ptr [si], 0
fl_2:
      push     es
      les      di, ssss
fill_loop:
      cmp      si, dx
      jb       fl_1
      mov      si, bx
fl_1:
      lodsb
      stosb
      loop     fill_loop
      pop      es
      jmp      short M_fill_end
M_fill_err:
      call     ill_char
M_fill_end:
      ret
M_fill endp
;
prog ends
;
end
