TITLE Monitor Memory Copy
;
name moncop
;
pgroup group prog
dgroup group data
;
; data segment (dummy)
data segment word public 'data'
      extrn ssss:word, dsss:word, cccc:word, dddd:word
data ends
;
      public M_copy
      assume cs:pgroup, ds:dgroup, es:dgroup
;
;
; Memcopy
;
prog segment byte public 'prog'
;
; M_copy :
;   Copy memory locations start from ssss to dddd for cccc bytes.
;   An interesting problem is to determine whether a number x is in the
;   range not greater than 32K bounded by a and b, where the number set
;   is from hex 0000 to FFFF wrapping around (i.e.FFFA in[FFF0, 0005]):
;      (Not SF(x-a)) and (x-a<count), where count is b-a+1.
;      or simply sign bit of (x-a) is 0 and the one of (x-a-count) is 1
;   This gives the exact result.
;
      extrn put_msg_kb:near
      extrn rng_exc_msg:byte
      extrn cpcnt_lmt:abs
;
M_copy proc near
      cmp      cccc, cpcnt_lmt
      ja       rng_exc_err
; Within 32K copy
      mov      cx, cccc
      mov      ax, dddd  ; x is dddd
; Test lower bound in range
      sub      ax, ssss  ; a is ssss
      js       block_copy  ; Upper bound not in range
      sub      ax, cx
      jns      block_copy  ; Upper bound not in range
; Upper bound in range -- Reverse order
      add      ssss, cx
      dec      ssss
      add      dddd, cx
      dec      dddd
      std
block_copy:
      push     es
      push     ds
      mov      ax, dsss
      mov      es, ax
      mov      di, dddd
      lds      si, dword ptr ssss
copy_loop:
      lodsb
      stosb
      loop copy_loop
      pop      ds
      pop      es
      jmp      short copy_end
rng_exc_err:
      mov      si, offset pgroup:rng_exc_msg
      call     put_msg_kb
copy_end:
      cld
      ret
M_copy endp
;
prog ends
;
end
