TITLE Data segment
;
name data
;
pgroup group prog
dgroup group data
;
; literals
;
cr          equ   0dh
lf          equ   0ah
public cr, lf
;
; Command codes
;
M_code      equ   'M'
R_code      equ   'R'
P_code      equ   'P'
E_code      equ   'E'
B_code      equ   'B'
W_code      equ   'W'
L_code      equ   'L'
O_code      equ   'O'
S_code      equ   'S'
I_code      equ   'I'
Q_code      equ   'Q'
public M_code, R_code, P_code, E_code, B_code, W_code, L_code, O_code
public S_code, I_code, Q_code
;
; Command symbols
;
prompt      equ   ':'
eocmd       equ   0dh
cmd_tmn     equ   ';'
seg_ovr     equ   ':'
port_intro  equ   '='
cnt_ind     equ   ','
end_ind     equ   '.'
fll_ind     equ   '<'
cop_ind     equ   '>'
rupd_ind    equ   ':'
Pin_ind     equ   '<'
Pout_ind    equ   '>'
sng_quote   equ   "'"
dbl_quote   equ   '"'
bp_inq      equ   '?'
till_ind    equ   '-'
public prompt, eocmd
public cmd_tmn, seg_ovr, port_intro
public cnt_ind, end_ind, fll_ind, cop_ind, rupd_ind, Pin_ind, Pout_ind
public sng_quote, dbl_quote, bp_inq, till_ind
;
; Pre-definition
;
vc_first    equ   ' '
vc_last     equ   '~'
dft_cnt     equ   80h
upd_row     equ   1
cpcnt_lmt   equ   8000h
ill_instr   equ   66h
init_seg    equ   1000h
boot_seg    equ   0ff20h
boot_loc    equ   0
public vc_first, vc_last, dft_cnt, upd_row, cpcnt_lmt
public ill_instr, init_seg, boot_seg, boot_loc
;
; Operation switches
;
upd_quit    equ   '.'
gh_quit     equ   '.'
public upd_quit, gh_quit
;
; Relative
;
R_num     equ   (R_nend-R_names)/2
wreg_num  equ   (wreg_nend-wreg_name)/2
flag_num  equ   (flag_nend-flag_name)/2
public R_num, wreg_num, flag_num
;
; Data segment
;
data segment word public 'data'
;
quit_point dd ?
public quit_point
;
cmd_ptr     dw   ?
last_port   dw   ?
ssss        dw   ?
dsss        dw   ?
cccc        dw   ?
dddd        dw   ?
port_addr   dw   8 dup (?)
public cmd_ptr, last_port, ssss, dsss, cccc, dddd, port_addr
;
read_buf    db   82 dup (?)
cmd_buf     db   81 dup (?)
mem_buf     db   10h dup (?)
mem_buf_end label byte
wr_buf      db   8 dup (?)
load_buf    db   77 dup (?)  ; 9+64+2+2
public read_buf, cmd_buf, mem_buf, mem_buf_end, wr_buf, load_buf
;
brk_pnt_seg dw ?
brk_pnt_addr dw ?
brk_pnt_instr db ?
ss_save dw ?
sp_save dw ?
till_loc dw ?
till_instr db ?
W_flag db ?
ip_offset dw ?
public brk_pnt_seg, brk_pnt_addr, brk_pnt_instr, ss_save, sp_save
public till_loc, till_instr, W_flag, ip_offset
;
reg_set label word
ax_ dw ?
bx_ dw ?
cx_ dw ?
dx_ dw ?
ds_ dw ?
si_ dw ?
es_ dw ?
di_ dw ?
cs_ dw ?
ip_ dw ?
ss_ dw ?
sp_ dw ?
bp_ dw ?
fcw dw ?
public reg_set
public ax_, bx_, cx_, dx_
public ds_, si_, es_, di_
public cs_, ip_, ss_, sp_
public bp_, fcw
dummy label byte
;
data ends
;
; Message pool
;
prog segment byte public 'prog'
;
      public err_cmd_msg, ill_char_msg, header_msg, rng_exc_msg
      public no_bp_msg, bp_is_msg
      public abort_msg
      public r_disp_head
      public cs_ip, ds_si, es_di, ss_sp
      public wreg_name, wreg_nend, flag_name, flag_nend
      public R_names, R_nend
;
err_cmd_msg db   err_cmd_mend-err_cmd_msg-1
            db   'Unrecognized command!', cr, lf
err_cmd_mend label byte
;
ill_char_msg db  ill_char_mend-ill_char_msg-1
             db  'Illegal character "'
ill_char_mend label byte
;
header_msg  db   header_mend-header_msg-1
            db   'COLEX System Controller -- MONDEB 1.00'
            db   ' (Monitor/Debugger)', cr, lf
header_mend label byte
;
rng_exc_msg db   rng_exc_mend-rng_exc_msg-1
            db   'Source block exceed 32 K bytes', cr, lf
rng_exc_mend label byte
;
abort_msg db   abort_mend-abort_msg-1
            db   'Error in loading -- Abort', cr, lf
abort_mend label byte
;
no_bp_msg db   no_bp_mend-no_bp_msg-1
            db   'No break point is set', cr, lf
no_bp_mend label byte
;
bp_is_msg db   bp_is_mend-bp_is_msg-1
            db   'Break point is '
bp_is_mend label byte
;
cs_ip db   cs_ip_mend-cs_ip-1
 db 'CS:IP('
cs_ip_mend label byte
;
ds_si db   ds_si_mend-ds_si-1
 db '  DS:SI='
ds_si_mend label byte
;
es_di db   es_di_mend-es_di-1
 db '  ES:DI='
es_di_mend label byte
;
ss_sp db   ss_sp_mend-ss_sp-1
 db '  SS:SP='
ss_sp_mend label byte
;
r_disp_head db   r_disp_hend-r_disp_head-1
db ' AX   BX   CX   DX   DS   SI   ES   DI   CS   IP   SS   SP   BP   '
db 'ODITSZ-A-P-C', cr, lf
r_disp_hend label byte
;
; Register Names
;
R_names label word
wreg_name label word
db 'AX'
db 'BX'
db 'CX'
db 'DX'
db 'DS'
db 'SI'
db 'ES'
db 'DI'
db 'CS'
db 'IP'
db 'SS'
db 'SP'
db 'BP'
wreg_nend label word
flag_name label word
db 'OF'
db 'DF'
db 'IF'
db 'TF'
db 'SF'
db 'ZF'
db '  '
db 'AF'
db '  '
db 'PF'
db '  '
db 'CF'
flag_nend label word
R_nend label word
;
prog ends
;
end
