TITLE Monitor Memory Command Recognition
;
name monM
;
pgroup group prog
dgroup group data
;
      extrn cnt_ind:abs, end_ind:abs, fll_ind:abs, cop_ind:abs
      extrn cmd_tmn:abs, seg_ovr:abs, dft_cnt:abs
;
; data segment (dummy)
data segment word public 'data'
      extrn ssss:word, dsss:word, cccc:word, dddd:word, ds_:word
data ends
;
prog segment byte public 'prog'
      extrn M_update:near, M_display:near
      extrn M_fill:near, M_copy:near
      extrn fetch_oprn:near, ill_char:near
      public M_proc
      assume cs:pgroup, ds:dgroup, es:dgroup
;
; M_proc :
;   Memory operations --
;      One operand for updating;
;      Two operands for displaying;
;      Three operands for copying.
;      (No operand defaults displaying following)
;
M_proc proc near
      call     fetch_oprn
      lodsb
      jc       M_oprn_1
; Non-active operand
      cmp      al, seg_ovr
      je       non_act_ovr
      cmp      al, cmd_tmn
      jne      non_act_non_ovr
      mov      cccc, dft_cnt
      jmp      M_disp
; Non-active non-override, but not end
non_act_non_ovr:
      push     ds_
      pop      dsss
      jmp      short M_oprn_2
; M:... -- Non-active override
non_act_ovr:
      call     fetch_oprn
      lodsb
      jc       ld_ssss
; Non-active override, with non-active ssss also
      cmp      al, cmd_tmn
      jne      M_oprn_2
; M:
      mov      ssss, 0
      mov      cccc, dft_cnt
      jmp      M_disp
; First operand active
M_oprn_1:
      cmp      al, seg_ovr
      je       act_ovr
      cmp      al, cmd_tmn
      jne      act_non_ovr
; Mssss
      mov      ssss, dx
      jmp      short M_upd
; Mssss... -- Active non-override, but not end
act_non_ovr:
      push     ds_
      pop      dsss
      jmp      short ld_ssss
; Mdsss:... -- Active override (after next operand, may be end)
act_ovr:
      mov      dsss, dx
      call     fetch_oprn
      lodsb
      jnc      non_act_ssss
      mov      ssss, dx
      cmp      al, cmd_tmn
      jne      M_oprn_2
      jmp      short M_upd
; Active override but non-active ssss
non_act_ssss:
      mov      ssss, 0
      cmp      al, cmd_tmn
      mov      cccc, dft_cnt
      je       M_disp
      jmp      short M_oprn_2
ld_ssss:
      mov      ssss, dx
M_oprn_2:
      mov      bx, si  ; Save pointer
      call     fetch_oprn
      jc       M_oprn_21
      mov      dx, dft_cnt  ; Default count :  100 hex
M_oprn_21:
      cmp      al, cnt_ind
      je       M_oprn_22
      cmp      al, end_ind
      je       M_oprn_23
      cmp      al, ' '
      je       M_oprn_23
      cmp      al, fll_ind
      je       M_oprn_26
      cmp      al, cmd_tmn
      jne      short M_err
M_upd:
      call     M_update
      jmp      short M_end
M_oprn_23:
; Count calculation (Wrap around)
      sub      dx, ssss
      inc      dx
      jmp      short M_oprn_25
M_oprn_22:
      cmp      dx, 0
      ja       M_oprn_25
      mov      dx, dft_cnt
M_oprn_25:
      mov      cccc, dx
      lodsb
      cmp      al, cmd_tmn
      jne      M_oprn_3
M_disp:
      call     M_display
      jmp      short M_end
M_oprn_26:
      mov      dddd, 0  ; Indicating string fill (Count is string len)
      mov      si, bx  ; Resume pointer to the string list
      jmp      short M_fll
M_oprn_3:
      cmp      al, fll_ind
      jne      M_oprn_35
      mov      dddd, 0ffffh  ; Indicating count effective
M_fll:
      call     M_fill
      jmp      short M_end
M_oprn_35:
      cmp      al, cop_ind
      je       M_oprn_33
      cmp      al, ' '
      je       M_oprn_33
      jmp      short M_err
M_oprn_33:
      call     fetch_oprn
      lodsb
      jc       M_oprn_34
      cmp      al, cmd_tmn
      je       M_oprn_31
      jmp      short M_err
M_oprn_34:
      cmp      al, cmd_tmn
      je       M_oprn_32
      jmp      short M_err
M_oprn_31:
; Default copy destination -- Block immediately following source one
      mov      dx, ssss
      add      dx, cccc
M_oprn_32:
      mov      dddd, dx
      call     M_copy
      jmp      short M_end
M_err:
      call     ill_char
M_end:
      ret
M_proc endp
;
prog ends
;
end
