TITLE Monitor Load Command Recognition
;
name monL
;
pgroup group prog
dgroup group data
;
      extrn cr:abs, lf:abs
;
; data segment (dummy)
data segment word public 'data'
      extrn cs_:word, ds_:word, ip_:word, ip_offset:word
      extrn ssss:word, dsss:word, dddd:word
      extrn load_buf:byte
data ends
;
prog segment byte public 'prog'
;
      extrn put_str_kb:near, strhex:near, put_msg_kb:near, crlf_:near
      extrn send_type:near, send_end:near, read_file:near
      extrn abort_msg:byte
      public L_proc
      assume cs:pgroup, ds:dgroup, es:dgroup
;
read_rec macro
      local rr
      call     read_file
      cmp      cx, 0
      je       rr
      jmp      L_err  ; In complete record
rr:
endm
;
; L_proc :
;
L_proc proc near
      mov      ax, ds_  ; Load segment address
      mov      dsss, ax
      mov      dddd, 0ffffh  ; Null in dddd (Start address buffer)
      call     send_type
ld_rec_lp:
      mov      cx, 9  ; The read prefix
      mov      di, offset load_buf
      read_rec
      cmp      load_buf, ':'
      je       lrl_1
      jmp      L_err  ; Illegal delimitor
lrl_1:
      mov      si, offset load_buf[3]
      call     strhex
      mov      bx, dx  ; Destination address
      cmp      dddd, 0ffffh
      jne      lrl_2
      mov      dddd, dx  ; Module starting load address buffer
lrl_2:
      mov      load_buf[3], 0  ; Delimit the Number-of-bytes
      mov      si, offset load_buf[1]
      call     strhex
      cmp      word ptr load_buf[7], '00'  ; Record type 00
      je       lrl_4
      jmp      ld_end_rec
lrl_4:
      mov      cx, dx  ; Number of bytes
      mov      ax, cx  ; Save
      shl      cx, 1  ; 2 chars for 1 byte
      add      cx, 4  ; Check sum and <CR><LF>
      mov      word ptr load_buf, '00'  ; Leave 2 bytes for odd
      mov      di, offset load_buf[2]
      read_rec
      mov      ssss, bx  ; Load address
      les      di, dword ptr ssss  ; Load segment
      mov      cx, ax
      test     cx, 1  ; Test odd
      jz       even_bytes
; Odd bytes
      mov      si, offset load_buf
      call     strhex
      cmp      si, offset load_buf[4]
      je       lrl_3
      jmp      L_err  ; Illegal character in data bytes
lrl_3:
      mov      al, dl
      stosb
      jmp      short ld_byte
even_bytes:
      mov      si, offset load_buf[2]
ld_byte:
      add      bl, bh  ; Initialize the checksum
      add      bl, cl
      shr      cx, 1  ; even bytes into words
ld_byte_lp:
      mov      ax, si
      add      ax, 4  ; For checking
      call     strhex
      cmp      si, ax
      jne      L_err
      mov      ax, dx
      xchg     ah, al
      stosw
; Check sum
      add      bl, ah
      add      bl, al
      loop     ld_byte_lp
;
      mov      ax, ds
      mov      es, ax  ; Resume ES
      mov      ax, si
      add      ax, 2
      call     strhex
      cmp      si, ax
      jne      L_err
      add      bl, dl
      jnz      L_err  ; Check sum error
      lodsb
      cmp      al, cr  ; <CR> check
      jne      L_err
      lodsb
      cmp      al, lf  ; <LF> check
      jne      L_err
      jmp      ld_rec_lp
; Load end-of-file record
; Number of bytes in DX. Transfer address in BX.
; Note that ES is resumed at this point
ld_end_rec:
      cmp      word ptr load_buf[7], '10'  ; Hex 01 for EOF
      jne      L_err  ; Not EOF record
      cmp      dx, 0
      jne      L_err  ; Illegal EOF -- Number of bytes non-zero
      mov      cx, 2
      mov      di, offset load_buf[9]
      read_rec  ; read the checksum
      mov      si, offset load_buf[7]
      call     strhex
      cmp      si, offset load_buf[11]
      jne      L_err  ; Illegal character in data bytes
      add      dl, dh  ; Check sum
      add      dl, bh
      add      dl, bl
      jnz      L_err  ; Check sum error
      mov      ip_, bx  ; The transfer address
      mov      ip_offset, bx  ; Initialize the offset
      mov      ax, ds_  ; The load segment
      mov      cs_, ax  ; is assumed to be the program segment
      jmp      short L_end  ; Load OK
L_err:
      mov      ax, ds
      mov      es, ax  ; Resume ES
      mov      si, offset pgroup:abort_msg
      call     put_msg_kb
L_end:
      cmp      dddd, 0ffffh  ; Null in starting address buffer?
      je       L_end_1
      mov      ax, dddd
      mov      ssss, ax
L_end_1:
      call     crlf_
      call     send_end
      ret
L_proc endp
;
prog ends
;
end
