TITLE	Format Hard Disk


if1
%out Pass 1...
else
%out Pass 2...
endif

pgroup	group prog
dgroup	group data

include	\gifi\gifmac.mac
include	\186\xinstr.mac
include	\gifi\rcd0.s86
include	src\hardisk.equ


data	segment word public 'data'
	extrn gifdic:dword

devhand	dw scondev*64

iiibuf	label byte
wordbuf	dw ?
bytebuf	db ?
fmtunit	db 1
fmtctlr	db 0
gdrv	db ?
fmtflg	db ?
public bytebuf, fmtunit, fmtctlr, gdrv, fmtflg

drive	db ?

ascbuf	db 8 dup (?)
tcmdbuf	label byte
dw 0
db 0
dw tsize
db 0
public tcmdbuf

osmaddr	label word
x=0
rept numosm
dw dib.osm0[x]
x=x+osmsize
endm

public osmaddr

; TASK Call
task	label dword
tskloc	dw ?
tskseg	dw ?


; CBB & SBB
cbb	db 6
	db 4
xbcdrv	db ?
	db 0, 0
xbcintl	db ?
	db 7

sbb	db 2, ?, ?

cct	dw cctlen
db '.',	abort
db bs,	delast
db del,	clear
db ',',	exit
db cr,	exit
cctlen	equ ($-cct)/2-1

osmout	dd 0,0,0

dibsav	db 0			; DIB Saved onto Disk
dib	rcd0	<,,,hpnt,cpnt>
db	(bps-(size rcd0)) dup (-1)
public dibsav, dib

bbrtsav	db -1			; BBRT Saved onto Disk
bbrtsec	dd -1
bbrt	db bps dup (-1)
bbrtmp	db bps dup (-1)
dd -1
public bbrtsav, bbrtsec, bbrt, bbrtmp


stack	dw 80h dup (?)
tos	label word
data	ends

prog	segment byte public 'prog'
	assume cs:pgroup, ds:dgroup, es:dgroup, ss:dgroup
	extrn hexin:near
	extrn scandrv:near, opnsys:near, drvcvt:near, closys:near
	extrn rddib:near, wrdib:near, setchkb:near, getbbrt:near
	extrn H_cmd:near, L_cmd:near, R_cmd:near, F_cmd:near, E_cmd:near
	extrn Q_cmd:near, M_cmd:near, C_cmd:near, S_cmd:near, D_cmd:near
	extrn T_cmd:near, A_cmd:near, P_cmd:near, CZ_cmd:near
	public showver, showdrv, crlf, dispchr, capschr, capsech
	public hexinp, hexout, cmdexit, ignexit, mapset, inixeb, hformat


start:
	mov	ax, dgroup
	mov	ss, ax
	mov	sp, offset ss:tos
; Scan the Drive
	call	scandrv
	jnc	sd1
	mov	ah, getcurd
	int	21h
sd1:
	mov	dx, dgroup
	mov	ds, dx
	mov	es, dx
	mov	drive, al
print	<esc,'H',esc,'JHard Disk Initialization Program for COLEX-2000'>
	call	showver
	call	init
	mov	ax, 4c00h
	int	21h


capschr:
	mov	ah, inpcon
	int	21h
	cmp	al, 'a'
	jb	cpok
	cmp	al, 'z'
	ja	cpok
	sub	al, 'a'-'A'
cpok:
	ret


capsech:
	call	capschr
	push	ax
	cmp	al, ' '
	jnb	ce1
	cmp	al, cr
	je	ce1
	cmp	al, lf
	je	ce1
	push	ax
	mov	al, '^'
	call	dispchr
	pop	ax
	add	al, 'A'-1
ce1:
	call	dispchr
	pop	ax
	ret


public	dispchr
dispchr	proc near
	pusha
	mov	dl, al
	mov	ah, prtcon
	int	21h
	popa
	ret
dispchr	endp


public	ascii
ascii	proc near
	call	capschr
	cmp	al, '0'
	jb	ascerr
	cmp	al, '9'
	jbe	ascok
	cmp	al, 'A'
	jb	ascerr
	cmp	al, 'F'
	jbe	ascok
ascerr:
	mov	ah, dead
	stc
	ret
ascok:
	xor	ah, ah
	ret
ascii	endp


hexinp	proc
	mov	si, offset ds:ascbuf
	mov	bx, devhand
	mov	ax, offset ss:cct
	call	hexin
	ret
hexinp	endp


hexout	proc
	mov	si, offset ds:ascbuf
	mov	bx, devhand
	call	hexin
	ret
hexout	endp


cbsec	proc near
	pusha
	cmp	dl, 0
	jnz	cs1
	mov	al, cbpassc
	call	dispchr
cs1:
if 0
	mov	dl, -1
	mov	ah, dconio
	int	21h
	jz	cs2
else
	gifcall	scondev,read,noopt
	jc	cs2
endif
	cmp	al, cbabort
	clc
	je	csexit
cs2:
	stc
csexit:
	popa
	ret
cbsec	endp


cbbad	proc near
	pusha
	mov	wordbuf, dx
	mov	bytebuf, bl
	mov	di, offset es:iiibuf
	hexoutm	6
	mov	al, cbbadc
	call	dispchr
	popa
	ret
cbbad	endp


INIT	proc near
	mov	ax, offset cs:cbsec
	mov	bx, offset cs:cbbad
	call	setchkb
; GIFSYS99
	call	opnsys
	jcm	giaterr
	mov	al, drive
	call	drvcvt
	jcm	giaterr
	call	closys
	jcm	giaterr
	cmp	al, -1
	jzm	ndrverr
	test	al, hd
	jnzm	in6
; Not a hard disk
	push	ax
	print	<cr,lf,'Is '>
	call	showdrv
	print	<' a hard disk <Y/N> ? '>
	call	capsech
	and	al, caps
	cmp	al, 'Y'
	pop	ax
	jnzm	iniexit
in6:
	and	al, not hd
	mov	gdrv, al
	dreset
	mov	fmtunit, cl
	mov	fmtctlr, ch
	call	inixeb
	mov	di, offset es:bbrtmp
	call	rddib
	jnc	in2
	cmp	ah, 0
	stc
	je	in2
	print	<cr, lf, 'Probably Unformatted Disk'>
	jmp	in1
in2:
	pushf
	print	<cr, lf, 'The DIB on the hard disk is read'>
	popf
	jnc	in3
	print	', but it does not match the COLEX format.'
	jmp	short in1
in3:
	print	' and loaded as the initial one.'
; Copy DIB
	mov	dibsav, -1
	mov	si, offset ds:bbrtmp
	mov	di, offset es:dib
	mov	cx, bps/2
	rep	movsw
; Init XEBEC
	call	inixeb
	cmp	word ptr dib.badr, -1
	jne	in5
	cmp	byte ptr dib.badr[2], -1
	je	in1
in5:
; Load BBRT
	mov	al, gdrv
	mov	di, offset es:bbrt
	call	getbbrt
	jnc	in4
	mov	di, offset es:bbrt
	mov	cx, bps/2
	mov	ax, -1
	rep	stosw
	jmp	short in1
in4:
	mov	word ptr bbrtsec, dx
	mov	al, ah
	xor	ah, ah
	mov	word ptr bbrtsec[2], ax
in1:
	print	<cr,lf,lf,"Please type 'H' for instructions",cr,lf>
cmdlp:
	call	getcmd
	call	ax
	jnc	cmdlp
iniexit:
	ret
INIT	endp



crlf:
	print	<cr, lf>
	ret

showver:
	print	<'  v.1.1-',cr,lf>
	ret

dispdrv:
	call	crlf
showdrv:
	print	'Drive '
	mov	al, drive
	add	al, 'A'
	call	dispchr
	ret

giaterr:
	print	<cr, lf, 'GIFSYS99 Device Error', cr, lf>
	jmp	iniexit

ndrverr:
	call	dispdrv
	print	<' does not exist', cr, lf>
	jmp	iniexit

cmdcod	db 'HLRFEQMCSDTAP', ctrl_z, commnt, cr, lf
cmdnum	equ $-cmdcod

cmdent	dw H_cmd, L_cmd, R_cmd, F_cmd, E_cmd, Q_cmd
	dw M_cmd, C_cmd, S_cmd, D_cmd, T_cmd, A_cmd, P_cmd
	dw CZ_cmd, cmtcmd, cmdexit, cmdexit

; Read in one byte and compute command retry in AX
getcmd	proc
	push	es
	mov	ax, cs
	mov	es, ax
	assume es:pgroup
gclp:
	print	<cr, lf, cmdprm>
	call	capsech
	mov	cx, cmdnum
	mov	di, offset es:cmdcod
	repne	scasb
	je	gcgot
	print	' Command Illgal'
	jmp	gclp
gcgot:
	sub	di, (1 + offset es:cmdcod)
	shl	di, 1
	mov	ax, cmdent[di]
gcexit:
	pop	es
	assume es:dgroup
	ret
getcmd	endp


cmtcmd:
	call	capsech
	cmp	al, cr
	jne	cmtcmd
	jmp	short cmdexit

ignexit:
	print	<cr,lf,'Command ignored'>

cmdexit:
	clc
	ret

mapset	proc
	lodsw	; Boot offset
	mov	bp, ax
	PUSH	ES
	MOV	ES, BP
	lodsw
	lodsw	; Start Sector
	mov	di, ax
	lodsw
	mov	dh, al
	lodsw	; Size
	mov	cx, ax
	lodsw
	mov	ah, al
	mov	al, gdrv
	dss	sosmap
	POP	ES
	ret
mapset	endp



; Initialize XEBEC
inixeb	proc
	mov	ch, fmtctlr
	xicpar
	dss	xebecs
	dss	xebeci
	ret
inixeb	endp



HFORMAT	proc near
; Switch on message dump
	mov	dh, 80h
	dss	msgdmp
;
	cmp	fmtflg, 0
	jzm	hfcpdib
; Format operation
	mov	al, gdrv
	push	es
	dformat
	pop	es
	jnc	hf1
	print	<cr, lf, 'Not the right PROM'>
	jmp	hferr
hf1:
	mov	tskloc, dx
	MOV	TSKSEG, BX
; Disable Time out
	mov	dh, 80h
	dss	tmoc
; Format the Hard Disk
	mov	al, fmtunit
	roral	3
	mov	xbcdrv, al
	itlpar
	mov	al, [di]
	mov	xbcintl, al
	mov	si, offset ds:cbb
	mov	di, offset ds:sbb
	mov	ch, dmaoff
	mov	cl, fmtctlr
	call	task
; Enable the Time out again
	pushf
	xor	dh, dh
	dss	tmoc
	popf
	jnc	hf2
	print	<cr,lf,lf,'Error in formatting'>
	jmp	hferr
hf2:
	print	<cr,lf,lf,'Format Complete',cr,lf>
	mov	ax, -1
	mov	word ptr bbrtsec, ax
	mov	word ptr bbrtsec[2], ax
	mov	word ptr dib.badr, ax
	mov	word ptr dib.badr[2], ax
	mov	bbrtsav, al

hfcpdib:
; Copy DIB
	mov	al, gdrv
	mov	di, offset es:dib
	call	wrdib
	jc	hfdibe
	mov	dibsav, -1
	print	<cr,lf,lf,'DIB Saved'>
	jmp	short hfexit
hfdibe:
	print	<cr,lf,lf,'Error in copying DIB'>
hferr:
	mov	si, offset ds:osmout
	call	mapset		; Map out the disk again
hfexit:
; Switch off message dump
	xor	dh, dh
	dss	msgdmp
	ret
HFORMAT	endp


prog	ends

end	start
	

