	page	60,132

TITLE INITIAL I/O INTERFACE FOR UNIX

	SUBTTL	LISTING CONTROLS ETC.

	.xall		; standard listing

	SUBTTL	EXTERNAL FILES
	PAGE


	include	gifdic.mac
	include 80186.mac

	SUBTTL	DATA STRUCTURES IN THE MAILBOXES
	PAGE

	; I/O ACTIVITY FLAGS

flags	struc

startx	dw	0
start	dw	0		; 68k request start = 1

busyx	dw	0ffffh
busy	dw	0ffffh		;  186 response = 0

donex	dw	0
done	dw	0		; 186 finished = 1

readyx	dw	0
ready	dw	0		; 68k acknowledge = 0

statusx	dw	0
status	dw	0		; 186 status alert = 1

gotstx	dw	0ffffh
gotst	dw	0ffffh		; 68k acknowledge status

abortx	dw	0
abort	dw	0		; 68k abort request = 1

abortedx	dw	0ffffh
aborted	dw	0ffffh		; 186 ack abort request

flags	ends



	; LAYOUT OF COMMON PART OF CHANNEL STATUS BLOCK

csb_main	struc

devno	db 0		; device number
devtyp	db 0		; major device type ( 0 = tty, 1 = disc, 2 = rtc
device	dw 0		; device description
maxrq	db 0		; max simultanious requests
nowrq	db 0		; current request count

csb_main	ends

	; LAYOUT OF ADDITIONAL DATA FOR DISK DEVICES

csb_disk	struc

secsize	dw 0		; physical sector size
sizmsw	dw 0		; msb of last sector
sizlsw	dw 0		; last sector number
sectrk	dw 0		; sectors per track
headno	dw 0		; number of heads
	dw 2 dup (0)
errcod	dw 0		; error status code
	dw 0		; spare error status

	dw 4 dup (0)

csb_disk	ends

	; LAYOUT OF ADDITIONAL DATA FOR CHARACTER DEVICES

csb_tty	struc

	dw 7 dup (0)
conerr	dw 0
	dw 0

	dw 4 dup (0)

csb_tty	ends

	; LAYOUT OF ADDITIONAL DATA FOR THE REAL TIME CLOCK

csb_rtc		struc

	dw 13 dup (0)		; rtc is undefined as yet

csb_rtc		ends

	; LAYOUT OF CHANNEL REQUEST BLOCK

crb_main	struc

rdevno	db 0		; request on device number
rdevtyp	db 0		; request on major device type
comand	dw 0		; operation code
rqcount	dw 0		; request count
com1	dw 0		; 1st parameter
com2	dw 0		; 2nd parameter
com3	dw 0		; 3rd parameter
com4	dw 0		; 4th parameter
com5	dw 0		; 5th parameter
com6	dw 0		; 6th parameter
com7	dw 0		; 7th parameter
com8	dw 0		; 8th parameter
com9	dw 0		; 9th parameter
coma	dw 0		; 10th parameter
comb	dw 0		; 11th parameter
comc	dw 0		; 12th parameter
comd	dw 0		; 13th parameter


crb_main	ends

	; use of crb parameters :

; DISK :	read or write
;

ussn	equ	com1	; upper start sector number
lssn	equ	com2	; lower start sector number

nstt	equ	com3	; number of sectors to transfer

udma	equ	com4	; upper data transfer address
ldma	equ	com5	; lower data transfer address

dvme	equ	com6	; disk vme access

ulas	equ	com7	; upper look ahead block
llas	equ	com8	; lower look ahead sector

lasc	equ	com9	; look ahead sector count

;
; CHAR :	input ( to fifo )
;

fiptr	equ	com1	; input pointer

foptr	equ	com2	; output pointer

fifos	equ	com3	; fifo size

ufiad	equ	com4	; upper fifo start address
lfiad	equ	com5	; lower fifo start address

fvme	equ	com6	; fifo vme access

;
; CHAR :	output ( by block )
;

blsiz	equ	com3	; block length

ublad	equ	com4	; upper block start address
lblad	equ	com5	; lower block start address

bvme	equ	com6	; block vme access

;
; CHAR :	change channel setup
;
;	undefined
;
; RTC  :	read / write
;
;	undefined
;

bytemode	struc

bytein	db 0
flagin	db 01
bytout	db 0		; output byte
flagout	db 0		; bit 0 = output

bytemode	ends


	SUBTTL	EQUATES FOR THE INTERFACE SYSTEM
	PAGE

unix_drive1	equ	3		; drive d: first

unix_start	equ	0800h		; starting address
unix_stack	equ	0800h		; initial stack pointer

rfport	equ	0e204h			; access to register file
rfdma	equ	0e206h			; access to dma r file

cr	equ	0dh
lf	equ	0ah
etx	equ	04h

exit	equ	4c00h

crb_size	equ	32		; size of one crb
crbmax	equ	7
;

	SUBTTL	STARTUP CODE
	PAGE

PGROUP	GROUP	PROG

PROG	SEGMENT
	assume cs:pgroup

begin:			; set up stack
	push	cs
	pop	ss
	mov	sp,offset pgroup:stacke
;
;
	xor	cx,cx
	int	99h			; link up to gifdic
	mov	ax,es:[di.ghndlr]
	mov	cs:gifl,ax
	mov	ax,es:[di.spgroup]
	mov	cs:gifh,ax
;
;
	mov	al,unix_drive1
	gifcall dskdev,reset,0		; reset the hard disk
;
;
	call	set_mail		; point to mailboxes
	assume	ds:mailimg 		; cheat the assembler

	mov	ax,seg mailimg
	push	ds
	pop	es			; real mailbox in es
	mov	ds,ax			; source in ds
	mov	si,0
	mov	di,0
	mov	cx,unix_start		; 800h bytes
	rep	movsb			; move the string in bytes

	push	cs
	pop	es
	mov	di,offset signon	; say hello to the folks
	call	ptext


	mov	dx,rfport		; start up the 68k cpu
	mov 	al,stmrf
	out	dx,al
	mov	ax,seg stmmcpu
	mov	ds,ax
	assume	ds:stmmcpu
	mov	ax,stmmcpu0

	mov	cs:pending,0		; no done pending

domailbox:			; check round the mailboxes

	call	set_mail		; point to mailboxes
	assume	ds:mailimg 		; cheat the assembler

	test	bitio.flagout,01h	; any output ?
	jz	no_bytes
	mov	al,bytout		; get it
	push	ds
	gifcall	kvddev,write,waitnr	; print it
	pop	ds
	and	bitio.flagout,0feh	; clear flag
no_bytes:

	test	bitio.flagin,01h	; input
	jnz	no_inbyte
	push	ds
	gifcall	kvddev,read,noopt	; read it
	pop	ds
	jc	no_inbyte
	mov	ds:bytein,al
	or	bitio.flagin,01h
no_inbyte:

	mov	si,cs:concnt		; get pointer
reconout:
	cmp	si,cs:consiz		; anything ??
	jz	noconout
	mov	al,cs:[si]
	gifcall	kvddev,write,noopt	; try to output it
	jc	noconout

	inc	cs:concnt
	inc	si			; point to next
	jmp	reconout

noconout:

	mov	si,cs:dtecnt		; get pointer
redteout:
	cmp	si,cs:dtesiz		; anything ??
	jz	nodteout
	mov	al,cs:[si]
	gifcall	dtedev,write,noopt	; try to output it
	jc	nodteout

	inc	cs:dtecnt
	inc	si			; point to next
	jmp	redteout

nodteout:

	mov	si,cs:dcecnt		; get pointer
redceout:
	cmp	si,cs:dcesiz		; anything ??
	jz	nodceout
	mov	al,cs:[si]
	gifcall	dcedev,write,noopt	; try to output it
	jc	nodceout

	inc	cs:dcecnt
	inc	si			; point to next
	jmp	redceout

nodceout:

	mov	ax,mb.ready		; 0 if no activity
	and	mb.done,ax		; then clear any at idle

	mov	ax,mb.start		; get any
	mov	bx,cs:pending		; waiting for no start
	and	cs:pending,ax		; update pending if no start
	xor	bx,cs:pending		; whats new ?
	xor	mb.busy,bx		; clear busy
	xor	mb.done,bx		; set done

	not	ax
	and	mb.busy,ax		; force busy if start

	mov	ax,mb.busy		; get it
	or	ax,cs:pending		; pick out actions required

	xor	ax,0ffffh		; inverse logic
	jnz	do_this_bit
	jmp	domailbox
do_this_bit:

	roli	ax,8			; adjust bytes

	mov	cx,crbmax		; how many matter

	mov	si,offset mailimg:crb1	; point to first crb

	mov	bx,1

check_crb:
	test	ax,bx			; this crb ?
	jz	not_this
	pusha				; save the state
	call	do_crb			; do the crb
	pushf
	call	set_mail		; point to mailbox again
	popf
	popa				; restore all
	jc	not_this		; not finished
	or	cs:pending,bx		; flag it done
	xor	ax,bx			; clear this bit
	jnz	not_this
	jmp	domailbox		; any more bits ??
not_this:
	shl	bx,1			; next bit
	add	si,crb_size		; point to next
	loop	check_crb		; do all crbs
	jmp	domailbox		; repeat


do_crb:
	cmp	[si].rdevtyp,00		; tty ??
	jnz	notcon
	jmp	console
notcon:
	cmp	[si].rdevtyp,01		; disk ??
	jz	is_disk
	call	badcrb
	clc
	ret				; clear request and exit

is_disk:
	cmp	[si].devno,01		; disk csb
	jz	gooddev
	call	badcrb
	clc
	ret				; error exit
gooddev:
	mov	ax,[si].comand		; get command
	cmp	al,01			; disk command ?
	jnz	baddisk
	and	ah,7fh			; mask flush bit
	cmp	ah,01			; read
	jz	disk_read
	cmp	ah,02
	jz	disk_write
baddisk:
	call	badcomand
	clc
	ret

disk_read:
	call	set_disk		; test & set parameters
	mov	dx,rfdma		; own rf
	out	dx,al			; set it up
	mov	dx,bx			; get start
	mov	al,3			; drive 3 (d:)
	gifcall	dskdev,read,noopt	; do it
	jmp	disk_exit

disk_write:
	call	set_disk		; test & set parameters
	mov	dx,rfport		; share port with mbox
	out	dx,al			; set it up
	mov	dx,bx			; get start
	mov	al,3			; drive 3 (d:)
	gifcall	dskdev,write,noopt	; do it
	jmp	disk_exit

console:
	cmp	[si].rdevno,02		; console device ??
	jz	ok_con
	cmp	[si].rdevno,03		; dte
	jz	ok_dte
	cmp	[si].rdevno,04		; dce
	jz	ok_dce
	call	badcrb
	clc
	ret
ok_con:
	cmp	[si].comand,0102h	; input ?
	jz	conin
	cmp	[si].comand,0202h	; output ??
	jnz	notconout
	jmp	conout
notconout:
	call	badcomand
	clc
	ret

ok_dte:
	cmp	[si].comand,0302h	; fifo mode
	jz	dtefin
	cmp	[si].comand,0102h	; input ?
	jz	dtein
	cmp	[si].comand,0202h	; output ??
	jnz	baddte
	jmp	dteout
baddte:
	call	badcomand
	clc
	ret

ok_dce:
	cmp	[si].comand,0102h	; input ?
	jnz	tryother
	jmp	dcein
tryother:
	cmp	[si].comand,0202h	; output ??
	jnz	baddce
	jmp	dceout
baddce:
	call	badcomand
	clc
	ret

conin:
	push	ds
	gifcall	kvddev,read,noopt	; try it
	pop	ds
	jc	no_input
	push	ax
	lea	si,[si].com4		; point to address
	call	set_addr		; point to it
	pop	ax
	mov	es:[di],al		; set it up
	clc
no_input:
	ret

dtein:
	push	ds
	gifcall	dtedev,read,noopt	; try it
	pop	ds
	jc	dte_input
	push	ax
	lea	si,[si].com4		; point to address
	call	set_addr		; point to it
	pop	ax
	mov	es:[di],al		; set it up
	clc
dte_input:
	ret


dtefin:			; input to fifo

	mov	cl,8			; for shifts
	mov	ax,[si].fiptr		; in pointer
	mov	bx,[si].com2		; out pointer
	mov	dx,[si].com3		; fifo size
	ror	ax,cl
	ror	bx,cl
	ror	dx,cl			; adjust hi lo
	push	ax			; old pointer
	inc	ax			; next
	cmp	ax,dx			; wrap round ?
	jnz	nowrap
	xor	ax,ax			; restart
nowrap:
	push	ax			; next pointer
	cmp	ax,bx			; pointers same ??
	jnz	tryinput
fifexit:
	pop	ax
	pop	ax			; clear stack
	stc				; not finished
	ret

tryinput:
	push	ds
	gifcall	dtedev,read,noopt	; try to get it
	pop	ds
	jc	fifexit			; no data
	push	ax
	push	si			; save pointer to crb
	lea	si,[si].com4		; point to address
	call	set_addr		; point to it
	pop	si			; recover crb
	pop	ax			; recover data
	pop	dx			; new pointer
	pop	bx			; old pointer
	mov	es:[bx.di],al		; set it up
	mov	bx,dx			; save pointer
	call	set_mail		; restore mailboxes
	mov	[si].com1,bx		; new pointer
	stc
	ret				; not finished

dcein:
	push	ds
	gifcall	dcedev,read,noopt	; try it
	pop	ds
	jc	dce_input
	push	ax
	lea	si,[si].com4		; point to address
	call	set_addr		; point to it
	pop	ax
	mov	es:[di],al		; set it up
	clc
dce_input:
	ret


conout:
	mov	ax,cs:concnt		; pointer
	cmp	ax,cs:consiz		; busy ?
	jnz	con_busy

	mov	ax,[si].com3		; data count
	mov	cl,ah
	mov	ch,al			; swap count
	push	cx
	add	cx,offset pgroup:conbuf
	mov	cs:consiz,cx
	mov	cs:concnt,offset pgroup:conbuf

	lea	si,[si].com4
	call	set_addr		; point to data
	push	es
	pop	ds
	push	cs
	pop	es
	mov	si,di			; point to data
	mov	di,offset pgroup:conbuf
	pop	cx
	rep	movsb
	clc
	ret

con_busy:
	stc
	ret				; return busy

dteout:
	mov	ax,cs:dtecnt		; pointer
	cmp	ax,cs:dtesiz		; busy ?
	jnz	dte_busy

	mov	ax,[si].com3		; data count
	mov	cl,ah
	mov	ch,al			; swap count
	push	cx
	add	cx,offset pgroup:dtebuf
	mov	cs:dtesiz,cx
	mov	cs:dtecnt,offset pgroup:dtebuf

	lea	si,[si].com4
	call	set_addr		; point to data
	push	es
	pop	ds
	push	cs
	pop	es
	mov	si,di			; point to data
	mov	di,offset pgroup:dtebuf
	pop	cx
	rep	movsb
	clc
	ret

dte_busy:
	stc
	ret				; return busy

dceout:
	mov	ax,cs:dcecnt		; pointer
	cmp	ax,cs:dcesiz		; busy ?
	jnz	dce_busy

	mov	ax,[si].com3		; data count
	mov	cl,ah
	mov	ch,al			; swap count
	push	cx
	add	cx,offset pgroup:dcebuf
	mov	cs:dcesiz,cx
	mov	cs:dcecnt,offset pgroup:dcebuf

	lea	si,[si].com4
	call	set_addr		; point to data
	push	es
	pop	ds
	push	cs
	pop	es
	mov	si,di			; point to data
	mov	di,offset pgroup:dcebuf
	pop	cx
	rep	movsb
	clc
	ret

dce_busy:
	stc
	ret				; return busy


set_addr:				; point to vme address
	call	get_addr		; calculate
	mov	dx,rfport		; rf port address
	out	dx,al			; set up rf
	ret				; done

get_addr:				; calculate vme address

	mov	cx,8			; for byte swap
	mov	ax,[si]			; upper address
	ror	ax,cl
	add	ax,40h			; start address offset on vme
	and	ax,00f8h		; upper 5 bits
	mov	bx,[si+4]		; vme access code
	ror	bx,cl
	and	bx,0007h		; valid bits
	or	ax,bx			; data for rf in al
	mov	bx,[si]			; upper address
	ror	bx,cl
	mov	dx,[si+2]		; lower address
	ror	dx,cl
	mov	cx,4
	shr	dx,cl			; reduce to segment size
	shl	bx,cl			; bits up in bl
	or	dh,bl
	and	dx,7fffh		; clear msb
	add	dx,4000h		; last move
	mov	es,dx			; got it in seg reg
	mov	di,[si+2]		; lower address
	mov	cx,8
	ror	di,cl
	and	di,0fh			; offset
	ret



set_disk:
	push	si			; save our pointer
	lea	si,[si].com4		; address data
	call	get_addr		; get vme data
	pop	si
	mov	cx,8			; byte swap
	mov	bx,[si].com3		; sector count
	ror	bx,cl
	push	bx
	mov	bx,[si].com2		; start sector number
	ror	bx,cl
	pop	cx
	ret

disk_exit:
	push	ax
	call	set_mail		; point to mail boxes
	pop	ax
	mov	al,0			; not valid status in al
	mov	csb1.errcod,ax		; send it
	clc
	ret

set_mail:				; access mailboxes
	mov	dx,rfport		; register file port
	mov	al,mailrf		; mailbox access
	out	dx,al			; set it up
	mov	ax,seg mailbox		; access address
	mov	ds,ax
	ret
errfull:
	mov	di,offset fifoflow
	jmp	perr

badcrb:
	mov	di,offset crberr
	jmp	perr
badcomand:
	mov	di,offset comerr
	jmp	perr
badsect:
	mov	di,offset secerr
	jmp	perr
baddev:
	mov	di,offset deverr
	jmp	perr
badtype:
	mov	di,offset typerr

perr:
ptext:		; print all characters from es:di to 04h ( etx )
	push	cs
	pop	es			; messages are in cs
	jmp	ptext1			; starting point
printone:
	push	es
	push	di
	gifcall	kvddev,write,waitnr	; print 1, no return till done
	pop	di
	pop	es
ptext1:
	mov	al,es:[di]		; get character
	inc	di			; next
	cmp	al,etx
	jne	printone		; output one
	ret


signon:	db	lf,lf,cr,'1st level UNIX I/O System',cr,lf
	db	'Starting UNIX now.',lf,cr,etx

crberr:	db	cr,lf,'Illegal CRB requested !',cr,lf,etx

comerr:	db	cr,lf,'Bad command.',cr,lf,etx
secerr:	db	cr,lf,'Bad disc sector.',cr,lf,etx
deverr:	db	cr,lf,'Bad disc device.',cr,lf,etx
typerr:	db	cr,lf,'Bad disc type.',cr,lf,etx

fifoflow:	db	'.',etx

;
gifdic	label	dword
gifl	dw	?
gifh	dw	?
;
	db ?
	db ?
	db ?
pending dw	0

conbuf	db	400h dup (?)	; output buffer
concnt	dw	?
consiz	dw	?

dtebuf:	db	400h dup (?)	; output buffer
dtecnt	dw	?
dtesiz	dw	?

dcebuf:	db	400h dup (?)	; output buffer
dcecnt	dw	?
dcesiz	dw	?


		; space for system stack

	dw	80h dup (?)
STACKE:

PROG	ENDS

	SUBTTL	DATA SEGMENTS ON MMCPU CARD FOR START UP
	PAGE


stmmcpu segment at 0b000h
stmrf	equ	0bbh			; register file access
	org	0fffeh
stmmcpu0 dw ?
stmmcpu ends

mmcpu	segment at 4000h	; real mmcpu address space
mmcrf	equ	043h
mmcpu ends


mailimg	segment		; image of mmcpu memory on syscon

ssp0	dw 	0000			; upper initial stack
ssp1	dw	unix_stack		; initial 68k stack
pc0	dw	0000			; upper start address
pc1	dw	unix_start		; 68k start address

	dw 508 dup (0)			; rest of the vectors

		; address at 400h

mb	flags	<>			; flag structure

		; address at 420h

csb1	csb_main	<1,1,1,1,0,
	csb_disk	<>

csb2	csb_main	<>
	csb_disk	<>

csb3	csb_main	<>
	csb_disk	<>

csb4	csb_main	<>
	csb_disk	<>

csb5	csb_main	<>
	csb_tty		<>

csb6	csb_main	<>
	csb_tty		<>

csb7	csb_main	<>
	csb_tty		<>

csb8	csb_main	<>
	csb_tty		<>

csb9	csb_main	<>
	csb_rtc		<>


		; address at 540h

crb1	crb_main	<>

crb2	crb_main	<>

crb3	crb_main	<>

crb4	crb_main	<>

crb5	crb_main	<>

crb6	crb_main	<>

crb7	crb_main	<>

crb8	crb_main	<>

crb9	crb_main	<>

		; address at 660h

	dw 206 dup (0)		; spare space

		; address at 7fch

bitio	bytemode	<>


mailimg	ends

	SUBTTL	DATA SEGMENT FOR MAILBOXES : FLAGS
	PAGE

mailbox segment at 4000h
mailrf	equ	043h			; register file access

mailbox	ends


	end	begin		; program start address

