TITLE --- text editor : to edit a line of characters


include xinstr.mac
include texin.equ
include ledtor.equ
include gifmac.mac

pgroup group prog


prog segment byte public 'prog'

	assume cs:pgroup

	extrn dispchr:near, lookcct:near, dispubuf:near, shbufr:near
	extrn ascii:near, nchrhdlr:near

; function : to input character string with powerful editing functions
; input parameters:
;	es:di	default line buffer
;	ds:si	user buffer
;	cx	default buffer length
;	bx	gifdic channel code
;	dx	command register
;	ss:ax	control character table (CCT)
;
; output parameters:
;	cx	character count
;	es:di	edited buffer
;	CY	if error
;
; destroyed : ds, si


nprocedure texin

	push bp
	xor bp, bp
	enter <size leddat>, 0	; reserve area in stack
	push bp
	mov bp, sp
	add bp, 2
	mov [bp.gifdev], bx	; save the input parameters
	mov [bp.cctptr], ax
	mov [bp.cmd], dx
	mov [bp.defbuflen], cx
	mov [bp.usrbufirst], si
	mov [bp.defbufirst], di
	push ds			; exchange es:di and ds:si
	mov ax, es
	mov ds, ax
	pop es
	xchg si, di
	test dx, echom		; test whether it needs to echo
	jz edcont
	call dispubuf		; display user buffer up to defbuflen
	jc resbufs
edcont:
	test dx, outputm
	jz edcont2
	stc
	jmp resbufs
edcont2:
	mov al, cr_c		; display carriage return
	call dispchr
	jc resbufs
edcont1:
	mov al, sp_c		; initialize user buffer
	mov cx, linlen
	rep stosb
	mov cx, [bp.defbuflen]
	mov si, [bp.defbufirst]
	mov di, [bp.usrbufirst]
	rep movsb		; mov default buffer content to user
				; buffer content
resbufs:
	push ds			; resume original es:di and ds:di
	mov ax, es
	mov ds, ax
	pop es
	mov si, [bp.usrbufirst]
	mov di, [bp.defbufirst]
	jc edret
	mov cx, [bp.defbuflen]  ; set character count to default buffer length
	mov [bp.curposn], 0	; cursor position is set to zero
				; in the user buffer
	mov [bp.putmode], insertm ; initial put mode is set to insert from
				; bol
	mov [bp.insflag], ibegin ; set insert from bol
	mov [bp.msuffix], nchrc  ; set mode suffix to normal character code
	mov [bp.mtchr], 0	; set edit character count to zero
	mov [bp.exitf], 0	; set exit flag to zero
	mov [bp.errorf], 0	; set error flag to zero
	mov [bp.curmode], offset pgroup:nchrhdlr ; set current mode to normal char handler
						 ; character
togetchr:			; use a loop to get and handle char
	mov bx, [bp.gifdev]	; set bx to gifdic channel code
	or bx, (read shl 2)
	call ascii
	jc  edret
	call lookcct
	jnc nrmlchar
	cmp [bp.errorf], itserr
	je edret
	cmp [bp.exitf], toexit
	jne togetchr
	clc
	jmp edret
nrmlchar:
	xor bx, bx
	mov bl, [bp.putmode]
	shl bx, 1
	add bx, offset pgroup:putmhdlr
	call word ptr cs:[bx]
	jnc togetchr
edret:
	mov bx, [bp.gifdev]
	mov ax, [bp.cctptr]
	mov dx, [bp.cmd]
	pop bp
	leave
	pop bp
	ret
texin  endp


putmhdlr  dw  offset pgroup:toappend
	  dw  offset pgroup:toinsert
	  dw  offset pgroup:tochange


; function : to append a character at the current cursor position
; input parameter : al -- the character to be put in
; output parameter : cx -- the new character count
;			CY if error
; destroyed : si, bx, ax


nprocedure toappend

	mov si, [bp.usrbufirst] ; first set si pointing to cursor posn
	xor bx, bx
	mov bl, [bp.curposn]
	add si, bx
	push cx			; save character count
	mov [si], al		; store character at cursor posn
	mov cx, 1
	call dispubuf		; display cursor posn of buffer
	pop cx		; restore character count
	jc appret
	cmp cl, linlen	 ; update char count if character count is not
	je appcont	 ; exit cursor position
	cmp cl, [bp.curposn]
	jg appcont
	inc cx
appcont:
	cmp [bp.curposn], (linlen-1) ; update cursor posn if not exit
				     ; line length
	je bcursor
	inc [bp.curposn]
	jmp short appnexit
bcursor:			; if it is at the most right hand side
	mov al, bsp_c		; then make the cursor remain there
	mov bx, [bp.gifdev]
	call dispchr
appnexit:
	clc
appret:
	ret
toappend endp


; function : to insert a character at the current cursor position
;	     cursor position is updated if insflag = 1
; input parameter : al -- the character to be inserted
; output parameter : updated cx, CY if error
; destroyed : si, bx, ax

nprocedure toinsert

	mov si, [bp.usrbufirst]  ; get the cursor posn in the buffer
	xor bx, bx
	mov bl, [bp.curposn]
	add si, bx
insmkrm:
	mov bx, 1
	call shbufr	; shift chars from cursor posn to eol right 1 
	jc insret
	mov [si], al	; store character into the buffer
	push cx		; save character count
	mov cx, [bp.usrbufirst]
	add cx, linlen
	sub cx, si
	call dispubuf ; display character from cursor posn to eol
	jnc inscont
	pop cx
	jmp short insret
inscont:
	test [bp.insflag], ibegin ; test whether it is insert from bol
	jnz  toicont
	cmp cx, 1	; if it is, the number of columns to retreat
			; must be less than the characters displayed
			; by 1 unless it is at the most right hand side
	je chkcurs
	dec cx
chkcurs:
	cmp [bp.curposn], (linlen-1) ; update cursor posn unless
	je toicont		; it is at the most right hand side
	inc [bp.curposn]
toicont:		; move cursor backward
	mov bx, [bp.gifdev]
idisbsp:
	mov al, bsp_c
	call dispchr
	jc insret
	loop idisbsp
	pop cx		; resume character count
	cmp cx, linlen	; update character count
	je insnexit
	inc cx
insnexit:
	clc
insret:
	ret
toinsert endp


; function : to change a character until a counter is exhausted
; input parameter : al -- the character to be put in
; output parameter : CY if error
; destroyed : bx

nprocedure tochange

	mov si, [bp.usrbufirst]
	xor bx, bx
	mov bl, [bp.curposn]
	add si, bx
	mov bl, [bp.mtchr]	; check whether the matched char is reached
	cmp [si], bl
	je chg2ins
	push cx			; save character count
	mov [si], al		; store character at cursor posn
	mov cx, 1
	call dispubuf		; display cursor posn of buffer
	pop cx			; resume character count
	jc chgret
	inc [bp.curposn]
	jmp short chgret
chg2ins:
	mov [bp.putmode], insertm
	mov [bp.insflag], iccurs
	jmp insmkrm
chgret:
	ret
tochange endp


prog ends

end
