TITLE --- LEDTOR : this is a line editor which provides both text editing
;	  function and hexdecimal input editing function


include ledtor.equ
include xinstr.mac


pgroup group prog

prog segment byte public 'prog'

	assume cs:pgroup
	extrn texin:near, hexin:near


; function : line editor which arbitrates between line editor and hexdecimal
;	     input editor
;
; input : ES:DI -- default line buffer / HEX buffer
;   	  DS:SI -- user buffer / ASCII buffer
; 	  CX -- default buffer length / number of digits (ASCII buffer length)
;	  BX -- GIFDIC handler device
;	  DX -- Command Register
;	  SS:AX -- Control Character Table (CCT)
;
;
; output : for text editor
;	    ES:DI -- beginning of default line buffer
;	    DS:SI -- corrupt
;	    CX -- character count
;
;	   for hexadecimal input editor :
;	    ES:DI -- immediate after the last character filled in
;	    DS:SI -- immediate after the last character read from
;
;	   CY if error
; destroyed : none of other registers


nprocedure ledtor

	test dx, asciim
	jz itshexin
	jmp texin
itshexin:
	jmp hexin

ledtor endp

prog ends

end

