/*
	Routines MSDOS File system debugger
*/
#include "\gifi\c\gifdicc.h"
#include "\c\h\stdio.h"
struct giftd waitkey={SCONDEV+READ,2};
struct giftd stopr={SCONDEV+READ};
struct giftd gifcout={SCONDEV+WRITE,2};
struct giftd gifpout={SPRTDEV+WRITE,2};
struct giftd rddks={DSKDEV+READ};
extern int xx,more; /*dummy*/
extern char fatbuf[];
extern int unit,data,printflg;
struct giftd xx1;
char refbuf[100] [51];
char buf[] = "1234567890abcdef";
char srcbuf[4096];
int stopf,moref;

/*
main(){
gifinit();
pbah(&buf);
pbasc(&buf);
}
*/
stop()
{
   char x;
   if (stopf) {
	stopf=0; return(1);
   }
   if ((x=gift(&stopr,&xx1))==0 && xx1.ral==0x7f) {
   	printf("\n*Interupted*\n"); return(1);
   }
   else return(0);
}

gcpo()
{
    gifpout.ral=gifcout.ral; gift(&gifcout,&xx);
    if (printflg)
	gift(&gifpout,&xx);
}

gout(y)
char y;
{
   if (y=='\r') return(0);
   if (y=='\n') {
		if (more) {
			if (moref++==23) {
				gift(&waitkey,&xx1); moref=0;
				if (xx1.ral==0x7f) stopf=1;
			}
		}
 		gifcout.ral='\r'; gcpo();
   }
		gifcout.ral=y; gcpo();
}

goutp(y)
char y;
{
	if ((gifcout.ral=y&0x7f)<' ' || gifcout.ral == 0x7f) gifcout.ral=' ';
	gcpo();
}


pdigh(y)
char y;
{
   if ((y=y&0xf)<=9) gout(y+'0'); else gout(y+'7');
}

pbyte(y)
char y;
{
   pdigh(y>>4);
   pdigh(y);
}
pword(y)
int y;
{
   pbyte(y>>8);
   pbyte(y);
}


pasc16(y)
char *y;
{
int i;
   for (i = 0; i<16; i++) {
	goutp(*y++);
   }
}

phex16(y)
char *y;
{
   int i;
   for (i = 0; i<16; i++) {
	pbyte(*y++); gout(' ');
	if (i%4==3) gout(' ');
   }
}


pbhex(y)
char *y;
{
   int i,x;
   for (i=0; i<256; i++) {
		if ((x=stop())) break;
	pbyte(i); gout(' '); phex16(y); pasc16(y); y=y+16; gout('\n');
   }
}
pbasc(y)
char *y;
{
   int i,j,x;
   char c,curs;
   for (i=0; i<4096; i++) {
	if ((x=stop())) break;
	if ((c=*y++&0x7f) >= ' ' && c < 0x7f ) {
		gout(c); curs++;
	}
	else if (c=='\n') {
		gout(c); curs=0;
	}
	else if (c=='\t') {
		for (j=(curs&7); j<8; j++)
			gout(' ');
	}
   }
}

pdir(y)
char *y;
{
   int i,j,k,l,m,x;
   char c;
	for (i=0; i<128; i++) {
		if ((x=stop())) break;
		if (*y==0) break;
		l=8;
		for (j=0; j<8; j++) {
			if (*y >= ' ') {
				goutp(*y++); l--;
			}
			else break;
		}
		y=y+l; if (*y <=' ' ) {
				y=y+3; l=l+4; m=0;
			}
		else {
			gout('.'); m=3;
		}
		for (k=0; k<m; k++) goutp(*y++);
		for (k=0; k<l+4; k++) gout(' ');
		gout('F'); gout(' '); pbyte(*y++); gout(' ');
		gout('C'); gout(' ');
		y=y+14; c=*y++; pbyte(*y++); pbyte(c); gout(' ');
		gout('S'); gout(' ');
		c=*y++; pbyte(*y++); pbyte(c); y=y+2; gout('\n');
	}
}

rdfat(x)
int x;
{
	int y,z;
	z=x*3/2; y=x*12;
	if (y&7) 
		y=(fatbuf[z]>>4)+(fatbuf[z+1]<<4);
	else
		y=fatbuf[z]+((fatbuf[z+1]&0xf)<<8);
	return(y);
}

rdfatr(x)
int x;
{
	int y,z;
	z=x*3/2; y=x*12;
	if (y&7) 
		y=(srcbuf[z]>>4)+(srcbuf[z+1]<<4);
	else
		y=srcbuf[z]+((srcbuf[z+1]&0xf)<<8);
	return(y);
}

wrfat(x,t)
int t,x;
{
	int y,z;
	z=x*3/2; y=x*12;
	if (y&7) {
		fatbuf[z]=(fatbuf[z] & 0xf)+((t & 0xf)<<4);
		fatbuf[z+1]=t >> 4 & 0xff;
	}
	else
	{
		fatbuf[z]=t & 0xff;
		fatbuf[z+1]=(fatbuf[z+1] & 0xf0)+(t >> 8 & 0xff);
	}
}

prfat(x)
int x;
{
int i,y,z;
	i=0;
	do {
	    y=rdfat(x++);
	    pword(y); gout(' ');
	    if (i++==15) {
		gout('\n'); i=0;
	    }
            if ((z=stop())) break;
	}
	while (y != 0xfff);
}
pfrcls(x,y)
int x,y;
{
    int i,j,z;
    j=0;
    for (i=x; i<=y; i++) {
	if ((z=rdfat(i))==0) {
	    pword(i); gout(' ');
	    if (j++==15) {
		gout('\n'); j=0;
	    }
	}
	if ((z=stop())) break;
    }
}

srchstr(i)
int i;
{
  int j,k,l,m,x,y,z;
  l=0;
  do {
    j=x=y=z=0;
    while (x<4096) {
	while ((srcbuf[x+z] & 0x5f)==(refbuf[l] [z] & 0x5f))
	    if (refbuf[l] [++z]=='\0') {
		if (k != i*l) {
		    k=i*l; gout('\n'); m=0;
		    while (refbuf[l] [m])
			gout(refbuf[l] [m++]);
		    gout(' '); pword(i); gout('\n');
		}
		pword(x); gout(' '); x=x+z;
		if (j++==15) {
		    gout('\n'); j=0;
		}
	    }
	if ((srcbuf[x+z] &0x7f) > ' ') z=0;
	x++;
    }
  }
 while (refbuf[++l] [0]);
}

srchpat(x,y)
int x,y;
{
    int i,q,r,z;
    y++;
    scanf("%1s",&q);
    q = q | ' ' ;
    scanf("%2d",&r);
    for (i=0; i<r+1; i++)
	refbuf[i] [0] = 0;
    for (i=0; i<r; i++) 
	scanf("%50s",&refbuf[i] [0]);
    for (i=x; i<y; i++) {
	if (((z=rdfat(i))==0 && q == 'u') || q == 'x' || (q == 'a' && z)) {
	    rddks.rdx=(i-2)*8+0x18; rddks.rcx=8; rddks.ral=unit;
	    rddks.rdi=&srcbuf; rddks.res=data;
	    gift(&rddks,&xx1);
	    srchstr(i);
	}
	if ((z=stop())) break;
    }
}

editfat()
{
    char chr[2];
    char chr1[2];
    int x,y,z;
    scanf("%1s",&chr); chr[0]=chr[0] | ' ';
    scanf("%3x",&x);
    while (1) {
	z=rdfat(x); printf("\n%3x %3x",x,z);
	if ((chr[1]=scanf("%3x",&y))==EOF) break;
	if (chr[1]==1) {
	    wrfat(x,y); z=y;
	}
	else {
	    scanf("%1s",&chr1);
	    if ((chr1[0] | ' ') == 'q') return(0);
	}
	if (chr[0]!='l')
	    x=z;
	else
	    x++;
    }
}

cmpfat()
{
    int i,x,y,z;
    for (i=0; i<0xff0; i++) {
	if ((x=rdfat(i)) != (y=rdfatr(i)))
	    printf("E %3x F %3x R %3x\n",i,x,y);
	if ((z=stop())) break;
    }
}
/*



a

