 	page	60,80
TITLE GENERAL PURPOSE I/O INTERFACE VERSION 1.5
SUBTTL	GENERAL PURPOSE UTILITIES VERSION 1.5

	.xlist

	include	gifdic.mac
	include	80186.mac
	include options.h
	include equates.h
	include mailboxs.h
	include	data.h
	
boot_utl	equ	1

	include	boot_lnk.h

	.list
	.xall

;******************************************************
;
;	UTILITIES
;
;******************************************************
	assume	ds:mailbox
get_csb:
			; make ds:di point to the relevent csb

	mov	al,[si].DEVNO		; get the device (csb) number
	dec	al
	xor	ah,ah			; clear ah
	sali	ax,5			; multiply by 32
	mov	di,offset mailbox:MCSB1	; start
	add	di,ax			; pointer
	ret

get_flag:
	mov	dx,si
	sub	dx,offset mailbox:MCRB1
	sari	dx,5			; / 32
	push	dx
	sari	dx,4			; / 16
	add	dx,dx			; * 2
	add	di,dx			; flag address
	pop	cx
	and	cx,0fh
	mov	dx,8000h
	sar	dx,cl			; set bit
	ret

tst_flag:
	pusha
	call	get_flag
	test	[di],dx
	popa
	ret

set_flag:
	pusha
	call	get_flag
	or	[di],dx
	popa
	ret

clr_flag:
	pusha
	call	get_flag
	not	dx
	and	[di],dx
	popa
	ret

xor_flag:
	pusha
	call	get_flag
	xor	[di],dx
	popa
	ret
	
to_hex:				; convert hex - ascii
	and	al,0fh
	add	al,30h
	cmp	al,3ah
	jc	is_hex
	add	al,7h
is_hex:
	ret


set_addr:				; point to vme address
	call	get_addr		; calculate
	mov	dx,rfport		; rf port address
	out	dx,al			; set up rf
	ret				; done

get_addr:				; calculate vme address

	mov	ax,[si]			; upper address
	swap	ax
	add	ax,ram_68k		; start address offset on vme
	and	ax,00f8h		; upper 5 bits
	mov	bx,[si+4]		; vme access code
	swap	bx
	and	bx,0007h		; valid bits
	or	ax,bx			; data for rf in al
	mov	bx,[si]			; upper address
	swap	bx
	mov	dx,[si+2]		; lower address
	swap	dx
	mov	cx,4
	shr	dx,cl			; reduce to segment size
	shl	bx,cl			; bits up in bl
	or	dh,bl
	and	dx,7fffh		; clear msb
	add	dx,4000h		; last move
	mov	es,dx			; got it in seg reg
	mov	di,[si+2]		; lower address
	swap	di
	and	di,0fh			; offset
	ret

test_boot:
	mov	byte ptr cs:doboot,0		; flag cold boot
	call	do_boot
	cld
	repe	cmpsb			; test it
	jnz	clr_boot
	push	es
	pop	ds
	mov	ax,MLAB.CTICK		; unix tick
	mov	cx,80h
ticking:
	cmp	ax,MLAB.CTICK
	loope	ticking
	je	clr_boot			; 

	mov	byte ptr cs:doboot,0ffh		; flag it
clr_boot:
	call	do_boot
	mov	byte ptr es:[di],01		; active
	ret

set_boot:
	call	do_boot
	mov	byte ptr es:[di],0feh		; passive
	mov	ax,cs:pending.PEND1
	mov	es:SUSPEND.PEND1,ax
	mov	ax,cs:pending.PEND2
	mov	es:SUSPEND.PEND2,ax
	mov	ax,cs:pending.PEND3
	mov	es:SUSPEND.PEND3,ax
	mov	ax,cs:pending.PEND4
	mov	es:SUSPEND.PEND4,ax

	ret

do_boot:
	call	set_mail		; set mailboxes
	push	cs
	push	ds
	pop	es
	pop	ds
	mov	si,offset cs:stboot
	mov	di,offset mailbox:MSCB.SFLAG
	mov	cx,8        ; lenboot		; byte count
	ret

clear_ram:
	cld
	mov	cs:ram_size,0ffffh
	mov	bx,0ffffh
clear_loop:
	call	get_next_page
	call	peep_seg
	jnz	end_of_ram
	mov	ax,0ffffh
	call	fill_seg
	jmp	clear_loop
end_of_ram:
	mov	cs:ram_size,bx
	mov	bx,0ffffh
cloop1:
	call	get_next_page
	cmp	cs:ram_size,bx
	jz	eor1
	mov	ax,0ffffh
	call	check_seg
	jnz	eor1
	mov	ax,0a55ah
	call	fill_seg
	jmp	cloop1
eor1:
	mov	cs:ram_size,bx
	mov	bx,0ffffh
cloop2:
	call	get_next_page
	cmp	cs:ram_size,bx
	jz	eor2
	mov	ax,0a55ah
	call	check_seg
	jnz	eor2
	mov	ax,05aa5h
	call	fill_seg
	jmp	cloop2
eor2:
	mov	cs:ram_size,bx
	mov	bx,0ffffh
cloop3:
	call	get_next_page
	cmp	cs:ram_size,bx
	jz	eor3
	mov	ax,05aa5h
	call	check_seg
	jnz	eor3
	mov	ax,00000h
	call	fill_seg
	jmp	cloop3
eor3:
	mov	cs:ram_size,bx
	mov	bx,0ffffh
cloop4:
	call	get_next_page
	cmp	cs:ram_size,bx
	jz	eor4
	mov	ax,00000h
	call	check_seg
	jz	cloop4
eor4:
	mov	cs:ram_size,bx
	ret



get_next_page:
	mov	ax,es			; get the segment
	add	ax,1000h		; get next segment
	mov	es,ax			; save it
	mov	ds,ax			; for later
	xor	si,si
	xor	di,di			; pointers to start
	inc	bx			; up the counter
	test	bx,07h			; rf ok ?
	jnz	got_next		; then skip
	mov	dx,rfport		; register file port
	mov	al,bl			; get count
	and	al,0f8h			; mask in good bits
	add	al,mmcrf		; add the amods
	out	dx,al
	mov	ax,4000h		; first segment
	mov	es,ax
	mov	ds,ax			; into seg regs
got_next:
	ret

fill_seg:
	mov	cx,8000h
	rep	stosw
	ret

check_seg:
	mov	cx,8000h
	repz	cmpsw
	ret

peep_seg:
	mov	byte ptr es:[0],0a5h
	cmp	byte ptr es:[0],0a5h
	jnz	bad_read
	mov	byte ptr es:[0],05ah
	cmp	byte ptr es:[0],05ah
bad_read:
	ret

set_mail:				; access mailboxes
	mov	dx,rfport		; register file port
	mov	al,mailrf		; mailbox access
	out	dx,al			; set it up
	mov	ax,seg mailbox		; access address
	mov	ds,ax
	ret


get_boot:
	mov	ax,cs
	sub	ax,10h			; right ds
	mov	ds,ax			; segment for file

	mov	di,68h
	xor	al,al
	mov	cx,20h
	push	ds
	pop	es			; sort oursegments
	rep	stosb			; clear fcb
	mov	dx,05ch
	mov	ah,0fh			; open file
	int	sys_call
	cmp	al,0
	jz	fileopen

	mov	di,05ch			; fcb
	push	ds
	pop	es
	push	cs
	pop	ds			; swap segments around
	mov	si,offset cs:bootname
	mov	cx,37			; no of bytes
	rep	movsb			; copy it
	push	es
	pop	ds			; restore ds

	mov	dx,05ch
	mov	ah,0fh			; open file
	int	sys_call
	cmp	al,0
	jz	fileopen
	mov	dx,offset pgroup:errmes
	add	dx,100h
	mov	ah,9			; print string
	int	sys_call
	mov	ah,4ch			; terminate
	int	sys_call		; quit
fileopen:
	push	ds
	push	cs
	pop	ds
	mov	dx,offset pgroup:dbuffer
	mov	ah,1ah
	int	sys_call
	pop	ds
	mov	dx,5ch
	mov	ah,14h
	int	sys_call
	mov	ah,10h			; close file
	int	sys_call
	push	es
	push	ds			; save es,ds
	pop	es			; put ds into es for stosb
	xor	al,al
	mov	cx,37			; clear 37 bytes
	mov	di,6ch			; address of fcb
	rep	stosb			; clear fcb
	mov	al,20h
	mov	cx,11			; 11 char for filename
	mov	di,6dh
	rep	stosb			; fill filename area with blanks
	push	ds			; put ds back on stack
	push	cs
	pop	es			; put cs into es
	push	cs
	pop	ds			; put cs into ds
	test	byte ptr cs:doboot,0ffh		; cold boot?
	jnz	ddskl			; no warm boot
	mov	si,offset pgroup:oslabel
	mov	cx,3			; # chars in oslabel
	call	fnd_nme
	cmp	al,0ffh
	jz	fferror
	mov	cx,9000h		; start address for unix
	cmp	al,50h			; first char of name P
	jne	getnam			; no
	mov	cx,4200h		; start address for PDOS
getnam:
	mov	cs:osstart,cx		; save it
	mov	si,offset pgroup:nmlabel
	mov	cx,5			; # chars in nmlabel
	call	fnd_nme
	cmp	al,0ffh			; error in finding os label?
	jz	fferror
	call	get_val			; get file name of os
	cmp	al,0ffh			; error in finding name?
	jz	fferror
	cmp	cx,0			; error in finding name?
	jz	fferror
	mov	si,di
	pop	es			; put ds into es
	mov	di,6dh			; location for filename in fcb
	cld
	rep	movsb			; move filename into fcb
	push	es			; put ds back on stack
ddskl:
	push	cs
	pop	es			; put cs into es
	mov	si,offset pgroup:dklabel
	mov	cx,5			; # of chars in disk label
	call	fnd_nme			; find disk label
	cmp	al,0ffh			; error in finding label?
	jz	fferror
	mov	ah,NUM_DISK		; load number of disks allowed
	mov	bx,0			; initialize offset
ldklpe:
	call	get_val			; get next value in list
	cmp	al,0ffh			; error in next value?
	jz	fferror
	mov	si,di
	mov	di,offset pgroup:wdtab
	add	di,bx			; add offest into wdtab
	rep	movsb			; move disk name into wdtab
	cmp	al,0feh			; end of disk list?
	jz	caryon			; yes
	dec	ah			; decrement disk counter
	cmp	ah,0			; used up all of our disks?
	jz	caryon			; yep
	add	bx,4			; increment wdtab pointer
	mov	di,dx			; point to next value in list
	jmp	ldklpe

fferror:
	jmp	cferror

caryon:
	mov	si,offset pgroup:chlabel
	mov	cx,5			; # of chars in char label
	call 	fnd_nme			; find char label
	cmp	al,0ffh			; error in finding label?
	jz	fferror
	mov	ah,4			; # of character devices supported
	mov	si,offset pgroup:chtab	; get address to char table
lchlpe:
	call	get_val			; get next value in list
	cmp	al,0ffh			; error?
	jz	fferror
	mov	bl,es:[di]		; get first character
	cmp	bl,4bh			; is it a 'K'
	jz	iskvd
	cmp	bl,50h			; is it a 'P'
	jz	isprt
	cmp	bl,44h			; is it a 'D'
	jne	fferror			; no - an error in config file
	mov	bl,es:[di+1]		; get next character in value
	cmp	bl,43h			; is it a 'C'
	jz	isdce
	cmp	bl,54h			; is it a 'T'
	jz	isdte	
	jmp	fferror			; error in config
iskvd:
	mov	bx,kvddev		; enter kvd code into chtab
	mov	di,offset cs:con_fifo	; load offset for fifo
	jmp	echlpe
isprt:
	mov	bx,prtdev		; enter prt code into chtab
	mov	di,offset cs:prn_fifo	; get fifo
	jmp	echlpe
isdce:
	mov	bx,dcedev		; enter dce code into chtab
	mov	di,offset cs:dce_fifo	; get fifo
	jmp	echlpe
isdte:
	mov	bx,dtedev		; enter dte code into chtab
	mov	di,offset cs:dte_fifo	; get fifo

echlpe:
	mov	ds:[si],bx
	mov	ds:[si+2],di		; put fifo address into table
	cmp	al,0feh			; end of list?
	jz	karyon
	dec	ah			; decrement char counter
	cmp	ah,0			; all finisked?
	jz	karyon
	add	si,4			; increment chtab pointer
	mov	di,dx			; point to next value 
	jmp	lchlpe

karyon:
	mov	si,offset pgroup:fplabel
	mov	cx,5			; # chars in flop label
	call	fnd_nme
	cmp	al,0ffh
	jz	cferror
	sub	al,30h			; turn ascii into binary
	mov	cs:num_flop,al		; store number of floppys on system
	pop	ds			; restore ds
	pop	es			; restore es
	test	byte ptr cs:doboot,0ffh		; cold boot?
	jz	cdboot			; yes
	ret
cdboot:
	mov	dx,6ch			; loc. of fcb
	mov	ah,0fh			; open system file
	int	sys_call
	cmp	al,0			; any errors?
	jne	cferror			; yes

	mov	dx,rfport
	mov	al,mmcrf		; 50000h on 68k is destination
	out	dx,al
	mov	dx,rfdma
	out	dx,al			; set both rfs for transfer
	mov	ax,cs:osstart
	mov	bx,0ff80h		; 0-80h
	push	ax
	push	bx
	push	ds			; saveit
getblock:
	pop	ax			; really ds
	pop	dx
	pop	ds			; destination ds:dx
	add	dx,80h			; one block
	push	ds
	push	dx			; save for next time
	push	ax			; save it again
	mov	ah,1ah
	int	sys_call		; set dma

	pop	ds
	push	ds			; get and save ds
	mov	dx,6ch			; point to fcb
	mov	ah,14h			; read
	int	sys_call
	cmp	al,00
	jz	getblock		; repeat till done

	mov	ah,10h			; close file
	int	sys_call
	pop	ax
	pop	ax
	pop	ax
	ret

cferror:
	push	cs
	pop	ds			; put cs into ds
	mov	dx,offset pgroup:cfmess
	mov	ah,9
	int	sys_call		; print error message
	mov	ah,4ch
	int	sys_call		; quit program

fnd_nme:
	mov	cs:cntno,cl
	mov	cs:mapbase,si
	mov	di,offset pgroup:dbuffer
fnd_lpe:
	repe	cmpsb			; find matching string
	je	got_lne			; found a match
	mov	al,0ah			; load lf
	push	cx
	mov	cx,80			; max # of chars to search for lf
	cld
	repne	scasb			; scan for lf
	pop cx				; restore cx
	jne	ernme			; no lf
	mov	al,es:[di]
	cmp	al,1ah			; eof?
	jz	ernme	
	mov	si,cs:mapbase
	xor	cx,cx
	mov	cl,cs:cntno
	jmp	fnd_lpe
got_lne:
	inc	di			; point to next char after label
	mov	al,es:[di]
	cmp	al,20h			; compare to space
	jg	got_var			; next char ok
	cmp	al,0ah			; compare it to lf
	jz	ernme			; no value bad config
	jmp	got_lne			; go check next char
ernme:
	mov	al,0ffh
got_var:
	ret

get_val:
	push	bx
	mov	cx,0			; init. char counter
get_val1:
	mov	bx,cx
	mov	al,es:[di+bx]		; load next char
	cmp	al,2ch			; compare to comma
	jz	enval			; is comma
	jl	enline			; less than comma
	inc	cx			; increment counter
	jmp	get_val1
enval:
	mov	dx,di			; put di into dx
	add	dx,cx			; add length of string
	inc	dx			; point to next char after comma
	jmp	end_val
enline:
	cmp	al,0dh			; is is a 'cr'
	jz	eok
	cmp	al,0ah			; is it a 'lf'
	jz	eok
	mov	al,0ffh			; load error code
	jmp	end_val
eok:
	mov	al,0feh			; last value in line
end_val:
	pop 	bx
	ret


prog	ends
	end
