	page	60,80
TITLE INITIAL I/O INTERFACE FOR UNIX
SUBTTL	TERMINAL INTERFACE

	.xlist

	include	gifdic.mac
	include	80186.mac
	include options.h
	include equates.h
	include mailboxs.h
	include	data.h
	
boot_tty	equ	1

	include	boot_lnk.h

	.list
	.xall

;**********************************************
;
;	NOW DO CHARACTER DEVICES
;
;**********************************************
	assume	ds:mailbox

firstty	equ	(maxdsk+maxsys+1)

console:
	push	ax
	mov	al,[si].DEVNO
	sub	al,firstty
	cmp	al,num_chard		; compare against number of char dev.
	jle	good_con
	jmp	badcrb

good_con:
	mov	bl,chtbsze		; size of chtab records
	mul	bl			; get offset into chtab
	mov	di,offset pgroup:chtab
	add	di,ax
	pop	ax
	mov	bx,cs:[di]		; get dev #
	mov	di,cs:[di+2]		; get fifo offset
	cmsp	[si].COMND,TINFF	; fifo mode
	jz	allfin
	cmsp	[si].COMND,TINBY	; input ?
	jz	all_in
	cmsp	[si].COMND,TOTBL	; output ??
	jnz	not_allout
	jmp	allout
not_allout:
	cmsp	[si].COMND,TSTAT	; get status
	jz	all_stat
	cmsp	[si].COMND,TOTFF	; fifo output
	jnz	mb_setup
	jmp	all_fout
mb_setup:
	cmsp	[si].COMND,TSTUP	; set up channel
	jnz	bad_con_com
	jmp	all_setup
bad_con_com:
	jmp	badcomand


all_stat:
	mov	dl,GIOST
	gifcall	,GSTATRG,NOOPT
	push	ax
	call	get_csb
	pop	ax
	mov	[di].CHSTS,0		; clear old status
	test	al,dcd
	jz	no_dcd1
	or	[di].CHSTS,1
no_dcd1:
	test	al,breakc
	jz	no_break1
	or	[di].CHSTS,8
no_break1:
	clc
	ret				; null for now



all_in:
	push	ds
	gifcall	,read,noopt		; try it
	pop	ds
	jnc	good_input
	cmp	ah,NOTRDY
	stc
	jz	no_input
	call	all_error
	clc
	ret
good_input:
	push	ax
	lea	si,[si].CHADDM		; point to address
	call	set_addr		; point to it
	pop	ax
	mov	es:[di],al		; set it up
	clc
no_input:
	ret


allfin:			; input to fifo
	get	ax,[si].INPTR		; input pointer
	get	cx,[si].OTPTR		; out pointer
	get	dx,[si].CHCNT		; fifo size
	push	ax			; old pointer
	inc	ax			; next
	cmp	ax,dx			; wrap round ?
	jnz	nowrap
	xor	ax,ax			; restart
nowrap:
	push	ax			; next pointer
	cmp	ax,cx			; pointers same ??
	jnz	tryinput
fifexit:
	mov	dl,GIOST
	gifcall	,GSTATRG,NOOPT
	push	ax
	call	get_csb
	pop	ax
	mov	bx,[di].CHSTS
	and	bh,0f6h
	test	al,dcd
	jz	no_dcd
	or	bh,1
no_dcd:
	test	al,breakc
	jz	no_break
	or	bh,8
no_break:
	cmp	[di].CHSTS,bx
	mov	[di].CHSTS,bx
	jz	no_status
	mov	di,offset MAILBOX:MFLAGS.STATS1
	call	set_flag
no_status:
	pop	ax
	pop	ax			; clear stack
	stc				; not finished
	ret

tryinput:
	push	bx
	gifcall	,read,noopt		; bx is channel
	pop	bx
	jnc	good_finput
	cmp	ah,NOTRDY
	jz	quick_exit
	call	all_error
quick_exit:
	pop	ax
	pop	ax
	stc
	ret
good_finput:
	push	ax
	push	si			; save pointer to crb
	push	bx
	lea	si,[si].CHADDM		; point to address
	call	set_addr		; point to it
	pop	cx			; channel number
	pop	si			; recover crb
	pop	ax			; recover data
	pop	dx			; new pointer
	pop	bx			; old pointer
	mov	es:[bx.di],al		; set it up
	push	cx			; channel number
	push	dx			; save pointer
	call	set_mail		; restore mailboxes
	pop	dx
	put	[si].INPTR,dx		; new pointer
	mov	di,offset MAILBOX:MFLAGS.ACTON1
	call	set_flag
	pop	bx			; restore channel
	jmp	allfin


all_error:
	push	ax
	call	get_csb
	pop	ax
	cmp	ax,OUTPAP
	jnz	try_frame
	or	[di].CHSTS,10h
	jmp	set_stat
try_frame:
	cmp	ax,FRAMERR
	jnz	try_parerr
	or	[di].CHSTS,4
	jmp	set_stat
try_parerr:
	cmp	ax,PARERR
	jz	is_parerr
	ret
is_parerr:
	or	[di].CHSTS,2
set_stat:
	mov	di,offset MAILBOX:MFLAGS.STATS1
	call	set_flag
	ret


;********************************************************
;
;	MOVE BLOCKS OF CHARACTERS TO THE OUTPUT FIFOS
;
;********************************************************

allout:
	mov	ax,cs:[di].output	; get output pointer
	sub	ax,cs:[di].input	; how much space
	dec	ax			; adjust ( 0=mt not full )
	and	ax,3ffh			; normalise to fifo size
	get	cx,[si].CHCNT		; get block size
	cmp	ax,cx			; nuf space for whole block ?
	ja	out_ok			; yes, skip
	stc
	ret				; sorry

out_ok:
	push	di			; save fifo pointer
	push	cx			; save length

	lea	si,[si].CHADDM
	call	set_addr		; point to data

	mov	si,di			; source pointer
	pop	cx			; recover count
	pop	di			; target pointer
move_block:
	mov	al,es:[si]		; byte pointer
	mov	bx,cs:[di].input	; get fifo input pointer
	mov	cs:[di.bx].buffer,al	; move data
	inc	bx
	cmp	bx,cs:[di].maxize	; in range ??
	jnz	no_wrap_out		; yes, skip
	mov	bx,0			; restart
no_wrap_out:
	mov	cs:[di].input,bx	; save new pointer
	inc	si			; next source
	loop	move_block		; repeat till done

	clc
	ret

;********************************************************
;
;	MOVE CHARACTERS FROM FIFOS TO THE OUTPUT FIFOS
;
;********************************************************

all_fout:
	mov	bx,[si].OTPTR		; get output pointer
	cmp	bx,[si].INPTR		; compare
	jz	no_fout
	swap	bx
	mov	ax,cs:[di].output	; get output pointer
	sub	ax,cs:[di].input	; how much space
	dec	ax			; adjust ( 0=mt not full )
	and	ax,3ffh			; normalise to fifo size
	jnz	do_fout
no_fout:
	stc
	ret				; sorry

do_fout:
	push	di			; save fifo pointer
	push	bx			; save user fifo pointer
	push	si

	lea	si,[si].CHADDM
	call	set_addr		; point to data

	pop	si
	pop	bx			; pointer
	mov	al,es:[di.bx]		; byte pointer
	pop	di
	mov	bx,cs:[di].input	; get fifo input pointer
	mov	cs:[di.bx].buffer,al	; move data
	inc	bx
	cmp	bx,cs:[di].maxize	; in range ??
	jnz	no_wrap_today		; yes, skip
	mov	bx,0			; restart
no_wrap_today:
	mov	cs:[di].input,bx	; save new pointer
	push	si
	call	set_mail
	pop	si
	get	bx,[si].OTPTR
	inc	bx
	get	ax,[si].CHCNT
	cmp	ax,bx
	jnz	no_wrap_either
	mov	bx,0
no_wrap_either:
	put	[si].OTPTR,bx
	jmp	all_fout



all_setup:

    if	real_tty

	cmp	bx,dtedev
	jz	allset
	cmp	bx,dcedev
	jz	allset
	jmp	bit7set
allset:						; only serial ports
	get	di,[si].BAUDR
	add	di,offset cs:baud_table
	mov	al,cs:[di]
	push	bx
	mov	dl,SBAUDR
	gifcall	,SSTATUS,noopt
	pop	bx

	mov	al,0		; no parity
	test	[si].CCONF,0004h
	jz	do_parity
	inc	al
	test	[si].CCONF,0008h
	jnz	do_parity
	inc	al
do_parity:
	push	bx
	mov	dl,SPARITY
	gifcall	,SSTATUS,noopt
	pop	bx

	get	ax,[si].CCONF
	sar	ax,1
	rori	al,2
	and	ax,000fh
	mov	di,offset cs:bit_table
	add	di,ax
	mov	al,cs:[di]
	push	bx
	mov	dl,SBITSC
	gifcall	,SSTATUS,noopt
	pop	bx

	mov	al,0
	test	[si].CCONF,0800h
	jz	do_xonxoff
	inc	al
	test	[si].CCONF,1000h
	jz	do_xonxoff
	add	al,2
do_xonxoff:
	push	bx
	mov	dl,SXON
	gifcall	,SSTATUS,noopt
	pop	bx

bit7set:
	xor	al,al
	test	[si].CCONF,0002h
	jz	do_bit_7
	mov	al,1
do_bit_7:
	mov	dl,WRATTB
	gifcall	,SSTATUS,noopt

	call	get_csb
	or	[di].CHSTS,100h		; set dcd for dana

	clc
	ret

bit_table:
	db	2		; default 8,1
	db	2
	db	2
	db	2
	db	2
	db	2
	db	2
	db	2
	db	2
	db	0		; 7,1
	db	1
	db	1
	db	2
	db	2
	db	3
	db	3

baud_table:
	db	6		; default 9600
	db	6
	db	6
	db	0		; 110
	db	6
	db	6
	db	6
	db	1		; 300
	db	2		; 600
	db	3		; 1200
	db	6
	db	4		; 2400
	db	5		; 4800
	db	6		; 9600
	db	7		; 19200


    else


			; for now we just print a message
	mov	di,offset cs:setup1
	call	ptext
	mov	al,[si].DEVNO		; get device number
	mov	di,offset cs:devtab
	xor	ah,ah
	sub	ax,firstty
	shl	ax,1			; *2
	add	di,ax			; calculate address
	mov	di,cs:[di]		; get message
	call	ptext
	mov	di,offset cs:setup2	; next message
	call	ptext
	mov	di,offset cs:baud1
	call	ptext
	get	ax,[si].BAUDR		; baud rate number
	test	ax,0fff0h		; 0-15 only
	jz	good_baud
	xor	ax,ax
good_baud:
	mov	di,offset cs:bautab
	add	di,ax
	add	di,ax
	mov	di,cs:[di]
	call	ptext
	mov	di,offset cs:dtrmes
	test	[si].CCONF,0100h	; bit 0
	jnz	set_dtr
	mov	di,offset cs:dtnrms
set_dtr:
	call	ptext
	get	ax,[si].CCONF		; get set word
	and	ax,180h			; data bits
	shri	ax,7
	add	al,35h			; ascii 5-8
	push	ds
	call	sys_prn
	mov	di,offset cs:bitmes
	call	ptext
	get	ax,[si].CCONF		; get word
	and	al,6			; get bits
	push	ax
	jpe	paritye			; 0 or two
	mov	al,31h			; 1
	call	sys_prn
	pop	ax
	cmp	al,2			; one bit
	jz	dunstop
	mov	al,2eh
	call	sys_prn
	mov	al,35h
	call	sys_prn
	jmp	dunstop
paritye:
	pop	ax
	mov	al,30h			; 0 bits
	jz	gotbits
	add	ax,2
gotbits:
	call	sys_prn
dunstop:
	pop	ds
	mov	di,offset cs:stopms
	call	ptext
	mov	di,offset cs:xnonms	; no xoff input
	test	[si].CCONF,800h
	jz	noxon
	mov	di,offset cs:xonmes
	call	ptext
	mov	di,offset cs:xnanms
	test	[si].CCONF,1000h
	jz	noxon
	mov	di,offset cs:xanyms
noxon:	
	call	ptext
	mov	di,offset cs:xnofms
	test	[si].CCONF,2000h
	jz	xnoff
	mov	di,offset cs:xoffms
xnoff:
	call	ptext
	test	[si].CCONF,4000h
	jz	nobreak
	mov	di,offset cs:brkmes
	call	ptext
nobreak:
	mov	di,offset cs:no_parity
	test	[si].CCONF,0004h	; parity ?
	jz	do_parity
	mov	di,offset cs:even_parity
	test	[si].CCONF,0008h
	jz	do_parity
	mov	di,offset cs:odd_parity
do_parity:
	call	ptext
	mov	di,offset cs:nbrkms
	call	ptext

	call	get_csb			; point to csb
	mov	[di].CHSTS,0100h	; show dcd
	clc
	ret				; null for now

		; messages for dummy setup

devtab:	dw	dtemes
	dw	prnmes
	dw	dcemes
	dw	conmes
	dw	nulmes
	dw	nulmes
	dw	nulmes
	dw	nulmes

setup1:	db	cr,lf,'Set up ',etx
setup2:	db	' device : ',etx
conmes:	db	'CONSOLE',etx
prnmes:	db	'PRINTER',etx
dtemes:	db	'DTE SERIAL',etx
dcemes:	db	'DCE SERIAL',etx
nulmes: db	'NULL',etx

baud1:	db	'Baud rate : ',etx
bautab:	dw	badmes
	dw	b50
	dw	b75
	dw	b110
	dw	b134
	dw	b150
	dw	b200
	dw	b300
	dw	b600
	dw	b1200
	dw	b1800
	dw	b2400
	dw	b4800
	dw	b9600
	dw	b19200
	dw	bext
badmes:	db	'BAD	',etx
b50:	db	'50	',etx
b75:	db	'75	',etx
b110:	db	'110	',etx
b134:	db	'134.5	',etx
b150:	db	'150	',etx
b200:	db	'200	',etx
b300:	db	'300	',etx
b600:	db	'600	',etx

b1200:	db	'1200	',etx
b1800:	db	'1800	',etx
b2400:	db	'2400	',etx
b4800:	db	'4800	',etx
b9600:	db	'9600	',etx
b19200:	db	'19200	',etx
bext:	db	'EXTERNAL	',etx

dtrmes:	db	', DTR, ',etx
dtnrms:	db	', no DTR, ',etx
bitmes:	db	' data bits,',cr,lf,etx
stopms:	db	' stop bits, ',etx
xnonms:	db	'ignore XOFF, ',etx
xonmes:	db	'stop on XOFF, ',etx
xnanms:	db	'start on XON, ',etx
xanyms:	db	'start on XANY, ',etx
xnofms:	db	'dont use XOFF',etx
xoffms:	db	'use XOFF control',etx
brkmes:	db	', send BREAK'
no_parity:	db	', no',etx
even_parity:	db	', even',etx
odd_parity:	db	', odd',etx
nbrkms:	db	' parity.',cr,lf,etx

    endif

;*****************************************************
;
;	ATTEMPT TO OUTPUT FROM CHARACTER FIFOS
;
;*****************************************************

fifo_next:
	test	al,0e0h			; control ??
	jnz	not_control		; no
	cmp	al,lf
	jz	new_line
	cmp	al,cr			; return ??
	jnz	not_return
new_line:
	mov	cs:[di].lineptr,0	; position 0
not_return:
	cmp	al,tab
	jmp	next_char
;	jnz	next_char
	inc	cs:[di].lineptr
	test	cs:[di].lineptr,07h
	jnz	fifo_out
	jmp	next_char
not_control:
	inc	cs:[di].lineptr		; next position
next_char:
	mov	ax,cs:[di].output	; get it
	inc	ax			; next
	cmp	ax,cs:[di].maxize	; too much ??
	jnz	fifo_wrap
	mov	ax,0			; wrap pointer
fifo_wrap:
	mov	cs:[di].output,ax

fifo_out:

	mov	bp,cs:[di].output	; get fifo output pointer
	cmp	bp,cs:[di].input	; anything ??
	jnz	got_chars		; if so skip
	ret				; else quit

got_chars:
	mov	al,cs:[di.bp].buffer	; get data
	pusha				; save registers
	cmp	al,tab
	jmp	nottab
;	jnz	nottab
	mov	al,20h			; space
nottab:
	gifcall	,write,noopt		; try to write
	popa
	jnc	fifo_next		; try another
	ret

prog	ends
	end
