	page	60,80
TITLE GENERAL PURPOSE I/O INTERFACE VERSION 1.5
SUBTTL	CALENDAR CLOCK MODULE VERSION 1.5

	.xlist

	include	gifdic.mac
	include	80186.mac
	include options.h
	include equates.h
	include mailboxs.h
	include	data.h
	
boot_rtc	equ	1

	include	boot_lnk.h

	.list
	.xall

;*******************************************************
;
;	REAL TIME CLOCK ACCESS
;
;*******************************************************

do_rtc:
	cmsp	[si].comnd,READS	; read clock
	jz	read_rtc
        cmsp    [si].comnd,READT        ; read as h/m/s etc.
        jz      read_rtc
	cmsp	[si].comnd,RITES	; write clock
	jnz	rtc_badcom
	jmp	write_rtc
rtc_badcom:
	jmp	badcomand

read_rtc:

	push	ds
	push	cs
	pop	es
	mov	di,offset cs:rtc_buffer
	mov	cx,6			; read first six
	mov	dx,0
	gifcall	rtcdev,read,noopt
	pop	ds
	jnc	no_read_err
	push	ds
	push	cs
	pop	es
	mov	di,offset cs:rtc_buffer
	mov	cx,6			; read first six
	mov	dx,0
	gifcall	rtcdev,read,noopt	; try again
	pop	ds
	jnc	no_read_err
	jmp	end_com
no_read_err:
	call	get_csb			; get the csb
        cmsp    [si].comnd,READT        ; which type of read?
        jnz     do_reads                ; read as seconds     
	jmp	do_readt		; read as m/d/y etc		
do_reads:
	push	di			; save csb pointer
	mov	al,cs:rtc_buffer.byear	; get year
	call	get_hex
	sub	ax,70			; years since -1
	jnc	add_cent
	add	ax,100			; correct it
add_cent:
	push	ax
	mov	si,365			; days per year
	mul	si			; years * days
	mov	si,ax			; save it
	pop	ax			; years again
	inc	ax			; adjust
	cmp	cs:rtc_buffer.bmoth,3	; after feb ??
	jc	not_feb
	inc	ax			; nother year
not_feb:
	shri	ax,2			; /4 for leap years
	add	si,ax			; add to days
	xor	ch,ch			; clear it
	mov	cl,cs:rtc_buffer.bmoth	; get month
	dec	cx			; minus one
	jz	dun_month		; if jan
	call	add_month		; do months
dun_month:
	mov	al,cs:rtc_buffer.bdate	; odd days
	call	get_hex
	dec	ax			; days 1-31 etc
	add	si,ax			; add them in
	mov	ax,5180h		; hours per day -10000
	mul	si			; seconds passed
	add	si,dx			; extra word
	mov	di,ax			; save it
	mov	al,cs:rtc_buffer.bhour
	call	get_hex			; convert
	mov	bx,60			; minutes
	mul	bx			; 
	mov	bx,ax			; save it
	mov	al,cs:rtc_buffer.bmins
	call	get_hex			; convert
	add	ax,bx			; total minutes
	mov	bx,60			; to seconds
	mul	bx			; got it
	mov	bx,ax			; save it
	mov	al,cs:rtc_buffer.bsecs
	call	get_hex			; convert
	add	ax,bx
	jnc	no_xtra_sec
	inc	dx			; upper bits
no_xtra_sec:
	add	ax,di			; final lower
	jnc	no_extra_sec
	inc	dx
no_extra_sec:
	add	dx,si			; final answer
	pop	di			; recover csb
	put	[di].TIMESM,dx
	put	[di].TIMESL,ax		; save result
	xor	ax,ax
	jmp	rtc_exit

add_month:
	add	si,31			; jan
	loop	jan
	ret
jan:	add	si,28			; feb
	loop	feb
	ret
feb:	add	si,31			; march
	loop	march
	ret
march:	add	si,30			; april
	loop	april
	ret
april:	add	si,31			; may
	loop	may
	ret
may:	add	si,30			; june
	loop	june
	ret
june:	add	si,31			; july
	loop	july
	ret
july:	add	si,31			; august
	loop	august
	ret
august:	add	si,30			; september
	loop	sept
	ret
sept:	add	si,31			; october
	loop	oct
	ret
oct:	add	si,30			; november
	ret


get_hex:			; convert 2 nibbles to hex
	push	ax			; save it
	shri	al,4			; upper nibble
	mov	cl,10			; ten
	mul	cl			; al * cl
	pop	cx
	and	cx,0fh			; lower only
	add	ax,cx			; result in ax
	ret

do_readt:
        mov     al,cs:rtc_buffer.byear  ; get the year
	call	get_hex
	mov	[di].TYEAR,al
	mov	al,cs:rtc_buffer.bmoth	
	call	get_hex
	mov	[di].TMOTH,al
	mov	al,cs:rtc_buffer.bdate
	call	get_hex
	mov	[di].TDAYM,al
	mov	al,cs:rtc_buffer.bhour
	call	get_hex
	mov	[di].THOUR,al
	mov	al,cs:rtc_buffer.bmins
	call	get_hex
	mov	[di].TMINS,al
	mov	al,cs:rtc_buffer.bsecs
	call	get_hex
	mov	[di].TSECS,al
	xor	ax,ax
	jmp	rtc_exit


write_rtc:
	get	dx,[si].STIMEM
	get	ax,[si].STIMEL
	mov	bx,0a8c0h		; 60 * 60 * 12
	div	bx			; ax = days * 2, dx = secs
	xor	bx,bx			; clear hours & mins
	mov	ch,bh			; clear secs
	shr	ax,1			; /2
	push	ax			; 
	mov	ax,dx			; get remaining seconds
	mov	dx,0			; clear upper part
	jnc	not_12_hrs		; dont add 12 hours
	add	ax,0a8c0h		; 12 * 60 * 60
	jnc	not_12_hrs		; no carry
	inc	dx
not_12_hrs:
	mov	si,60			; sec/min
	div	si			; div dx.ax/60
	mov	cs:rtc_buffer.bsecs,dl	; remaining seconds
	xor	dx,dx			; clear upper
	div	si			; min/60 = hours
	mov	cs:rtc_buffer.bmins,dl
	mov	cs:rtc_buffer.bhour,al	; save results
	pop	ax			; days
	xor	dx,dx			; clear upper
	mov	si,365			; days per year
	div	si			; ax = years, dx = days
	add	ax,2			; normalise for leap years
	mov	bl,al			; save years
	shri	ax,2			; /4
	sub	dx,ax			; remove leap days
	jnc	no_leaps		; ok
	dec	bl			; one year less
	add	dx,365			; restore to days
no_leaps:
	add	bl,68			; add offset
	cmp	bl,99			; range check
	jc	good_year
	sub	bl,100			; adjust
good_year:
	mov	cs:rtc_buffer.byear,bl	; save years

	call	undo_month		; get month

	inc	dl			; days 1-31 etc
	mov	cs:rtc_buffer.bmoth,cl	; save month
	mov	cs:rtc_buffer.bdate,dl	; save date


				; convert all times to nibbles
	mov	al,cs:rtc_buffer.bsecs
	call	put_hex
	mov	cs:rtc_buffer.bsecs,al
	mov	al,cs:rtc_buffer.bmins
	call	put_hex
	mov	cs:rtc_buffer.bmins,al
	mov	al,cs:rtc_buffer.bhour
	call	put_hex
	mov	cs:rtc_buffer.bhour,al
	mov	al,cs:rtc_buffer.bdate
	call	put_hex
	mov	cs:rtc_buffer.bdate,al
	mov	al,cs:rtc_buffer.bmoth
	call	put_hex
	mov	cs:rtc_buffer.bmoth,al
	mov	al,cs:rtc_buffer.byear
	call	put_hex
	mov	cs:rtc_buffer.byear,al

	push	cs
	pop	es
	mov	di,offset cs:rtc_buffer
	mov	cx,6			; move six bytes
	mov	dx,0			; start at begining
	push	ds
	push	si
	gifcall	rtcdev,write,noopt	; send it
	pop	si
	pop	ds
	jnc	rtc_exit
				; try again
	push	cs
	pop	es
	mov	di,offset cs:rtc_buffer
	mov	cx,6			; move six bytes
	mov	dx,0			; start at begining
	push	ds
	push	si
	gifcall	rtcdev,write,noopt	; send it
	pop	si
	pop	ds

rtc_exit:
	jmp	end_com

undo_month:
	mov	cl,1
	cmp	dx,31			; january
	jc	got_month
	sub	dx,31			; remove days
	inc	cl
	mov	bx,28			; non leap years
	test	cs:rtc_buffer.byear,3	; check it
	jnz	is_not_leap
	inc	bx			; 29
is_not_leap:
	cmp	dx,bx
	jc	got_month
	sub	dx,bx
	inc	cl
	cmp	dx,31			; march
	jc	got_month
	sub	dx,31
	inc	cl
	cmp	dx,30			; april
	jc	got_month
	sub	dx,30
	inc	cl
	cmp	dx,31			; may
	jc	got_month
	sub	dx,31
	inc	cl
	cmp	dx,30			; june
	jc	got_month
	sub	dx,30
	inc	cl
	cmp	dx,31			; july
	jc	got_month
	sub	dx,31
	inc	cl
	cmp	dx,31			; august
	jc	got_month
	sub	dx,31
	inc	cl
	cmp	dx,30			; september
	jc	got_month
	sub	dx,30
	inc	cl
	cmp	dx,31			; october
	jc	got_month
	sub	dx,31
	inc	cl
	cmp	dx,30			; november
	jc	got_month
	sub	dx,30
	inc	cl
got_month:
	ret


put_hex:
	xor	ah,ah			; clear top
	mov	bx,10
	div	bl			; divide al by 10
	shli	al,4			; move bits in ah
	add	al,ah			; result
	ret


rtc_buffer	rtc <>		; real time clock buffer


prog	ends
	end

