
	page	60,80
TITLE INITIAL I/O INTERFACE FOR UNIX
SUBTTL	MAILBOX INITIAL SETUP

	.xlist

	include	gifdic.mac
	include	80186.mac
	include options.h
	include equates.h
	include mailboxs.h
	include	data.h
	
boot_mal	equ	1

	include	boot_lnk.h

	.list
	.xall

mail_start:

; clear all space to zero
	push	ds	
	call	set_mail
	assume	ds:mailbox

	xor	ax,ax
	mov	cx,SMAIL		; size of mailboxes
	sar	cx,1			; /2
	push	ds
	pop	es			; get segment in es
	mov	di,BMAIL
	rep	stosw			; clear it out
	
; SCB
	mov	si,offset cs:cflag
	mov	di,offset mailbox:MSCB.SFLAG
	push	cs
	pop	ds			; get segment
	mov	cx,zflag
	rep	movsb			; set up flag & version
;
	push	es
	pop	ds
	puti	MSCB.GMADDM,ACCESS	; access address
	puti	MSCB.GMADDL,BMAIL	; lower offset
	puti	MSCB.GMAMC,3		; address modifier
	puti	MSCB.MBSIZ,SMAIL	; size of mailboxes
	puti	MSCB.LMADDL,BMAIL	; local start

	puti	MSCB.STLAB,(MLAB-MSCB)
	puti	MSCB.STCSB,(MCSB1-MSCB)
	puti	MSCB.STCRB,(MCRB1-MSCB)
	puti	MSCB.STFLG,(MFLAGS-MSCB)
	puti	MSCB.STDAT,(MDATA-BMAIL)

	puti	MSCB.LABSZ,(MFLAGS-MLAB)
	puti	MSCB.CSBTL,((MCRB1-MCSB1)/csb_size)
	puti	MSCB.CRBTL,((MLAB-MCRB1)/crb_size)
	puti	MSCB.FLGSZ,(((((MLAB-MCRB1)/crb_size)+31)/32)*4)
	puti	MSCB.DATSZ,(EMAIL-MDATA)

	mov	MSCB.SYSCT,maxsys
	mov	MSCB.DSKCT,maxdsk
	mov	MSCB.TTYCT,maxtty
	mov	MSCB.RTCCT,maxrtc
; LAB
	puti	MLAB.CRATE,300h
	puti	MLAB.CLDIV,6		; set up clock

; CSB
	mov	si,offset mailbox:MCSB1

	puti	[si].DEVIC,SYSMS	; flag MSDOS
	mov	[si].RQMAX,1
	mov	ax,cs:ram_size		; ram / 64k
	put	[si].RAMSZ,ax		; insert
	mov	al,1

	mov	cx,maxsys
	mov	bl,CSYST
	call	fill_loop

	push	si			; save first disk CSB

	mov	cx,maxdsk
	mov	bl,CDISK
	call	fill_loop

	pop	di
	mov	cx,4
	push	si
	mov	si,offset  pgroup:wdtab
	add	si,2

dsk_csb1:
	mov	dx,cs:[si]
	cmp	dx,0
	jz	no_dsk1
	puti	[di].DEVIC,0001		; hard disk
	mov	[di].RQMAX,01		; requests	
	puti	[di].BLKSZ,512		; sector size
	puti	[di].BLKCTM,0
	put	[di].BLKCTL,dx		; sector count
	puti	[di].SECTK,11h		; sectors per track
	puti	[di].HEADS,6		; heads 
	puti	[di].BLKOF,0
	mov	[di].BLKS1,dx
	puti	[di].BLKS2,0
no_dsk1:
	add	di,32
	add	si,4
	loop	dsk_csb1
	pop	si
	add	di,32			; next CSB

	cmp	cs:num_flop,0		; any floppies
	jz	do_chars

	puti	[di].DEVIC,0002		; floppy disk
	mov	[di].RQMAX,01		; requests	

	add	di,32

	cmp	cs:num_flop,02		; second floppy     
	jne	do_chars

	puti	[di].DEVIC,0002
	mov	[di].RQMAX,01

do_chars:
	push	si
	push	ax
	mov	bx,0			; initialize pointer
	mov	di,offset pgroup:chtab
chdevlpe:
	mov	cx,cs:[di+bx]		; get dev # from chtab
	mov	ax,SYCON
	cmp	cx,kvddev		; video?
	jz	gotchdev	
	mov	ax,CENTP
	cmp	cx,prtdev		; parallel printer
	jz	gotchdev
	mov	ax,RSTTY		; must be tty
gotchdev:
	put	[si].DEVIC,ax		; put device # into csb
	mov	[si].RQMAX,2
	cmp	bx,(num_chard - 1)*chtbsze	; have we done the char dev
	jz	dnechdev
	add	bx,chtbsze		; add size of chtab entries
	add	si,csb_size
	jmp	chdevlpe		; go again
dnechdev:
	pop 	ax
	pop	si

	mov	cx,maxtty
	mov	bl,CTTYS
	call	fill_loop

	puti	[si].DEVIC,SYRTC	; syscon RTC
	mov	[si].RQMAX,1		; 1 request only
	mov	cx,maxrtc
	mov	bl,CRTCS
	call	fill_loop

	mov	cx,(csbmax-maxsys-maxdsk-maxtty-maxrtc)
	mov	bl,0ffh
	call	fill_loop

	mov	si,offset MAILBOX:MCRB1
	mov	al,1

	mov	cx,crbmax
	call	fill_loop	

; FLAGS
	mov	si,offset mailbox:MFLAGS.BUSY1
	call	do_flag
	mov	si,offset mailbox:MFLAGS.STACK1
	call	do_flag
	mov	si,offset mailbox:MFLAGS.ABACK1
	call	do_flag
	pop	ds


	ret

fill_loop:
	mov	[si],al
	inc	al
	mov	[si].DEVCL,bl
	add	si,csb_size
	loop	fill_loop
	ret


do_flag:
	get	cx,MSCB.FLGSZ
loop_flag:
	mov	byte ptr [si],0ffh
	inc	si
	loop	loop_flag
	ret

		; source of mailboxes

cflag	db	0feh,80h,05,0a0h,45h,0a2h,55h,0aah
	db	00,02				; version number
	db	01,04				; revision 1.4

zflag	equ	$ - cflag

prog	ends
	end
