	page	60,80
TITLE INITIAL I/O INTERFACE FOR UNIX
SUBTTL	INITIALISATION AND RESTART

	.xlist

	include	gifdic.mac
	include	80186.mac
	include options.h
	include equates.h
	include mailboxs.h
	include	data.h
	
boot_int	equ	1

	include boot_lnk.h

	.list
	.xall

begin:			; set up stack
	push	cs
	pop	ss
	mov	sp,offset pgroup:stacke

	mov	cs:sys_flag,0		; set debug print off
;
	call	gifdic_init
;
	call	test_boot		; cold / warm start
	test	byte ptr cs:doboot,0ffh		; cold
	jnz	wboot
;
;	*******	COLD START SYSTEM ***************
;
	call	clear_ram		; init 68k ram
;
	call	get_boot		; read in the boot file
;
	call	set_start		; popinters for 68k start
;
	call	disk_init		; sort out the disk system
;
	call	mail_start		; initiialize the mailboxes
;
	call	start_68k		; start the 68k
;
	call	no_pending		; clear pending action
;
	jmp	start_mailbox

wboot:
	call	get_boot		; read in config file
;
	call	disk_init		; sort out the disk system
;
	call	get_pending		; recover pending flags
;
	jmp	start_mailbox

restart:
	mov	sp,offset pgroup:stacke
;
	call	get_boot		; read bootstrap
;
	call	set_start		; set up pc/sp
;
	call	disk_init		; sort the disks
;
	call	mail_start		; set up mailboxes
;
	call	no_pending		; idle
;
;		drop through
;
start_mailbox:

	call	set_mail		; point to mailboxes
	assume	ds:mailbox
	puti	MSCB.SFLAG,0180h	; flag active
	jmp	domailbox

;
set_start:
;
	call	set_mail
	assume	ds:mmcpu
;
	puti	ssp0,stack_up		; upper stack pointer
	puti	ssp1,stack_lo		; lower stack pointer
 	cmp	cs:osstart,9000h	; unix or pdos
	jz 	stunix
	puti	pc0,00h			; start for pdos
	puti	pc1,2000h
	ret
stunix:
	puti	pc0,5h     		; start for unix
	puti	pc1,0000h   		; start for unix
;
	ret

start_68k:
;
	mov	dx,rfport
	mov	al,stmrf
	out	dx,al			; point to it
;
	mov	ax,seg stmmcpu
	mov	ds,ax
	assume	ds:stmmcpu		; get segment
;
	mov	ax,stmmcpu0		; start it up
;
	ret

no_pending:
;
	mov	cs:pending.PEND1,0
	mov	cs:pending.PEND2,0
	mov	cs:pending.PEND3,0
	mov	cs:pending.PEND4,0
;	
	ret

get_pending:
;
	call	set_mail
	assume	ds:mailbox
;
	mov	ax,SUSPEND.PEND1
	or	al,80h			; clear system bit
	mov	cs:pending.PEND1,ax
	mov	ax,SUSPEND.PEND2
	mov	cs:pending.PEND2,ax
	mov	ax,SUSPEND.PEND3
	mov	cs:pending.PEND3,ax
	mov	ax,SUSPEND.PEND4
	mov	cs:pending.PEND4,ax
;
	ret	

gifdic_init:
;
	xor	cx,cx
	int	99h			; link up to gifdic
	mov	ax,es:[di.ghndlr]
	mov	cs:gifl,ax
	mov	ax,es:[di.spgroup]
	mov	cs:gifh,ax
;
	ret

prog	ends
	end	begin
