

	page	60,80
TITLE GENERAL PURPOSE I/O INTERFACE VERSION 1.5
SUBTTL	DISK HANDLER VERSION 1.5

	.xlist

	include	gifdic.mac
	include	80186.mac
	include options.h
	include equates.h
	include mailboxs.h
	include	data.h
	
boot_dsk	equ	1

	include	boot_lnk.h

	.list
	.xall

is_disk:

	mov	al,[si].DEVNO		; drive number
	cmp	al,7
	mov	ah,2
	jz	got_diskno
	cmp	al,8
	mov	ah,3
	jz	got_diskno
	jg	to_bg
	mov	ah,al
	add	ah,2
	jmp	got_diskno
to_bg:
	mov	ah,0ffh

got_diskno:
	mov	cs:drvno,ah		; to use

	get	ax,[si].COMND
	and	al,07fh			; clear flush bit
	cmp	ax,DREAD
	jz	disk_rw
	cmp	ax,DRITE			; write
	if	write_protect
	jz	disk_wite		; ************* temp only
	else
	jz	disk_rw
	endif
	cmp	ax,DSTAT		; get status
	jz	disk_stat
	cmp	ax,DFORM			; format
	jz	disk_format
baddisk:
	jmp	badcomand


disk_rw:
	jmp	disk_wrap		; do real disk read/write

;*********************************************
;
;	for debug purposes
;
;*********************************************

disk_format:
	mov	di,offset formes
	call	ptext
	call	pdisk
	mov	di,offset fend
	call	ptext
	clc
	ret

disk_stat:


	mov	al,cs:drvno		; disk
	mov	dl,medchk
	gifcall	dskdev,gstatus,noopt	; check it
	jnc	stat_good
disk_rec:
	mov	al,cs:drvno		; disk
	gifcall	dskdev,reset,noopt	; clear error
	mov	al,cs:drvno		; disk
	mov	dl,medchk
	gifcall	dskdev,gstatus,noopt	; check it
stat_good:
	push	dx
	push	ax
	call	get_csb			; where to put it
	pop	ax
	and	ax,0ff00h		; clear bad status
	mov	[si].CEROR,ax
	mov	[di].ERROR,ax		; error status
	jz	good_status
	pop	dx
	clc
	ret

good_status:
	pop	dx			; restore media
	cmp	dl,0			; hard ??
	jz	done_status
	push	dx
	mov	dh,dl			; get media byte
	mov	al,cs:drvno		; drive
	mov	dl,medset
	gifcall	dskdev,sstatus,noopt	; set it
	pop	dx
	puti	[di].BLKSZ,512	; set up sector size
	mov	[di].BLKCTM,0		; no upper sector
	mov	si,offset cs:disktab	; table of values
	and	dl,0fh			; lower bits
	mov	al,6			; 3 words
	mul	dl			; offset
	add	si,ax			; point to it
	mov	ax,cs:[si]		; first
	put	[di].BLKCTL,ax
	mov	[di].BLKS1,ax		; 
	mov	ax,cs:[si].2
	put	[di].SECTK,ax
	mov	ax,cs:[si].4
	put	[di].HEADS,ax
	mov	[di].BLKOF,0
	mov	[di].BLKS2,0
	mov	[di].BLKS3,0
	mov	[di].BLKS4,0
	mov	[di].BLKS5,0
	mov	[di].BLKS6,0

done_status:
	clc
	ret

	if	write_protect
disk_wite:
	mov	di,offset dwrit
	call	ptext
	call	pdisk
	mov	di,offset cs:dwend
	call	ptext
	clc
	ret
	endif

pdisk:
	mov	al,[si].DEVNO		; get drive
	add	al,30h			; to ascii
	call	sys_prn
	ret

	if	write_protect
dwrit:	db	'Pretend to write to disk ',etx
dwend:	db	'.',cr,lf,etx
	endif

formes:	db	cr,lf,'Disk format request. Drive ',etx
fend:	db	'.',cr,lf,etx

disktab:
	dw	2cfh,9,1
	dw	59fh,9,2
	dw	27fh,8,1
	dw	4ffh,8,2
	dw	167h,9,1
	dw	2cfh,9,2
	dw	13fh,8,1
	dw	27fh,8,2
	dw	167h,9,1
	dw	2cfh,9,2
	dw	13fh,8,1
	dw	27fh,8,2
	dw	0b3h,9,1
	dw	167h,9,2
	dw	09fh,8,1
	dw	13fh,8,2

;*****************************************************
;
;	this code does disk read/write even across
;	page and 1/2 mb boundaries
;
;*****************************************************


disk_wrap:

	cmp	[si].SECNT,0		; done all ??
	jnz	dosome
	clc
	ret				; good return
dosome:
	mov	bx,[si].DMADDM		; upper address
	swap	bx			; byte swap
	and	bx,07			; bits below 1/2 mb
	mov	dx,[si].DMADDL		; lower address
	swap	dx			; byte swap
	mov	cx,0			; sectors done
	mov	ax,511			; sector size - 1
loopsec:
	add	dx,ax			; address of end of block
	mov	ax,512
	jc	iscarry			; carry into bx
nextsec:
	inc	cx
	swap	cx			; byte swap
	cmp	cx,[si].SECNT		; done all sectors
	pushf
	swap	cx			; byte swap
	popf
	jnz	loopsec			; no, go back
	jmp	diskex			; execute disk

iscarry:
	inc	bx			; do carry
	test	bx,07			; over a boundary ??
	jnz	nextsec			; go onward till done
	cmp	cx,0			; any to do ??
	jz	goodisk			; no, skip
	push	[si].SECNT		; save total sector count
	push	dx			; lower address
	push	bx			; upper address
	push	cx			; good sectors
	swap	cx
	mov	[si].SECNT,cx		; do this number
	push	si
	call	diskex			; do so far
	mov	bp,ax			; save error code
	pop	si			; point to crb again
	pop	cx
	pop	bx
	pop	dx
	pop	ax
	swap	ax			; get it our way round
	cmp	bp,0			; no errors ??
	jz	goodisk
	clc				; quiting, flag done
	ret
goodisk:
	sub	ax,cx			; sectors left
	get	bx,[si].DSECTL		; get start sector
	add	bx,cx			; increase the start sector
	pushf
	put	[si].DSECTL,bx		; store it away
	popf
	jnc	noextra
	get	bx,[si].DSECTM		; do upper byte
	inc	bx
	put	[si].DSECTM,bx		; store it back
noextra:
	put	[si].SECNT,ax		; new sector count
	get	ax,[si].DMADDM		; upper address
	and	ax,0fff8h		; mask lower bits to zero
	add	ax,0008h		; next boundary
	put	[si].DMADDM,ax		; store it back
	inc	dx			; start of next sector
	put	[si].DMADDL,dx		; new lower boundary
	swap	dx
	cmp	dx,512			; if exact sector
	jnz	dobitwise		; here is trouble
	mov	[si].DMADDL,0		; back to start
	jmp	disk_wrap		; proceed

dobitwise:
	test	[si].COMND,0100h	; read bit
	jnz	skip_move		; if its a read
	call	move_data		; copy over before write
skip_move:
	call	disk_bit		; do the physical i/o
	jnc	good_bit		; no errors
	jmp	disk_exit		; else report and end
good_bit:
	test	[si].COMND,0100h	; read bit
	jz	done_move		; if its a write
	call	move_data		; if its a read
done_move:
	jmp	disk_wrap		; done

move_data:
	push	ds
	push	si			; save these

	mov	bx,[si].DMADDL		; get lower address
	push	bx			; and save lower address
	mov	ax,[si].DMADDM		; get upper address
	push	ax			; save upper address

	swap	ax
	dec	ax			; down one
	put	[si].DMADDM,ax		; reduced upper address

	swap	bx
	push	bx			; save second count
	mov	ax,512			; sector size
	sub	ax,bx			; first size
	sub	bx,512			; reduce lower address
	put	[si].DMADDL,bx		; put it away
	mov	cs:start_move,offset pgroup:dbuffer
	call	real_move
	call	set_mail		; back to mailboxes
	pop	ax			; next count
	mov	[si].DMADDL,00		; lower address start at 0
	pop	bx			; new upper address
	mov	[si].DMADDM,bx		; set it up
	call	real_move
	call	set_mail		; boxes again
	pop	bx
	mov	[si].DMADDL,bx		; new lower address
	pop	si
	pop	ds			; restore
	ret


real_move:
	push	ds
	push	si
	push	ax			; save count
	lea	si,[si].DMADDM		; point to address
	call	get_addr		; get address makeup
	pop	cx			; count
	pop	bx			; use as pointer
	push	bx
	mov	si,cs:start_move
	push	si
	add	si,cx			; final address
	mov	cs:start_move,si	; set up for part 2
	pop	si
	test	[bx].COMND,0100h	; read ??
	push	cs
	pop	ds
	mov	dx,rfport		; get register file
	out	dx,al			; do vme access
	jnz	no_swap
	push	es
	push	ds
	xchg	di,si			; swap these
	pop	es
	pop	ds
no_swap:
	cld
	rep	movsb			; move it
	pop	si
	pop	ds
	ret

disk_bit:
	get	dx,[si].SECNT		; sector count
	dec	dx			; one less
	put	[si].SECNT,dx		; store it back
	get	dx,[si].DSECTL		; start number
	push	dx			; save for us
	inc	dx
	pushf				; save carry
	put	[si].DSECTL,dx		; value for next
	popf				; restore flags
	jnc	no_overflow
	get	dx,[si].DSECTM		; upper sector
	inc	dx			; increment upper
	put	[si].DSECTM,dx		; store back
no_overflow:
	pop	dx
	mov	cx,1			; one sector
	push	si
	push	ds
	push	cs
	pop	es			; destination segment
	mov	di,offset pgroup:dbuffer
	mov	ax,[si].DSECTM		; upper sector
	shri	ax,5			; semiswap
	add	al,cs:drvno		; add disk number
	test	[si].COMND,0100h	; read bit
	jz	bit_write
	call	real_read
	jmp	was_read
bit_write:
	call	real_write
;
was_read:
	pop	ds
	pop	si
	ret				; done physical disk

;******************************************
;
;	DO PHYSICAL DISK READ/WRITE
;
;******************************************


diskex:
	test	[si].COMND,0100h	; read bit
	jz	disk_write


disk_read:
	call	set_disk		; test & set parameters
	mov	dx,rfdma		; own rf
	out	dx,al			; set it up
	mov	dx,rfport
	out	dx,al			; ************ fudge !!!!
	mov	dx,bx			; get start
	mov	al,cs:drvno		; get drive
	call	real_read
	jmp	disk_exit


disk_write:
	call	set_disk		; test & set parameters
	mov	dx,rfport		; share port with mbox
	out	dx,al			; set it up
	mov	dx,bx			; get start
	mov	al,cs:drvno		; get drive
	call	real_write
;
disk_exit:
	push	ax
	push	si			; save our pointer
	call	set_mail		; point to mail boxes
	pop	si
	mov	ax,[si].SECLAM
	or	ax,[si].SECLAL		; any look ahead
	jz	no_look_ahead
	test	[si].SIZLA,0ffffh
	jz	no_look_ahead
	mov	di,offset cs:look_start
	call	ptext
	mov	al,[si].DEVNO
	call	phex
	mov	di,offset cs:look_ahead
	call	ptext
	mov	ax,[si].SECLAM
	call	phex
	get	ax,[si].SECLAM
	call	phex
	mov	ax,[si].SECLAL
	call	phex
	get	ax,[si].SECLAL
	call	phex
	mov	di,offset cs:look_size
	call	ptext
	mov	ax,[si].SIZLA
	call	phex
	get	ax,[si].SIZLA
	call	phex
	mov	di,offset cs:fend
	call	ptext
no_look_ahead:
	call	get_csb			; point to csb
	pop	ax
	and	ax,0ff00h		; al not valid
	mov	[si].CEROR,ax
	mov	[di].ERROR,ax		; status
	jz	no_disk_error
	push	ax
	push	di
	call	disk_rec		; re init disk
	pop	di
	pop	ax
	mov	[di].ERROR,ax		; status
	mov	[si].CEROR,ax
no_disk_error:
	clc
	ret

look_start:	db	'Drive : ',etx
look_ahead:	db	' look ahead request block : ',etx
look_size:	db	', count : ',etx


set_disk:
	push	si
	lea	si,[si].DMADDM		; address data
	call	get_addr		; get vme data
	pop	si
	get	cx,[si].SECNT		; sector count
	get	bx,[si].DSECTL		; start sector number
	ret


read_loop:
	mov	al,cs:drvno
	gifcall	dskdev,reset,noopt
	dec	cs:error_byte
	jnz	read_try
	mov	cs:error_byte,ah
	popa
	mov	ah,cs:error_byte
	mov	cs:error_byte,trycnt
	stc
	ret
read_try:
	popa
real_read:
	pusha
	gifcall	dskdev,read,noopt
	jc	read_loop
	mov	cs:error_byte,trycnt
	popa
	xor	ax,ax
	ret

write_loop:
	mov	al,cs:drvno
	gifcall	dskdev,reset,noopt
	dec	cs:error_byte
	jnz	write_try
	mov	cs:error_byte,ah
	popa
	mov	ah,cs:error_byte
	mov	cs:error_byte,trycnt
	stc
	ret
write_try:
	popa
real_write:
	pusha
	gifcall	dskdev,write,noopt
	jc	write_loop
	mov	cs:error_byte,trycnt
	popa
	xor	ax,ax
	ret
	
error_byte	db	trycnt

disk_init:

	mov	cs:cntno,1
	mov	cs:unitno,0

	mov	al,8
	mov	dl,SNUMDRV	; set number of drives to 8
	gifcall dskdev,sstatus,noopt
do_mapn:
	mov	al,1		; GIFDIC drive number
	mov	ch,cs:cntno	; controller number
	mov	cl,cs:unitno	; unit number
	mov	dh,40h		; hard disk
	mov	dl,DRVMAP
	gifcall	dskdev,sstatus,noopt


	xor	ax,ax
	mov	es,ax
	mov	al,1
	mov	di,00
	mov	cx,10h
	mov	dx,SOSMAP
	gifcall	dskdev,reset,noopt

	mov	al,1
	gifcall	dskdev,reset,noopt

	mov	al,1
	mov	cx,01
	mov	dx,00
	push	cs
	pop	es
	mov	di,offset  pgroup:dbuffer
	pusha
	gifcall	dskdev,read,noopt
	popa
	jc	nxt_unit
	call	realinit	; initialize gifdic from dib
nxt_unit:
	inc	cs:unitno
	cmp	cs:unitno,1	; check for a second disk on controller
	jz	do_mapn

	ret

disk_quit:
	ret

realinit:
	push	ds
	push	cs
	pop	ds
	add	di,16		; point to nos of maps
	mov	bl,cs:[di]	; load number of maps
	inc	di		; position to first map
domap:
	cmp	bl,0		; any maps left in this dib?
	jnz	contmap
	jmp	dnedib
contmap:
	mov	cs:mapbase,di	;save for later
	mov	si,offset pgroup:wdtab
	mov	cs:drvno,4
dodkn:
	add	di,12		; point to OS name
	mov	cx,2		; 2 chars
	cld
	repe	cmpsb
	jne	nxtdkn		; no match
	pusha
	push	es
	mov	si,cs:mapbase	; found a match	
	xor	ax,ax
	mov	al,cs:drvno	; disk #
	mov	ch,cs:cntno	; controller number
	mov	cl,cs:unitno	; unit number
	mov	dh,40h		; hard disk
	mov	dl,DRVMAP
	gifcall	dskdev,sstatus,noopt
	xor	ax,ax
	mov	es,cs:[si].dbotl	; load boot offset
	mov	al,cs:drvno		; disk #
	mov	di,cs:[si].dstrtl	; start offset
	mov	cx,cs:[si].dszel	; partition size
	mov	dx,SOSMAP
	gifcall dskdev,sstatus,noopt
	mov	al,cs:drvno
	gifcall	dskdev,reset,noopt
	pop	es
	popa
	mov	di,cs:mapbase
	mov	cx,cs:[di].dszel
	mov	cs:[si],cx
	jmp	nxtmap
nxtdkn:
	inc	cs:drvno
	mov	al,cs:drvno
	cmp	ax,8		; have we used all table entries?
	jz	nxtmap		; y
	mov	bh,dktbsze	; n
	sub	ax,2
	mul	bh		; offset to next drive in wdtable
	mov	si,offset pgroup:wdtab
	add	si,ax
	mov	di,cs:mapbase
	jmp	dodkn
nxtmap:
	mov	di,cs:mapbase	; get base of map in dib
	add	di,14		; position to next map in dib
	dec	bl		; decrement map counter
	jmp	domap
dnedib:
	pop 	ds
	ret



	; END OF DISK HANDLER CODE

prog	ends
	end
