	TITLE	'Loader bios for CP/M 3.0'

; ***********  **********  ***           ******** ****          ****
;************ ************ ***          *********   ****      ****
;***          ***      *** ***          ***           ****  ****
;***          ***      *** ***          ********        ****
;***          ***      *** ***          ********          ****
;***          ***      *** ***          ***           ****  ****
;************ ************ ************ ****************      ****
; *********    **********   *********    *************          ****
;
; Copyright (c) 1983, Colex Electronic Co. Ltd. All rights reserved.
;
;     No  part of this publication may be  reproduced,   transmitted,
;transcribed,   stored in a retrieval system,  or translated into any
;language  or  computer  language,   in any form  or  by  any  means,
;electronic,   mechanical,  magnetic,  optical,  chemical,  manual or
;otherwise   without the prior written permission of Colex Electronic
;Co. Ltd., 623, Ocean Centre, Kowloon, Hong Kong.
;
;
;     Colex  makes no representations or  warranties with  respect to
;the   contents  hereof  and  specifically  disclaims   any   implied
;warranties of merchantability or fitness for any particular purpose. 
;Further  Colex reserves the right to revise  this publication and to
;make  changes  from  time to  time  in the  content  hereof  without
;obligation  of  Colex  to  notify any person  of  such  revision  or
;changes.
;
	PAGE
;****************************************************************
;*								*
;*	Colex SC-820/850 Loader BIOS for CP/M 3.0		*
;*								*
;*		This program is a cut-down non-banked CP/M 3.0	*
;*	bios. It is only required to do console output and	*
;*	read disk 0. (plus any init. required by console or	*
;*	disk.)							*
;*								*
;****************************************************************
;Date		  Author		Modification
;15-Sep-82	K.J. Brand
;20-Apr-83	K.J. Brand	for DY-4 systems dstd-102, dstd-711
;					dstd-325, dstd-402, etc.
;25-Sep-83	K.J. Brand	removed all extraneous stuff to reduce size
;					leaving only what's necessary
;					added switch for boot from winchester
;19-Oct-83	R.J. Wellsted	changed winchester parameters (17 sec/trk)
;					added switch for internal crt
	PAGE
	MACLIB	EQUATES		;system equates
	MACLIB	MODEBAUD	;this gets used to create char$table value
	MACLIB	CPM3		;dpb macros and etc.
	MACLIB	PORTS		;i/o ports
	MACLIB	Z80		;z80 opcodes

CR	EQU 	13
LF	EQU 	10
BELL	EQU 	7
CTLQ	EQU 	'Q'-'@'
CTLS	EQU 	'S'-'@'

RESTORE	EQU	9
STEP	EQU	59H
SEEK	EQU	19H
TIMES	EQU	10

DD	EQU	10B		;mode bits for double density
EIGHT	EQU	01B		;mode bits for eight inch
SD	EQU	00B		;mode bits for single density

;	SASI host adaptor bit definitions

I$O	EQU	00000001B	;bit 0 is i/o
REQ	EQU	00000010B	;bit 1 is request
C$D	EQU	00000100B	;bit 2 is c/d
MSG	EQU	00001000B	;bit 3 is message
BSY	EQU	00010000B	;bit 4 is busy
ACK	EQU	00100000B	;bit 5 is acknowledge
SEL	EQU	01000000B	;bit 6 is select
RESET	EQU	10000000B	;bit 7 is reset

WINSIZ	EQU	2		;number of 256 pieces in a physical sector
				;in a winchester
XBCID	EQU	0CH		;xebec init command
REQ$SENSE EQU	03H		;request sense status
HDRD	EQU	8		;sasi read command

MAXCYL	EQU	306		;data for ST412
MAXHDS	EQU	4
WRTCYL	EQU	128
WRTPRC	EQU	64
ECCDTA	EQU	11

CRTFLG	EQU	0003H		;flag to say if std-crt present
				;	set/reset by bootstrap prom
CCP	EQU 	0100H		;Console Command Processor gets loaded
				;into the TPA

    ;BIOS Jump vector.

    ;All BIOS routines are invoked by calling these
    ;	entry points.

?BOOT:	JMP	BOOT		;initial entry on cold start
?WBOOT:	JMP	WBOOT		;reentry on program exit, warm start
?CONST:	JMP	CONST		;return console input status
?CONIN:	JMP	CONIN		;return console input character
?CONO:	JMP	CONOUT		;send console output character
?LIST:	JMP	LIST		;send list output character
?AUXO:	JMP	AUXOUT		;send auxilliary output character
?AUXI:	JMP	AUXIN		;return auxilliary input character
?HOME:	JMP	HOME		;set disks to logical home
?SLDSK:	JMP	SELDSK		;select disk drive, return dph
?STTRK:	JMP	SETTRK		;set disk track
?STSEC:	JMP	SETSEC		;set disk sector
?STDMA:	JMP	SETDMA		;set disk I/O memory address
?READ:	JMP	READ		;read physical block(s)
?WRITE:	JMP	WRITE		;write physical block(s)
?LISTS:	JMP	LISTST		;return list device status
?SCTRN:	JMP	SECTRN		;translate logical to physical sector
?CONOS:	JMP	CONOST		;return console output status
?AUXIS:	JMP	AUXIST		;return aux input status
?AUXOS:	JMP	AUXOST		;return aux output status
?DVTBL:	JMP	DEVTBL		;return address of device def table
?DEVIN:	JMP	0		;change baud rate of device
?DRTBL:	JMP	GETDRV		;return address of disk drive table
?MLTIO:	JMP	MULTIO		;set multiple record count for disk I/O
?FLUSH:	JMP	FLUSH		;flush BIOS maintained disk caching
?MOV:	JMP	MOVE		;block move memory to memory
?TIM:	JMP	0		;Signal Time and Date operation
?BNKSL:	JMP	BNKSEL		;select bank for code and default DMA
?STBNK:	JMP	SETBNK		;select bank for disk I/O DMA operations.
?XMOV:	JMP	XMOVE     	;set banks for move operation
	JMP	0		;reserved for future expansion
	JMP	0		;reserved for future expansion
	JMP	0		;reserved for future expansion

BOOT:	RET
WBOOT:	RET			;not required for cpmldr

DEVTBL:	LXI 	H,CHAR$TABLE	;point to character device table
	RET

CHAR$TABLE:
	DB	'CRT   '	;just a simple crt for output only
	DB	MB$OUTPUT+MB$SERIAL
	DB	BAUD$9600	;there just to save space
	DB	0

GETDRV:	LXI	H,DRIVE$TABLE	;point to disk device table
	RET

DRIVE$TABLE:
	DW	ONLY$DRIVE
	DW	0,0,0
	DW	0,0,0,0
	DW	0,0,0,0
	DW	0,0,0,0

CONOUT:	CALL	CONOST		;get console output status
	ORA	A		;test
	JRZ	CONOUT		;loop if not ready
	LDA	CRTFLG		;get redirection flag
	ORA	A		;set?
	JRZ	SEROUT		;no, skip to serial driver
	MOV	A,C		;get char
	OUT	P$VDUDA		;send to vdu
	RET

SEROUT:	MOV	A,C		;get character
	OUT	P$CRT$DATA	;send to serial crt
	RET

AUXOUT:	RET
LIST:	RET			;not required in loader

CONOST:	LDA	CRTFLG		;get redirection flag
	ORA	A		;is it set?
	JRZ	SERSTA		;no, get status of serial crt
	IN	P$VDUST		;get vdu status
	ANI	80H		;get the output ready bit
	JR	CHKSTA		;skip to flag status
SERSTA:	IN	P$CRT$STAT	;get serial crt status
	ANI	4		;get tx buffer status
CHKSTA:	RZ			;zero returned if not ready
	MVI	A,-1		;flag ready
	RET

AUXOST:	RET
LISTST:	RET
CONST:	RET
AUXIST:	RET
CONIN:	RET
AUXIN:	RET			;not required for loader

?PMSG:		;print message @<HL> up to a null
		;saves <BC> & <DE>
	PUSH 	B		;save regs
	PUSH 	D
PMSG$LOOP:
	MOV 	A,M 		;get char
	ORA 	A		;test if null
	JZ 	PMSG$EXIT	;skip if so
	MOV 	C,A		;copy char
	PUSH 	H		;save pointer
	CALL 	CONOUT		;send char to crt
	POP 	H		;restore pointer
	INX 	H		;adjust pointer
	JMP	PMSG$LOOP	;loop back for more
PMSG$EXIT:
	POP 	D		;restore regs.
	POP 	B
	RET

?PDEC:				;print binary number 0-65535 from <HL>
	LXI 	B,TABLE10	;point to powers of 10 table
	LXI 	D,-10000	;load -10,000
NEXT:	MVI 	A,'0'-1		;set initial char value
PDECL:	PUSH 	H		;save no.
	INR 	A		;adjust char
	DAD 	D		;adjust & check number
	JNC 	STOPLOOP	;skip if this digit done
	INX 	SP		;adjust stack pointer
	INX 	SP
	JMP	PDECL		;loop back
STOPLOOP:
	PUSH 	D		;save regs.
	PUSH 	B
	MOV 	C,A		;copy digit
	CALL 	CONOUT		;print digit
	POP 	B		;restore regs
	POP 	D
NEXTDIGIT:
	POP 	H		;get no.
	LDAX 	B		;get next power of 10
	MOV 	E,A		;save it
	INX 	B		;adjust pointer
	LDAX 	B		;get high byte
	MOV 	D,A		;save it
	INX 	B		;adjust pointer
	MOV 	A,E		;get low byte
	ORA 	D		;test if at end of table
	JNZ 	NEXT		;loop for next digit if not
	RET

TABLE10:			;powers of 10 table
	DW	-1000
	DW	-100
	DW	-10
	DW	-1
	DW	0		;end of table


BNKSEL:	RET			;not required for loader

SELDSK:	LXI	H,ONLY$DRIVE	;point to the dpb
	MOV 	A,E		;get logged in flag
	ANI 	1		;test it
	RNZ			;return if not first select
	PUSH	H		;save dph pointer
	CALL	BOOT$LOGIN	;login the disk
	POP 	H		;recover dph pointer
	RET

HOME:	LXI 	B,0		;same as set track zero

SETTRK:	SBCD 	TRK		;save track no.
	RET

SETSEC:	SBCD 	SECT		;save sector no.
	RET

SETDMA:	SBCD 	DMA		;save dma pointer
	RET

SETBNK:	RET			;not required for loader

SECTRN:	MOV 	L,C 		;copy logical no. to hl
	MOV 	H,B
	MOV 	A,D 		;test if table address given
	ORA 	E
	RZ			;no table, so no translate
	XCHG 			;swap regs
	DAD 	B 		;add table index (logical sector no.)
	MOV	L,M		;get physical sector no.
	MVI 	H,0		;high order zero
	RET

MULTIO:	STA 	CNT		;save count
	RET

FLUSH:	XRA 	A 
	RET			;return with no error

MOVE:	XCHG			;swap regs for ldir
	LDIR			;use Z80 block move
	XCHG			;swap back
	RET

XMOVE:	RET			;not rquired for loader
WRITE:	RET

	IF NOT SC$850		;this is the read code for a floppy
				;system
READ:	LHLD	DMA		;set dma address in dma init bytes
	SHLD	ZDMA$DMA
MORE$RETRIES:
	MVI 	C,TIMES		;allow 'times' retries
RETRY$OPERATION:
	PUSH 	B		;save retry counter
	LDA	OLD$TRACK 	;where were we?
	OUT	P$FDTRACK	;update track register on 1797
				;with old value
	MOV	B,A		;save for comparison
	LDA	TRK		;where do we want to go?
	CMP	B		;same?
	JRZ 	SAME$TRACK	;if not same track as last, seek
	OUT	P$FDDATA	;to send to 1797
	STA	OLD$TRACK	;update old$track
	MVI	A,SEEK		;track register of 1797 updated above
	CALL	BUSY		;send command & wait for it to finish
SAME$TRACK:
	LDA 	SECT 		;get sector no.
	OUT 	P$FDSECTOR	;and sector
	CPI	11		;second side begins with sector 11
	EXAF			;save flag
	LXI 	H,DMA$BLOCK	;point to dma command block
	MVI	B,17		;no. of bytes to send to dma
	MVI	C,P$ZDMA	;point to dma port
	OUTIR			;send commands to Z80 DMA
	MVI	A,087H		;load dma enable command
	OUTP	A		;send to dma
	EXAF			;get side flag
	MVI	A,88H		;get 1797 command
	JRC	SID0		;skip if side zero
	SETB	1,A		;set up for second side
SID0:	CALL 	BUSY		;send command & wait for it to finish
	POP 	B		;recover retry counter
	ORA 	A		;test for errors
	RZ			;return if all ok
	PUSH	B		;save retry counter
	CALL	BOOT$LOGIN	;this restores drive and changes dens
				;if required
	POP	B		;get retry counter
	DCR 	C 		;decrement tries
	JNZ 	RETRY$OPERATION	;if at first you don't succeed.....
	MVI	A,1		;give up trying
	RET			;return to cpm with bad news

	;LOGIN
	;	Restores drive A and figures out density and sides

BOOT$LOGIN:
	MVI	A,01101001B	;set up drive A, five inch double
	OUT	P$SELECT	;density, motor on
	MVI	A,RESTORE	;home the head
	CALL	BUSY		;do it, & wait for it to finish
	MVI	A,2		;seek track two
	STA	OLD$TRACK	;update head posistion
	OUT	P$FDDATA	;send to controller
	MVI	A,SEEK		;seek to 'this' track
	CALL	BUSY		;send & wait for it to finish
	MVI	A,11		;set sector 11 (5" max sector=10)
	OUT	P$FDSECTOR	;send to controller
	MVI	A,8AH		;read side 1
	CALL	BUSY		;send command & wait for it to finish
	ANI	10010000B	;checks rnf
	IN	P$FDDATA	;flush data register since no data taken
	LXIX	TABLE		;set up for single density parameters too
	JRNZ	MOVEM		;error means its s/s
	           		;but if ok means its d/s-d/d or d/s-s/d
	INXIX
	INXIX
	INXIX
	INXIX			;move up to double sided section of table
MOVEM:	LXI	H,512-1		;and set up for 512 byte sectors
	SHLD	ZDMA$LENGTH	;save sector size
	PUSHIX			;save table pointer
	POP	H		;get source data address in hl
	LXI	D,ONLY$DRIVE 	;and address of xdph parameter table in de
				;which will be the destination
	LDI			;move trans address into xdph
	LDI
	XCHG			;get address in xdph into <hl> for increment
	LXI	B,10		;offset to the dpb value within the xdph
	DAD	B               ;(<bc> used to have rdrv value, not req'd now)
	XCHG			;<de> now pointing to dpb[rdrv], <hl> at
				;table data for dpb for this format
	LDI			;move it
	LDI
	RET

BUSY:	OUT	P$FDCMND	;send command to fdc
	MVI	A,0FH		;load delay counter
DELA:	DCR	A		;give the fdc some time to sort
	JRNZ	DELA		;itself out
NOTYET:	IN	P$FDCMND	;get fdc status
	RRC			;test if finished
	JRC	NOTYET		;loop if not
	IN	P$FDCMND	;get status
	RET

	;DISK PARAMETERS for various floppy disk boot drive formats
TABLE:	DW	TRANS5,DPB5D
	DW	TRANS5D,DPB5DD

	;SECTOR TRANSLATE TABLE for boot drive

TRANS5:	SKEW 10,4,1			;make the single sided
TRANS5D:
	SKEW 10,4,1			;and double sided sector skews
	SKEW 10,4,11

	;DISK PARAMETER TABLES for boot drive
    	;(the disk parameter blocks ably produced by cpm3.lib)

DPB5D:	DPB	512,10,80,2048,128,2,128
DPB5DD:	DPB	512,20,80,2048,128,2,128

	;DPH for a floppy disk boot drive

ONLY$DRIVE:
	DW	TRANS5D
	DB	0,0,0,0,0,0,0,0,0
	DB	-1
	DW	DPB5DD
	DW	CHECK$SUM$VECTOR
	DW	ALLOCATION$VECTOR
	DW	DIR$HEAD
	DW	DTA$HEAD
	DW	-1				;no hashing
	DB	0				;no hash bank

	;command string for Z80DMA device for reading

DMA$BLOCK:
	DB	0C3H
	DB	0C3H
	DB	0C3H
	DB	0C3H		;ensure dma is reset
	DB	0C3H
	DB	0C3H
	DB	14H		;channel A is incrementing memory
	DB	28H		;channel B is fixed port address
	DB	9AH		;RDY is high, CE/ only, stop on EOB
	DB	79H		;program all of ch. A, xfer B->A (temp)
ZDMA$DMA:
	DS	2		;starting DMA address
ZDMA$LENGTH:
	DS	2		;sector size-1
	DB	85H		;xfer byte at a time, ch B is 8 bit address
	DB	P$FDDATA	;ch B port address (1797 data port)
	DB	0CFH		;load B as source register

	ELSE			;here are the winchester read/login routines

	;READ for a winchester
READ:	MVI	A,HDRD		;load read sector command
	STA 	COMND		;save command
	LHLD	TRK		;get track no.
	XRA	A		;clear high order result
	DAD	H
	ACI	0		;track*2
	DAD	H
	ACI	0		;track*4
	DAD	H
	ACI	0		;track*8
	DAD	H
	ACI	0		;track*16
	LDED	TRK		;get track no. again
	DAD	D
	ACI	0		;track*17 (no. of sectors/track)
	LDED	SECT		;add in sector offset
	DAD	D
	ACI	0		;take care of carry (if any)
	XCHG			;save result
	LXI	H,ADDR1		;point to where address goes
	MOV	M,D		;save middle order result
	INX	H		;adjust pointer
	MOV	M,E		;save low order result
	CALL	SELSEND		;send command
XFERDAT:
	LHLD	DMA		;where to put data
	MVI	B,0		;set up for 256 byte xfer
	MVI	C,P$HDDATA	;to/from data port

LOOP6:	IN	P$HDCOM		;get hd status
	ANI	C$D		;ready for transfer?
	JRNZ	LOOP6		;loop if not
LOOP7:	IN	P$HDSTAT	;get status
	ANI	REQ		;controller requesting transfer?
	JRZ	LOOP7		;loop if not
	MVI	A,WINSIZ	;load no. of 256 byte blocks
HERE:	INIR			;transfer 256 bytes
	DCR	A		;adjust block counter
	JRNZ	HERE		;loop if sector not yet done
STATUS:	LXI	H,STAT$BYTES	;point to status buffer
	MVI	B,2		;get 2 bytes at first
LOOP8:	IN	P$HDCOM		;get controller status
	ANI	C$D		;test if ready
	JRZ	LOOP8		;loop if not
LOOP9:	IN	P$HDSTAT	;get status
	ANI	REQ		;controller requesting transfer?
	JRZ	LOOP9		;loop if not
	IN	P$HDDATA	;get status byte
	MOV	M,A		;save in buffer
	INX	H		;adjust buffer pointer
	DJNZ	LOOP9		;loop back for more if needed
	LDA	STAT$BYTES	;get status bytes
	ANI	00000010B	;look at status bytes we're into
	RZ			;return with status to cp/m
	MVI	A,REQ$SENSE	;load command to get error code
	STA	COMND		;save command
	CALL	SELSEND		;send the command
	LXI	H,ER$BYTES	;where to put data
	MVI	B,6		;set up for 6 byte xfer
	MVI	C,P$HDDATA	;from data port
LOOPA:	IN	P$HDCOM		;get controller status
	ANI	C$D		;ready to xfer data?
	JRNZ	LOOPA		;loop if not data ready
LOOPB:	IN	P$HDSTAT	;get controller status
	ANI	REQ		;requesting xfer?
	JRZ	LOOPB		;loop if not
	INIR			;get error code bytes
	CALL	STATUS		;finish command (recursive call. CAUTION)
	LDA	ER$BYTES	;get first error byte
	ANI	3FH		;mask unwanted bits
	RZ			;zero if no error occured
	SUI	18H		;test for corrected soft error
	RZ			;ok.
	MVI	A,1		;mark error for cp/m
	RET

SELSEND:
	IN	P$HDCOM		;get controller status
	ANI	BSY		;is it busy?
	JRNZ	SELSEND		;loop if so
	MVI	A,1		;load controller address
	OUT	P$HDDATA	;send it
	MVI	A,SEL		;load select bit
	OUT	P$HDCOM		;send it
LOOPD:	IN	P$HDCOM		;get controller status
	ANI	BSY		;check the busy bit
	JRZ	LOOPD		;loop if not set
	XRA	A		;reset select bit
	OUT	P$HDCOM		;send to controller
SENDCMD:
	LXI	H,COMND		;point to command
LOOPE:	IN	P$HDSTAT	;get controller status
	ANI	REQ		;is it requesting?
	JRZ	LOOPE		;loop if not
	IN	P$HDCOM		;get controller status
	ANI	C$D OR I$O	;ready for command output?
	CPI	C$D		;ready for data?
	RNZ			;done if not command
	MOV	A,M		;get command byte
	OUT	P$HDDATA	;send to controller
	INX	H		;adjust command pointer
	JR	LOOPE		;loop back for rest of command

	;LOGIN for a winchester...just set up the right parameters
	;	

BOOT$LOGIN:
	MVI	A,8
	OUT	P$HDSTAT
	MVI	A,RESET		;reset the xebec
	OUT	P$HDCOM
	PUSHIX			;90 t state delay for controller
	PUSHIX			;electronics
	PUSHIX			;gives the reset a chance to do its
	POPIX			;stuff
	POPIX
	POPIX
	XRA	A		;clear the reset
	OUT	P$HDCOM
	MVI	A,6		;load the step rate byte
	STA	CNTRL		;save in command block
	LXI	H,0		;big 0
	SHLD	LUN		;clear out address fields
	SHLD	ADDR0
	MVI	A,1		;default to 1 sector per xfer
	STA	BLOCKS
	MVI	A,XBCID		;configuration command
	STA	COMND
	CALL	SELSEND		;send to controller
	LXI	H,IDBYTES	;place where config data is set up
	LXI	D,MAXCYL	;load max cylinders
	MOV	M,D		;save high byte
	INX	H		;adjust pointer
	MOV	M,E		;save low byte
	INX	H		;adjust pointer
	MVI	M,MAXHDS	;load no. of heads
	INX	H		;adjust pointer
	LXI	D,WRTCYL	;load cyl to start low current
	MOV	M,D		;save high byte
	INX	H		;adjust pointer
	MOV	M,E		;save low byte
	INX	H		;adjust pointer
	LXI	D,WRTPRC	;load cyl to start write precomp
	MOV	M,D		;save high byte
	INX	H		;adjust pointer
	MOV	M,E		;save low byte
	INX	H		;adjust pointer
	MVI	M,ECCDTA	;load max. burst error length
	MVI	B,8		;the number of bytes to send
	MVI	C,P$HDDATA	;start xfering config bytes here
	LXI	H,IDBYTES	;point to bytes to send
LOOP1:	IN	P$HDCOM		;get controller status
	ANI	C$D		;command or data?
	JRNZ	LOOP1		;loop if not data
LOOP2:	IN	P$HDSTAT	;get controller status
	ANI	REQ		;requesting xfer?
	JRZ	LOOP2		;loop if not
	OUTIR			;send the config bytes
	JMP	STATUS		;return from status

    ;data areas unique to winchester
    ;DPH for a winchester boot drive

ONLY$DRIVE:
	DW	0		;no sector translation, thank you
	DB	0,0,0,0,0,0,0,0,0
	DB	-1
	DW	DPBHD
	DW	0
	DW	ALLOCATION$VECTOR
	DW	DIR$HEAD
	DW	DTA$HEAD
	DW	-1		;no hashing
	DB	0		;no hash bank

DPBHD:	DW	68		;sectors per track
	DB	5		;block shift
	DB	31		;block mask
	DB	1		;extent mask
	DW	1299		;max block no.
	DW	1023		;max dirent no.
	DB	11111111B	;dir allocation 0
	DB	00000000B	;dir allocation 1
	DW	8000H		;permanent drive, no checks
	DW	1		;1 reserved track
	DB	2		;physical sector shift
	DB	3		;physical sector mask

ID$BYTES:
	DS	8		;configuration data stored here

COMND:	DS	1		;command word storage
LUN:	DS	1		;lun/high address
ADDR1:	DS	1		;middle address
ADDR0:	DS	1		;low address
BLOCKS:	DS	1		;no. of sectors to xfer
CNTRL:	DS	1		;step rate

STAT$BYTES:
	DS	2		;command result
ER$BYTES:
	DS	16		;error code + spare

	ENDIF			;end of read/login routines for both
				;floppy and winchester

	;disk communication data items

OLD$TRACK:
	DS	1
TRK:	DS	2		;current track number
SECT:	DS	2		;current sector number
DMA:	DS	2		;current DMA address
CNT:	DB	0		;record count for multisector transfer
DBNK:	DB	0		;bank for DMA operations
CBNK:	DB	0		;bank for processor operations

CHECK$SUM$VECTOR:		;only used by floppy
	DS	33

ALLOCATION$VECTOR:		;large enough for winchester or floppy
	DS	(1299/8)+1

DIR$HEAD:
	DB	-1		;drive
	DB	0,0,0		;rec#
	DB	0		;wflg
	DB	0		;scratch
	DW	0		;track
	DW	0		;sector
	DW	DIR$BUFFER	;pointer to buffer
	
DTA$HEAD:
	DB	-1		;drive
	DB	0,0,0		;rec#
	DB	0		;wflg
	DB	0		;scratch
	DW	0		;track
	DW	0		;sector
	DW	DTA$BUFFER	;pointer to buffer
	
DIR$BUFFER:
	DS	1024		;for floppy or winchester

DTA$BUFFER:			;for floppy or winchester
	DS	1024

	END
