	TITLE	'COLEX 800 series CP/M 3.0 character i/o module.'

; ***********  **********  ***           ******** ****          ****
;************ ************ ***          *********   ****      ****
;***          ***      *** ***          ***           ****  ****
;***          ***      *** ***          ********        ****
;***          ***      *** ***          ********          ****
;***          ***      *** ***          ***           ****  ****
;************ ************ ************ ****************      ****
; *********    **********   *********    *************          ****
;
;Copyright (c) 1983, Colex Electronic Co. Ltd. All rights reserved.
;
;     No  part of this publication may be  reproduced,   transmitted,
;transcribed,   stored in a retrieval system,  or translated into any
;language  or  computer  language,   in any form  or  by  any  means,
;electronic,   mechanical,  magnetic,  optical,  chemical,  manual or
;otherwise   without the prior written permission of Colex Electronic
;Co. Ltd., 623, Ocean Centre, Kowloon, Hong Kong.
;
;
;     Colex  makes no representations or  warranties with  respect to
;the   contents  hereof  and  specifically  disclaims   any   implied
;warranties of merchantability or fitness for any particular purpose. 
;Further  Colex reserves the right to revise  this publication and to
;make  changes  from  time to  time  in the  content  hereof  without
;obligation  of  Colex  to  notify any person  of  such  revision  or
;changes.
;
	PAGE
;****************************************************************
;*								*
;*	Character i/o  module for CP/M 3.0 on the Colex 820/850	*
;*	Initialises the cio & interupt vector, handles clock	*
;*	interupts and performs character i/o.			*
;*								*
;****************************************************************
;  Date		  Author		Modification
;22-Nov-83	R.J. Wellsted
;24-Nov-83	R.J. Wellsted		Changed Disk timeout method to use
;						clock ticks.
;
	PAGE
	PUBLIC	?INIT,?CINIT,?TIME
	PUBLIC	?CI,?CO,?CIST,?COST
	PUBLIC	@CTBL,@HD$UP
	PUBLIC	NULINT,RTCINT
	EXTRN	@CIVEC,@COVEC,@AIVEC,@AOVEC
	EXTRN	@LOVEC,@INTVE
	EXTRN	@DATE,@HOUR,@MIN,@SEC
	EXTRN	?PMSG

	MACLIB	Z80
	MACLIB	PORTS
	MACLIB	MODEBAUD
	MACLIB	EQUATES

CR	EQU	0DH
LF	EQU	0AH
CRTFLG	EQU	0003H
TICKS	EQU	32		;no.of ticks/second
RTCTC	EQU	62500		;rtc time constant (2000000/32)
;****************************************************************
;*								*
;*		General system initialisation			*
;*	set up interupt vector & init cio. for rtc, and init	*
;*	the i/o vectors (CON: vectors set up for internal or	*
;*	external crt as determined by the boot prom.		*
;*								*
;****************************************************************
	DSEG	; init done from banked memory
?INIT:	LXI	H,4000H		;assume no std-crt
	LDA	CRTFLG		;get bootprom flag for which crt
	ORA	A		;test flag
	JRZ	NO$CRT		;skip over if not set
	LXI 	H,8000H		;must be external then
NO$CRT:	SHLD 	@CIVEC
	SHLD 	@COVEC		;assign channel 0 to CRT:
	LXI 	H,1000H
	SHLD 	@LOVEC 		;assign channel 3 to LST:
	LXI	H,2000H		;assign channel 2 to AUX:
	SHLD	@AOVEC
	SHLD	@AIVEC
	LXI	H,@INTVE	;get interupt vector address
	MOV	A,H
	STAI			;copy to interupt vector register
	MOV	A,L		;get low byte
	STA	RTCVEC		;save in cio params
	IN	P$PORTX		;insures state 0 or reset state
	XRA	A
	OUT	P$PORTX		;write pointer or clear reset
	IN	P$PORTX		;state 0
	XRA	A
	OUT	P$PORTA		;clear port a
	OUT	P$PORTB		;clear port b
	OUT	P$PORTC		;clear port c
	LXI	H,CIO$PB	;point to params
	MVI	B,CIO$PBL	;load params length
	MVI	C,P$PORTX	;point to port
	OUTIR			;init the ports
	IM2			;mode 2 interupts
	EI			;interupts on
	LXI 	H,SIGNON$MSG 
	CALL 	?PMSG		; print signon message
	RET	

SIGNON$MSG:
	DB	CR,LF
	DB	'COLEX '
	IF	SC$850
	DB	'850'		;850
	ELSE
	DB	'820'		;820
	ENDIF
	DB	' CP/M Version 3.0',CR,LF
	DB	'(BIOS Revision '
	DB	VERS / 10 + '0','.',VERS MOD 10 + '0'
	DB	')',CR,LF,LF,0

CIO$PB:	DB	00H,01H,00H	;reset the cio
	DB	05H,00001010B	;port c polarity
	DB	06H,00000101B	;port c directions
	DB	07H,00000000B	;port c normal outputs
	DB	08H,00000000B	;port a command
	DB	20H,00010000B	;port a single buffered
	DB	22H,00000000B	;port a polarity
	DB	23H,00000000B	;port a direction (output)
	DB	24H,00000000B	;port a normal outputs
	DB	28H,00010000B	;port b single buffered
	DB	2AH,00000000B	;port b polarity
	DB	2BH,00000000B	;port b direction (output)
	DB	2CH,00000000B	;port b normal outputs
	DB	1EH,10000001B	;c/t 3 continuous
	DB	0CH,00100000B	;clear ius & ip
	DB	1AH,HIGH RTCTC	;time constant high byte
	DB	1BH,LOW RTCTC	;time constant low byte
	DB	04H
RTCVEC:	DB	0		;c/t interupt vector
	D	00H,10000100	;maste interup reg
	DB	01H,10010100B	;enable ports a, b, c & c/t 3
	DB	0CH,11000110B	;set ie, allow counts, trigger
CIO$PBL	EQU	$-CIO$PB
	PAGE
;****************************************************************
;*								*
;*	The entry points for the character i/o devices.		*
;*								*
;****************************************************************
	CSEG			;common memory

?CINIT:	MOV	B,C		;move device no. to reg b
	CALL	TBLJMP
	DW	D0INIT		;device 0 init
	DW	D1INIT		;device 1 init
	DW	D2INIT		;device 2 init
	DW	D3INIT		;device 3 init
	DW	D4INIT		;device 4 init
	DW	NULINI		;null device

?CI:	CALL	TBLJMP
	DW	DEV0IN		;device 0 in
	DW	DEV1IN		;device 1 in
	DW	DEV2IN		;device 2 in
	DW	DEV3IN		;device 3 in
	DW	DEV4IN		;device 4 in
	DW	NULLIN		;null device

?CO:	CALL	TBLJMP
	DW	DEV0OT		;device 0 out
	DW	DEV1OT		;device 1 out
	DW	DEV2OT		;device 2 out
	DW	DEV3OT		;device 3 out
	DW	DEV4OT		;device 4 out
	DW	NULLOT		;null device

?CIST:	CALL	TBLJMP
	DW	DEV0IS		;device 0 in status
	DW	DEV1IS		;device 1 in status
	DW	DEV2IS		;device 2 in status
	DW	DEV3IS		;device 3 in status
	DW	DEV4IS		;device 4 in status
	DW	NULLIS		;null device

?COST:	CALL	TBLJMP
	DW	DEV0OS		;device 0 out status
	DW	DEV1OS		;device 1 out status
	DW	DEV2OS		;device 2 out status
	DW	DEV3OS		;device 3 out status
	DW	DEV4OS		;device 4 out status
	DW	NULLOS		;null device

?TIME:	RET			;no hardware rtc
	PAGE
;****************************************************************
;*								*
;*	The routines for the table driven entry points and	*
;*		the floppy time-out routine.			*
;*								*
;****************************************************************
TBLJMP:	POP	H		;get hl
	MOV	E,B
	MOV	A,E		;get device no.
	CPI	MAX$DEV		;check range
	RNC			;return if bad
	MVI	D,0		;make 16 bit device no.
	DAD	D
	DAD	D		;double index
	MOV	E,M		;get low address
	INX	H		;adjust pointer
	MOV	D,M		;get high address
	XCHG			;move to de
	PCHL			;go to correct routine
	PAGE
;****************************************************************
;*								*
;*	The handler for device 0  [INTCRT] (STD-CRT card.)	*
;*								*
;****************************************************************
D0INIT:	RET			;no init for dev 0

DEV0IS:	IN	P$VDUST		;get crt status
	ANI	40H		;test for key pressed
	RZ
	MVI	A,-1		;load ready status
	RET

DEV0IN:	CALL	DEV0IS		;get input status
	JRZ	DEV0IN		;loop if not ready yet
	IN	P$VDUDA		;get the char
	ANI	7FH		;mask parity bit
	RET

DEV0OS:	IN	P$VDUST		;get crt status
	ANI	80H		;test if ready to take character
	RZ			;return if not ready
	MVI	A,-1		;load ready status
	RET

DEV0OT:	CALL	DEV0OS		;test if device ready
	JRZ	DEV0OT		;loop until ready
	MOV	A,C		;get character
	OUT	P$VDUDA		;send to crt
	RET
	PAGE
;****************************************************************
;*								*
;*	The handlers for device 1 [EXTCRT] (SCC channel B)	*
;*								*
;****************************************************************
DEV1IS:	XRA	A		;pointer for reg 0
	OUT	P$CRT$STAT	;send to scc
	IN	P$CRT$STAT	;get reg 0
	ANI	1		;mask for rx rdy
	RZ			;return if not ready
	MVI	A,-1		;flag ready
	RET

DEV1IN:	CALL	DEV1IS		;get channel rx status
	JRZ	DEV1IN		;loop if not ready
	IN	P$CRT$DATA	;get the character
	ANI	7FH		;remove msb
	RET

DEV1OS:	XRA	A		;point to register 0
	OUT	P$CRT$STAT
	IN	P$CRT$STAT	;get status
	ANI	4		;isolate tx ready bit
	RZ			;return if not ready
	MVI	A,-1		;flag ready
	RET

DEV1OT:	CALL	DEV1OS		;get device status
	JRZ	DEV1OT		;loop if not ready
	MOV	A,C		;get character
	OUT	P$CRT$DATA	;send to device
	RET

D1INIT:	LDA	DEV1BR		;get baud rate
	MVI	C,P$CRT$STAT	;load port address
	LXI	H,SCCA$PB	;point to correct params
	MVI	B,SCCA$PBL	;load param block length
	J	SCC$INI	;ski ove t ini code
	PAGE
;****************************************************************
;*								*
;*	The handler for device 2 [SERIAL] (SCC channel A)	*
;*								*
;****************************************************************
D2INIT:	LDA	DEV2BR
	MVI	C,P$AUX$STAT
	LXI	H,SCCB$PB	;point to correct params
	MVI	B,SCCB$PBL	;load param block length
SCC$INIT:
	PUSH	B
	PUSH	H		;save regs
	MOV	E,A		;form 16 bit baud rate index
	MVI	D,0
	LXI	H,BAUD$TABLE	;point to table
	DAD	D		;add in index
	DAD	D
	MOV	C,M		;get low byte tc.
	INX	H		;adjust pointer
	MOV	B,M		;get high byte
	POP	D		;get pointer to params
	LXI	H,BROFFS	;load offset for low byte of baudrate
	DAD	D		;add in to pointer
	MOV	M,C		;save low byte
	INX	H
	INX	H		;adjust pointer for high byte
	MOV	M,B		;save high byte
	XCHG			;get param pointer
	POP	B		;get length & port
	OUTIR			;send to device
	RET

DEV2IS:	XRA	A		;point to register 0
	OUT	P$AUX$STAT
	IN	P$AUX$STAT	;get status
	ANI	1		;isolate rx ready bit
	RZ			;return if not ready
	MVI	A,-1		;flag ready
	RET

DEV2IN:	CALL	DEV2IS		;get device status
	JRZ	DEV2IN		;loop if not ready
	IN	P$AUX$DATA	;get data
	ANI	7FH		;remove msb
	RET

DEV2OS:	XRA	A		;point to register 0
	OUT	P$AUX$STAT
	IN	P$AUX$STAT	;get status
	ANI	4		;isolate tx ready bit
	RZ			;return if not ready
	MVI	A,-1		;flag ready
	RET

DEV2OT:	CALL	DEV2OS		;get device status
	JRZ	DEV2OT		;loop if not ready
	MOV	A,C		;get character
	OUT	P$AUX$DATA	;send to device
	RET
	PAGE
;****************************************************************
;*								*
;*	The handler for device 3 [CENTR1] (CIO port A)		*
;*								*
;****************************************************************
DEV3OS:	IN	P$PORTC		;get status byte
	ANI	100B		;isolate busy bit
	RZ			;done if zero
	MVI	A,-1		;flag ready
	RET

DEV3OT:	CALL	DEV3OS		;get device status
	JRZ	DEV3OT		;loop if not ready
	MOV	A,C		;get character
	OUT	P$PORTA		;send to device
	MVI	A,1000B
	OUT	P$PORTC		;set strobe bit
	XRA	A
	OUT	P$PORTC		;reset strobe bit
	RET
	PAGE
;****************************************************************
;*								*
;*	The handler for device 4 [CENTR2] (CIO channel B)	*
;*								*
;****************************************************************
D3INIT:
D4INIT:	RET

DEV4OS:	IN	P$PORTC		;get status byte
	ANI	1B		;isolate busy bit
	RZ			;done if zero
	MVI	A,-1		;flag ready
	RET

DEV4OT:	CALL	DEV4OS		;get device status
	JRZ	DEV4OT		;loop if not ready
	MOV	A,C		;get character
	OUT	P$PORTB		;send to device
	MVI	A,10B
	OUT	P$PORTC		;set strobe bit
	XRA	A
	OUT	P$PORTC		;reset strobe bit
	RET

NULINI:	RET			;no init for null decive

DEV3IS:
DEV4IS:
NULLIS:	MVI	A,-1		;always ready to input
	ORA	A		;set flags
	RET

DEV3IN:
DEV4IN:
NULLIN:	MVI	A,1AH		;end of file for null device
	RET

NULLOS:	MVI	A,-1		;always ready to output
	ORA	A		;set flags

NULLOT:	RET
	PAGE
;****************************************************************
;*								*
;*		The Character device Table.			*
;*	Each entry is 8 bytes (6 byte name (ascii), 1 mode	*
;*	byte and a baud rate byte).				*
;*								*
;****************************************************************
@CTBL:	DB	'INTCRT'	;internal crt
	DB	MB$IN$OUT+MB$SERIAL
	DB	BAUD$NONE
	DB	'EXTCRT'	;external crt
	DB	MB$IN$OUT+MB$SERIAL+MB$SOFTBAUD
DEV1BR:	DB	BAUD$9600
	DB	'SERIAL'	;auxillary link
	DB	MB$IN$OUT+MB$SERIAL+MB$SOFTBAUD+MB$XONXOFF
DEV2BR:	DB	BAUD$9600
	DB	'CENTR1'	;main centronics interface
	DB	MB$OUTPUT
	DB	BAUD$NONE
	DB	'CENTR2'	;aux centronics interface
	DB	MB$OUTPUT
	DB	BAUD$NONE
MAX$DEV	EQU	($-@CTBL)/8	;no. of devices
	DB	0

BAUD$TABLE:
	DW	0		;no baudrate
	DW	2302		;   50	 baud
	DW	1534		;   75	 baud
	DW	1045		;  110	 baud
	DW	854		;  134.5 baud
	DW	766		;  150	 baud
	DW	382		;  300	 baud
	DW	190		;  600	 baud
	DW	94		; 1200	 baud
	DW	62		; 1800	 baud
	DW	46		; 2400	 baud
	DW	30		; 3600	 baud
	DW	22		; 4800	 baud
	DW	14		; 7200	 baud
	DW	10		; 9600	 baud
	DW	4		;19200	 baud

@HD$UP:	DW	0		;floppy head unload counter

SCCA$PB:
	DB	3,11000001B	;rx(8 bits, rx enable)
	DB	4,01001100B	;*16 clk, 2 stop bits, no parity
	DB	5,11101010B	;tx(dtr, 8 bits, tx enable, rts)
	DB	11,11010100B	;xtal, rxc=brg, txc=brg, trxc out=xtal
	DB	12
BROFFS	EQU	$-SCCA$PB
	DS	1		;baud rate low byte
	DB	13
	DS	1		;baud rate high byte
	DB	14,00000001B	;dtr mode, brg clk=xtal, brg enable
SCCA$PBL EQU	$-SCCA$PB

SCCB$PB:
	DB	3,11000001B	;rx(8 bits, rx enable)
	DB	4,01001100B	;*16 clk, 2 stop bits, no parity
	DB	5,11101010B	;tx(dtr, 8 bits, tx enable, rts)
	DB	11,01010110B	;rxc=brg, txc=brg, trxc out=brg
	DB	12
	DS	1		;baud rate low byte
	DB	13
	DS	1		;baud rate high byte
	DB	14,0000001B	;dtr mode, brg clk=rtxc, brg enable
SCCB$PBL EQU	$-SCCB$PB
	PAGE
;****************************************************************
;*								*
;*		The clock interupt handler.			*
;*								*
;****************************************************************
INTSAV:	XTHL			;save hl & get return address
	PUSH	D		;save de
	PUSH	B		;save bc
	PUSH	PSW		;save a & flags
	PCHL			;return

RTCINT:	SSPD	SAVDSP		;save current stack pointer
	LXI	SP,INTSTK	;point to interupt stack
	CALL	INTSAV		;save registers
	LXI	H,TICK		;point to tick counter
	DCR	M		;adjust
	JNZ	RTCEND		;done if not zero
	MVI	M,TICKS		;reload counter
	ORA	A		;clear carry
	LXI	H,@SEC		;point to seconds counter
	MOV	A,M		;get current value
	INR	A		;adjust
	DAA
	MOV	M,A		;save new value
	CPI	60H		;check for overflow
	JC	RTCEND		;interupt done if not
	MVI	M,0		;reset value
	ORA	A		;clear carry
	LXI	H,@MIN		;point to minutes counter
	MOV	A,M		;get current value
	INR	A		;adjust
	DAA
	MOV	M,A		;save new value
	CPI	60H		;check for overflow
	JC	RTCEND		;interupt done if not
	MVI	M,0		;reset value
	ORA	A		;clear carry
	LXI	H,@HOUR		;point to hours counter
	MOV	A,M		;get current value
	INR	A		;adjust
	DAA
	MOV	M,A		;save new value
	CPI	24H		;check for overflow
	JC	RTCEND		;interupt done if not
	MVI	M,0		;reset value
	ORA	A		;clear carry
	LHLD	@DATE
	INX	H		;adjust date
	SHLD	@DATE
RTCEND:	LXI	H,@HD$UP+1	;point to time-out flag
	MOV	A,M		;get time out flag
	ORA	A		;test it
	JRNZ	NO$TIME$OUT	;skip if disabled
	DCX	H		;point to time out counter
	DCR	M		;adjust counter
	JRNZ	NO$TIME$OUT	;skip if not done
	INX	H		;point to flag
	MVI	M,-1		;disable further time outs
	MVI	A,01000000B	;load de-select mask
	OUT	P$SELECT	;deselect floppy
NO$TIME$OUT:
	MVI	A,0CH		;pointer for c/t 3
	OUT	P$PORTX		;send to cio
	MVI	A,00100100B	;reset ius & ip
	OUT	P$PORTX		;send to cio
RETINT:	POP	PSW		;restore a & flags
	POP	B		;restore bc
	POP	D		;restore de
	POP	H		;restore hl
	LSPD	SAVDSP		;get user stack

NULINT:	EI			;re-enable interupts
	RETI			;return

	DW	0C7C7H,0C7C7H,0C7C7H,0C7C7H
	DW	0C7C7H,0C7C7H,0C7C7H,0C7C7H
	DW	0C7C7H,0C7C7H,0C7C7H,0C7C7H
	DW	0C7C7H,0C7C7H,0C7C7H,0C7C7H
INTSTK	EQU	$
SAVDSP:	DW	0C7C7H
TICK:	DB	TICKS		;tick counter

	END
