	TITLE	'COLEX SC-850 Winchester Bootstrap'
	
; ***********  **********  ***           ******** ****          ****
;************ ************ ***          *********   ****      ****
;***          ***      *** ***          ***           ****  ****
;***          ***      *** ***          ********        ****
;***          ***      *** ***          ********          ****
;***          ***      *** ***          ***           ****  ****
;************ ************ ************ ****************      ****
; *********    **********   *********    *************          ****
;
;Copyright (c) 1983, Colex Electronic Co. Ltd. All rights reserved.
;
;     No  part of this publication may be  reproduced,   transmitted,
;transcribed,   stored in a retrieval system,  or translated into any
;language  or  computer  language,   in any form  or  by  any  means,
;electronic,   mechanical,  magnetic,  optical,  chemical,  manual or
;otherwise   without the prior written permission of Colex Electronic
;Co. Ltd., 623, Ocean Centre, Kowloon, Hong Kong.
;
;
;     Colex  makes no representations or  warranties with  respect to
;the   contents  hereof  and  specifically  disclaims   any   implied
;warranties of merchantability or fitness for any particular purpose. 
;Further  Colex reserves the right to revise  this publication and to
;make  changes  from  time to  time  in the  content  hereof  without
;obligation  of  Colex  to  notify any person  of  such  revision  or
;changes.
;
	PAGE
;****************************************************************
;*								*
;*		Colex SC-850 Winchester boot program.		*
;*								*
;*		This program resides on sector 1 of track 0.	*
;*	The bootstrap PROM loads this sector into location	*
;*	0100H and the transfers control to that address. This	*
;*	program the reads the remainder (except sector 0) of	*
;*	track 0 into memory at location 0400H up. Control is	*
;*	then transfered to location 400H (The CP/M 3.0 loader.)	*
;*								*
;****************************************************************
;  Date		  Author		Modification
;27-Oct-83	R.J. Wellsted	Initial Release
	PAGE
	MACLIB	Z80
	MACLIB	EQUATES
	MACLIB	PORTS

CPMLDR	EQU	400H
NSECT	EQU	17-2		;sector/track - 2 reserved

;	SASI host adaptor bit definitions

I$O	EQU	00000001B	;bit 0 is i/o
REQ	EQU	00000010B	;bit 1 is request
C$D	EQU	00000100B	;bit 2 is c/d
MSG	EQU	00001000B	;bit 3 is message
BSY	EQU	00010000B	;bit 4 is busy
ACK	EQU	00100000B	;bit 5 is acknowledge
SEL	EQU	01000000B	;bit 6 is select
RESET	EQU	10000000B	;bit 7 is reset


HDRD	EQU	8
WINSIZ	EQU	2		;1 = 256 byte sectors, 2 = 512 byte sectors

BOOTW:	LXI	SP,BOOTW	;set up stack
	MVI	D,NSECT		;d = number of sectors to read
	MVI	C,P$HDDATA	;point to hard disk data port
	LXI	H,CPMLDR	;starting dma address
	SHLD	XFRADR		;save it
	MVI	A,HDRD		;load read command
	STA 	COMND		;save it
	MVI	A,1		;set up rest of the command table
	STA	BLOCKS		;number of blocks to read
	MVI	A,6		;step rate control byte
	STA	CNTRL		;(we're using buffered seeks)
	XRA	A		;must boot from unit 0
	STA	LUN
	LXI	H,200H		;start with sector 2
	SHLD	ADDR1		;(remember the xebec works backwards)
LOOP:	CALL	SELSEND		;send the command block to the controller
	LHLD	XFRADR		;get dma address for this pass
	CALL	XFERDAT		;transfer the data
	DCR	D		;adjust loop counter (no. of sectors left)
	JZ	CPMLDR		;if 0 we've finished
	LDA	ADDR0		;get current sector no.
	INR	A		;point to next
	STA	ADDR0		;save it
	JR	LOOP		;go do it

XFERDAT:			;now get data
LUP1:	IN	P$HDSTAT	;get controller status
	ANI	C$D		;wait for C/D to be deasserted
	JRNZ	LUP1		;loop if not in data mode
LUP2:	IN	P$HDSTAT	;get controller status
	ANI	REQ		;wait for request to be asserted
	JRZ	LUP2		;loop if not ready to transfer
	MVI	B,0		;sets up for 256 byte transfer
	MVI	A,WINSIZ	;load no. of 256 byte blocks
AGIN:	INIR			;get data from controller
	DCR	A		;adjust block count
	JRNZ	AGIN		;do it again if needed
	SHLD	XFRADR		;save new value of hl
	LXI	H,STATUS	;point to status buffer
	MVI	B,2		;get two bytes
LUP3:	IN	P$HDSTAT	;get controller status
	ANI	C$D		;test if ready to transfer status info
	JRZ	LUP3		;loop if not
LUP4:	IN	P$HDSTAT	;get controller status
	ANI	REQ		;wait for req to be asserted
	JRZ	LUP4		;loop if not
	IN	P$HDDATA	;get status byte
	MOV	M,A		;save in buffer
	INX	H		;adjust buffer pointer
	DJNZ	LUP4		;loop if more to get
	DCX	H		;point back at first status byte
	DCX	H
	MOV	A,M		;get it
	ANI	00011111B	;check relavant bits
	RNZ			;not zero if error
	INX	H		;point to completion message
	MOV	A,M		;(gets a 0)
	RET

SELSEND:			;select controller and send command
	IN	P$HDSTAT	;get controller status
	ANI	BSY		;test if busy
	JRNZ	SELSEND		;loop if so
	MVI	A,1		;load controller address
	OUT	P$HDDATA	;send to controller
	MVI	A,SEL		;load select bit
	OUT	P$HDCOM		;send to controller
LUP5:	IN	P$HDCOM		;get controller status
	ANI	BSY		;has it gone busy?
	JRZ	LUP5		;loop if not
	XRA	A		;turn off selct bit
	OUT	P$HDCOM
SENCOM:	LXI	H,COMND		;point to command string
				;entered with b = number of bytes to transfer
LUP6:	IN	P$HDSTAT	;get controller status
	ANI	REQ		;is it requesting a command?
	JRZ	LUP6		;loop until it does
	IN	P$HDSTAT	;get status
	ANI	C$D OR I$O	;test for command input
	CPI	C$D		;test for command
	RNZ			;done if not
	MOV	A,M		;get command byte
	OUT	P$HDDATA	;send to controller
	INX	H		;adjust pointer
	JR	LUP6		;loop back for rest of command

COMND:	DB	0		;I/O operation command
LUN:	DB	0		;bits 7,6,5 = LUN; 4,3,2,1,0 = address2
ADDR1:	DB	0		;ms byte of disk address = address1
ADDR0:	DB	0		;ls byte of disk address = address0
BLOCKS:	DB	0		;number of blocks
CNTRL:	DB	0		;control byte, enable retries/error correction
STATUS:	DB	0,0		;status and completion message

XFRADR:	DW	0		;address for transfer

	END
