	TITLE	'Boot loader module for CP/M 3.0'

; ***********  **********  ***           ******** ****          ****
;************ ************ ***          *********   ****      ****
;***          ***      *** ***          ***           ****  ****
;***          ***      *** ***          ********        ****
;***          ***      *** ***          ********          ****
;***          ***      *** ***          ***           ****  ****
;************ ************ ************ ****************      ****
; *********    **********   *********    *************          ****
;
;Copyright (c) 1983, Colex Electronic Co. Ltd. All rights reserved.
;
;     No  part of this publication may be  reproduced,   transmitted,
;transcribed,   stored in a retrieval system,  or translated into any
;language  or  computer  language,   in any form  or  by  any  means,
;electronic,   mechanical,  magnetic,  optical,  chemical,  manual or
;otherwise   without the prior written permission of Colex Electronic
;Co. Ltd., 623, Ocean Centre, Kowloon, Hong Kong.
;
;
;     Colex  makes no representations or  warranties with  respect to
;the   contents  hereof  and  specifically  disclaims   any   implied
;warranties of merchantability or fitness for any particular purpose. 
;Further  Colex reserves the right to revise  this publication and to
;make  changes  from  time to  time  in the  content  hereof  without
;obligation  of  Colex  to  notify any person  of  such  revision  or
;changes.
;
	PAGE
;****************************************************************
;*								*
;*	This module performs a (re-)load of the CCP into	*
;*	the tpa when requested. The CCP is loaded from a file	*
;*	called CCP.COM on drive A:. If the file is not found	*
;*	The message "BIOS Error on A: No CCP.COM file." is	*
;*	displayed on the console.				*
;*								*
;****************************************************************
;  Date		  Author		Modification
;22-Nov-83	R.J. Wellsted
	PAGE
	PUBLIC	?LDCCP,?RLCCP	;entry points to (re-)load CCP
	EXTRN	?PMSG,?CONIN	;subroutines to print message/get con char
	EXTRN 	@CBNK,?BNKSL	;current bank/bank select routine

	MACLIB	PORTS		;i/o port equates
	MACLIB	Z80		;z80 opcodes
	MACLIB	EQUATES		;system equates

BDOS	EQU	5		;bdos entry point

	IF	BANKED
TPA$BANK EQU	1		;tpa in bank 1
	ELSE
TPA$BANK EQU	0		;tpa in bank 0
	ENDIF

CR	EQU	0DH
LF	EQU	0AH

	CSEG	;boot loading most be done from resident memory

?RLCCP:				;here to reload the CCP at warm starts
?LDCCP:	MVI	A,TPA$BANK	;select the tpa bank
	CALL	?BNKSL
	XRA	A
	STA 	CCP$FCB+15	;zero extent
	LXI 	H,0
	SHLD 	FCB$NR		;start at beginning of file
	LXI 	D,CCP$FCB
	CALL 	OPEN		;open file containing CCP
	INR 	A
	JZ 	NO$CCP		;error if no file...
	LXI 	D,0100H
	CALL 	SETDMA		;start of TPA
	LXI	D,128		;this will do it to death
	CALL	SETMULTI
	LXI 	D,CCP$FCB
	CALL 	READ		;load the thing
	RET

NO$CCP:	LXI 	H,CCP$MSG
	CALL 	?PMSG		;report this...
	CALL 	?CONIN		;get a response
	JMP 	?LDCCP		;and try again
	PAGE
;****************************************************************
;*								*
;*		CP/M BDOS Function Interfaces			*
;*								*
;****************************************************************
OPEN:	MVI 	C,15
	JMP 	BDOS		;open file

SETDMA:	MVI 	C,26
	JMP 	BDOS		;set data transfer address

SETMULTI:
	MVI 	C,44
	JMP 	BDOS		;set record count

READ:	MVI 	C,20
	JMP 	BDOS		;read records


CCP$MSG:
	DB	CR,LF,'BIOS Err on A: No CCP.COM file',0

CCP$FCB:
	DB	1,'CCP     ','COM',0,0,0,0
	DS	16
FCB$NR:	DB	0,0,0

	END
