/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	rx_kernel.c,v $
 * Revision 2.3  89/06/03  15:39:55  jsb
 * 	Merged with newer ITC sources.
 * 	[89/05/26  22:25:04  jsb]
 * 
 * Revision 2.2  89/04/22  15:29:12  gm0w
 * 	Updated to RX version.
 * 	[89/04/14            gm0w]
 * 
 */
/*
****************************************************************************
*        Copyright IBM Corporation 1988, 1989 - All Rights Reserved        *
*                                                                          *
* Permission to use, copy, modify, and distribute this software and its    *
* documentation for any purpose and without fee is hereby granted,         *
* provided that the above copyright notice appear in all copies and        *
* that both that copyright notice and this permission notice appear in     *
* supporting documentation, and that the name of IBM not be used in        *
* advertising or publicity pertaining to distribution of the software      *
* without specific, written prior permission.                              *
*                                                                          *
* IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL *
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL IBM *
* BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY      *
* DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER  *
* IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING   *
* OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.    *
****************************************************************************
*/
#include <afs/param.h>
#include <sys/types.h>
#include <sys/param.h>
#ifdef	AFS_AUX_ENV
#ifdef	PAGING
#include <sys/mmu.h>
#include <sys/seg.h>
#include <sys/page.h>
#include <sys/region.h>
#endif
#include <sys/sysmacros.h>
#include <sys/signal.h>
#include <sys/errno.h>
#include <sys/var.h>
#endif
#include <sys/systm.h>
#if	!defined(AFS_IBM_ENV) || !defined(sys_rt_r3)
#include <sys/time.h>
#endif	AFS_IBM_ENV
#ifdef	AFS_AIX_ENV
#include <sys/errno.h>
#else
#include <sys/kernel.h>
#endif
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <sys/protosw.h>
#include <sys/domain.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/uio.h>
#include <sys/buf.h>
#ifdef	AFS_GFS_ENV
#include <afs/gfs_vfs.h>
#include <afs/gfs_vnode.h>
#else
#ifdef	AFS_MACH_ENV
#include <vfs/vfs.h>
#include <vfs/vnode.h>
#include <sys/inode.h>
#else	AFS_MACH_ENV
#include <sys/vfs.h>
#include <sys/vnode.h>
#include <ufs/inode.h>
#endif	AFS_MACH_ENV
#endif	AFS_GFS_ENV
#include <netinet/in.h>
#include <net/route.h>
#include <netinet/in_pcb.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/ip_var.h>
#include <netinet/ip_icmp.h>
#include <netinet/udp.h>
#include <netinet/udp_var.h>
#include <sys/mbuf.h>
#include <sys/proc.h>
#include <sys/file.h>
#include <rpc/types.h>
#include <afs/osi.h>
#include <afs/lock.h>

#include <rpc/xdr.h>
#include <rx/rx.h>
#include <rx/rx_globals.h>

#define	MAXRXPORTS  20
extern long afs_debug;
static int idone=0;
static struct protosw parent_proto;	/* udp proto switch */
static unsigned	short ports[MAXRXPORTS];
static char *portRocks[MAXRXPORTS];
int (*rxk_GetPacketProc)(); /* set to packet allocation procedure */
int (*rxk_PacketArrivalProc)();

/* basic packet handling routine called at splnet from softnet loop */
#if	(defined(AFS_SUN_ENV) && !defined(AFS_VFS40))
/* Unfortunately grabbing of the packets using contants might no work right since the udphdr was pointing to the wrong place at least for the suns; for the time being we include the ifdefed code for the suns which should work for the rest and we'll clean this up soon */
static rxk_input(am)
#else
static rxk_input (am, aif)
struct ifnet *aif;
#endif	/*(defined(AFS_SUN_ENV) && !defined(AFS_VFS40))*/
register struct mbuf *am;
{
    int (*tproc)();
    register unsigned short *tsp;
    int hdr;
    struct udphdr *tu;
    register struct ip *ti;
    register int i;
    char *phandle, *pdata;
    register long code;
    struct sockaddr_in taddr;
    short port;

    /* make sure we have ip and udp headers in first mbuf */
    if (am->m_off > MMAXOFF || am->m_len < 28) {
	am = m_pullup(am, 28);
	if (!am) return;
    }
    hdr = (mtod(am, struct ip *))->ip_hl;
    if (hdr > 5) {
	if (am->m_len < (28 + (hdr<<2))) {
	    am = m_pullup(am, 28+(hdr<<2));
	    if (!am) return;
	}
	ti = mtod(am, struct ip	*); /* recompute, since m_pullup allocates new mbuf */
	tu = (struct udphdr *)(((char *)ti) + 20 + (hdr<<2)); /* skip ip hdr */
    }
    else {
	ti = mtod(am, struct ip *);
	tu = (struct udphdr *)(((char *)ti) + 20);	/* skip basic ip hdr */
    }
    
    /* now read the port out */
    port = tu->uh_dport;

    for(tsp=ports, i=0; i<MAXRXPORTS;i++) {
	if (*tsp++ == port) {
	    /* checksum the packet */
#ifdef	AFS_AIX_ENV
	    ip_stripoptions(am,	(struct	mbuf *)	0); /* get rid of anything we don't need */
#else
	    ip_stripoptions(ti,	(struct	mbuf *)	0); /* get rid of anything we don't need */
#endif
	    /* deliver packet to rx */
	    taddr.sin_family = AF_INET;	    /* compute source address */
	    taddr.sin_port = tu->uh_sport;
	    taddr.sin_addr.s_addr = ti->ip_src.s_addr;
	    code = (*rxk_GetPacketProc)(&phandle, &pdata, 0);
	    if (code==0) {
		/*
		 * 28 is IP (20) + UDP (8) header.  ulen includes
		 * udp header, and we *don't* tell RX about udp
		 * header either.  So, we remove those 8 as well.
		 */
		register int data_len;
		
		data_len = ntohs(tu->uh_ulen);
		data_len -= 8;
		if ((data_len >= 0) &&
		    (data_len <= RX_MAX_PACKET_SIZE)) {
		    register int resid = m_cpytoc(am, 28, data_len, pdata);
		    
		    if (resid != 0) {
			/* XXX should just increment counter here.. */
			printf("rx: truncated UDP packet\n");
			rxi_FreePacket(phandle);
		    }
		    else 
			(*rxk_PacketArrivalProc)(phandle, pdata, &taddr,
						 portRocks[i], data_len);
		} else {
		    /*
		     * XXX if packet is too long for our buffer,
		     * should do this at a higher layer and let other
		     * end know we're losing.
		     */
		    printf("rx: packet from 0x%x dropped: bad ulen\n",
			   taddr.sin_addr.s_addr);
		    rxi_FreePacket(phandle);
		}	
	    }
	    m_freem(am);
	    return;
	}
    }

    /* if we get here, try to deliver packet to udp */
#if	(defined(AFS_SUN_ENV) && !defined(AFS_VFS40))
    if (tproc = parent_proto.pr_input) i = (*tproc)(am);
#else
    if (tproc = parent_proto.pr_input) i = (*tproc)(am, aif);
#endif	/*(defined(AFS_SUN_ENV) && !defined(AFS_VFS40))*/
    else i = 0;
    return i;
}

/* called 5 times per second (at unknown priority?).  Must go to splnet before touching anything significant */
static rxk_fasttimo () {
    int code;
    int (*tproc)();
    int s;
    struct clock temp;

    s = splnet();
    /* do rx fasttimo processing here */
    rxevent_RaiseEvents(&temp);
    splx(s);
    if (tproc = parent_proto.pr_fasttimo) code = (*tproc)();
    else code = 0;
    return code;
}

/* start intercepting basic calls */
static rxk_init() {
    register struct protosw *tpro, *last;
    if (idone) return 0;

    last = inetdomain.dom_protoswNPROTOSW;
    for (tpro = inetdomain.dom_protosw; tpro < last; tpro++)
      if (tpro->pr_protocol == IPPROTO_UDP) {
          bcopy(tpro, &parent_proto, sizeof(parent_proto));
          tpro->pr_input = rxk_input;
          tpro->pr_fasttimo = rxk_fasttimo;
          bzero(ports, sizeof(ports));
          /*
           * don't bother with pr_drain and pr_ctlinput
           * until we have something to do
           */
          idone = 1;
          return 0;
      }
    panic("inet:no udp");
}

/* add a port to the monitored list, port # is in network order */
rxk_AddPort(aport, arock)
char *arock;
u_short aport; {
    register int i;
    register unsigned short *tsp, ts;
    int zslot;

    if (!idone) rxk_init();
    zslot = -1;	    /* look for an empty slot simultaneously */
    for(i=0,tsp=ports;i<MAXRXPORTS;i++,tsp++) {
	if (((ts = *tsp) == 0) && (zslot == -1)) 
	    zslot = i;
	if (ts == aport) {
	    return 0;
	}
    }
    /* otherwise allocate a new port slot */
    if (zslot < 0) return E2BIG; /* all full */
    ports[zslot] = aport;
    portRocks[zslot] = arock;
    return 0;
}

/* remove as port from the monitored list, port # is in network order */
rxk_DelPort(aport)
u_short aport; {
    register int i;
    register unsigned short *tsp;

    if (!idone) rxk_init();
    for(i=0,tsp=ports;i<MAXRXPORTS;i++,tsp++) {
	if (*tsp == aport) {
	    /* found it, adjust ref count and free the port reference if all gone */
	    *tsp = 0;
	    return 0;
	}
    }
    /* otherwise port not found */
    return ENOENT;
}

osi_socket rxi_GetUDPSocket(port)
    u_short port;
{
    struct socket *socket;
    socket = (struct socket *) osi_NewSocket(port);
    if (socket == (struct socket *) 0) return OSI_NULLSOCKET;
    rxk_AddPort(port, (char *) socket);
    return socket;
}


osi_Panic(msg, a1, a2, a3) {
    printf(msg, a1, a2, a3);
    panic("rx panic");
}

rxi_StartListener() {
    /* if kernel, give name of appropriate procedures */
    rxk_GetPacketProc = MyPacketProc;
    rxk_PacketArrivalProc = MyArrivalProc;
}

static int MyPacketProc(ahandle, adata, asize)
long asize;
char **ahandle;
char **adata; {
    register struct rx_packet *tp;
    tp = rxi_AllocPacket(RX_PACKET_CLASS_RECEIVE);
    if (!tp) return -1;
    /* otherwise we have a packet, set appropriate values */
    *ahandle = (char *) tp;
    *adata = (char *) (&(tp->wire));
    return 0;
}

static int MyArrivalProc(ahandle, adata, afrom, arock, asize)
register struct rx_packet *ahandle;
char *adata;
register struct sockaddr_in *afrom;
char *arock;
long asize; {
    /* handle basic rx packet */
    if (afs_debug & 2)
	afs_dp("rcv %d bytes from %x %d\n", asize, afrom->sin_addr.s_addr, afrom->sin_port);
    ahandle->length = asize - RX_HEADER_SIZE;
    rxi_DecodePacketHeader(ahandle);
    ahandle = rxi_ReceivePacket(ahandle, (struct socket *) arock, afrom->sin_addr.s_addr, afrom->sin_port);
    /* free the packet if it has been returned */
    if (ahandle) rxi_FreePacket(ahandle);
    return 0;
}

/* Routine called during the afsd "-shutdown" process to put things back to the initial state */
rxkernel_shutdown()
{
    register struct protosw *tpro, *last;
    int i;

    last = inetdomain.dom_protoswNPROTOSW;
    for (tpro = inetdomain.dom_protosw; tpro < last; tpro++)
      if (tpro->pr_protocol == IPPROTO_UDP) {
          bcopy(&parent_proto, tpro, sizeof(parent_proto)); /* restore original udp protocol switch */
	  bzero(&parent_proto, sizeof(parent_proto));
	  idone = 0;
	  for (i=0; i<MAXRXPORTS;i++) {
	      ports[i] = 0;
	      portRocks[i] = (char *)0;
	  }
	  return;
      }    
    panic("rxkernel_shutdown: no udp proto");
}
