/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	rx_bcrypt.c,v $
 * Revision 2.3  89/06/03  15:38:34  jsb
 * 	Merged with newer ITC sources.
 * 	[89/05/26  22:23:48  jsb]
 * 
 * Revision 2.2  89/04/22  15:28:29  gm0w
 * 	Updated to RX version.
 * 	[89/04/14            gm0w]
 * 
 */
/*
****************************************************************************
*        Copyright IBM Corporation 1988, 1989 - All Rights Reserved        *
*                                                                          *
* Permission to use, copy, modify, and distribute this software and its    *
* documentation for any purpose and without fee is hereby granted,         *
* provided that the above copyright notice appear in all copies and        *
* that both that copyright notice and this permission notice appear in     *
* supporting documentation, and that the name of IBM not be used in        *
* advertising or publicity pertaining to distribution of the software      *
* without specific, written prior permission.                              *
*                                                                          *
* IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL *
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL IBM *
* BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY      *
* DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER  *
* IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING   *
* OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.    *
****************************************************************************
*/

#ifdef KERNEL
#include <rx/bcrypt.h>
#else KERNEL
# include "bcrypt.h"
#endif KERNEL

unsigned char cs0[256] = {
 0xc4, 0x7d, 0xda, 0x5b, 0x28, 0x10, 0x21, 0x8c, 0x86, 0xd8, 0x3f, 0x9e, 0x56, 0x41, 0x41, 0xa0,
 0x25, 0xd2, 0xdb, 0x46, 0x65, 0xa2, 0x80, 0x7a, 0xb9, 0xdc, 0x3e, 0x9a, 0xdf, 0xcd, 0x03, 0xc3,
 0x0d, 0xff, 0xc3, 0xc3, 0x84, 0x27, 0xc2, 0x48, 0x80, 0xdd, 0x3b, 0x98, 0x07, 0x84, 0x02, 0x01,
 0x83, 0xf5, 0x78, 0xff, 0x82, 0x04, 0x0b, 0x10, 0x5d, 0xc8, 0x44, 0x08, 0xd0, 0x11, 0x52, 0x0c,
 0x04, 0x2d, 0x28, 0x22, 0x10, 0x80, 0x03, 0x4c, 0x04, 0x7a, 0x59, 0x81, 0x4a, 0x44, 0x08, 0x40,
 0xc1, 0xfb, 0x4a, 0x4d, 0x1f, 0x08, 0x8c, 0xcb, 0x10, 0xc6, 0x30, 0x88, 0x12, 0x80, 0x92, 0x6a,
 0x50, 0x17, 0x44, 0x74, 0x00, 0x35, 0xe7, 0x6d, 0xc1, 0x20, 0x29, 0x49, 0x0d, 0x50, 0x1d, 0x6a,
 0x2a, 0x90, 0x40, 0x14, 0x50, 0x42, 0x09, 0x6f, 0x90, 0x20, 0x89, 0x4a, 0x5d, 0x5f, 0xce, 0x7a,
 0x9e, 0xe9, 0x52, 0xc5, 0x49, 0x17, 0xa9, 0x5c, 0xfe, 0xc5, 0xff, 0xcf, 0x77, 0xfc, 0x8d, 0xa9,
 0xd0, 0x6e, 0xb9, 0xa0, 0xe2, 0x50, 0x2c, 0x89, 0xf1, 0x55, 0x5b, 0x8b, 0x0d, 0xed, 0xb3, 0xab,
 0x5d, 0xbd, 0xd8, 0x57, 0x2e, 0xc3, 0x95, 0x38, 0x56, 0xd7, 0x56, 0xc8, 0x0b, 0x23, 0xbf, 0xfd,
 0xfd, 0xcb, 0x87, 0xd7, 0x24, 0x2f, 0xa8, 0x10, 0x37, 0x00, 0x05, 0x86, 0x44, 0x40, 0x10, 0x29,
 0x03, 0x20, 0x82, 0xdc, 0x44, 0xd8, 0x33, 0x94, 0x0c, 0x91, 0xdd, 0xf5, 0xa1, 0x86, 0x95, 0xa6,
 0xcd, 0xc7, 0xa6, 0x06, 0x34, 0x4e, 0x08, 0x88, 0x96, 0xb7, 0x95, 0xde, 0x2e, 0x2b, 0x22, 0xa3,
 0x49, 0x46, 0xfb, 0xbe, 0xfd, 0xda, 0x6b, 0xe6, 0x17, 0x79, 0x5d, 0x0b, 0x32, 0x42, 0x67, 0xab,
 0x6d, 0xb0, 0x87, 0xa6, 0xd2, 0x02, 0x1a, 0x43, 0x29, 0x11, 0x82, 0x59, 0xa6, 0x2d, 0xe0, 0x84,
};

unsigned char cs1[256] = {
 0x61, 0x13, 0x86, 0xca, 0x3e, 0xd2, 0xd1, 0xb4, 0x74, 0x43, 0x03, 0xc0, 0x22, 0x14, 0x4c, 0x01,
 0xd5, 0x2c, 0x78, 0x59, 0x2e, 0xe5, 0xaf, 0x89, 0xb2, 0x33, 0x61, 0xf6, 0xff, 0x1b, 0x76, 0xf9,
 0xe6, 0x0e, 0x75, 0x32, 0xcc, 0x20, 0x24, 0x1e, 0xca, 0x33, 0xed, 0xc6, 0xdd, 0xd3, 0xdc, 0xac,
 0x5d, 0x64, 0x07, 0x58, 0x51, 0x03, 0x33, 0x03, 0x84, 0x56, 0x39, 0x54, 0xb5, 0xb1, 0x0b, 0xb3,
 0x95, 0xae, 0x73, 0xa6, 0x81, 0xf8, 0x74, 0x12, 0xa6, 0xa0, 0xed, 0x8b, 0xe7, 0x8b, 0xfb, 0xfc,
 0x6b, 0x7f, 0x7b, 0xc5, 0xbb, 0xb4, 0x2a, 0xb3, 0x73, 0x71, 0x90, 0x1b, 0x90, 0x30, 0x06, 0x24,
 0xa1, 0x68, 0x80, 0xd6, 0xfc, 0xfe, 0x3d, 0xd4, 0xf7, 0xa8, 0x45, 0x4b, 0x32, 0xbe, 0x36, 0xdf,
 0xd9, 0x1c, 0x41, 0xcc, 0x38, 0x19, 0x08, 0x5d, 0xb6, 0x49, 0x6e, 0x04, 0x80, 0x93, 0xb3, 0x23,
 0x1f, 0xd6, 0xe2, 0xe1, 0xc1, 0x14, 0x32, 0xe0, 0xce, 0xfa, 0xb2, 0xbd, 0xbe, 0x25, 0xa7, 0xd5,
 0xcf, 0x13, 0x0d, 0x16, 0x88, 0xb3, 0x8f, 0x7b, 0xf2, 0x90, 0x0a, 0x4e, 0xed, 0x3e, 0x9a, 0x89,
 0x41, 0xd6, 0x9d, 0x50, 0x91, 0x10, 0x06, 0xe8, 0x21, 0xcb, 0xe8, 0x49, 0x4d, 0xb9, 0xc8, 0x7d,
 0x47, 0x94, 0xc4, 0x13, 0x44, 0x88, 0x03, 0x8e, 0x06, 0xd3, 0xe9, 0x14, 0x58, 0x04, 0x64, 0xf5,
 0x3e, 0x9d, 0xb2, 0x8c, 0xf1, 0x5a, 0xd6, 0x46, 0x28, 0x6e, 0x42, 0x47, 0x3f, 0x37, 0x60, 0xb6,
 0x9c, 0x2a, 0x3b, 0x9d, 0xcf, 0x15, 0x77, 0x6f, 0xb2, 0x8f, 0xc3, 0x87, 0x21, 0x1d, 0x1d, 0x35,
 0x36, 0x72, 0xe6, 0xb6, 0x88, 0x70, 0x67, 0xd5, 0x02, 0x43, 0xbf, 0x3f, 0xb6, 0x7d, 0xa2, 0xf7,
 0xe8, 0xf1, 0x75, 0x52, 0x42, 0x3a, 0x10, 0xa0, 0x48, 0x60, 0xb1, 0x81, 0x63, 0x08, 0x20, 0x92,
};

unsigned char cs2[256] = {
 0x1e, 0x35, 0x5c, 0x77, 0x02, 0x64, 0x16, 0xa0, 0x5d, 0x19, 0x38, 0x25, 0xa7, 0x05, 0xbf, 0x6f,
 0x92, 0x32, 0xa3, 0x41, 0x2e, 0xca, 0x9c, 0x80, 0xc4, 0x12, 0xb0, 0x6a, 0x1b, 0x4d, 0x5e, 0x96,
 0x48, 0x0a, 0x05, 0x5b, 0x89, 0x84, 0x0c, 0x16, 0x6c, 0x83, 0x02, 0x20, 0xa0, 0x6c, 0xb4, 0x0c,
 0x15, 0xf8, 0x64, 0xb6, 0x56, 0x01, 0x0e, 0x8a, 0xc8, 0x50, 0x82, 0x45, 0x67, 0x58, 0x11, 0x4a,
 0x88, 0x22, 0x22, 0x49, 0x70, 0xd2, 0xa0, 0x80, 0x10, 0x55, 0x5c, 0x62, 0xaf, 0x26, 0xab, 0x80,
 0xf8, 0x40, 0xc1, 0x21, 0x82, 0x88, 0x4a, 0x2c, 0xb2, 0x52, 0xd8, 0x5d, 0x66, 0x31, 0x62, 0xa1,
 0x03, 0x89, 0x20, 0x90, 0xfe, 0xe9, 0x21, 0x15, 0xbd, 0xe1, 0xc3, 0xc2, 0x14, 0xdf, 0x6a, 0xff,
 0xa5, 0xf7, 0xd7, 0x49, 0x20, 0x08, 0x7b, 0x26, 0x08, 0xb2, 0xd6, 0x1d, 0xa6, 0x7f, 0x4e, 0x36,
 0x73, 0x83, 0xfe, 0xfb, 0xc0, 0xfc, 0x2e, 0xa9, 0xa0, 0xca, 0xb0, 0xa1, 0xaa, 0x38, 0xc2, 0xb9,
 0x02, 0x74, 0x5b, 0xdb, 0xcd, 0xa7, 0xf9, 0x2e, 0xeb, 0x03, 0x44, 0xd1, 0x11, 0xbd, 0x9e, 0x73,
 0x5d, 0x41, 0xaa, 0x52, 0x7d, 0xaf, 0x84, 0xb5, 0xe4, 0x73, 0x76, 0xfa, 0x6f, 0xfb, 0x72, 0xdf,
 0x0d, 0x8d, 0x66, 0xe7, 0x89, 0x2c, 0x16, 0x60, 0x18, 0x01, 0x15, 0x0a, 0x01, 0x31, 0x0c, 0x00,
 0xc7, 0xa6, 0x63, 0x32, 0xc8, 0x0c, 0xc2, 0x28, 0x3e, 0x42, 0x7d, 0x5b, 0xca, 0x88, 0x01, 0xbe,
 0x22, 0xd0, 0x10, 0x37, 0x9f, 0x99, 0x59, 0x02, 0x43, 0x53, 0xcb, 0xb4, 0x7d, 0x82, 0xc8, 0x65,
 0x30, 0x18, 0xe5, 0xb4, 0xbb, 0xe6, 0x06, 0x77, 0xeb, 0x10, 0xd9, 0x7b, 0xe7, 0xaf, 0x14, 0xdb,
 0x47, 0x92, 0x3a, 0xb2, 0x84, 0xe0, 0x6c, 0x20, 0x5c, 0x02, 0x04, 0x32, 0x47, 0x9f, 0x4b, 0x8e,
};

unsigned char cs3[256] = {
 0x02, 0x86, 0xbb, 0xed, 0x3a, 0x61, 0x23, 0x22, 0x0b, 0x97, 0x1c, 0x2e, 0x30, 0x44, 0x21, 0x77,
 0x76, 0x75, 0xc1, 0x1b, 0xbc, 0x02, 0x88, 0x74, 0xa9, 0xca, 0xee, 0x9f, 0x11, 0x80, 0x80, 0x44,
 0xa8, 0x4d, 0xeb, 0x7e, 0x78, 0xa7, 0x04, 0xa6, 0x24, 0x08, 0x1e, 0xf0, 0xf8, 0xf0, 0x60, 0x41,
 0x10, 0x46, 0x7e, 0xaa, 0x06, 0xb8, 0x00, 0x10, 0x0a, 0x80, 0x26, 0x20, 0xa5, 0x01, 0x9a, 0x0a,
 0xa8, 0x2f, 0xe8, 0x10, 0x60, 0x63, 0x14, 0x34, 0x43, 0x86, 0x81, 0x08, 0xd1, 0x40, 0x81, 0x02,
 0x29, 0x25, 0xa0, 0x05, 0xe8, 0x41, 0x80, 0x84, 0xa4, 0x01, 0x11, 0x40, 0x04, 0xa3, 0x90, 0x01,
 0x17, 0x77, 0xe7, 0x81, 0x80, 0x43, 0x81, 0xf5, 0xa8, 0x65, 0x30, 0x88, 0x43, 0xa0, 0x15, 0xdc,
 0x9b, 0x7f, 0x85, 0xab, 0xa2, 0x4c, 0xb2, 0x49, 0xf4, 0x04, 0x80, 0x34, 0xa0, 0xa3, 0x33, 0xc9,
 0x89, 0x53, 0xa1, 0xfa, 0x0f, 0x87, 0x0d, 0x37, 0x8f, 0xa6, 0xb8, 0xbc, 0xa6, 0x28, 0x70, 0x85,
 0x02, 0x45, 0xa0, 0x04, 0x03, 0x9f, 0xe3, 0x90, 0xd8, 0x3b, 0x57, 0x37, 0xe1, 0x8d, 0x01, 0xc7,
 0xde, 0x31, 0x27, 0x6e, 0xf6, 0xe0, 0xff, 0xff, 0xfb, 0xd0, 0x18, 0x05, 0x67, 0x63, 0xf5, 0xea,
 0xb7, 0xf0, 0x38, 0x3f, 0x44, 0x41, 0x01, 0x33, 0x02, 0xa1, 0x8f, 0xbf, 0xa2, 0x80, 0x07, 0xc2,
 0xf3, 0x2f, 0x5c, 0x10, 0x24, 0x82, 0xc0, 0xd7, 0x47, 0x31, 0xba, 0x6b, 0x8f, 0xb8, 0x07, 0xed,
 0x9b, 0x7f, 0x67, 0xf9, 0xeb, 0x68, 0xf5, 0x9e, 0xff, 0x5f, 0x7a, 0x89, 0x71, 0x73, 0xf7, 0x4e,
 0xca, 0x46, 0x8b, 0x89, 0x76, 0x10, 0xc5, 0xc6, 0xdb, 0xad, 0xfb, 0xfe, 0xf1, 0x87, 0xc3, 0x02,
 0x07, 0x69, 0x00, 0x05, 0x04, 0x3e, 0x84, 0x49, 0x50, 0x30, 0x70, 0x14, 0xd6, 0x93, 0xe1, 0xa0,
};

/* perm is 1, 3, 5, 2 --  4, 8, 10, 11 --  17, 19, 21, 0 -- 20, 18, 30, 25
    6, 7, 9, 12 --  13, 14, 15, 16 -- 31, 29, 28, 27 -- 26, 24, 22, 23 */

long pc1[16] = {0x0, 0x2, 0x8, 0xa, 0x20, 0x22, 0x28, 0x2a,
    0x4, 0x6, 0xc, 0xe, 0x24, 0x26, 0x2c, 0x2e};
    
long pc2[16] = {0, 0x10, 0x100, 0x110, 0x400, 0x410, 0x500, 0x510,
    0x800, 0x810, 0x900, 0x910, 0xc00, 0xc10, 0xd00, 0xd10};

long pc3[16] = {0, 0x2000, 0x8000, 0xa000, 0x20000, 0x22000, 0x28000, 0x2a000,
    1, 0x2001, 0x8001, 0xa001, 0x20001, 0x22001, 0x28001, 0x2a001};

long pc4[16] = {0, 0x100000, 0x40000, 0x140000, 0x40000000, 0x40040000, 0x40100000, 0x40140000,
    0x2000000, 0x2100000, 0x2040000, 0x2140000, 0x42000000, 0x42040000, 0x42100000, 0x42140000};

long pc5[16] = {0, 0x40, 0x80, 0xc0, 0x200, 0x240, 0x280, 0x2c0,
    0x1000, 0x1040, 0x1080, 0x10c0, 0x1200, 0x1240, 0x1280, 0x12c0};

long pc6[16] = {0, 0x2000, 0x4000, 0x6000, 0x8000, 0xa000, 0xc000, 0xe000,
    0x10000, 0x12000, 0x14000, 0x16000, 0x18000, 0x1a000, 0x1c000, 0x1e000};

long pc7[16] = {0, 0x80000000, 0x20000000, 0xa0000000, 0x10000000, 0x90000000, 0x30000000, 0xb0000000,
    0x8000000, 0x88000000, 0x28000000, 0xa8000000, 0x18000000, 0x98000000, 0x38000000, 0xb8000000};

long pc8[16] = {0, 0x4000000, 0x1000000, 0x5000000, 0x400000, 0x4400000, 0x1400000, 0x5400000,
    0x800000, 0x4800000, 0x1800000, 0x5800000, 0xc00000, 0x4c00000, 0x1c00000, 0x5c00000};

static zero8(ato)
    register char *ato; {
    *ato++ = 0;
    *ato++ = 0;
    *ato++ = 0;
    *ato++ = 0;
    *ato++ = 0;
    *ato++ = 0;
    *ato++ = 0;
    *ato = 0;
}

static copy8 (afrom, ato)
    register unsigned char *afrom, *ato; {
    *ato++ = *afrom++;
    *ato++ = *afrom++;
    *ato++ = *afrom++;
    *ato++ = *afrom++;
    *ato++ = *afrom++;
    *ato++ = *afrom++;
    *ato++ = *afrom++;
    *ato++ = *afrom++;
}

static xor8 (afrom, ato)
    register unsigned char *afrom, *ato; {
    register int tc;
    
    tc = *afrom++;
    *ato++ ^= tc;
    tc = *afrom++;
    *ato++ ^= tc;
    tc = *afrom++;
    *ato++ ^= tc;
    tc = *afrom++;
    *ato++ ^= tc;
    tc = *afrom++;
    *ato++ ^= tc;
    tc = *afrom++;
    *ato++ ^= tc;
    tc = *afrom++;
    *ato++ ^= tc;
    tc = *afrom;
    *ato ^= tc;
}

static perm(aval)
    register long aval; {
    register long temp;
    temp = pc1[aval & 0xf];
    aval >>= 4;
    temp |= pc2[aval & 0xf];
    aval >>= 4;
    temp |= pc3[aval & 0xf];
    aval >>= 4;
    temp |= pc4[aval & 0xf];
    aval >>= 4;
    temp |= pc5[aval & 0xf];
    aval >>= 4;
    temp |= pc6[aval & 0xf];
    aval >>= 4;
    temp |= pc7[aval & 0xf];
    aval >>= 4;
    temp |= pc8[aval & 0xf];
    return temp;
}

static rot(aval)
    register long aval; {
    return ((aval & 1)? ((aval>>1) | 0x80000000) : (aval>>1));
}

bcrypt_setkey(akey, ablock)
    register unsigned char *akey;
    struct bcrypt_key *ablock; {
    register l, r;
    /* build a key schedule */
    l = (akey[0]<<24) | (akey[1]<<16) | (akey[2]<<8) | akey[3];
    r = (akey[4]<<24) | (akey[5]<<16) | (akey[6]<<8) | akey[7];
    ablock->k[0] = r;
    ablock->k[1] = l;
    r = rot(perm(r));
    l = rot(perm(l));
    ablock->k[2] = l;
    ablock->k[3] = r;
    r = rot(perm(r));
    l = rot(perm(l));
    ablock->k[4] = r;
    ablock->k[5] = l;
    r = rot(perm(r));
    l = rot(perm(l));
    ablock->k[6] = l;
    ablock->k[7] = r;
    r = rot(perm(l));
    l = rot(perm(r));
    ablock->k[8] = l;
    ablock->k[9] = r;
    r = rot(perm(r));
    l = rot(perm(l));
    ablock->k[10] = l;
    ablock->k[11] = r;
    r = rot(perm(r));
    l = rot(perm(l));
    ablock->k[12] = l;
    ablock->k[13] = r;
    r = rot(perm(r));
    l = rot(perm(l));
    ablock->k[14] = l;
    ablock->k[15] = r;
}

/* one stage in computing F */
#define STAGE(l,r,k,x,v) \
    v =	0; 	/* compute f(r,k) in v */ \
    x =	r;	/* save old r */ \
    r =	((r & (1<<31))?	((r<<1) | 1) : (r<<1));	/* rot left */ \
    r =	r^(k);	/* xor with this stage's key */ \
    v = cs0[r & 0xff]; \
    r >>= 8; \
    v <<= 8; \
    v |= cs1[r & 0xff]; \
    r >>= 8; \
    v <<= 8; \
    v |= cs2[r & 0xff]; \
    r >>= 8; \
    v <<= 8; \
    v |= cs3[r & 0xff]; \
    r = l ^ v; \
    l = x;

bcrypt_OneBlockEncrypt(afrom, ato, atable)
    unsigned char *afrom;
    unsigned char *ato;
    struct bcrypt_key *atable; {
    register long l, x, v, r;
    
    /* setup for running the 8 stages */
    l = 0;
    l += *afrom++;
    l <<= 8;
    l += *afrom++;
    l <<= 8;
    l += *afrom++;
    l <<= 8;
    l += *afrom++;
    r = 0;
    r += *afrom++;
    r <<= 8;
    r += *afrom++;
    r <<= 8;
    r += *afrom++;
    r <<= 8;
    r += *afrom++;

    STAGE(l,r,atable->k[0],x,v);
    STAGE(l,r,atable->k[1],x,v);
    STAGE(l,r,atable->k[2],x,v);
    STAGE(l,r,atable->k[3],x,v);
    STAGE(l,r,atable->k[4],x,v);
    STAGE(l,r,atable->k[5],x,v);
    STAGE(l,r,atable->k[6],x,v);
    STAGE(l,r,atable->k[7],x,v);
    STAGE(l,r,atable->k[8],x,v);
    STAGE(l,r,atable->k[9],x,v);
    STAGE(l,r,atable->k[10],x,v);
    STAGE(l,r,atable->k[11],x,v);
    STAGE(l,r,atable->k[12],x,v);
    STAGE(l,r,atable->k[13],x,v);
    STAGE(l,r,atable->k[14],x,v);
    STAGE(l,r,atable->k[15],x,v);
    
    *ato++ = (l>>24);
    *ato++ = (l>>16);
    *ato++ = (l>>8);
    *ato++ = l;
    *ato++ = (r>>24);
    *ato++ = (r>>16);
    *ato++ = (r>>8);
    *ato++ = r;
}

/* decrypt is the same as encrypt, only you use the keys in the opposite order, exchange
    l and r in the input and again in the output stage */
bcrypt_OneBlockDecrypt(afrom, ato, atable)
    unsigned char *afrom;
    unsigned char *ato;
    struct bcrypt_key *atable; {
    register long l, x, v, r;
    
    /* setup for running the 8 stages, exchanging l and r */
    r = 0;
    r += *afrom++;
    r <<= 8;
    r += *afrom++;
    r <<= 8;
    r += *afrom++;
    r <<= 8;
    r += *afrom++;

    l = 0;
    l += *afrom++;
    l <<= 8;
    l += *afrom++;
    l <<= 8;
    l += *afrom++;
    l <<= 8;
    l += *afrom++;

    STAGE(l,r,atable->k[15],x,v);
    STAGE(l,r,atable->k[14],x,v);
    STAGE(l,r,atable->k[13],x,v);
    STAGE(l,r,atable->k[12],x,v);
    STAGE(l,r,atable->k[11],x,v);
    STAGE(l,r,atable->k[10],x,v);
    STAGE(l,r,atable->k[9],x,v);
    STAGE(l,r,atable->k[8],x,v);
    STAGE(l,r,atable->k[7],x,v);
    STAGE(l,r,atable->k[6],x,v);
    STAGE(l,r,atable->k[5],x,v);
    STAGE(l,r,atable->k[4],x,v);
    STAGE(l,r,atable->k[3],x,v);
    STAGE(l,r,atable->k[2],x,v);
    STAGE(l,r,atable->k[1],x,v);
    STAGE(l,r,atable->k[0],x,v);
    
    *ato++ = (r>>24);
    *ato++ = (r>>16);
    *ato++ = (r>>8);
    *ato++ = r;
    *ato++ = (l>>24);
    *ato++ = (l>>16);
    *ato++ = (l>>8);
    *ato++ = l;
}

bcrypt_decrypt(afrom, ato, alen, akey)
    char *afrom;
    char *ato;
    long alen;
    char *akey; {
    char inBlock[8], chain[8], nextChain[8];
    struct bcrypt_key expKey;

    bcrypt_setkey(akey, &expKey);
    zero8(chain);
    while (alen > 0) {
	if (alen >= 8) {
	    copy8(afrom, nextChain);
	    bcrypt_OneBlockDecrypt(afrom, ato, &expKey);
	    xor8(chain, ato);
	    copy8(nextChain, chain);
	    afrom += 8;
	    ato += 8;
	    alen -= 8;
	}
	else {
	    bcopy(afrom, inBlock, alen);
	    xor8(chain, inBlock);
	    bcopy(inBlock, ato, alen);
	    break;
	}
    }
}

bcrypt_encrypt(afrom, ato, alen, akey)
    char *afrom;
    char *ato;
    long alen;
    char *akey; {
    char inBlock[8], chain[8];
    struct bcrypt_key expKey;

    bcrypt_setkey(akey, &expKey);
    zero8(chain);
    while (alen > 0) {
	if (alen >= 8) {
	    xor8(afrom, chain);
	    bcrypt_OneBlockEncrypt(chain, ato, &expKey);
	    copy8(ato, chain);
	    afrom += 8;
	    ato += 8;
	    alen -= 8;
	}
	else {
	    bcopy(afrom, inBlock, alen);
	    xor8(chain, inBlock);
	    bcopy(inBlock, ato, alen);
	    break;
	}
    }
}
