/* 
 * Mach Operating System
 * Copyright (c) 1990 Carnegie-Mellon University
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log$
 */

/*
 *	Apple Macintosh II Mach (macmach)
 *
 *	File: mac2/thread_status.h
 *	Author: David E. Bohman II (CMU macmach)
 */

/*
 * This file contains the structure definitions for the thread
 * state as applied to Macintosh II computers 68020/30 with 68881/2.
 */

#ifndef	_MAC2_THREAD_STATUS_H_
#define	_MAC2_THREAD_STATUS_H_

#ifdef	KERNEL
#include <mac2/reg.h>
#else	KERNEL
#include <machine/reg.h>
#endif	KERNEL

/*
 * Thread processor registers.
 */
#define	THREAD_STATE_REGS	1

typedef struct {
    unsigned long	d0;    /* data registers */
    unsigned long	d1;
    unsigned long	d2;
    unsigned long	d3;
    unsigned long	d4;
    unsigned long	d5;
    unsigned long	d6;
    unsigned long	d7;
    unsigned long	a0;    /* address registers */
    unsigned long	a1;
    unsigned long	a2;
    unsigned long	a3;
    unsigned long	a4;
    unsigned long	a5;
    unsigned long	a6;
    unsigned long	sp;    /* user's stack pointer */
} thread_state_regs_t;
#define	THREAD_STATE_REGS_COUNT		\
    (sizeof(thread_state_regs_t)/sizeof (long))

/*
 * Thread fpu registers.
 */
#define THREAD_STATE_FPREGS	2

typedef fp_state_t	thread_state_fpregs_t;
#define THREAD_STATE_FPREGS_COUNT	\
    (sizeof (thread_state_fpregs_t)/sizeof (long))

/*
 * Thread processor state frame.
 */
#define THREAD_STATE_FRAME	3

typedef struct {
    unsigned short	sr;
    unsigned long	pc;
    unsigned short	format;
    unsigned short	xxx[42];
} thread_state_frame_t;
#define THREAD_STATE_FRAME_COUNT	\
    (sizeof (thread_state_frame_t)/sizeof (long))

/*
 * Thread fpu state frame.
 */
#define THREAD_STATE_FPFRAME	4

typedef fp_frame_t	thread_state_fpframe_t;
#define THREAD_STATE_FPFRAME_COUNT	\
    (sizeof (thread_state_fpframe_t)/sizeof (long))

#endif	_MAC2_THREAD_STATUS_H_
