/* 
 * Mach Operating System
 * Copyright (c) 1988, 1989, 1990 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */

/*
 *	Apple Macintosh II Mach (macmach)
 *
 *	File: mac2emul/mactrap.s
 *	Author: David E. Bohman II (CMU macmach)
 */

/*
 * RCS documentation
 *
 * $Header$
 *
 * $Log$
 */

#include <mac2/cpu.h>
#include <mac2/trap.h>

#include <assym.s>

/*
 * Called by trap #1 to do a macintosh emulation call
 */
	.globl	__mactrap
__mactrap:
	movl	a0,sp@-
	movc	msp,a0
	moveml	d0-d7/a0-a6,a0@(PCB_REGS)
	movl	sp@+,a0@(PCB_A0)
	movl	usp,a1
	movl	a1,a0@(PCB_SP)
	jsr	_mactrap
	movc	msp,a0
	movl	a0@(PCB_SP),a1
	movl	a1,usp
	moveml	a0@(PCB_REGS),d0-d7/a0-a6
	rte

/*
 * Macro used for entering
 * the trap handler.
 */
#define TRAP(type)	\
	.globl	__##type;	\
__##type: ;	\
	btst	\#SR_SUPR_BIT,sp@;	\
	bne	1f;	\
	movl	a0,sp@-;	\
	movc	msp,a0;	\
	btst	\#MAC_EMULATION_BIT,a0@(PCB_FLAGS);	\
	bne	2f;	\
\
0:	moveml	d0-d7/a0-a6,a0@(PCB_REGS);	\
	movl	sp@+,a0@(PCB_A0);	\
	movl	usp,a1;	\
	movl	a1,a0@(PCB_SP);	\
	pea	sp@;	\
	movl	\#TRAP_##type,sp@-;	\
	jsr	_user_trap;	\
	addqw	\#8,sp;	\
	jmp	rte_user;	\
\
1:	moveml	d0-d7/a0-a7,sp@-;	\
	lea	sp@(R_SP+4),a0;	\
	pea	sp@;	\
	movl	a0,sp@-;	\
	movl	\#TRAP_##type,sp@-;	\
	jsr	_kernel_trap;	\
	addw	\#12,sp;	\
	jmp	rte_kernel;	\
2:

TRAP(EMULATION_1010)
	movl	d0,a0@(PCB_D0)
	movl	sp@+,a0@(PCB_A0)
	movl	#FC_UD,d0
	movc	d0,sfc
	movl	sp@(F_PC),a0
	movsw	a0@,d0
	andw	#0x0fff,d0
	btst	#11,d0
	beq	0f
	btst	#10,d0
	beq	0f
	bclr	#10,d0
0:	tstl	@(_mac_osinst_vector:l,d0:W:4)
	bne	1f

/*
 * Inline version of take_exception()
 * - normal case of no user trace set.
 */
	movc	msp,a0
	bclr	#TRACE_USER_BIT,a0@(PCB_AST)
	bne	0f
	movl	#FC_UD,d0
	movc	d0,dfc
	movl	usp,a0
	movw	sp@(F_VOR),d0
	movsw	d0,a0@-
	movl	sp@(F_PC),d0
	movsl	d0,a0@-
	movw	sp@(F_SR),d0
	movsw	d0,a0@-
	movl	a0,usp
	movc	msp,a0
	movl	a0@(PCB_EMUL),a0
	movl	a0@(MAC_VBR),a0
	movsl	a0@(0x28),d0
	movl	d0,sp@(F_PC)
	movc	msp,a0
	movl	a0@(PCB_D0),d0
	movl	a0@(PCB_A0),a0
	rte
/*
 * Inline version of take_exception()
 * - special case of user trace set.
 */
0:	movl	a0@(PCB_EMUL),a0
	movb	a0@(MAC_SR),sp@(F_SR)
	andb	#0x3f,a0@(MAC_SR)
	movl	#FC_UD,d0
	movc	d0,dfc
	movl	usp,a0
	movw	sp@(F_VOR),d0
	movsw	d0,a0@-
	movl	sp@(F_PC),d0
	movsl	d0,a0@-
	movw	sp@(F_SR),d0
	movsw	d0,a0@-
	movl	a0,usp
	clrb	sp@(F_SR)
	movc	msp,a0
	btst	#TRACE_AST_BIT,a0@(PCB_AST)
	beq	0f
	bset	#SR_TRACE_BIT,sp@(F_SR)
0:	movl	a0@(PCB_EMUL),a0
	movl	a0@(MAC_VBR),a0
	movsl	a0@(0x28),d0
	movl	d0,sp@(F_PC)
	movc	msp,a0
	movl	a0@(PCB_D0),d0
	movl	a0@(PCB_A0),a0
	rte

/*
 * Handle an emulated MacOS trap
 */
1:	movc	msp,a0
	movl	d1,a0@(PCB_D1)
	movl	a1,a0@(PCB_A1)
	movl	usp,a1
	movl	a1,a0@(PCB_SP)
	movl	a0,sp@-
	pea	sp@(4)
	jsr	_mac_osinst
	addqw	#8,sp
	movc	msp,a0
	movl	a0@(PCB_SP),a1
	movl	a1,usp
	movl	a0@(PCB_A1),a1
	movl	a0@(PCB_D1),d1
	movl	a0@(PCB_D0),d0
	movl	a0@(PCB_A0),a0
	rte
