/* 
 * Mach Operating System
 * Copyright (c) 1988, 1989, 1990 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */

/*
 *	Apple Macintosh II Mach (macmach)
 *
 *	File: mac2emul/mactrap.c
 *	Author: David E. Bohman II (CMU macmach)
 */

/*
 * RCS documentation
 *
 * $Header$
 *
 * $Log$
 */

/*
 * macintosh emulation traps
 */

#include <sys/param.h>
#include <sys/user.h>

#include <mac2emul/mactrap.h>
#include <mac2emul/macuser.h>

mac_trap()
{
    register thread_t thread;
    register struct pcb *pcb;
    register struct regs *regs;
    register code;
    register vm_offset_t usp;

    thread = (thread_t)queue_first(&current_thread()->task->thread_list);
    pcb = thread->pcb;
    regs = &current_thread_pcb()->pcb_user;
    
    code = regs->r_r0;
    usp = regs->r_sp;

    if (code == MAC_T_BEGIN) {
	if (pcb != current_thread_pcb())
	    return;
	mac_begin(pcb);
	return;
    }

    if (pcb->pcb_emul == 0)
	return;

    switch (code) {
      case MAC_T_SET_ADDR_MODE:
	{
	    boolean_t to32bit;

	    FETCH(usp + sizeof (long), &to32bit, to32bit);
	    mac_set_addr_mode(pcb, to32bit);
	    break;
	}

      case MAC_T_GET_SR:
	{
	    regs->r_r0 = mac_get_sr(pcb);
	    break;
	}

      case MAC_T_SET_SR:
	{
	    int sr;

	    FETCH(usp + sizeof (long), &sr, sr);
	    mac_set_sr(pcb, sr);
	    break;
	}

      case MAC_T_GET_ADDR_MODE:
	{
	    regs->r_r0 = mac_get_addr_mode(pcb);
	    break;
	}

      case MAC_T_GET_CTRL_REGS:
	{
	    vm_offset_t addr;

	    FETCH(usp + sizeof (long), &addr, addr);
	    mac_get_ctrl_regs(pcb, addr);
	    break;
	}

      case MAC_T_SET_CTRL_REGS:
	{
	    vm_offset_t addr;

	    FETCH(usp + sizeof (long), &addr, addr);
	    mac_set_ctrl_regs(pcb, addr);
	    break;
	}

      case MAC_T_SET_INTR_VECT:
	{
	    vm_offset_t addr;

	    FETCH(usp + sizeof (long), &addr, addr);
	    mac_set_intr_vect(pcb, addr);
	    break;
	}

      case MAC_T_SET_INTR_PEND:
	{
	    int intr;

	    FETCH(usp + sizeof (long), &intr, intr);
	    mac_set_intr_pend(pcb, intr);
	    break;
	}

      case MAC_T_SET_ENV_PTR:
	{
	    vm_offset_t addr;

	    FETCH(usp + sizeof (long), &addr, addr);
	    mac_set_env_ptr(pcb, addr);
	    break;
	}

      case MAC_T_GET_ENV_PTR:
	{
	    regs->r_r0 = mac_get_env_ptr(pcb);
	    break;
	}

      case MAC_T_GET_VIAS:
	{
	    vm_offset_t addr;

	    FETCH(usp + sizeof (long), &addr, addr);
	    mac_get_vias(pcb, addr);
	    break;
	}
    }
}
