/* 
 * Mach Operating System
 * Copyright (c) 1988, 1989, 1990 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */

/*
 *	Apple Macintosh II Mach (macmach)
 *
 *	File: mac2emul/macpmap.c
 *	Author: David E. Bohman II (CMU macmach)
 */

/*
 * RCS documentation
 *
 * $Header$
 *
 * $Log$
 */

/*
 * Macintosh memory
 * management pmap
 * support
 */

#include <sys/param.h>

#include <kern/task.h>
#include <kern/thread.h>

#include <vm/vm_map.h>

#include <mac2/pmmu_inline.c>

pmap_set_24bit_mode()
{
    register pmap_t	pmap = vm_map_pmap(current_task()->map);
    PMMU_RP_reg	rp;

    if (pmap->alt_root == 0) {
	pt_root_alloc(&pmap->alt_ptrt, &pmap->alt_root);
	pmap_do_24bit_map(pmap);
    }

    if ((pmap->flags&PMAP_F_24BIT) == 0) {
	pmap->flags |= PMAP_F_24BIT;

	rp.limit = PMMU_RP_LIMIT;
	rp.valid = PMMU_VALID_RP;
	rp.phys = (unsigned long)pmap->alt_root;
	pmmu_set_crp(&rp);
	flush_cpu_caches();
    }
}

pmap_set_32bit_mode()
{
    register pmap_t	pmap = vm_map_pmap(current_task()->map);
    PMMU_RP_reg	rp;

    if (pmap->flags&PMAP_F_24BIT) {
	pmap->flags &= ~PMAP_F_24BIT;

	rp.limit = PMMU_RP_LIMIT;
	rp.valid = PMMU_VALID_RP;
	rp.phys = (unsigned long)pmap->root;
	pmmu_set_crp(&rp);
	flush_cpu_caches();
    }
}
